/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.FileInfoBackingCache;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInfoBackingCacheTest {
    private static final Logger log = LoggerFactory.getLogger(FileInfoBackingCacheTest.class);
    final byte[] masterKey = new byte[0];
    final File baseDir;
    final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("backing-cache-test-%d").setDaemon(true).build();
    ExecutorService executor;

    public FileInfoBackingCacheTest() throws Exception {
        this.baseDir = File.createTempFile("foo", "bar");
    }

    @Before
    public void setup() throws Exception {
        Assert.assertTrue((boolean)this.baseDir.delete());
        Assert.assertTrue((boolean)this.baseDir.mkdirs());
        this.baseDir.deleteOnExit();
        this.executor = Executors.newCachedThreadPool(this.threadFactory);
    }

    @After
    public void tearDown() throws Exception {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    @Test(timeout=30000L)
    public void basicTest() throws Exception {
        FileInfoBackingCache cache = new FileInfoBackingCache((ledgerId, createIfNotFound) -> {
            File f = new File(this.baseDir, String.valueOf(ledgerId));
            f.deleteOnExit();
            return f;
        }, 1);
        FileInfoBackingCache.CachedFileInfo fi = cache.loadFileInfo(1L, this.masterKey);
        Assert.assertEquals((long)fi.getRefCount(), (long)1L);
        FileInfoBackingCache.CachedFileInfo fi2 = cache.loadFileInfo(2L, this.masterKey);
        Assert.assertEquals((long)fi2.getRefCount(), (long)1L);
        FileInfoBackingCache.CachedFileInfo fi3 = cache.loadFileInfo(1L, null);
        Assert.assertEquals((Object)fi, (Object)fi3);
        Assert.assertEquals((long)fi3.getRefCount(), (long)2L);
        fi.release();
        fi3.release();
        Assert.assertEquals((long)fi.getRefCount(), (long)-57005L);
        FileInfoBackingCache.CachedFileInfo fi4 = cache.loadFileInfo(1L, null);
        Assert.assertFalse((fi4 == fi ? 1 : 0) != 0);
        Assert.assertEquals((long)fi.getRefCount(), (long)-57005L);
        Assert.assertEquals((long)fi4.getRefCount(), (long)1L);
        Assert.assertEquals((Object)fi.getLf(), (Object)fi4.getLf());
    }

    @Test(expected=IOException.class, timeout=30000L)
    public void testNoKey() throws Exception {
        FileInfoBackingCache cache = new FileInfoBackingCache((ledgerId, createIfNotFound) -> {
            Assert.assertFalse((boolean)createIfNotFound);
            throw new Bookie.NoLedgerException(ledgerId);
        }, 1);
        cache.loadFileInfo(1L, null);
    }

    @Test(timeout=30000L)
    public void testForDeadlocks() throws Exception {
        int numRunners = 20;
        int maxLedgerId = 10;
        AtomicBoolean done = new AtomicBoolean(false);
        FileInfoBackingCache cache = new FileInfoBackingCache((ledgerId, createIfNotFound) -> {
            File f = new File(this.baseDir, String.valueOf(ledgerId));
            f.deleteOnExit();
            return f;
        }, 1);
        Iterable futures = IntStream.range(0, numRunners).mapToObj(i -> {
            Callable<Set> c = () -> {
                Random r = new Random();
                ArrayList<FileInfoBackingCache.CachedFileInfo> fileInfos = new ArrayList<FileInfoBackingCache.CachedFileInfo>();
                HashSet<FileInfoBackingCache.CachedFileInfo> allFileInfos = new HashSet<FileInfoBackingCache.CachedFileInfo>();
                while (!done.get()) {
                    if (r.nextBoolean() && fileInfos.size() < 5) {
                        FileInfoBackingCache.CachedFileInfo fi = cache.loadFileInfo((long)r.nextInt(maxLedgerId), this.masterKey);
                        Assert.assertFalse((boolean)fi.isClosed());
                        allFileInfos.add(fi);
                        fileInfos.add(fi);
                        continue;
                    }
                    Collections.shuffle(fileInfos);
                    if (fileInfos.isEmpty()) continue;
                    ((FileInfoBackingCache.CachedFileInfo)fileInfos.remove(0)).release();
                }
                for (FileInfoBackingCache.CachedFileInfo fi : fileInfos) {
                    Assert.assertFalse((boolean)fi.isClosed());
                    fi.release();
                }
                return allFileInfos;
            };
            return this.executor.submit(c);
        }).collect(Collectors.toList());
        Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
        done.set(true);
        for (Future f : futures) {
            f.get();
        }
        for (Future f : futures) {
            for (FileInfoBackingCache.CachedFileInfo fi : (Set)f.get()) {
                Assert.assertTrue((boolean)fi.isClosed());
                Assert.assertEquals((long)-57005L, (long)fi.getRefCount());
            }
        }
        for (int i2 = 0; i2 < maxLedgerId; ++i2) {
            Assert.assertEquals((long)1L, (long)cache.loadFileInfo((long)i2, this.masterKey).getRefCount());
        }
    }

    @Test(timeout=30000L)
    public void testRefCountRace() throws Exception {
        AtomicBoolean done = new AtomicBoolean(false);
        FileInfoBackingCache cache = new FileInfoBackingCache((ledgerId, createIfNotFound) -> {
            File f = new File(this.baseDir, String.valueOf(ledgerId));
            f.deleteOnExit();
            return f;
        }, 1);
        Iterable futures = IntStream.range(0, 2).mapToObj(i -> {
            Callable<Set> c = () -> {
                HashSet<FileInfoBackingCache.CachedFileInfo> allFileInfos = new HashSet<FileInfoBackingCache.CachedFileInfo>();
                while (!done.get()) {
                    FileInfoBackingCache.CachedFileInfo fi = cache.loadFileInfo(1L, this.masterKey);
                    Assert.assertFalse((boolean)fi.isClosed());
                    allFileInfos.add(fi);
                    fi.release();
                }
                return allFileInfos;
            };
            return this.executor.submit(c);
        }).collect(Collectors.toList());
        Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
        done.set(true);
        for (Future f : futures) {
            f.get();
        }
        for (Future f : futures) {
            for (FileInfoBackingCache.CachedFileInfo fi : (Set)f.get()) {
                Assert.assertTrue((boolean)fi.isClosed());
                Assert.assertEquals((long)-57005L, (long)fi.getRefCount());
            }
        }
    }

    private void guavaEvictionListener(RemovalNotification<Long, FileInfoBackingCache.CachedFileInfo> notification) {
        ((FileInfoBackingCache.CachedFileInfo)notification.getValue()).release();
    }

    @Test(timeout=30000L)
    public void testRaceGuavaEvictAndReleaseBeforeRetain() throws Exception {
        AtomicBoolean done = new AtomicBoolean(false);
        SecureRandom random = new SecureRandom();
        FileInfoBackingCache cache = new FileInfoBackingCache((ledgerId, createIfNotFound) -> {
            File f = new File(this.baseDir, String.valueOf(ledgerId));
            f.deleteOnExit();
            return f;
        }, 1);
        Cache guavaCache = CacheBuilder.newBuilder().maximumSize(1L).removalListener(this::guavaEvictionListener).build();
        Iterable futures = LongStream.range(0L, 2L).mapToObj(i -> {
            Callable<Set> c = () -> {
                HashSet<FileInfoBackingCache.CachedFileInfo> allFileInfos = new HashSet<FileInfoBackingCache.CachedFileInfo>();
                while (!done.get()) {
                    FileInfoBackingCache.CachedFileInfo fi = null;
                    do {
                        fi = (FileInfoBackingCache.CachedFileInfo)guavaCache.get((Object)i, () -> cache.loadFileInfo(i, this.masterKey));
                        allFileInfos.add(fi);
                        Thread.sleep(random.nextInt(100));
                    } while (!fi.tryRetain());
                    Assert.assertFalse((boolean)fi.isClosed());
                    fi.release();
                }
                return allFileInfos;
            };
            return this.executor.submit(c);
        }).collect(Collectors.toList());
        Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
        done.set(true);
        for (Future f : futures) {
            f.get();
        }
        guavaCache.invalidateAll();
        for (Future f : futures) {
            for (FileInfoBackingCache.CachedFileInfo fi : (Set)f.get()) {
                Assert.assertTrue((boolean)fi.isClosed());
                Assert.assertEquals((long)-57005L, (long)fi.getRefCount());
            }
        }
    }
}

