/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.List;
import org.apache.bookkeeper.bookie.BookieResources;
import org.apache.bookkeeper.bookie.BufferedChannel;
import org.apache.bookkeeper.bookie.FileInfo;
import org.apache.bookkeeper.bookie.FileSystemUpgrade;
import org.apache.bookkeeper.bookie.IndexPersistenceMgr;
import org.apache.bookkeeper.bookie.JournalChannel;
import org.apache.bookkeeper.bookie.TestBookieImpl;
import org.apache.bookkeeper.client.ClientUtil;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.bookkeeper.util.PortManager;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(FileInfo.class);
    private static final int bookiePort = PortManager.nextFreePort();

    public UpgradeTest() {
        super(0);
    }

    static void writeLedgerDirWithIndexDir(File ledgerDir, File indexDir, byte[] masterKey) throws Exception {
        long ledgerId = 1L;
        File fn = new File(indexDir, IndexPersistenceMgr.getLedgerName((long)ledgerId));
        fn.getParentFile().mkdirs();
        FileInfo fi = new FileInfo(fn, masterKey, 1);
        fi.write(new ByteBuffer[]{ByteBuffer.allocate(0)}, 0L);
        fi.close(true);
        long logId = 0L;
        ByteBuffer logfileHeader = ByteBuffer.allocate(1024);
        logfileHeader.put("BKLO".getBytes());
        FileChannel logfile = new RandomAccessFile(new File(ledgerDir, Long.toHexString(logId) + ".log"), "rw").getChannel();
        logfile.write((ByteBuffer)logfileHeader.clear());
        logfile.close();
    }

    static void writeLedgerDir(File dir, byte[] masterKey) throws Exception {
        long ledgerId = 1L;
        File fn = new File(dir, IndexPersistenceMgr.getLedgerName((long)ledgerId));
        fn.getParentFile().mkdirs();
        FileInfo fi = new FileInfo(fn, masterKey, 1);
        fi.write(new ByteBuffer[]{ByteBuffer.allocate(0)}, 0L);
        fi.close(true);
        long logId = 0L;
        ByteBuffer logfileHeader = ByteBuffer.allocate(1024);
        logfileHeader.put("BKLO".getBytes());
        FileChannel logfile = new RandomAccessFile(new File(dir, Long.toHexString(logId) + ".log"), "rw").getChannel();
        logfile.write((ByteBuffer)logfileHeader.clear());
        logfile.close();
    }

    static JournalChannel writeJournal(File journalDir, int numEntries, byte[] masterKey) throws Exception {
        long logId = System.currentTimeMillis();
        JournalChannel jc = new JournalChannel(journalDir, logId);
        BufferedChannel bc = jc.getBufferedChannel();
        long ledgerId = 1L;
        byte[] data = new byte[1024];
        Arrays.fill(data, (byte)88);
        long lastConfirmed = -1L;
        for (int i = 1; i <= numEntries; ++i) {
            ByteBuf packet = ClientUtil.generatePacket(ledgerId, i, lastConfirmed, i * data.length, data);
            lastConfirmed = i;
            ByteBuffer lenBuff = ByteBuffer.allocate(4);
            lenBuff.putInt(packet.readableBytes());
            lenBuff.flip();
            bc.write(Unpooled.wrappedBuffer((ByteBuffer)lenBuff));
            bc.write(packet);
            packet.release();
        }
        bc.flushAndForceWrite(false);
        return jc;
    }

    static File initV1JournalDirectory(File d) throws Exception {
        UpgradeTest.writeJournal(d, 100, "foobar".getBytes()).close();
        return d;
    }

    static File initV1LedgerDirectory(File d) throws Exception {
        UpgradeTest.writeLedgerDir(d, "foobar".getBytes());
        return d;
    }

    static File initV1LedgerDirectoryWithIndexDir(File ledgerDir, File indexDir) throws Exception {
        UpgradeTest.writeLedgerDirWithIndexDir(ledgerDir, indexDir, "foobar".getBytes());
        return ledgerDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createVersion2File(File dir) throws Exception {
        File versionFile = new File(dir, "VERSION");
        FileOutputStream fos = new FileOutputStream(versionFile);
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter(fos));
            bw.write(String.valueOf(2));
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            fos.close();
        }
    }

    static File initV2JournalDirectory(File d) throws Exception {
        UpgradeTest.createVersion2File(UpgradeTest.initV1JournalDirectory(d));
        return d;
    }

    static File initV2LedgerDirectory(File d) throws Exception {
        UpgradeTest.createVersion2File(UpgradeTest.initV1LedgerDirectory(d));
        return d;
    }

    static File initV2LedgerDirectoryWithIndexDir(File ledgerDir, File indexDir) throws Exception {
        UpgradeTest.initV1LedgerDirectoryWithIndexDir(ledgerDir, indexDir);
        UpgradeTest.createVersion2File(ledgerDir);
        UpgradeTest.createVersion2File(indexDir);
        return ledgerDir;
    }

    private static void testUpgradeProceedure(String zkServers, String journalDir, String ledgerDir, String indexDir) throws Exception {
        TestBookieImpl.Resources resources;
        RegistrationManager rm;
        MetadataBookieDriver metadataDriver;
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setMetadataServiceUri("zk://" + zkServers + "/ledgers");
        conf.setJournalDirName(journalDir).setLedgerDirNames(new String[]{ledgerDir}).setIndexDirName(new String[]{indexDir}).setBookiePort(bookiePort);
        TestBookieImpl b = null;
        try {
            metadataDriver = BookieResources.createMetadataDriver((ServerConfiguration)conf, (StatsLogger)NullStatsLogger.INSTANCE);
            try {
                rm = metadataDriver.createRegistrationManager();
                try {
                    resources = new TestBookieImpl.ResourceBuilder(conf).withMetadataDriver(metadataDriver).withRegistrationManager(rm).build();
                    b = new TestBookieImpl(resources);
                    Assert.fail((String)"Shouldn't have been able to start");
                }
                finally {
                    if (rm != null) {
                        rm.close();
                    }
                }
            }
            finally {
                if (metadataDriver != null) {
                    metadataDriver.close();
                }
            }
        }
        catch (IOException e) {
            Assert.assertTrue((String)"wrong exception", (boolean)e.getMessage().contains("upgrade needed"));
        }
        FileSystemUpgrade.upgrade((ServerConfiguration)conf);
        metadataDriver = BookieResources.createMetadataDriver((ServerConfiguration)conf, (StatsLogger)NullStatsLogger.INSTANCE);
        try {
            rm = metadataDriver.createRegistrationManager();
            try {
                resources = new TestBookieImpl.ResourceBuilder(conf).withMetadataDriver(metadataDriver).withRegistrationManager(rm).build();
                b = new TestBookieImpl(resources);
                b.start();
                b.shutdown();
            }
            finally {
                if (rm != null) {
                    rm.close();
                }
            }
        }
        finally {
            if (metadataDriver != null) {
                metadataDriver.close();
            }
        }
        b = null;
        FileSystemUpgrade.rollback((ServerConfiguration)conf);
        try {
            metadataDriver = BookieResources.createMetadataDriver((ServerConfiguration)conf, (StatsLogger)NullStatsLogger.INSTANCE);
            try {
                rm = metadataDriver.createRegistrationManager();
                try {
                    resources = new TestBookieImpl.ResourceBuilder(conf).withMetadataDriver(metadataDriver).withRegistrationManager(rm).build();
                    b = new TestBookieImpl(resources);
                    Assert.fail((String)"Shouldn't have been able to start");
                }
                finally {
                    if (rm != null) {
                        rm.close();
                    }
                }
            }
            finally {
                if (metadataDriver != null) {
                    metadataDriver.close();
                }
            }
        }
        catch (IOException e) {
            Assert.assertTrue((String)"wrong exception", (boolean)e.getMessage().contains("upgrade needed"));
        }
        FileSystemUpgrade.upgrade((ServerConfiguration)conf);
        FileSystemUpgrade.finalizeUpgrade((ServerConfiguration)conf);
        metadataDriver = BookieResources.createMetadataDriver((ServerConfiguration)conf, (StatsLogger)NullStatsLogger.INSTANCE);
        try {
            rm = metadataDriver.createRegistrationManager();
            try {
                resources = new TestBookieImpl.ResourceBuilder(conf).withMetadataDriver(metadataDriver).withRegistrationManager(rm).build();
                b = new TestBookieImpl(resources);
                b.start();
                b.shutdown();
            }
            finally {
                if (rm != null) {
                    rm.close();
                }
            }
        }
        finally {
            if (metadataDriver != null) {
                metadataDriver.close();
            }
        }
        b = null;
    }

    @Test
    public void testUpgradeV1toCurrent() throws Exception {
        File journalDir = UpgradeTest.initV1JournalDirectory(this.tmpDirs.createNew("bookie", "journal"));
        File ledgerDir = UpgradeTest.initV1LedgerDirectory(this.tmpDirs.createNew("bookie", "ledger"));
        UpgradeTest.testUpgradeProceedure(this.zkUtil.getZooKeeperConnectString(), journalDir.getPath(), ledgerDir.getPath(), ledgerDir.getPath());
    }

    @Test
    public void testUpgradeV1toCurrentWithIndexDir() throws Exception {
        File journalDir = UpgradeTest.initV1JournalDirectory(this.tmpDirs.createNew("bookie", "journal"));
        File indexDir = this.tmpDirs.createNew("bookie", "index");
        File ledgerDir = UpgradeTest.initV1LedgerDirectoryWithIndexDir(this.tmpDirs.createNew("bookie", "ledger"), indexDir);
        UpgradeTest.testUpgradeProceedure(this.zkUtil.getZooKeeperConnectString(), journalDir.getPath(), ledgerDir.getPath(), indexDir.getPath());
    }

    @Test
    public void testUpgradeV2toCurrent() throws Exception {
        File journalDir = UpgradeTest.initV2JournalDirectory(this.tmpDirs.createNew("bookie", "journal"));
        File ledgerDir = UpgradeTest.initV2LedgerDirectory(this.tmpDirs.createNew("bookie", "ledger"));
        File indexDir = this.tmpDirs.createNew("bookie", "index");
        UpgradeTest.testUpgradeProceedure(this.zkUtil.getZooKeeperConnectString(), journalDir.getPath(), ledgerDir.getPath(), indexDir.getPath());
    }

    @Test
    public void testUpgradeV2toCurrentWithIndexDir() throws Exception {
        File journalDir = UpgradeTest.initV2JournalDirectory(this.tmpDirs.createNew("bookie", "journal"));
        File indexDir = this.tmpDirs.createNew("bookie", "index");
        File ledgerDir = UpgradeTest.initV2LedgerDirectoryWithIndexDir(this.tmpDirs.createNew("bookie", "ledger"), indexDir);
        UpgradeTest.testUpgradeProceedure(this.zkUtil.getZooKeeperConnectString(), journalDir.getPath(), ledgerDir.getPath(), indexDir.getPath());
    }

    @Test
    public void testUpgradeCurrent() throws Exception {
        this.testUpgradeCurrent(false);
    }

    @Test
    public void testUpgradeCurrentWithIndexDir() throws Exception {
        this.testUpgradeCurrent(true);
    }

    public void testUpgradeCurrent(boolean hasIndexDir) throws Exception {
        File ledgerDir;
        File journalDir = UpgradeTest.initV2JournalDirectory(this.tmpDirs.createNew("bookie", "journal"));
        File indexDir = ledgerDir = this.tmpDirs.createNew("bookie", "ledger");
        if (hasIndexDir) {
            indexDir = this.tmpDirs.createNew("bookie", "index");
            UpgradeTest.initV2LedgerDirectoryWithIndexDir(ledgerDir, indexDir);
        } else {
            UpgradeTest.initV2LedgerDirectory(ledgerDir);
        }
        UpgradeTest.testUpgradeProceedure(this.zkUtil.getZooKeeperConnectString(), journalDir.getPath(), ledgerDir.getPath(), indexDir.getPath());
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(journalDir.getPath()).setLedgerDirNames(new String[]{ledgerDir.getPath()}).setBookiePort(bookiePort).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        FileSystemUpgrade.upgrade((ServerConfiguration)conf);
        MetadataBookieDriver metadataDriver = BookieResources.createMetadataDriver((ServerConfiguration)conf, (StatsLogger)NullStatsLogger.INSTANCE);
        RegistrationManager rm = metadataDriver.createRegistrationManager();
        TestBookieImpl.Resources resources = new TestBookieImpl.ResourceBuilder(conf).withMetadataDriver(metadataDriver).withRegistrationManager(rm).build();
        TestBookieImpl b = new TestBookieImpl(resources);
        b.start();
        b.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCommandLine() throws Exception {
        PrintStream origerr = System.err;
        PrintStream origout = System.out;
        File output = IOUtils.createTempFileAndDeleteOnExit((String)"bookie", (String)"stdout");
        File erroutput = IOUtils.createTempFileAndDeleteOnExit((String)"bookie", (String)"stderr");
        System.setOut(new PrintStream(output));
        System.setErr(new PrintStream(erroutput));
        try {
            FileSystemUpgrade.main((String[])new String[]{"-h"});
            try {
                FileSystemUpgrade.main((String[])new String[]{"-u"});
                Assert.fail((String)"Should have failed");
            }
            catch (IllegalArgumentException iae) {
                Assert.assertTrue((String)("Wrong exception " + iae.getMessage()), (boolean)iae.getMessage().contains("without configuration"));
            }
            File f = IOUtils.createTempFileAndDeleteOnExit((String)"bookie", (String)"tmpconf");
            try {
                FileSystemUpgrade.main((String[])new String[]{"--conf", f.getPath()});
                Assert.fail((String)"Should have failed");
            }
            catch (IllegalArgumentException iae) {
                Assert.assertTrue((String)("Wrong exception " + iae.getMessage()), (boolean)iae.getMessage().contains("Must specify -upgrade"));
            }
        }
        finally {
            System.setOut(origout);
            System.setErr(origerr);
        }
    }

    @Test
    public void testFSUGetAllDirectories() throws Exception {
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        File journalDir = this.tmpDirs.createNew("bookie", "journal");
        File ledgerDir1 = this.tmpDirs.createNew("bookie", "ledger");
        File ledgerDir2 = this.tmpDirs.createNew("bookie", "ledger");
        conf.setJournalDirName(journalDir.getPath()).setLedgerDirNames(new String[]{ledgerDir1.getPath(), ledgerDir2.getPath()}).setIndexDirName(new String[]{ledgerDir1.getPath(), ledgerDir2.getPath()});
        List allDirectories = FileSystemUpgrade.getAllDirectories((ServerConfiguration)conf);
        Assert.assertEquals((long)3L, (long)allDirectories.size());
        conf.setJournalDirName(journalDir.getPath()).setLedgerDirNames(new String[]{ledgerDir1.getPath(), ledgerDir2.getPath()}).setIndexDirName(new String[]{ledgerDir2.getPath(), ledgerDir1.getPath()});
        allDirectories = FileSystemUpgrade.getAllDirectories((ServerConfiguration)conf);
        Assert.assertEquals((long)3L, (long)allDirectories.size());
        File indexDir1 = this.tmpDirs.createNew("bookie", "index");
        File indexDir2 = this.tmpDirs.createNew("bookie", "index");
        conf.setJournalDirName(journalDir.getPath()).setLedgerDirNames(new String[]{ledgerDir1.getPath(), ledgerDir2.getPath()}).setIndexDirName(new String[]{indexDir1.getPath(), indexDir2.getPath()});
        allDirectories = FileSystemUpgrade.getAllDirectories((ServerConfiguration)conf);
        Assert.assertEquals((long)5L, (long)allDirectories.size());
        conf.setJournalDirName(journalDir.getPath()).setLedgerDirNames(new String[]{ledgerDir1.getPath(), ledgerDir2.getPath()}).setIndexDirName(new String[]{indexDir2.getPath(), indexDir1.getPath()});
        allDirectories = FileSystemUpgrade.getAllDirectories((ServerConfiguration)conf);
        Assert.assertEquals((long)5L, (long)allDirectories.size());
    }
}

