/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.datainteg;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.Cookie;
import org.apache.bookkeeper.bookie.datainteg.DataIntegrityCheck;
import org.apache.bookkeeper.bookie.datainteg.DataIntegrityCookieValidation;
import org.apache.bookkeeper.bookie.datainteg.MockDataIntegrityCheck;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.MockRegistrationManager;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.test.TmpDirs;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieValidationTest {
    private static Logger log = LoggerFactory.getLogger(CookieValidationTest.class);
    final TmpDirs tmpDirs = new TmpDirs();

    @After
    public void cleanup() throws Exception {
        this.tmpDirs.cleanup();
    }

    private File initializedDir() throws Exception {
        File dir = this.tmpDirs.createNew("cookie", "validation");
        BookieImpl.checkDirectoryStructure((File)BookieImpl.getCurrentDirectory((File)dir));
        return dir;
    }

    private static ServerConfiguration serverConf(boolean stampMissingCookies) {
        ServerConfiguration conf = new ServerConfiguration();
        conf.setDataIntegrityStampMissingCookiesEnabled(stampMissingCookies);
        conf.setAdvertisedAddress("foobar");
        return conf;
    }

    private Versioned<byte[]> genCookie(ServerConfiguration conf) throws UnknownHostException {
        return new Versioned((Object)Cookie.generateCookie((ServerConfiguration)conf).build().toString().getBytes(StandardCharsets.UTF_8), Version.NEW);
    }

    @Test
    public void testNoZkCookieAndEmptyDirsStampsNewCookie() throws Exception {
        ArrayList dirs = Lists.newArrayList((Object[])new File[]{this.initializedDir(), this.initializedDir()});
        ServerConfiguration conf = CookieValidationTest.serverConf(false);
        BookieId bookieId = BookieImpl.getBookieId((ServerConfiguration)conf);
        MockRegistrationManager regManager = new MockRegistrationManager();
        DataIntegrityCookieValidation v = new DataIntegrityCookieValidation(conf, (RegistrationManager)regManager, (DataIntegrityCheck)new MockDataIntegrityCheck());
        v.checkCookies((List)dirs);
        byte[] cookieBytes = (byte[])regManager.readCookie(bookieId).getValue();
        MatcherAssert.assertThat((Object)cookieBytes, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)cookieBytes.length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Cookie regManagerCookie = Cookie.parseFromBytes((byte[])cookieBytes);
        for (File d : dirs) {
            MatcherAssert.assertThat((Object)Cookie.readFromDirectory((File)d), (Matcher)Matchers.equalTo((Object)regManagerCookie));
        }
    }

    @Test(expected=BookieException.InvalidCookieException.class)
    public void testZkCookieAndEmptyDirsRaisesErrorWithoutMissingCookieStamping() throws Exception {
        ArrayList dirs = Lists.newArrayList((Object[])new File[]{this.initializedDir(), this.initializedDir()});
        ServerConfiguration conf = CookieValidationTest.serverConf(false);
        BookieId bookieId = BookieImpl.getBookieId((ServerConfiguration)conf);
        MockRegistrationManager regManager = new MockRegistrationManager();
        regManager.writeCookie(bookieId, this.genCookie(conf));
        DataIntegrityCookieValidation v = new DataIntegrityCookieValidation(conf, (RegistrationManager)regManager, (DataIntegrityCheck)new MockDataIntegrityCheck());
        v.checkCookies((List)dirs);
    }

    @Test
    public void testZkCookieAndEmptyDirsStampsNewCookieWithMissingCookieStamping() throws Exception {
        ArrayList dirs = Lists.newArrayList((Object[])new File[]{this.initializedDir(), this.initializedDir()});
        ServerConfiguration conf = CookieValidationTest.serverConf(true);
        BookieId bookieId = BookieImpl.getBookieId((ServerConfiguration)conf);
        MockRegistrationManager regManager = new MockRegistrationManager();
        regManager.writeCookie(bookieId, this.genCookie(conf));
        DataIntegrityCookieValidation v = new DataIntegrityCookieValidation(conf, (RegistrationManager)regManager, (DataIntegrityCheck)new MockDataIntegrityCheck());
        v.checkCookies((List)dirs);
        byte[] cookieBytes = (byte[])regManager.readCookie(bookieId).getValue();
        MatcherAssert.assertThat((Object)cookieBytes, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)cookieBytes.length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Cookie regManagerCookie = Cookie.parseFromBytes((byte[])cookieBytes);
        for (File d : dirs) {
            MatcherAssert.assertThat((Object)Cookie.readFromDirectory((File)d), (Matcher)Matchers.equalTo((Object)regManagerCookie));
        }
    }

    @Test(expected=BookieException.InvalidCookieException.class)
    public void testMissingZKCookieRaisesError() throws Exception {
        ArrayList dirs = Lists.newArrayList((Object[])new File[]{this.initializedDir(), this.initializedDir()});
        ServerConfiguration conf = CookieValidationTest.serverConf(true);
        MockRegistrationManager regManager = new MockRegistrationManager();
        DataIntegrityCookieValidation v1 = new DataIntegrityCookieValidation(conf, (RegistrationManager)regManager, (DataIntegrityCheck)new MockDataIntegrityCheck());
        v1.checkCookies((List)dirs);
        MockRegistrationManager blankRegManager = new MockRegistrationManager();
        DataIntegrityCookieValidation v2 = new DataIntegrityCookieValidation(conf, (RegistrationManager)blankRegManager, (DataIntegrityCheck)new MockDataIntegrityCheck());
        v2.checkCookies((List)dirs);
    }

    @Test
    public void testMatchingCookiesTakesNoAction() throws Exception {
        ArrayList dirs = Lists.newArrayList((Object[])new File[]{this.initializedDir(), this.initializedDir()});
        ServerConfiguration conf = CookieValidationTest.serverConf(true);
        MockRegistrationManager regManager = new MockRegistrationManager();
        DataIntegrityCookieValidation v1 = new DataIntegrityCookieValidation(conf, (RegistrationManager)regManager, (DataIntegrityCheck)new MockDataIntegrityCheck());
        v1.checkCookies((List)dirs);
        DataIntegrityCookieValidation v2 = new DataIntegrityCookieValidation(conf, (RegistrationManager)regManager, (DataIntegrityCheck)new MockDataIntegrityCheck());
        v2.checkCookies((List)dirs);
    }

    @Test
    public void testEmptyDirectoryTriggersIntegrityCheck() throws Exception {
        ArrayList dirs = Lists.newArrayList((Object[])new File[]{this.initializedDir(), this.initializedDir()});
        ServerConfiguration conf = CookieValidationTest.serverConf(true);
        MockRegistrationManager regManager = new MockRegistrationManager();
        MockDataIntegrityCheck dataIntegCheck = (MockDataIntegrityCheck)Mockito.spy((Object)new MockDataIntegrityCheck());
        DataIntegrityCookieValidation v1 = new DataIntegrityCookieValidation(conf, (RegistrationManager)regManager, (DataIntegrityCheck)dataIntegCheck);
        v1.checkCookies((List)dirs);
        ((MockDataIntegrityCheck)Mockito.verify((Object)dataIntegCheck, (VerificationMode)Mockito.times((int)0))).runPreBootCheck("INVALID_COOKIE");
        dirs.add(this.initializedDir());
        v1.checkCookies((List)dirs);
        ((MockDataIntegrityCheck)Mockito.verify((Object)dataIntegCheck, (VerificationMode)Mockito.times((int)1))).runPreBootCheck("INVALID_COOKIE");
        v1.checkCookies((List)dirs);
        ((MockDataIntegrityCheck)Mockito.verify((Object)dataIntegCheck, (VerificationMode)Mockito.times((int)1))).runPreBootCheck("INVALID_COOKIE");
    }

    @Test
    public void testErrorInIntegrityCheckPreventsStamping() throws Exception {
        ArrayList dirs = Lists.newArrayList((Object[])new File[]{this.initializedDir(), this.initializedDir()});
        ServerConfiguration conf = CookieValidationTest.serverConf(true);
        MockRegistrationManager regManager = (MockRegistrationManager)Mockito.spy((Object)new MockRegistrationManager());
        MockDataIntegrityCheck dataIntegCheck = (MockDataIntegrityCheck)Mockito.spy((Object)new MockDataIntegrityCheck(){

            @Override
            public CompletableFuture<Void> runPreBootCheck(String reason) {
                return FutureUtils.exception((Throwable)new BookieException.InvalidCookieException("blah"));
            }
        });
        DataIntegrityCookieValidation v1 = new DataIntegrityCookieValidation(conf, (RegistrationManager)regManager, (DataIntegrityCheck)dataIntegCheck);
        v1.checkCookies((List)dirs);
        ((MockDataIntegrityCheck)Mockito.verify((Object)dataIntegCheck, (VerificationMode)Mockito.times((int)0))).runPreBootCheck("INVALID_COOKIE");
        ((MockRegistrationManager)Mockito.verify((Object)regManager, (VerificationMode)Mockito.times((int)1))).writeCookie((BookieId)Mockito.any(), (Versioned<byte[]>)((Versioned)Mockito.any()));
        dirs.add(this.initializedDir());
        try {
            v1.checkCookies((List)dirs);
            Assert.fail((String)"failure of data integrity should fail cookie check");
        }
        catch (BookieException.InvalidCookieException invalidCookieException) {
            // empty catch block
        }
        ((MockDataIntegrityCheck)Mockito.verify((Object)dataIntegCheck, (VerificationMode)Mockito.times((int)1))).runPreBootCheck("INVALID_COOKIE");
        ((MockRegistrationManager)Mockito.verify((Object)regManager, (VerificationMode)Mockito.times((int)1))).writeCookie((BookieId)Mockito.any(), (Versioned<byte[]>)((Versioned)Mockito.any()));
        try {
            v1.checkCookies((List)dirs);
            Assert.fail((String)"failure of data integrity should fail cookie check");
        }
        catch (BookieException.InvalidCookieException invalidCookieException) {
            // empty catch block
        }
        ((MockDataIntegrityCheck)Mockito.verify((Object)dataIntegCheck, (VerificationMode)Mockito.times((int)2))).runPreBootCheck("INVALID_COOKIE");
        ((MockRegistrationManager)Mockito.verify((Object)regManager, (VerificationMode)Mockito.times((int)1))).writeCookie((BookieId)Mockito.any(), (Versioned<byte[]>)((Versioned)Mockito.any()));
    }

    @Test
    public void testChangingBookieIdRaisesError() throws Exception {
        ArrayList dirs = Lists.newArrayList((Object[])new File[]{this.initializedDir(), this.initializedDir()});
        ServerConfiguration conf = CookieValidationTest.serverConf(true);
        MockRegistrationManager regManager = new MockRegistrationManager();
        DataIntegrityCookieValidation v1 = new DataIntegrityCookieValidation(conf, (RegistrationManager)regManager, (DataIntegrityCheck)new MockDataIntegrityCheck());
        v1.checkCookies((List)dirs);
        conf.setAdvertisedAddress("barfoo");
        DataIntegrityCookieValidation v2 = new DataIntegrityCookieValidation(conf, (RegistrationManager)regManager, (DataIntegrityCheck)new MockDataIntegrityCheck());
        try {
            v2.checkCookies((List)dirs);
            Assert.fail((String)"Check shouldn't have succeeded with new bookieId");
        }
        catch (BookieException.InvalidCookieException invalidCookieException) {
            // empty catch block
        }
        conf.setAdvertisedAddress("foobar");
        DataIntegrityCookieValidation v3 = new DataIntegrityCookieValidation(conf, (RegistrationManager)regManager, (DataIntegrityCheck)new MockDataIntegrityCheck());
        v3.checkCookies((List)dirs);
    }

    @Test
    public void testMismatchLocalCookie() throws Exception {
        ArrayList dirs = Lists.newArrayList((Object[])new File[]{this.initializedDir(), this.initializedDir()});
        ServerConfiguration conf = CookieValidationTest.serverConf(true);
        MockDataIntegrityCheck dataIntegCheck = (MockDataIntegrityCheck)Mockito.spy((Object)new MockDataIntegrityCheck());
        MockRegistrationManager regManager = (MockRegistrationManager)Mockito.spy((Object)new MockRegistrationManager());
        DataIntegrityCookieValidation v1 = new DataIntegrityCookieValidation(conf, (RegistrationManager)regManager, (DataIntegrityCheck)dataIntegCheck);
        v1.checkCookies((List)dirs);
        ((MockDataIntegrityCheck)Mockito.verify((Object)dataIntegCheck, (VerificationMode)Mockito.times((int)0))).runPreBootCheck("INVALID_COOKIE");
        ((MockRegistrationManager)Mockito.verify((Object)regManager, (VerificationMode)Mockito.times((int)1))).writeCookie((BookieId)Mockito.any(), (Versioned<byte[]>)((Versioned)Mockito.any()));
        Cookie current = Cookie.readFromDirectory((File)((File)dirs.get(0)));
        Cookie mismatch = Cookie.newBuilder((Cookie)current).setBookieId("mismatch:3181").build();
        mismatch.writeToDirectory((File)dirs.get(0));
        MatcherAssert.assertThat((Object)current, (Matcher)Matchers.not((Object)Cookie.readFromDirectory((File)((File)dirs.get(0)))));
        v1.checkCookies((List)dirs);
        ((MockDataIntegrityCheck)Mockito.verify((Object)dataIntegCheck, (VerificationMode)Mockito.times((int)1))).runPreBootCheck("INVALID_COOKIE");
        ((MockRegistrationManager)Mockito.verify((Object)regManager, (VerificationMode)Mockito.times((int)2))).writeCookie((BookieId)Mockito.any(), (Versioned<byte[]>)((Versioned)Mockito.any()));
        Cookie afterCheck = Cookie.readFromDirectory((File)((File)dirs.get(0)));
        MatcherAssert.assertThat((Object)afterCheck, (Matcher)Matchers.equalTo((Object)current));
    }

    @Test(expected=BookieException.InvalidCookieException.class)
    public void testCorruptLocalCookie() throws Exception {
        ArrayList dirs = Lists.newArrayList((Object[])new File[]{this.initializedDir(), this.initializedDir()});
        ServerConfiguration conf = CookieValidationTest.serverConf(true);
        MockDataIntegrityCheck dataIntegCheck = (MockDataIntegrityCheck)Mockito.spy((Object)new MockDataIntegrityCheck());
        MockRegistrationManager regManager = (MockRegistrationManager)Mockito.spy((Object)new MockRegistrationManager());
        DataIntegrityCookieValidation v1 = new DataIntegrityCookieValidation(conf, (RegistrationManager)regManager, (DataIntegrityCheck)dataIntegCheck);
        v1.checkCookies((List)dirs);
        ((MockDataIntegrityCheck)Mockito.verify((Object)dataIntegCheck, (VerificationMode)Mockito.times((int)0))).runPreBootCheck("INVALID_COOKIE");
        ((MockRegistrationManager)Mockito.verify((Object)regManager, (VerificationMode)Mockito.times((int)1))).writeCookie((BookieId)Mockito.any(), (Versioned<byte[]>)((Versioned)Mockito.any()));
        File cookieFile = new File((File)dirs.get(0), "VERSION");
        try (FileOutputStream out = new FileOutputStream(cookieFile);){
            out.write(-559038737);
        }
        v1.checkCookies((List)dirs);
    }
}

