/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.datainteg;

import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.bookie.MockLedgerStorage;
import org.apache.bookkeeper.bookie.datainteg.EntryCopier;
import org.apache.bookkeeper.bookie.datainteg.EntryCopierImpl;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.MockTicker;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookieClient;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.MockBookieClient;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryCopierTest {
    private static final Logger log = LoggerFactory.getLogger(EntryCopierTest.class);
    private static final BookieId bookie1 = BookieId.parse((String)"bookie1:3181");
    private static final BookieId bookie2 = BookieId.parse((String)"bookie2:3181");
    private static final BookieId bookie3 = BookieId.parse((String)"bookie3:3181");
    private static final BookieId bookie4 = BookieId.parse((String)"bookie4:3181");
    private static final BookieId bookie5 = BookieId.parse((String)"bookie5:3181");
    private static final BookieId bookie6 = BookieId.parse((String)"bookie6:3181");
    private OrderedExecutor executor = null;

    @Before
    public void setup() throws Exception {
        this.executor = OrderedExecutor.newBuilder().numThreads(1).name("test").build();
    }

    @After
    public void teardown() throws Exception {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    @Test
    public void testCopyFromAvailable() throws Exception {
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        long ledgerId = 48875L;
        LedgerMetadata metadata = LedgerMetadataBuilder.create().withId(ledgerId).withPassword(new byte[0]).withDigestType(DigestType.CRC32C).withEnsembleSize(2).withWriteQuorumSize(2).withAckQuorumSize(2).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{bookie1, bookie2})).withLastEntryId(10L).withLength(1000L).withClosedState().build();
        bookieClient.getMockBookies().seedLedger(ledgerId, metadata);
        EntryCopierImpl copier = new EntryCopierImpl(bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        EntryCopier.Batch batch = copier.newBatch(ledgerId, metadata);
        CompletableFuture f1 = batch.copyFromAvailable(0L);
        CompletableFuture f2 = batch.copyFromAvailable(2L);
        CompletableFuture f3 = batch.copyFromAvailable(4L);
        CompletableFuture f4 = batch.copyFromAvailable(10L);
        try {
            batch.copyFromAvailable(100L);
            Assert.fail((String)"Should have given IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            batch.copyFromAvailable(-1L);
            Assert.fail((String)"Should have given IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        CompletableFuture.allOf(f1, f2, f3, f4).get();
        ((MockBookieClient)Mockito.verify((Object)bookieClient, (VerificationMode)Mockito.times((int)1))).readEntry((BookieId)Mockito.eq((Object)bookie2), Mockito.eq((long)ledgerId), Mockito.eq((long)0L), (BookkeeperInternalCallbacks.ReadEntryCallback)Mockito.any(), Mockito.any(), Mockito.anyInt(), (byte[])Mockito.any());
        ((MockBookieClient)Mockito.verify((Object)bookieClient, (VerificationMode)Mockito.times((int)1))).readEntry((BookieId)Mockito.eq((Object)bookie2), Mockito.eq((long)ledgerId), Mockito.eq((long)2L), (BookkeeperInternalCallbacks.ReadEntryCallback)Mockito.any(), Mockito.any(), Mockito.anyInt(), (byte[])Mockito.any());
        ((MockBookieClient)Mockito.verify((Object)bookieClient, (VerificationMode)Mockito.times((int)1))).readEntry((BookieId)Mockito.eq((Object)bookie2), Mockito.eq((long)ledgerId), Mockito.eq((long)4L), (BookkeeperInternalCallbacks.ReadEntryCallback)Mockito.any(), Mockito.any(), Mockito.anyInt(), (byte[])Mockito.any());
        ((MockBookieClient)Mockito.verify((Object)bookieClient, (VerificationMode)Mockito.times((int)1))).readEntry((BookieId)Mockito.eq((Object)bookie2), Mockito.eq((long)ledgerId), Mockito.eq((long)10L), (BookkeeperInternalCallbacks.ReadEntryCallback)Mockito.any(), Mockito.any(), Mockito.anyInt(), (byte[])Mockito.any());
        ((MockBookieClient)Mockito.verify((Object)bookieClient, (VerificationMode)Mockito.times((int)4))).readEntry((BookieId)Mockito.eq((Object)bookie2), Mockito.eq((long)ledgerId), Mockito.anyLong(), (BookkeeperInternalCallbacks.ReadEntryCallback)Mockito.any(), Mockito.any(), Mockito.anyInt(), (byte[])Mockito.any());
        ((MockLedgerStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)4))).addEntry((ByteBuf)Mockito.any());
        MatcherAssert.assertThat((Object)storage.entryExists(ledgerId, 0L), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.entryExists(ledgerId, 2L), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.entryExists(ledgerId, 4L), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.entryExists(ledgerId, 10L), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testNoCopiesAvailable() throws Exception {
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        long ledgerId = 48875L;
        LedgerMetadata metadata = LedgerMetadataBuilder.create().withId(ledgerId).withPassword(new byte[0]).withDigestType(DigestType.CRC32C).withEnsembleSize(1).withWriteQuorumSize(1).withAckQuorumSize(1).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{bookie1})).withLastEntryId(10L).withLength(1000L).withClosedState().build();
        bookieClient.getMockBookies().seedLedger(ledgerId, metadata);
        EntryCopierImpl copier = new EntryCopierImpl(bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        EntryCopier.Batch batch = copier.newBatch(ledgerId, metadata);
        ArrayList futures = Lists.newArrayList();
        for (long l = 0L; l < 10L; ++l) {
            futures.add(batch.copyFromAvailable(l));
        }
        try {
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get();
            Assert.fail((String)"Should have failed");
        }
        catch (ExecutionException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(BKException.BKReadException.class));
        }
    }

    @Test
    public void testCopyOneEntryFails() throws Exception {
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        long ledgerId = 48875L;
        LedgerMetadata metadata = LedgerMetadataBuilder.create().withId(ledgerId).withPassword(new byte[0]).withDigestType(DigestType.CRC32C).withEnsembleSize(2).withWriteQuorumSize(2).withAckQuorumSize(2).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{bookie1, bookie2})).withLastEntryId(10L).withLength(1000L).withClosedState().build();
        bookieClient.getMockBookies().seedLedger(ledgerId, metadata);
        bookieClient.setPreReadHook((bookie, ledger, entry) -> {
            if (entry == 2L) {
                return FutureUtils.exception((Throwable)new BKException.BKTimeoutException());
            }
            return CompletableFuture.completedFuture(null);
        });
        EntryCopierImpl copier = new EntryCopierImpl(bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        EntryCopier.Batch batch = copier.newBatch(ledgerId, metadata);
        CompletableFuture f1 = batch.copyFromAvailable(0L);
        CompletableFuture f2 = batch.copyFromAvailable(2L);
        CompletableFuture f3 = batch.copyFromAvailable(4L);
        CompletableFuture f4 = batch.copyFromAvailable(10L);
        try {
            CompletableFuture.allOf(f1, f2, f3, f4).get();
            Assert.fail((String)"Should have failed");
        }
        catch (ExecutionException ee) {
            MatcherAssert.assertThat((Object)ee.getCause(), (Matcher)Matchers.instanceOf(BKException.BKTimeoutException.class));
        }
        ((MockLedgerStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)3))).addEntry((ByteBuf)Mockito.any());
        MatcherAssert.assertThat((Object)storage.entryExists(ledgerId, 0L), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.entryExists(ledgerId, 4L), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.entryExists(ledgerId, 10L), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testCopyAllEntriesFail() throws Exception {
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage());
        long ledgerId = 48875L;
        LedgerMetadata metadata = LedgerMetadataBuilder.create().withId(ledgerId).withPassword(new byte[0]).withDigestType(DigestType.CRC32C).withEnsembleSize(2).withWriteQuorumSize(2).withAckQuorumSize(2).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{bookie1, bookie2})).withLastEntryId(10L).withLength(1000L).withClosedState().build();
        bookieClient.getMockBookies().seedLedger(ledgerId, metadata);
        bookieClient.setPreReadHook((bookie, ledger, entry) -> FutureUtils.exception((Throwable)new BKException.BKTimeoutException()));
        EntryCopierImpl copier = new EntryCopierImpl(bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        EntryCopier.Batch batch = copier.newBatch(ledgerId, metadata);
        CompletableFuture f1 = batch.copyFromAvailable(0L);
        CompletableFuture f2 = batch.copyFromAvailable(2L);
        CompletableFuture f3 = batch.copyFromAvailable(4L);
        CompletableFuture f4 = batch.copyFromAvailable(10L);
        try {
            CompletableFuture.allOf(f1, f2, f3, f4).get();
            Assert.fail((String)"Should have failed");
        }
        catch (ExecutionException ee) {
            MatcherAssert.assertThat((Object)ee.getCause(), (Matcher)Matchers.instanceOf(BKException.BKTimeoutException.class));
        }
        ((MockLedgerStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)0))).addEntry((ByteBuf)Mockito.any());
    }

    @Test
    public void testCopyOneEntryFailsOnStorage() throws Exception {
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage(){

            @Override
            public long addEntry(ByteBuf buffer) throws IOException, BookieException {
                long entryId = buffer.getLong(buffer.readerIndex() + 8);
                if (entryId == 0L) {
                    throw new IOException("failing");
                }
                return super.addEntry(buffer);
            }
        });
        long ledgerId = 48875L;
        LedgerMetadata metadata = LedgerMetadataBuilder.create().withId(ledgerId).withPassword(new byte[0]).withDigestType(DigestType.CRC32C).withEnsembleSize(2).withWriteQuorumSize(2).withAckQuorumSize(2).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{bookie1, bookie2})).withLastEntryId(10L).withLength(1000L).withClosedState().build();
        bookieClient.getMockBookies().seedLedger(ledgerId, metadata);
        EntryCopierImpl copier = new EntryCopierImpl(bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        EntryCopier.Batch batch = copier.newBatch(ledgerId, metadata);
        CompletableFuture f1 = batch.copyFromAvailable(0L);
        CompletableFuture f2 = batch.copyFromAvailable(2L);
        CompletableFuture f3 = batch.copyFromAvailable(4L);
        CompletableFuture f4 = batch.copyFromAvailable(10L);
        try {
            CompletableFuture.allOf(f1, f2, f3, f4).get();
            Assert.fail((String)"Should have failed");
        }
        catch (ExecutionException ee) {
            MatcherAssert.assertThat((Object)ee.getCause(), (Matcher)Matchers.instanceOf(IOException.class));
        }
        ((MockLedgerStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)4))).addEntry((ByteBuf)Mockito.any());
        MatcherAssert.assertThat((Object)storage.entryExists(ledgerId, 0L), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.entryExists(ledgerId, 2L), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.entryExists(ledgerId, 4L), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)storage.entryExists(ledgerId, 10L), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testCopyAllEntriesFailOnStorage() throws Exception {
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        MockLedgerStorage storage = (MockLedgerStorage)Mockito.spy((Object)new MockLedgerStorage(){

            @Override
            public long addEntry(ByteBuf buffer) throws IOException, BookieException {
                throw new IOException("failing");
            }
        });
        long ledgerId = 48875L;
        LedgerMetadata metadata = LedgerMetadataBuilder.create().withId(ledgerId).withPassword(new byte[0]).withDigestType(DigestType.CRC32C).withEnsembleSize(2).withWriteQuorumSize(2).withAckQuorumSize(2).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{bookie1, bookie2})).withLastEntryId(10L).withLength(1000L).withClosedState().build();
        bookieClient.getMockBookies().seedLedger(ledgerId, metadata);
        EntryCopierImpl copier = new EntryCopierImpl(bookie1, (BookieClient)bookieClient, (LedgerStorage)storage, (Ticker)new MockTicker());
        EntryCopier.Batch batch = copier.newBatch(ledgerId, metadata);
        CompletableFuture f1 = batch.copyFromAvailable(0L);
        CompletableFuture f2 = batch.copyFromAvailable(2L);
        CompletableFuture f3 = batch.copyFromAvailable(4L);
        CompletableFuture f4 = batch.copyFromAvailable(10L);
        try {
            CompletableFuture.allOf(f1, f2, f3, f4).get();
            Assert.fail((String)"Should have failed");
        }
        catch (ExecutionException ee) {
            MatcherAssert.assertThat((Object)ee.getCause(), (Matcher)Matchers.instanceOf(IOException.class));
        }
        ((MockLedgerStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)4))).addEntry((ByteBuf)Mockito.any());
        MatcherAssert.assertThat((Object)storage.entryExists(ledgerId, 0L), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.entryExists(ledgerId, 2L), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.entryExists(ledgerId, 4L), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)storage.entryExists(ledgerId, 10L), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testReadOneEntry() throws Exception {
        long ledgerId = 48875L;
        LedgerMetadata metadata = LedgerMetadataBuilder.create().withId(ledgerId).withPassword(new byte[0]).withDigestType(DigestType.CRC32C).withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(3).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{bookie1, bookie2, bookie3})).withLastEntryId(10L).withLength(1000L).withClosedState().build();
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        bookieClient.getMockBookies().seedLedger(ledgerId, metadata);
        EntryCopierImpl copier = new EntryCopierImpl(bookie2, (BookieClient)bookieClient, (LedgerStorage)new MockLedgerStorage(), (Ticker)new MockTicker());
        EntryCopierImpl.BatchImpl batch = (EntryCopierImpl.BatchImpl)copier.newBatch(ledgerId, metadata);
        for (int i = 0; i <= 10; ++i) {
            batch.fetchEntry((long)i).get();
            ((MockBookieClient)Mockito.verify((Object)bookieClient, (VerificationMode)Mockito.times((int)(i + 1)))).readEntry((BookieId)Mockito.any(), Mockito.anyLong(), Mockito.anyLong(), (BookkeeperInternalCallbacks.ReadEntryCallback)Mockito.any(), Mockito.any(), Mockito.anyInt());
            ((MockBookieClient)Mockito.verify((Object)bookieClient, (VerificationMode)Mockito.times((int)(i + 1)))).readEntry((BookieId)Mockito.eq((Object)bookie3), Mockito.anyLong(), Mockito.anyLong(), (BookkeeperInternalCallbacks.ReadEntryCallback)Mockito.any(), Mockito.any(), Mockito.anyInt());
        }
    }

    @Test
    public void testReadOneFirstReplicaFails() throws Exception {
        long ledgerId = 48875L;
        LedgerMetadata metadata = LedgerMetadataBuilder.create().withId(ledgerId).withPassword(new byte[0]).withDigestType(DigestType.CRC32C).withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(3).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{bookie1, bookie2, bookie3})).withLastEntryId(10L).withLength(1000L).withClosedState().build();
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        bookieClient.getMockBookies().seedLedger(ledgerId, metadata);
        bookieClient.errorBookies(bookie3);
        MockTicker ticker = new MockTicker();
        EntryCopierImpl copier = new EntryCopierImpl(bookie2, (BookieClient)bookieClient, (LedgerStorage)new MockLedgerStorage(), (Ticker)ticker);
        final CompletableFuture errorProcessedPromise = new CompletableFuture();
        EntryCopierImpl entryCopierImpl = copier;
        Objects.requireNonNull(entryCopierImpl);
        EntryCopierImpl.BatchImpl batch = new EntryCopierImpl.BatchImpl(entryCopierImpl, bookie2, ledgerId, metadata, new EntryCopierImpl.SinBin((Ticker)ticker)){
            {
                EntryCopierImpl entryCopierImpl = x0;
                Objects.requireNonNull(entryCopierImpl);
                super(entryCopierImpl, bookieId, ledgerId, metadata, sinBin);
            }

            void notifyBookieError(BookieId bookie) {
                super.notifyBookieError(bookie);
                errorProcessedPromise.complete(null);
            }
        };
        batch.fetchEntry(0L).get();
        ((MockBookieClient)Mockito.verify((Object)bookieClient, (VerificationMode)Mockito.times((int)2))).readEntry((BookieId)Mockito.any(), Mockito.anyLong(), Mockito.anyLong(), (BookkeeperInternalCallbacks.ReadEntryCallback)Mockito.any(), Mockito.any(), Mockito.anyInt());
        ((MockBookieClient)Mockito.verify((Object)bookieClient, (VerificationMode)Mockito.times((int)1))).readEntry((BookieId)Mockito.eq((Object)bookie3), Mockito.anyLong(), Mockito.anyLong(), (BookkeeperInternalCallbacks.ReadEntryCallback)Mockito.any(), Mockito.any(), Mockito.anyInt());
        ((MockBookieClient)Mockito.verify((Object)bookieClient, (VerificationMode)Mockito.times((int)1))).readEntry((BookieId)Mockito.eq((Object)bookie1), Mockito.anyLong(), Mockito.anyLong(), (BookkeeperInternalCallbacks.ReadEntryCallback)Mockito.any(), Mockito.any(), Mockito.anyInt());
        errorProcessedPromise.get(10L, TimeUnit.SECONDS);
        batch.fetchEntry(1L).get();
        ((MockBookieClient)Mockito.verify((Object)bookieClient, (VerificationMode)Mockito.times((int)3))).readEntry((BookieId)Mockito.any(), Mockito.anyLong(), Mockito.anyLong(), (BookkeeperInternalCallbacks.ReadEntryCallback)Mockito.any(), Mockito.any(), Mockito.anyInt());
        ((MockBookieClient)Mockito.verify((Object)bookieClient, (VerificationMode)Mockito.times((int)2))).readEntry((BookieId)Mockito.eq((Object)bookie1), Mockito.anyLong(), Mockito.anyLong(), (BookkeeperInternalCallbacks.ReadEntryCallback)Mockito.any(), Mockito.any(), Mockito.anyInt());
    }

    @Test
    public void testReadOneAllReplicasFail() throws Exception {
        long ledgerId = 48875L;
        LedgerMetadata metadata = LedgerMetadataBuilder.create().withId(ledgerId).withPassword(new byte[0]).withDigestType(DigestType.CRC32C).withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(3).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{bookie1, bookie2, bookie3})).withLastEntryId(10L).withLength(1000L).withClosedState().build();
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        bookieClient.getMockBookies().seedLedger(ledgerId, metadata);
        bookieClient.setPreReadHook((bookie, ledgerId1, entryId) -> {
            if (bookie.equals((Object)bookie1)) {
                return FutureUtils.exception((Throwable)new BKException.BKReadException());
            }
            if (bookie.equals((Object)bookie3)) {
                return FutureUtils.exception((Throwable)new BKException.BKBookieException());
            }
            return CompletableFuture.completedFuture(null);
        });
        EntryCopierImpl copier = new EntryCopierImpl(bookie2, (BookieClient)bookieClient, (LedgerStorage)new MockLedgerStorage(), (Ticker)new MockTicker());
        EntryCopierImpl.BatchImpl batch = (EntryCopierImpl.BatchImpl)copier.newBatch(ledgerId, metadata);
        try {
            batch.fetchEntry(0L).get();
            Assert.fail((String)"Shouldn't get this far");
        }
        catch (ExecutionException ee) {
            MatcherAssert.assertThat((Object)ee.getCause(), (Matcher)Matchers.instanceOf(BKException.BKBookieException.class));
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{bookieClient});
        ((MockBookieClient)inOrder.verify((Object)bookieClient, Mockito.times((int)1))).readEntry((BookieId)Mockito.eq((Object)bookie3), Mockito.anyLong(), Mockito.anyLong(), (BookkeeperInternalCallbacks.ReadEntryCallback)Mockito.any(), Mockito.any(), Mockito.anyInt());
        ((MockBookieClient)inOrder.verify((Object)bookieClient, Mockito.times((int)1))).readEntry((BookieId)Mockito.eq((Object)bookie1), Mockito.anyLong(), Mockito.anyLong(), (BookkeeperInternalCallbacks.ReadEntryCallback)Mockito.any(), Mockito.any(), Mockito.anyInt());
    }

    @Test
    public void testReadOneWithErrorBookieReinstatedAfterSinBin() throws Exception {
        long ledgerId = 48875L;
        LedgerMetadata metadata = LedgerMetadataBuilder.create().withId(ledgerId).withPassword(new byte[0]).withDigestType(DigestType.CRC32C).withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(3).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{bookie1, bookie2, bookie3})).withLastEntryId(10L).withLength(1000L).withClosedState().build();
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        bookieClient.getMockBookies().seedLedger(ledgerId, metadata);
        bookieClient.errorBookies(bookie3);
        final CompletableFuture errorProcessedPromise = new CompletableFuture();
        MockTicker ticker = new MockTicker();
        EntryCopierImpl copier = new EntryCopierImpl(bookie2, (BookieClient)bookieClient, (LedgerStorage)new MockLedgerStorage(), (Ticker)ticker);
        EntryCopierImpl.SinBin sinBin = new EntryCopierImpl.SinBin((Ticker)ticker);
        EntryCopierImpl entryCopierImpl = copier;
        Objects.requireNonNull(entryCopierImpl);
        EntryCopierImpl.BatchImpl batch = new EntryCopierImpl.BatchImpl(entryCopierImpl, bookie2, ledgerId, metadata, sinBin){
            {
                EntryCopierImpl entryCopierImpl = x0;
                Objects.requireNonNull(entryCopierImpl);
                super(entryCopierImpl, bookieId, ledgerId, metadata, sinBin);
            }

            void notifyBookieError(BookieId bookie) {
                super.notifyBookieError(bookie);
                errorProcessedPromise.complete(null);
            }
        };
        batch.fetchEntry(0L).get();
        ((MockBookieClient)Mockito.verify((Object)bookieClient, (VerificationMode)Mockito.times((int)1))).readEntry((BookieId)Mockito.eq((Object)bookie3), Mockito.anyLong(), Mockito.anyLong(), (BookkeeperInternalCallbacks.ReadEntryCallback)Mockito.any(), Mockito.any(), Mockito.anyInt());
        ((MockBookieClient)Mockito.verify((Object)bookieClient, (VerificationMode)Mockito.times((int)1))).readEntry((BookieId)Mockito.eq((Object)bookie1), Mockito.anyLong(), Mockito.anyLong(), (BookkeeperInternalCallbacks.ReadEntryCallback)Mockito.any(), Mockito.any(), Mockito.anyInt());
        errorProcessedPromise.get(10L, TimeUnit.SECONDS);
        bookieClient.removeErrors(bookie3);
        EntryCopierImpl entryCopierImpl2 = copier;
        Objects.requireNonNull(entryCopierImpl2);
        EntryCopierImpl.BatchImpl batch2 = new EntryCopierImpl.BatchImpl(entryCopierImpl2, bookie2, ledgerId, metadata, sinBin);
        batch2.fetchEntry(0L).get();
        ((MockBookieClient)Mockito.verify((Object)bookieClient, (VerificationMode)Mockito.times((int)1))).readEntry((BookieId)Mockito.eq((Object)bookie3), Mockito.anyLong(), Mockito.anyLong(), (BookkeeperInternalCallbacks.ReadEntryCallback)Mockito.any(), Mockito.any(), Mockito.anyInt());
        ((MockBookieClient)Mockito.verify((Object)bookieClient, (VerificationMode)Mockito.times((int)2))).readEntry((BookieId)Mockito.eq((Object)bookie1), Mockito.anyLong(), Mockito.anyLong(), (BookkeeperInternalCallbacks.ReadEntryCallback)Mockito.any(), Mockito.any(), Mockito.anyInt());
        ticker.advance(70, TimeUnit.SECONDS);
        EntryCopierImpl entryCopierImpl3 = copier;
        Objects.requireNonNull(entryCopierImpl3);
        EntryCopierImpl.BatchImpl batch3 = new EntryCopierImpl.BatchImpl(entryCopierImpl3, bookie2, ledgerId, metadata, sinBin);
        batch3.fetchEntry(0L).get();
        ((MockBookieClient)Mockito.verify((Object)bookieClient, (VerificationMode)Mockito.times((int)2))).readEntry((BookieId)Mockito.eq((Object)bookie3), Mockito.anyLong(), Mockito.anyLong(), (BookkeeperInternalCallbacks.ReadEntryCallback)Mockito.any(), Mockito.any(), Mockito.anyInt());
        ((MockBookieClient)Mockito.verify((Object)bookieClient, (VerificationMode)Mockito.times((int)2))).readEntry((BookieId)Mockito.eq((Object)bookie1), Mockito.anyLong(), Mockito.anyLong(), (BookkeeperInternalCallbacks.ReadEntryCallback)Mockito.any(), Mockito.any(), Mockito.anyInt());
    }

    @Test
    public void testReadEntryOnlyOnSelf() throws Exception {
        long ledgerId = 48875L;
        LedgerMetadata metadata = LedgerMetadataBuilder.create().withId(ledgerId).withPassword(new byte[0]).withDigestType(DigestType.CRC32C).withEnsembleSize(1).withWriteQuorumSize(1).withAckQuorumSize(1).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{bookie2})).withLastEntryId(10L).withLength(1000L).withClosedState().build();
        MockBookieClient bookieClient = (MockBookieClient)Mockito.spy((Object)new MockBookieClient(this.executor));
        bookieClient.getMockBookies().seedLedger(ledgerId, metadata);
        CompletableFuture errorProcessedPromise = new CompletableFuture();
        MockTicker ticker = new MockTicker();
        EntryCopierImpl copier = new EntryCopierImpl(bookie2, (BookieClient)bookieClient, (LedgerStorage)new MockLedgerStorage(), (Ticker)ticker);
        EntryCopierImpl.BatchImpl batch = (EntryCopierImpl.BatchImpl)copier.newBatch(ledgerId, metadata);
        try {
            batch.fetchEntry(0L).get();
        }
        catch (ExecutionException ee) {
            MatcherAssert.assertThat((Object)ee.getCause(), (Matcher)Matchers.instanceOf(BKException.BKReadException.class));
        }
        ((MockBookieClient)Mockito.verify((Object)bookieClient, (VerificationMode)Mockito.times((int)0))).readEntry((BookieId)Mockito.any(), Mockito.anyLong(), Mockito.anyLong(), (BookkeeperInternalCallbacks.ReadEntryCallback)Mockito.any(), Mockito.any(), Mockito.anyInt());
    }

    @Test
    public void testPreferredBookieIndices() throws Exception {
        long ledgerId = 48875L;
        LedgerMetadata metadata1 = LedgerMetadataBuilder.create().withId(ledgerId).withPassword(new byte[0]).withDigestType(DigestType.CRC32C).withEnsembleSize(5).withWriteQuorumSize(2).withAckQuorumSize(2).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{bookie1, bookie2, bookie3, bookie4, bookie5})).newEnsembleEntry(3L, (List)Lists.newArrayList((Object[])new BookieId[]{bookie1, bookie6, bookie3, bookie4, bookie5})).newEnsembleEntry(5L, (List)Lists.newArrayList((Object[])new BookieId[]{bookie1, bookie2, bookie3, bookie4, bookie5})).withLastEntryId(10L).withLength(1000L).withClosedState().build();
        ImmutableSortedMap order = EntryCopierImpl.preferredBookieIndices((BookieId)bookie2, (LedgerMetadata)metadata1, Collections.emptySet(), (long)ledgerId);
        MatcherAssert.assertThat((Object)((List)order.get(0L)), (Matcher)Matchers.contains((Object[])new Integer[]{4, 0, 3, 2}));
        MatcherAssert.assertThat((Object)((List)order.get(3L)), (Matcher)Matchers.contains((Object[])new Integer[]{4, 1, 0, 3, 2}));
        MatcherAssert.assertThat((Object)((List)order.get(5L)), (Matcher)Matchers.contains((Object[])new Integer[]{4, 0, 3, 2}));
        ImmutableSortedMap orderWithErr = EntryCopierImpl.preferredBookieIndices((BookieId)bookie2, (LedgerMetadata)metadata1, (Set)Sets.newHashSet((Object[])new BookieId[]{bookie1, bookie3}), (long)ledgerId);
        MatcherAssert.assertThat((Object)((List)orderWithErr.get(0L)), (Matcher)Matchers.contains((Object[])new Integer[]{4, 3, 0, 2}));
        MatcherAssert.assertThat((Object)((List)orderWithErr.get(3L)), (Matcher)Matchers.contains((Object[])new Integer[]{4, 1, 3, 0, 2}));
        MatcherAssert.assertThat((Object)((List)orderWithErr.get(5L)), (Matcher)Matchers.contains((Object[])new Integer[]{4, 3, 0, 2}));
    }
}

