/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.directentrylogger;

import com.google.common.util.concurrent.MoreExecutors;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.bookkeeper.bookie.storage.directentrylogger.BufferPool;
import org.apache.bookkeeper.bookie.storage.directentrylogger.DirectEntryLogger;
import org.apache.bookkeeper.bookie.storage.directentrylogger.DirectReader;
import org.apache.bookkeeper.bookie.storage.directentrylogger.DirectWriter;
import org.apache.bookkeeper.bookie.storage.directentrylogger.TestBuffer;
import org.apache.bookkeeper.common.util.nativeio.NativeIO;
import org.apache.bookkeeper.common.util.nativeio.NativeIOException;
import org.apache.bookkeeper.common.util.nativeio.NativeIOImpl;
import org.apache.bookkeeper.slogger.Slogger;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.test.TmpDirs;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestDirectReader {
    private final TmpDirs tmpDirs = new TmpDirs();
    private final ExecutorService writeExecutor = Executors.newSingleThreadExecutor();
    private final OpStatsLogger opLogger = NullStatsLogger.INSTANCE.getOpStatsLogger("null");

    @Before
    public void before() {
        Assume.assumeFalse((boolean)SystemUtils.IS_OS_WINDOWS);
    }

    @After
    public void cleanup() throws Exception {
        this.tmpDirs.cleanup();
        this.writeExecutor.shutdownNow();
    }

    @Test
    public void testReadInt() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("readInt", "logs");
        TestDirectReader.writeFileWithPattern(ledgerDir, 1234, -559038737, 0, 0x100000);
        try (DirectReader reader = new DirectReader(1234, DirectEntryLogger.logFilename((File)ledgerDir, (int)1234), ByteBufAllocator.DEFAULT, (NativeIO)new NativeIOImpl(), 4096, 0x100000, this.opLogger);){
            MatcherAssert.assertThat((Object)reader.readIntAt(0L), (Matcher)Matchers.equalTo((Object)-559038737));
            MatcherAssert.assertThat((Object)reader.readIntAt(2L), (Matcher)Matchers.equalTo((Object)-1091576147));
            MatcherAssert.assertThat((Object)reader.readIntAt(1024L), (Matcher)Matchers.equalTo((Object)-559038737));
            MatcherAssert.assertThat((Object)reader.readIntAt(1025L), (Matcher)Matchers.equalTo((Object)-1379995682));
        }
    }

    @Test
    public void testReadIntAcrossBoundary() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("readInt", "logs");
        TestDirectReader.writeFileWithPattern(ledgerDir, 1234, -559038737, 0, 0x100000);
        try (DirectReader reader = new DirectReader(1234, DirectEntryLogger.logFilename((File)ledgerDir, (int)1234), ByteBufAllocator.DEFAULT, (NativeIO)new NativeIOImpl(), 4096, 0x100000, this.opLogger);){
            MatcherAssert.assertThat((Object)reader.readIntAt(4094L), (Matcher)Matchers.equalTo((Object)-1091576147));
        }
    }

    @Test
    public void testReadLong() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("readLong", "logs");
        TestDirectReader.writeFileWithPattern(ledgerDir, 1234, -1091581186, 0, 0x100000);
        try (DirectReader reader = new DirectReader(1234, DirectEntryLogger.logFilename((File)ledgerDir, (int)1234), ByteBufAllocator.DEFAULT, (NativeIO)new NativeIOImpl(), 4096, 0x100000, this.opLogger);){
            MatcherAssert.assertThat((Object)reader.readLongAt(0L), (Matcher)Matchers.equalTo((Object)-4688305491595506946L));
            MatcherAssert.assertThat((Object)reader.readLongAt(2L), (Matcher)Matchers.equalTo((Object)-3819405496851448081L));
            MatcherAssert.assertThat((Object)reader.readLongAt(1024L), (Matcher)Matchers.equalTo((Object)-4688305491595506946L));
            MatcherAssert.assertThat((Object)reader.readLongAt(1025L), (Matcher)Matchers.equalTo((Object)-1167841057328922946L));
        }
    }

    @Test
    public void testReadLongAcrossBoundary() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("readLong", "logs");
        TestDirectReader.writeFileWithPattern(ledgerDir, 1234, -1091581186, 0, 0x100000);
        try (DirectReader reader = new DirectReader(1234, DirectEntryLogger.logFilename((File)ledgerDir, (int)1234), ByteBufAllocator.DEFAULT, (NativeIO)new NativeIOImpl(), 4096, 0x100000, this.opLogger);){
            MatcherAssert.assertThat((Object)reader.readLongAt(0L), (Matcher)Matchers.equalTo((Object)-4688305491595506946L));
            MatcherAssert.assertThat((Object)reader.readLongAt(2L), (Matcher)Matchers.equalTo((Object)-3819405496851448081L));
            MatcherAssert.assertThat((Object)reader.readLongAt(1024L), (Matcher)Matchers.equalTo((Object)-4688305491595506946L));
            MatcherAssert.assertThat((Object)reader.readLongAt(1025L), (Matcher)Matchers.equalTo((Object)-1167841057328922946L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadBuffer() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("readBuffer", "logs");
        TestDirectReader.writeFileWithPattern(ledgerDir, 1234, -1091581186, 1, 0x100000);
        try (DirectReader reader = new DirectReader(1234, DirectEntryLogger.logFilename((File)ledgerDir, (int)1234), ByteBufAllocator.DEFAULT, (NativeIO)new NativeIOImpl(), 16384, 0x100000, this.opLogger);){
            int j;
            ByteBuf bb = reader.readBufferAt(0L, 8192);
            try {
                for (j = 0; j < 1024; ++j) {
                    MatcherAssert.assertThat((Object)bb.readInt(), (Matcher)Matchers.equalTo((Object)-1091581186));
                }
                for (int i = 0; i < 1024; ++i) {
                    MatcherAssert.assertThat((Object)bb.readInt(), (Matcher)Matchers.equalTo((Object)-1091581185));
                }
                MatcherAssert.assertThat((Object)bb.readableBytes(), (Matcher)Matchers.equalTo((Object)0));
            }
            finally {
                bb.release();
            }
            bb = reader.readBufferAt(32768L, 4096);
            try {
                for (j = 0; j < 1024; ++j) {
                    MatcherAssert.assertThat((Object)bb.readInt(), (Matcher)Matchers.equalTo((Object)-1091581178));
                }
                MatcherAssert.assertThat((Object)bb.readableBytes(), (Matcher)Matchers.equalTo((Object)0));
            }
            finally {
                bb.release();
            }
            bb = reader.readBufferAt(41083L, 345);
            try {
                MatcherAssert.assertThat((Object)bb.readByte(), (Matcher)Matchers.equalTo((Object)8));
                for (j = 0; j < 86; ++j) {
                    MatcherAssert.assertThat((Object)bb.readInt(), (Matcher)Matchers.equalTo((Object)-1091581176));
                }
                MatcherAssert.assertThat((Object)bb.readableBytes(), (Matcher)Matchers.equalTo((Object)0));
            }
            finally {
                bb.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadBufferAcrossBoundary() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("readBuffer", "logs");
        TestDirectReader.writeFileWithPattern(ledgerDir, 1234, -1091581186, 1, 0x100000);
        BufferPool buffers = new BufferPool((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, 16384, 8);
        try (DirectReader reader = new DirectReader(1234, DirectEntryLogger.logFilename((File)ledgerDir, (int)1234), ByteBufAllocator.DEFAULT, (NativeIO)new NativeIOImpl(), 16384, 0x100000, this.opLogger);){
            ByteBuf bb = reader.readBufferAt(14336L, 4096);
            try {
                for (int j = 0; j < 512; ++j) {
                    MatcherAssert.assertThat((Object)bb.readInt(), (Matcher)Matchers.equalTo((Object)-1091581183));
                }
                for (int i = 0; i < 512; ++i) {
                    MatcherAssert.assertThat((Object)bb.readInt(), (Matcher)Matchers.equalTo((Object)-1091581182));
                }
                MatcherAssert.assertThat((Object)bb.readableBytes(), (Matcher)Matchers.equalTo((Object)0));
            }
            finally {
                bb.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadBufferBiggerThanReaderBuffer() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("readBuffer", "logs");
        TestDirectReader.writeFileWithPattern(ledgerDir, 1234, -1091581186, 1, 0x100000);
        try (DirectReader reader = new DirectReader(1234, DirectEntryLogger.logFilename((File)ledgerDir, (int)1234), ByteBufAllocator.DEFAULT, (NativeIO)new NativeIOImpl(), 4096, 0x100000, this.opLogger);){
            ByteBuf bb = reader.readBufferAt(0L, 8192);
            try {
                for (int j = 0; j < 1024; ++j) {
                    MatcherAssert.assertThat((Object)bb.readInt(), (Matcher)Matchers.equalTo((Object)-1091581186));
                }
                for (int i = 0; i < 1024; ++i) {
                    MatcherAssert.assertThat((Object)bb.readInt(), (Matcher)Matchers.equalTo((Object)-1091581185));
                }
                MatcherAssert.assertThat((Object)bb.readableBytes(), (Matcher)Matchers.equalTo((Object)0));
            }
            finally {
                bb.release();
            }
        }
    }

    @Test(expected=EOFException.class)
    public void testReadPastEndOfFile() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("readBuffer", "logs");
        TestDirectReader.writeFileWithPattern(ledgerDir, 1234, -1091637521, 1, 8192);
        try (DirectReader reader = new DirectReader(1234, DirectEntryLogger.logFilename((File)ledgerDir, (int)1234), ByteBufAllocator.DEFAULT, (NativeIO)new NativeIOImpl(), 4096, 0x100000, this.opLogger);){
            reader.readBufferAt(8192L, 4096);
        }
    }

    @Test(expected=EOFException.class)
    public void testReadPastEndOfFilePartial() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("readBuffer", "logs");
        TestDirectReader.writeFileWithPattern(ledgerDir, 1234, -1091637521, 1, 8192);
        try (DirectReader reader = new DirectReader(1234, DirectEntryLogger.logFilename((File)ledgerDir, (int)1234), ByteBufAllocator.DEFAULT, (NativeIO)new NativeIOImpl(), 4096, 0x100000, this.opLogger);){
            reader.readBufferAt(6144L, 4096);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadEntries() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("readEntries", "logs");
        int entrySize = 1124;
        HashMap<Integer, Integer> offset2Pattern = new HashMap<Integer, Integer>();
        try (BufferPool buffers = new BufferPool((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, 4096, 8);
             DirectWriter writer = new DirectWriter(1234, DirectEntryLogger.logFilename((File)ledgerDir, (int)1234), 0x100000L, (ExecutorService)MoreExecutors.newDirectExecutorService(), buffers, (NativeIO)new NativeIOImpl(), Slogger.CONSOLE);){
            for (int i = 0; i < 1000; ++i) {
                ByteBuf byteBuf = Unpooled.buffer((int)entrySize);
                int pattern = 48879 + i;
                TestBuffer.fillByteBuf(byteBuf, pattern);
                int offset = writer.writeDelimited(byteBuf);
                offset2Pattern.put(offset, pattern);
            }
        }
        try (DirectReader reader = new DirectReader(1234, DirectEntryLogger.logFilename((File)ledgerDir, (int)1234), ByteBufAllocator.DEFAULT, (NativeIO)new NativeIOImpl(), 4096, 0x100000, this.opLogger);){
            ArrayList offset2PatternList = new ArrayList(offset2Pattern.entrySet());
            Collections.shuffle(offset2PatternList);
            for (Map.Entry entry : offset2PatternList) {
                ByteBuf entry2 = reader.readEntryAt(((Integer)entry.getKey()).intValue());
                try {
                    MatcherAssert.assertThat((Object)entry2.readableBytes(), (Matcher)Matchers.equalTo((Object)entrySize));
                    while (entry2.isReadable()) {
                        MatcherAssert.assertThat((Object)entry2.readInt(), (Matcher)Matchers.equalTo((Object)((Integer)entry.getValue())));
                    }
                }
                finally {
                    entry2.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadFromFileBeingWrittenNoPreallocation() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("readWhileWriting", "logs");
        int entrySize = 2056;
        NativeIOImpl nativeIO = new NativeIOImpl(){

            public int fallocate(int fd, int mode, long offset, long len) throws NativeIOException {
                return 0;
            }
        };
        try (BufferPool buffers = new BufferPool((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, 4096, 8);
             DirectWriter writer = new DirectWriter(1234, DirectEntryLogger.logFilename((File)ledgerDir, (int)1234), 0x100000L, (ExecutorService)MoreExecutors.newDirectExecutorService(), buffers, (NativeIO)new NativeIOImpl(), Slogger.CONSOLE);
             DirectReader reader = new DirectReader(1234, DirectEntryLogger.logFilename((File)ledgerDir, (int)1234), ByteBufAllocator.DEFAULT, (NativeIO)new NativeIOImpl(), 4096, 0x100000, this.opLogger);){
            ByteBuf b2 = Unpooled.buffer((int)entrySize);
            TestBuffer.fillByteBuf(b2, 65246);
            int offset = writer.writeDelimited(b2);
            try {
                reader.readEntryAt(offset);
                Assert.fail((String)"Should have failed");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            writer.flush();
            ByteBuf bbread = reader.readEntryAt(offset);
            try {
                MatcherAssert.assertThat((Object)bbread.readableBytes(), (Matcher)Matchers.equalTo((Object)entrySize));
                while (bbread.isReadable()) {
                    MatcherAssert.assertThat((Object)bbread.readInt(), (Matcher)Matchers.equalTo((Object)65246));
                }
            }
            finally {
                bbread.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadFromFileBeingWrittenReadInPreallocated() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("readWhileWriting", "logs");
        int entrySize = 2056;
        try (BufferPool buffers = new BufferPool((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, 4096, 8);
             DirectWriter writer = new DirectWriter(1234, DirectEntryLogger.logFilename((File)ledgerDir, (int)1234), 0x100000L, (ExecutorService)MoreExecutors.newDirectExecutorService(), buffers, (NativeIO)new NativeIOImpl(), Slogger.CONSOLE);
             DirectReader reader = new DirectReader(1234, DirectEntryLogger.logFilename((File)ledgerDir, (int)1234), ByteBufAllocator.DEFAULT, (NativeIO)new NativeIOImpl(), 4096, 0x100000, this.opLogger);){
            ByteBuf bb = Unpooled.buffer((int)entrySize);
            TestBuffer.fillByteBuf(bb, 65261);
            int offset = writer.writeDelimited(bb);
            try {
                reader.readEntryAt(offset);
                Assert.fail((String)"Should have failed");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            writer.flush();
            ByteBuf bbread = reader.readEntryAt(offset);
            try {
                MatcherAssert.assertThat((Object)bbread.readableBytes(), (Matcher)Matchers.equalTo((Object)entrySize));
                while (bbread.isReadable()) {
                    MatcherAssert.assertThat((Object)bbread.readInt(), (Matcher)Matchers.equalTo((Object)65261));
                }
            }
            finally {
                bbread.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPartialRead() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("partialRead", "logs");
        int entrySize = 16384;
        NativeIOImpl nativeIO = new NativeIOImpl(){

            public long pread(int fd, long buf, long size, long offset) throws NativeIOException {
                long read = super.pread(fd, buf, size, offset);
                return Math.min(read, 4096L);
            }

            public int fallocate(int fd, int mode, long offset, long len) throws NativeIOException {
                return 0;
            }
        };
        try (BufferPool buffers = new BufferPool((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, 40960, 8);
             DirectWriter writer = new DirectWriter(1234, DirectEntryLogger.logFilename((File)ledgerDir, (int)1234), 0x100000L, (ExecutorService)MoreExecutors.newDirectExecutorService(), buffers, (NativeIO)new NativeIOImpl(), Slogger.CONSOLE);){
            ByteBuf b1 = Unpooled.buffer((int)entrySize);
            TestBuffer.fillByteBuf(b1, -17957139);
            int offset1 = writer.writeDelimited(b1);
            ByteBuf b2 = Unpooled.buffer((int)entrySize);
            TestBuffer.fillByteBuf(b2, -18940194);
            int offset2 = writer.writeDelimited(b2);
            writer.flush();
            try (DirectReader reader = new DirectReader(1234, DirectEntryLogger.logFilename((File)ledgerDir, (int)1234), ByteBufAllocator.DEFAULT, (NativeIO)nativeIO, 12288, 0x100000, this.opLogger);){
                ByteBuf bbread = reader.readEntryAt(offset1);
                try {
                    MatcherAssert.assertThat((Object)bbread.readableBytes(), (Matcher)Matchers.equalTo((Object)entrySize));
                    while (bbread.readableBytes() >= 4) {
                        MatcherAssert.assertThat((Object)bbread.readInt(), (Matcher)Matchers.equalTo((Object)-17957139));
                    }
                    MatcherAssert.assertThat((Object)bbread.readableBytes(), (Matcher)Matchers.equalTo((Object)0));
                }
                finally {
                    bbread.release();
                }
                bbread = reader.readEntryAt(offset2);
                try {
                    MatcherAssert.assertThat((Object)bbread.readableBytes(), (Matcher)Matchers.equalTo((Object)entrySize));
                    while (bbread.readableBytes() >= 4) {
                        MatcherAssert.assertThat((Object)bbread.readInt(), (Matcher)Matchers.equalTo((Object)-18940194));
                    }
                    MatcherAssert.assertThat((Object)bbread.readableBytes(), (Matcher)Matchers.equalTo((Object)0));
                }
                finally {
                    bbread.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLargeEntry() throws Exception {
        int offset2;
        int offset1;
        File ledgerDir = this.tmpDirs.createNew("largeEntries", "logs");
        int entrySize = 16384;
        try (BufferPool buffers = new BufferPool((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, 32768, 8);
             DirectWriter writer = new DirectWriter(1234, DirectEntryLogger.logFilename((File)ledgerDir, (int)1234), 0x100000L, (ExecutorService)MoreExecutors.newDirectExecutorService(), buffers, (NativeIO)new NativeIOImpl(), Slogger.CONSOLE);){
            ByteBuf b1 = Unpooled.buffer((int)entrySize);
            TestBuffer.fillByteBuf(b1, -17957139);
            offset1 = writer.writeDelimited(b1);
            ByteBuf b2 = Unpooled.buffer((int)entrySize);
            TestBuffer.fillByteBuf(b2, -18940194);
            offset2 = writer.writeDelimited(b2);
            writer.flush();
        }
        try (DirectReader reader = new DirectReader(1234, DirectEntryLogger.logFilename((File)ledgerDir, (int)1234), ByteBufAllocator.DEFAULT, (NativeIO)new NativeIOImpl(), 4096, 0x100000, this.opLogger);){
            ByteBuf bbread = reader.readEntryAt(offset1);
            try {
                MatcherAssert.assertThat((Object)bbread.readableBytes(), (Matcher)Matchers.equalTo((Object)entrySize));
                while (bbread.readableBytes() >= 4) {
                    MatcherAssert.assertThat((Object)bbread.readInt(), (Matcher)Matchers.equalTo((Object)-17957139));
                }
                MatcherAssert.assertThat((Object)bbread.readableBytes(), (Matcher)Matchers.equalTo((Object)0));
            }
            finally {
                bbread.release();
            }
            bbread = reader.readEntryAt(offset2);
            try {
                MatcherAssert.assertThat((Object)bbread.readableBytes(), (Matcher)Matchers.equalTo((Object)entrySize));
                while (bbread.readableBytes() >= 4) {
                    MatcherAssert.assertThat((Object)bbread.readInt(), (Matcher)Matchers.equalTo((Object)-18940194));
                }
                MatcherAssert.assertThat((Object)bbread.readableBytes(), (Matcher)Matchers.equalTo((Object)0));
            }
            finally {
                bbread.release();
            }
        }
    }

    private static void writeFileWithPattern(File directory, int logId, int pattern, int blockIncrement, int fileSize) throws Exception {
        try (BufferPool buffers = new BufferPool((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, 4096, 8);
             DirectWriter writer = new DirectWriter(logId, DirectEntryLogger.logFilename((File)directory, (int)logId), (long)fileSize, (ExecutorService)MoreExecutors.newDirectExecutorService(), buffers, (NativeIO)new NativeIOImpl(), Slogger.CONSOLE);){
            for (int written = 0; written < fileSize; written += 4096) {
                ByteBuf bb = Unpooled.buffer((int)4096);
                TestBuffer.fillByteBuf(bb, pattern);
                writer.writeAt((long)written, bb);
                bb.release();
                pattern += blockIncrement;
            }
            writer.flush();
        }
    }
}

