/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.directentrylogger;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.List;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.storage.EntryLogTestUtils;
import org.apache.bookkeeper.bookie.storage.EntryLogger;
import org.apache.bookkeeper.bookie.storage.directentrylogger.DirectCompactionEntryLog;
import org.apache.bookkeeper.bookie.storage.directentrylogger.DirectEntryLogger;
import org.apache.bookkeeper.bookie.storage.directentrylogger.EntryLogIdsImpl;
import org.apache.bookkeeper.slogger.Slogger;
import org.apache.bookkeeper.test.TmpDirs;
import org.apache.bookkeeper.util.LedgerDirUtil;
import org.apache.commons.lang3.tuple.Pair;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestEntryLogIds {
    private static final Slogger slog = Slogger.CONSOLE;
    private final TmpDirs tmpDirs = new TmpDirs();

    @After
    public void cleanup() throws Exception {
        this.tmpDirs.cleanup();
    }

    @Test
    public void testNoStomping() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("entryLogIds", "ledgers");
        int highestSoFar = -1;
        try (EntryLogger legacy = EntryLogTestUtils.newLegacyEntryLogger(1024, ledgerDir);){
            ByteBuf e1 = EntryLogTestUtils.makeEntry(1L, 1L, 2048);
            long loc1 = legacy.addEntry(1L, e1);
            int logId1 = EntryLogTestUtils.logIdFromLocation(loc1);
            ByteBuf e2 = EntryLogTestUtils.makeEntry(1L, 2L, 2048);
            long loc2 = legacy.addEntry(1L, e2);
            int logId2 = EntryLogTestUtils.logIdFromLocation(loc2);
            MatcherAssert.assertThat((Object)logId2, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(logId1)));
            highestSoFar = logId2;
        }
        EntryLogIdsImpl ids = new EntryLogIdsImpl(EntryLogTestUtils.newDirsManager(ledgerDir), slog);
        int logId3 = ids.nextId();
        MatcherAssert.assertThat((Object)logId3, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(highestSoFar)));
        TestEntryLogIds.touchLog(ledgerDir, logId3);
        highestSoFar = logId3;
        int logId4 = ids.nextId();
        MatcherAssert.assertThat((Object)logId4, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(highestSoFar)));
        TestEntryLogIds.touchLog(ledgerDir, logId4);
        highestSoFar = logId4;
        try (EntryLogger legacy = EntryLogTestUtils.newLegacyEntryLogger(1024, ledgerDir);){
            ByteBuf e1 = EntryLogTestUtils.makeEntry(1L, 1L, 2048);
            long loc5 = legacy.addEntry(1L, e1);
            int logId5 = EntryLogTestUtils.logIdFromLocation(loc5);
            MatcherAssert.assertThat((Object)logId5, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(highestSoFar)));
            ByteBuf e2 = EntryLogTestUtils.makeEntry(1L, 2L, 2048);
            long loc6 = legacy.addEntry(1L, e2);
            int logId6 = EntryLogTestUtils.logIdFromLocation(loc6);
            MatcherAssert.assertThat((Object)logId6, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(logId5)));
        }
    }

    @Test
    public void testNoStompingDirectStartsFirst() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("entryLogIds", "ledgers");
        int highestSoFar = -1;
        EntryLogIdsImpl ids = new EntryLogIdsImpl(EntryLogTestUtils.newDirsManager(ledgerDir), slog);
        int logId1 = ids.nextId();
        MatcherAssert.assertThat((Object)logId1, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(highestSoFar)));
        TestEntryLogIds.touchLog(ledgerDir, logId1);
        highestSoFar = logId1;
        try (EntryLogger legacy = EntryLogTestUtils.newLegacyEntryLogger(1024, ledgerDir);){
            ByteBuf e1 = EntryLogTestUtils.makeEntry(1L, 1L, 2048);
            long loc2 = legacy.addEntry(1L, e1);
            int logId2 = EntryLogTestUtils.logIdFromLocation(loc2);
            MatcherAssert.assertThat((Object)logId2, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(highestSoFar)));
            highestSoFar = logId2;
            ByteBuf e2 = EntryLogTestUtils.makeEntry(1L, 2L, 2048);
            long loc3 = legacy.addEntry(1L, e2);
            int logId3 = EntryLogTestUtils.logIdFromLocation(loc3);
            MatcherAssert.assertThat((Object)logId3, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(logId2)));
            highestSoFar = logId3;
        }
        ids = new EntryLogIdsImpl(EntryLogTestUtils.newDirsManager(ledgerDir), slog);
        int logId4 = ids.nextId();
        MatcherAssert.assertThat((Object)logId4, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(highestSoFar)));
        TestEntryLogIds.touchLog(ledgerDir, logId4);
        highestSoFar = logId4;
    }

    @Test
    public void testIdGenerator() throws Exception {
        File base = this.tmpDirs.createNew("entryLogIds", "ledgers");
        File ledgerDir1 = new File(base, "l1");
        File ledgerDir2 = new File(base, "l2");
        File ledgerDir3 = new File(base, "l3");
        File ledgerDir4 = new File(base, "l4");
        ledgerDir1.mkdir();
        ledgerDir2.mkdir();
        ledgerDir3.mkdir();
        ledgerDir4.mkdir();
        LedgerDirsManager ledgerDirsManager = EntryLogTestUtils.newDirsManager(ledgerDir1, ledgerDir2);
        EntryLogIdsImpl ids1 = new EntryLogIdsImpl(ledgerDirsManager, slog);
        for (int i = 0; i < 10; ++i) {
            int logId = ids1.nextId();
            File log1 = new File(ledgerDir1 + "/current", logId + ".log");
            log1.createNewFile();
            Assert.assertEquals((long)logId, (long)i);
        }
        EntryLogIdsImpl ids2 = new EntryLogIdsImpl(ledgerDirsManager, slog);
        for (int i = 0; i < 10; ++i) {
            int logId = ids2.nextId();
            Assert.assertEquals((long)logId, (long)(10 + i));
        }
        LedgerDirsManager ledgerDirsManager3 = EntryLogTestUtils.newDirsManager(ledgerDir3);
        LedgerDirsManager ledgerDirsManager4 = EntryLogTestUtils.newDirsManager(ledgerDir4);
        EntryLogIdsImpl ids3 = new EntryLogIdsImpl(ledgerDirsManager3, slog);
        for (int i = 0; i < 10; ++i) {
            int logId = ids3.nextId();
            File log1 = new File(ledgerDir3 + "/current", logId + ".log");
            log1.createNewFile();
            Assert.assertEquals((long)logId, (long)i);
        }
        EntryLogIdsImpl ids4 = new EntryLogIdsImpl(ledgerDirsManager4, slog);
        for (int i = 0; i < 10; ++i) {
            int logId = ids4.nextId();
            Assert.assertEquals((long)logId, (long)i);
        }
    }

    @Test
    public void testMultiDirectory() throws Exception {
        File base = this.tmpDirs.createNew("entryLogIds", "ledgers");
        File ledgerDir1 = new File(base, "l1");
        File ledgerDir2 = new File(base, "l2");
        File ledgerDir3 = new File(base, "l3");
        int highestSoFar = -1;
        try (EntryLogger legacy = EntryLogTestUtils.newLegacyEntryLogger(1024, ledgerDir1, ledgerDir2, ledgerDir3);){
            ByteBuf e1 = EntryLogTestUtils.makeEntry(1L, 1L, 2048);
            long loc1 = legacy.addEntry(1L, e1);
            int logId1 = EntryLogTestUtils.logIdFromLocation(loc1);
            MatcherAssert.assertThat((Object)logId1, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(highestSoFar)));
            highestSoFar = logId1;
            ByteBuf e2 = EntryLogTestUtils.makeEntry(1L, 2L, 2048);
            long loc2 = legacy.addEntry(1L, e2);
            int logId2 = EntryLogTestUtils.logIdFromLocation(loc2);
            MatcherAssert.assertThat((Object)logId2, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(highestSoFar)));
            highestSoFar = logId2;
            ByteBuf e3 = EntryLogTestUtils.makeEntry(1L, 3L, 2048);
            long loc3 = legacy.addEntry(1L, e3);
            int logId3 = EntryLogTestUtils.logIdFromLocation(loc3);
            MatcherAssert.assertThat((Object)logId3, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(highestSoFar)));
            highestSoFar = logId3;
        }
        EntryLogIdsImpl ids = new EntryLogIdsImpl(EntryLogTestUtils.newDirsManager(ledgerDir1, ledgerDir2, ledgerDir3), slog);
        int logId4 = ids.nextId();
        MatcherAssert.assertThat((Object)logId4, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(highestSoFar)));
        TestEntryLogIds.touchLog(ledgerDir2, logId4);
        highestSoFar = logId4;
        try (EntryLogger legacy = EntryLogTestUtils.newLegacyEntryLogger(1024, ledgerDir1, ledgerDir2, ledgerDir3);){
            ByteBuf e1 = EntryLogTestUtils.makeEntry(1L, 1L, 2048);
            long loc5 = legacy.addEntry(1L, e1);
            int logId5 = EntryLogTestUtils.logIdFromLocation(loc5);
            MatcherAssert.assertThat((Object)logId5, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(highestSoFar)));
            highestSoFar = logId5;
        }
    }

    @Test
    public void testWrapAround() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("entryLogIds", "ledgers");
        new EntryLogIdsImpl(EntryLogTestUtils.newDirsManager(ledgerDir), slog);
        TestEntryLogIds.touchLog(ledgerDir, 0x7FFFFFFE);
        EntryLogIdsImpl ids = new EntryLogIdsImpl(EntryLogTestUtils.newDirsManager(ledgerDir), slog);
        int logId = ids.nextId();
        MatcherAssert.assertThat((Object)logId, (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void testCompactingLogsNotConsidered() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("entryLogIds", "ledgers");
        new EntryLogIdsImpl(EntryLogTestUtils.newDirsManager(ledgerDir), slog);
        TestEntryLogIds.touchLog(ledgerDir, 123);
        TestEntryLogIds.touchCompacting(ledgerDir, 129);
        EntryLogIdsImpl ids = new EntryLogIdsImpl(EntryLogTestUtils.newDirsManager(ledgerDir), slog);
        int logId = ids.nextId();
        MatcherAssert.assertThat((Object)logId, (Matcher)Matchers.equalTo((Object)124));
    }

    @Test
    public void testCompactedLogsConsidered() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("entryLogIds", "ledgers");
        new EntryLogIdsImpl(EntryLogTestUtils.newDirsManager(ledgerDir), slog);
        TestEntryLogIds.touchLog(ledgerDir, 123);
        TestEntryLogIds.touchCompacted(ledgerDir, 129, 123);
        EntryLogIdsImpl ids = new EntryLogIdsImpl(EntryLogTestUtils.newDirsManager(ledgerDir), slog);
        int logId = ids.nextId();
        MatcherAssert.assertThat((Object)logId, (Matcher)Matchers.equalTo((Object)130));
    }

    @Test
    public void testGapSelection() throws Exception {
        Assert.assertEquals((Object)LedgerDirUtil.findLargestGap((List)Lists.newArrayList()), (Object)Pair.of((Object)0, (Object)Integer.MAX_VALUE));
        Assert.assertEquals((Object)LedgerDirUtil.findLargestGap((List)Lists.newArrayList((Object[])new Integer[]{0})), (Object)Pair.of((Object)1, (Object)Integer.MAX_VALUE));
        Assert.assertEquals((Object)LedgerDirUtil.findLargestGap((List)Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6})), (Object)Pair.of((Object)7, (Object)Integer.MAX_VALUE));
        Assert.assertEquals((Object)LedgerDirUtil.findLargestGap((List)Lists.newArrayList((Object[])new Integer[]{Integer.MAX_VALUE})), (Object)Pair.of((Object)0, (Object)Integer.MAX_VALUE));
        Assert.assertEquals((Object)LedgerDirUtil.findLargestGap((List)Lists.newArrayList((Object[])new Integer[]{0x3FFFFFFF})), (Object)Pair.of((Object)0, (Object)0x3FFFFFFF));
        Assert.assertEquals((Object)LedgerDirUtil.findLargestGap((List)Lists.newArrayList((Object[])new Integer[]{0x3FFFFFFE})), (Object)Pair.of((Object)0x3FFFFFFF, (Object)Integer.MAX_VALUE));
    }

    private static void touchLog(File ledgerDir, int logId) throws Exception {
        MatcherAssert.assertThat((Object)DirectEntryLogger.logFile((File)new File(ledgerDir, "current"), (int)logId).createNewFile(), (Matcher)Matchers.equalTo((Object)true));
    }

    private static void touchCompacting(File ledgerDir, int logId) throws Exception {
        MatcherAssert.assertThat((Object)DirectCompactionEntryLog.compactingFile((File)new File(ledgerDir, "current"), (int)logId).createNewFile(), (Matcher)Matchers.equalTo((Object)true));
    }

    private static void touchCompacted(File ledgerDir, int newLogId, int compactedLogId) throws Exception {
        MatcherAssert.assertThat((Object)DirectCompactionEntryLog.compactedFile((File)new File(ledgerDir, "current"), (int)newLogId, (int)compactedLogId).createNewFile(), (Matcher)Matchers.equalTo((Object)true));
    }
}

