/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.directentrylogger;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.bookkeeper.bookie.EntryLogMetadata;
import org.apache.bookkeeper.bookie.storage.directentrylogger.BufferPool;
import org.apache.bookkeeper.bookie.storage.directentrylogger.DirectEntryLogger;
import org.apache.bookkeeper.bookie.storage.directentrylogger.DirectReader;
import org.apache.bookkeeper.bookie.storage.directentrylogger.DirectWriter;
import org.apache.bookkeeper.bookie.storage.directentrylogger.Header;
import org.apache.bookkeeper.bookie.storage.directentrylogger.LogMetadata;
import org.apache.bookkeeper.bookie.storage.directentrylogger.LogWriter;
import org.apache.bookkeeper.common.util.nativeio.NativeIO;
import org.apache.bookkeeper.common.util.nativeio.NativeIOImpl;
import org.apache.bookkeeper.slogger.Slogger;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.test.TmpDirs;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Test;

public class TestMetadata {
    private static final Slogger slog = Slogger.CONSOLE;
    private final OpStatsLogger opLogger = NullStatsLogger.INSTANCE.getOpStatsLogger("null");
    private final TmpDirs tmpDirs = new TmpDirs();
    private final ExecutorService writeExecutor = Executors.newSingleThreadExecutor();

    @After
    public void cleanup() throws Exception {
        this.tmpDirs.cleanup();
        this.writeExecutor.shutdownNow();
    }

    @Test
    public void testReadMetaFromHeader() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("writeMetadataBeforeFsync", "logs");
        int logId = 5678;
        try (BufferPool buffers = new BufferPool((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, 4096, 8);
             DirectWriter writer = new DirectWriter(logId, DirectEntryLogger.logFilename((File)ledgerDir, (int)logId), 0x1000000L, this.writeExecutor, buffers, (NativeIO)new NativeIOImpl(), Slogger.CONSOLE);){
            long offset = 4096L;
            writer.position(offset);
            EntryLogMetadata entryLogMetadata = new EntryLogMetadata((long)logId);
            entryLogMetadata.addLedgerSize(1L, 10L);
            entryLogMetadata.addLedgerSize(2L, 11L);
            LogMetadata.write((LogWriter)writer, (EntryLogMetadata)entryLogMetadata, (ByteBufAllocator)ByteBufAllocator.DEFAULT);
            try (DirectReader reader = new DirectReader(logId, DirectEntryLogger.logFilename((File)ledgerDir, (int)logId), ByteBufAllocator.DEFAULT, (NativeIO)new NativeIOImpl(), 4096, 0x100000, this.opLogger);){
                ByteBuf header = reader.readBufferAt(0L, 1024);
                MatcherAssert.assertThat((Object)1, (Matcher)Matchers.equalTo((Object)Header.extractVersion((ByteBuf)header)));
                MatcherAssert.assertThat((Object)offset, (Matcher)Matchers.equalTo((Object)Header.extractLedgerMapOffset((ByteBuf)header)));
                MatcherAssert.assertThat((Object)2, (Matcher)Matchers.equalTo((Object)Header.extractLedgerCount((ByteBuf)header)));
            }
        }
    }
}

