/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.directentrylogger;

import com.google.common.util.concurrent.MoreExecutors;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.bookkeeper.bookie.CompactableLedgerStorage;
import org.apache.bookkeeper.bookie.EntryLocation;
import org.apache.bookkeeper.bookie.EntryLogMetadata;
import org.apache.bookkeeper.bookie.MockLedgerStorage;
import org.apache.bookkeeper.bookie.TransactionalEntryLogCompactor;
import org.apache.bookkeeper.bookie.storage.CompactionEntryLog;
import org.apache.bookkeeper.bookie.storage.EntryLogIds;
import org.apache.bookkeeper.bookie.storage.EntryLogScanner;
import org.apache.bookkeeper.bookie.storage.EntryLogTestUtils;
import org.apache.bookkeeper.bookie.storage.EntryLogger;
import org.apache.bookkeeper.bookie.storage.directentrylogger.DirectEntryLogger;
import org.apache.bookkeeper.bookie.storage.directentrylogger.EntryLogIdsImpl;
import org.apache.bookkeeper.common.util.nativeio.NativeIO;
import org.apache.bookkeeper.common.util.nativeio.NativeIOImpl;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.slogger.Slogger;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.TmpDirs;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Test;

public class TestTransactionalEntryLogCompactor {
    private static final Slogger slog = Slogger.CONSOLE;
    private final TmpDirs tmpDirs = new TmpDirs();
    private static final long deadLedger = 1L;
    private static final long liveLedger = 2L;

    @After
    public void cleanup() throws Exception {
        this.tmpDirs.cleanup();
    }

    @Test
    public void testHappyCase() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("compactHappyCase", "ledgers");
        File curDir = new File(ledgerDir, "current");
        curDir.mkdirs();
        long logId = this.writeLogData(ledgerDir);
        MockLedgerStorage ledgerStorage = new MockLedgerStorage();
        try (DirectEntryLogger entryLogger = EntryLogTestUtils.newDirectEntryLogger(0x200000, ledgerDir);){
            TransactionalEntryLogCompactor compactor = new TransactionalEntryLogCompactor(new ServerConfiguration(), (EntryLogger)entryLogger, (CompactableLedgerStorage)ledgerStorage, removedLogId -> {});
            EntryLogMetadata meta = entryLogger.getEntryLogMetadata(logId);
            MatcherAssert.assertThat((Object)meta.containsLedger(1L), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)meta.containsLedger(2L), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)meta.getTotalSize(), (Matcher)Matchers.equalTo((Object)2008L));
            MatcherAssert.assertThat((Object)meta.getRemainingSize(), (Matcher)Matchers.equalTo((Object)meta.getTotalSize()));
            meta.removeLedgerIf(ledgerId -> ledgerId == 1L);
            MatcherAssert.assertThat((Object)compactor.compact(meta), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat(ledgerStorage.getUpdatedLocations(), (Matcher)Matchers.hasSize((int)1));
            EntryLocation loc = ledgerStorage.getUpdatedLocations().get(0);
            long compactedLogId = EntryLogTestUtils.logIdFromLocation(loc.getLocation());
            MatcherAssert.assertThat((Object)compactedLogId, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)logId)));
            MatcherAssert.assertThat((Object)loc.getLedger(), (Matcher)Matchers.equalTo((Object)2L));
            MatcherAssert.assertThat((Object)loc.getEntry(), (Matcher)Matchers.equalTo((Object)2L));
            meta = entryLogger.getEntryLogMetadata(compactedLogId);
            MatcherAssert.assertThat((Object)meta.containsLedger(1L), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat((Object)meta.containsLedger(2L), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)meta.getTotalSize(), (Matcher)Matchers.equalTo((Object)1004L));
            MatcherAssert.assertThat((Object)meta.getRemainingSize(), (Matcher)Matchers.equalTo((Object)meta.getTotalSize()));
            ByteBuf bb = entryLogger.readEntry(loc.getLedger(), loc.getEntry(), loc.getLocation());
            EntryLogTestUtils.assertEntryEquals(bb, EntryLogTestUtils.makeEntry(2L, 2L, 1000, (byte)-6));
            MatcherAssert.assertThat((Object)entryLogger.incompleteCompactionLogs(), (Matcher)Matchers.empty());
        }
    }

    @Test
    public void testHappyCase1000() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("compactHappyCase1000", "ledgers");
        File curDir = new File(ledgerDir, "current");
        curDir.mkdirs();
        long logId = this.writeLogData1000(ledgerDir);
        MockLedgerStorage ledgerStorage = new MockLedgerStorage();
        try (DirectEntryLogger entryLogger = EntryLogTestUtils.newDirectEntryLogger(0x200000, ledgerDir);){
            TransactionalEntryLogCompactor compactor = new TransactionalEntryLogCompactor(new ServerConfiguration(), (EntryLogger)entryLogger, (CompactableLedgerStorage)ledgerStorage, removedLogId -> {});
            EntryLogMetadata meta = entryLogger.getEntryLogMetadata(logId);
            MatcherAssert.assertThat((Object)meta.containsLedger(1L), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)meta.containsLedger(2L), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)meta.getTotalSize(), (Matcher)Matchers.equalTo((Object)2008000L));
            MatcherAssert.assertThat((Object)meta.getRemainingSize(), (Matcher)Matchers.equalTo((Object)meta.getTotalSize()));
            meta.removeLedgerIf(ledgerId -> ledgerId == 1L);
            MatcherAssert.assertThat((Object)compactor.compact(meta), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat(ledgerStorage.getUpdatedLocations(), (Matcher)Matchers.hasSize((int)1000));
            long compactedLogId = -1L;
            for (int i = 0; i < 1000; ++i) {
                EntryLocation loc = ledgerStorage.getUpdatedLocations().get(i);
                compactedLogId = EntryLogTestUtils.logIdFromLocation(loc.getLocation());
                MatcherAssert.assertThat((Object)compactedLogId, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)logId)));
                MatcherAssert.assertThat((Object)loc.getLedger(), (Matcher)Matchers.equalTo((Object)2L));
                MatcherAssert.assertThat((Object)loc.getEntry(), (Matcher)Matchers.equalTo((Object)i));
                ByteBuf bb = entryLogger.readEntry(loc.getLedger(), loc.getEntry(), loc.getLocation());
                EntryLogTestUtils.assertEntryEquals(bb, EntryLogTestUtils.makeEntry(2L, i, 1000, (byte)(250 + i)));
            }
            meta = entryLogger.getEntryLogMetadata(compactedLogId);
            MatcherAssert.assertThat((Object)meta.containsLedger(1L), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat((Object)meta.containsLedger(2L), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)meta.getTotalSize(), (Matcher)Matchers.equalTo((Object)1004000L));
            MatcherAssert.assertThat((Object)meta.getRemainingSize(), (Matcher)Matchers.equalTo((Object)meta.getTotalSize()));
            MatcherAssert.assertThat((Object)entryLogger.incompleteCompactionLogs(), (Matcher)Matchers.empty());
        }
    }

    @Test
    public void testScanFail() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("compactScanFail", "ledgers");
        File curDir = new File(ledgerDir, "current");
        curDir.mkdirs();
        long logId = this.writeLogData(ledgerDir);
        MockLedgerStorage ledgerStorage = new MockLedgerStorage();
        try (DirectEntryLogger entryLogger = TestTransactionalEntryLogCompactor.newDirectEntryLoggerFailAdd(ledgerDir);){
            TransactionalEntryLogCompactor compactor = new TransactionalEntryLogCompactor(new ServerConfiguration(), (EntryLogger)entryLogger, (CompactableLedgerStorage)ledgerStorage, removedLogId -> {});
            EntryLogMetadata meta = entryLogger.getEntryLogMetadata(logId);
            MatcherAssert.assertThat((Object)meta.containsLedger(1L), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)meta.containsLedger(2L), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)meta.getTotalSize(), (Matcher)Matchers.equalTo((Object)2008L));
            MatcherAssert.assertThat((Object)meta.getRemainingSize(), (Matcher)Matchers.equalTo((Object)meta.getTotalSize()));
            meta.removeLedgerIf(ledgerId -> ledgerId == 1L);
            MatcherAssert.assertThat((Object)compactor.compact(meta), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat(ledgerStorage.getUpdatedLocations(), (Matcher)Matchers.hasSize((int)0));
            MatcherAssert.assertThat((Object)entryLogger.incompleteCompactionLogs(), (Matcher)Matchers.empty());
            MatcherAssert.assertThat(this.compactingFiles(curDir), (Matcher)Matchers.empty());
            MatcherAssert.assertThat(this.compactedFiles(curDir), (Matcher)Matchers.empty());
        }
    }

    @Test
    public void testScanFailNoAbortAndContinue() throws Exception {
        EntryLogMetadata meta;
        TransactionalEntryLogCompactor compactor;
        File ledgerDir = this.tmpDirs.createNew("compactScanFail", "ledgers");
        File curDir = new File(ledgerDir, "current");
        curDir.mkdirs();
        long logId = this.writeLogData(ledgerDir);
        MockLedgerStorage ledgerStorage = new MockLedgerStorage();
        try (DirectEntryLogger entryLogger = TestTransactionalEntryLogCompactor.newDirectEntryLoggerFailAddNoAbort(ledgerDir);){
            compactor = new TransactionalEntryLogCompactor(new ServerConfiguration(), (EntryLogger)entryLogger, (CompactableLedgerStorage)ledgerStorage, removedLogId -> {});
            meta = entryLogger.getEntryLogMetadata(logId);
            MatcherAssert.assertThat((Object)meta.containsLedger(1L), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)meta.containsLedger(2L), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)meta.getTotalSize(), (Matcher)Matchers.equalTo((Object)2008L));
            MatcherAssert.assertThat((Object)meta.getRemainingSize(), (Matcher)Matchers.equalTo((Object)meta.getTotalSize()));
            meta.removeLedgerIf(ledgerId -> ledgerId == 1L);
            MatcherAssert.assertThat((Object)compactor.compact(meta), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat(ledgerStorage.getUpdatedLocations(), (Matcher)Matchers.hasSize((int)0));
            MatcherAssert.assertThat((Object)this.compactingFiles(curDir).size(), (Matcher)Matchers.equalTo((Object)1));
            MatcherAssert.assertThat(this.compactedFiles(curDir), (Matcher)Matchers.empty());
        }
        entryLogger = EntryLogTestUtils.newDirectEntryLogger(0x200000, ledgerDir);
        try {
            compactor = new TransactionalEntryLogCompactor(new ServerConfiguration(), (EntryLogger)entryLogger, (CompactableLedgerStorage)ledgerStorage, removedLogId -> {});
            compactor.cleanUpAndRecover();
            MatcherAssert.assertThat(this.compactingFiles(curDir), (Matcher)Matchers.empty());
            MatcherAssert.assertThat(this.compactedFiles(curDir), (Matcher)Matchers.empty());
            meta = entryLogger.getEntryLogMetadata(logId);
            meta.removeLedgerIf(ledgerId -> ledgerId == 1L);
            MatcherAssert.assertThat((Object)compactor.compact(meta), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat(ledgerStorage.getUpdatedLocations(), (Matcher)Matchers.hasSize((int)1));
            EntryLocation loc = ledgerStorage.getUpdatedLocations().get(0);
            long compactedLogId = EntryLogTestUtils.logIdFromLocation(loc.getLocation());
            MatcherAssert.assertThat((Object)compactedLogId, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)logId)));
            MatcherAssert.assertThat((Object)loc.getLedger(), (Matcher)Matchers.equalTo((Object)2L));
            MatcherAssert.assertThat((Object)loc.getEntry(), (Matcher)Matchers.equalTo((Object)2L));
        }
        finally {
            if (entryLogger != null) {
                entryLogger.close();
            }
        }
    }

    @Test
    public void testFlushFail() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("compactScanFail", "ledgers");
        File curDir = new File(ledgerDir, "current");
        curDir.mkdirs();
        long logId = this.writeLogData(ledgerDir);
        MockLedgerStorage ledgerStorage = new MockLedgerStorage();
        try (DirectEntryLogger entryLogger = TestTransactionalEntryLogCompactor.newDirectEntryLoggerFailFlush(ledgerDir);){
            TransactionalEntryLogCompactor compactor = new TransactionalEntryLogCompactor(new ServerConfiguration(), (EntryLogger)entryLogger, (CompactableLedgerStorage)ledgerStorage, removedLogId -> {});
            EntryLogMetadata meta = entryLogger.getEntryLogMetadata(logId);
            MatcherAssert.assertThat((Object)meta.containsLedger(1L), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)meta.containsLedger(2L), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)meta.getTotalSize(), (Matcher)Matchers.equalTo((Object)2008L));
            MatcherAssert.assertThat((Object)meta.getRemainingSize(), (Matcher)Matchers.equalTo((Object)meta.getTotalSize()));
            meta.removeLedgerIf(ledgerId -> ledgerId == 1L);
            MatcherAssert.assertThat((Object)compactor.compact(meta), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat(ledgerStorage.getUpdatedLocations(), (Matcher)Matchers.hasSize((int)0));
            MatcherAssert.assertThat((Object)entryLogger.incompleteCompactionLogs(), (Matcher)Matchers.empty());
            MatcherAssert.assertThat(this.compactingFiles(curDir), (Matcher)Matchers.empty());
            MatcherAssert.assertThat(this.compactedFiles(curDir), (Matcher)Matchers.empty());
        }
    }

    @Test
    public void testMarkCompactFailNoAbort() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("compactScanFail", "ledgers");
        File curDir = new File(ledgerDir, "current");
        curDir.mkdirs();
        long logId = this.writeLogData(ledgerDir);
        MockLedgerStorage ledgerStorage = new MockLedgerStorage();
        try (DirectEntryLogger entryLogger = TestTransactionalEntryLogCompactor.newDirectEntryLoggerFailMarkCompactedNoAbort(ledgerDir);){
            TransactionalEntryLogCompactor compactor = new TransactionalEntryLogCompactor(new ServerConfiguration(), (EntryLogger)entryLogger, (CompactableLedgerStorage)ledgerStorage, removedLogId -> {});
            EntryLogMetadata meta = entryLogger.getEntryLogMetadata(logId);
            MatcherAssert.assertThat((Object)meta.containsLedger(1L), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)meta.containsLedger(2L), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)meta.getTotalSize(), (Matcher)Matchers.equalTo((Object)2008L));
            MatcherAssert.assertThat((Object)meta.getRemainingSize(), (Matcher)Matchers.equalTo((Object)meta.getTotalSize()));
            meta.removeLedgerIf(ledgerId -> ledgerId == 1L);
            MatcherAssert.assertThat((Object)compactor.compact(meta), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat(ledgerStorage.getUpdatedLocations(), (Matcher)Matchers.hasSize((int)0));
            MatcherAssert.assertThat(this.compactingFiles(curDir), (Matcher)Matchers.empty());
            MatcherAssert.assertThat(this.compactedFiles(curDir), (Matcher)Matchers.hasSize((int)1));
        }
        entryLogger = EntryLogTestUtils.newDirectEntryLogger(0x200000, ledgerDir);
        try {
            MatcherAssert.assertThat((Object)entryLogger.logExists(logId), (Matcher)Matchers.equalTo((Object)true));
            CompletableFuture removedId = new CompletableFuture();
            TransactionalEntryLogCompactor compactor = new TransactionalEntryLogCompactor(new ServerConfiguration(), (EntryLogger)entryLogger, (CompactableLedgerStorage)ledgerStorage, removedLogId -> removedId.complete(removedLogId));
            compactor.cleanUpAndRecover();
            MatcherAssert.assertThat(this.compactingFiles(curDir), (Matcher)Matchers.empty());
            MatcherAssert.assertThat(this.compactedFiles(curDir), (Matcher)Matchers.empty());
            MatcherAssert.assertThat((Object)removedId.isDone(), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)((Long)removedId.get()), (Matcher)Matchers.equalTo((Object)logId));
            MatcherAssert.assertThat(ledgerStorage.getUpdatedLocations(), (Matcher)Matchers.hasSize((int)1));
            EntryLocation loc = ledgerStorage.getUpdatedLocations().get(0);
            long compactedLogId = EntryLogTestUtils.logIdFromLocation(loc.getLocation());
            MatcherAssert.assertThat((Object)compactedLogId, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)logId)));
            MatcherAssert.assertThat((Object)loc.getLedger(), (Matcher)Matchers.equalTo((Object)2L));
            MatcherAssert.assertThat((Object)loc.getEntry(), (Matcher)Matchers.equalTo((Object)2L));
            EntryLogMetadata meta = entryLogger.getEntryLogMetadata(compactedLogId);
            MatcherAssert.assertThat((Object)meta.containsLedger(1L), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat((Object)meta.containsLedger(2L), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)meta.getTotalSize(), (Matcher)Matchers.equalTo((Object)1004L));
            MatcherAssert.assertThat((Object)meta.getRemainingSize(), (Matcher)Matchers.equalTo((Object)meta.getTotalSize()));
            ByteBuf bb = entryLogger.readEntry(loc.getLedger(), loc.getEntry(), loc.getLocation());
            EntryLogTestUtils.assertEntryEquals(bb, EntryLogTestUtils.makeEntry(2L, 2L, 1000, (byte)-6));
            MatcherAssert.assertThat((Object)entryLogger.incompleteCompactionLogs(), (Matcher)Matchers.empty());
        }
        finally {
            if (entryLogger != null) {
                entryLogger.close();
            }
        }
    }

    @Test
    public void testIndexFail() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("compactScanFail", "ledgers");
        File curDir = new File(ledgerDir, "current");
        curDir.mkdirs();
        long logId = this.writeLogData(ledgerDir);
        MockLedgerStorage ledgerStorageFailFlush = new MockLedgerStorage(){

            @Override
            public void flushEntriesLocationsIndex() throws IOException {
                throw new IOException("fail on flush");
            }
        };
        try (DirectEntryLogger entryLogger = EntryLogTestUtils.newDirectEntryLogger(0x200000, ledgerDir);){
            TransactionalEntryLogCompactor compactor = new TransactionalEntryLogCompactor(new ServerConfiguration(), (EntryLogger)entryLogger, (CompactableLedgerStorage)ledgerStorageFailFlush, removedLogId -> {});
            EntryLogMetadata meta = entryLogger.getEntryLogMetadata(logId);
            MatcherAssert.assertThat((Object)meta.containsLedger(1L), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)meta.containsLedger(2L), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)meta.getTotalSize(), (Matcher)Matchers.equalTo((Object)2008L));
            MatcherAssert.assertThat((Object)meta.getRemainingSize(), (Matcher)Matchers.equalTo((Object)meta.getTotalSize()));
            meta.removeLedgerIf(ledgerId -> ledgerId == 1L);
            MatcherAssert.assertThat((Object)compactor.compact(meta), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat(ledgerStorageFailFlush.getUpdatedLocations(), (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat(this.compactingFiles(curDir), (Matcher)Matchers.empty());
            MatcherAssert.assertThat(this.compactedFiles(curDir), (Matcher)Matchers.hasSize((int)1));
        }
        MockLedgerStorage ledgerStorage = new MockLedgerStorage();
        CompletableFuture removedId = new CompletableFuture();
        try (DirectEntryLogger entryLogger = EntryLogTestUtils.newDirectEntryLogger(0x200000, ledgerDir);){
            TransactionalEntryLogCompactor compactor = new TransactionalEntryLogCompactor(new ServerConfiguration(), (EntryLogger)entryLogger, (CompactableLedgerStorage)ledgerStorage, removedLogId -> removedId.complete(removedLogId));
            MatcherAssert.assertThat((Object)entryLogger.logExists(logId), (Matcher)Matchers.equalTo((Object)true));
            compactor.cleanUpAndRecover();
            MatcherAssert.assertThat(this.compactingFiles(curDir), (Matcher)Matchers.empty());
            MatcherAssert.assertThat(this.compactedFiles(curDir), (Matcher)Matchers.empty());
            MatcherAssert.assertThat((Object)removedId.isDone(), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)((Long)removedId.get()), (Matcher)Matchers.equalTo((Object)logId));
            MatcherAssert.assertThat(ledgerStorage.getUpdatedLocations(), (Matcher)Matchers.hasSize((int)1));
            EntryLocation loc = ledgerStorage.getUpdatedLocations().get(0);
            long compactedLogId = EntryLogTestUtils.logIdFromLocation(loc.getLocation());
            MatcherAssert.assertThat((Object)compactedLogId, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)logId)));
            MatcherAssert.assertThat((Object)loc.getLedger(), (Matcher)Matchers.equalTo((Object)2L));
            MatcherAssert.assertThat((Object)loc.getEntry(), (Matcher)Matchers.equalTo((Object)2L));
            EntryLogMetadata meta = entryLogger.getEntryLogMetadata(compactedLogId);
            MatcherAssert.assertThat((Object)meta.containsLedger(1L), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat((Object)meta.containsLedger(2L), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)meta.getTotalSize(), (Matcher)Matchers.equalTo((Object)1004L));
            MatcherAssert.assertThat((Object)meta.getRemainingSize(), (Matcher)Matchers.equalTo((Object)meta.getTotalSize()));
            ByteBuf bb = entryLogger.readEntry(loc.getLedger(), loc.getEntry(), loc.getLocation());
            EntryLogTestUtils.assertEntryEquals(bb, EntryLogTestUtils.makeEntry(2L, 2L, 1000, (byte)-6));
            MatcherAssert.assertThat((Object)entryLogger.incompleteCompactionLogs(), (Matcher)Matchers.empty());
        }
    }

    @Test
    public void testMetadataWritten() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("compactHappyCase", "ledgers");
        File curDir = new File(ledgerDir, "current");
        curDir.mkdirs();
        long logId = this.writeLogData1000(ledgerDir);
        MockLedgerStorage ledgerStorage = new MockLedgerStorage();
        try (DirectEntryLogger entryLogger = EntryLogTestUtils.newDirectEntryLogger(0x200000, ledgerDir);){
            TransactionalEntryLogCompactor compactor = new TransactionalEntryLogCompactor(new ServerConfiguration(), (EntryLogger)entryLogger, (CompactableLedgerStorage)ledgerStorage, removedLogId -> {});
            EntryLogMetadata meta = entryLogger.getEntryLogMetadata(logId);
            meta.removeLedgerIf(ledgerId -> ledgerId == 1L);
            MatcherAssert.assertThat((Object)compactor.compact(meta), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat(ledgerStorage.getUpdatedLocations(), (Matcher)Matchers.hasSize((int)1000));
            long compactedLogId = EntryLogTestUtils.logIdFromLocation(ledgerStorage.getUpdatedLocations().get(0).getLocation());
            meta = entryLogger.readEntryLogIndex(compactedLogId);
            MatcherAssert.assertThat((Object)meta.containsLedger(1L), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat((Object)meta.containsLedger(2L), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)meta.getTotalSize(), (Matcher)Matchers.equalTo((Object)1004000L));
            MatcherAssert.assertThat((Object)meta.getRemainingSize(), (Matcher)Matchers.equalTo((Object)meta.getTotalSize()));
        }
    }

    Set<File> compactingFiles(File dir) throws Exception {
        return Arrays.stream(dir.listFiles(f -> f.getName().endsWith(".log.compacting"))).collect(Collectors.toSet());
    }

    Set<File> compactedFiles(File dir) throws Exception {
        return Arrays.stream(dir.listFiles(f -> f.getName().endsWith(".compacted"))).collect(Collectors.toSet());
    }

    int writeLogData(File ledgerDir) throws Exception {
        try (EntryLogger entryLogger = EntryLogTestUtils.newLegacyEntryLogger(0x200000, ledgerDir);){
            long loc1 = entryLogger.addEntry(1L, EntryLogTestUtils.makeEntry(1L, 1L, 1000, (byte)-34));
            long loc2 = entryLogger.addEntry(2L, EntryLogTestUtils.makeEntry(2L, 2L, 1000, (byte)-6));
            MatcherAssert.assertThat((Object)EntryLogTestUtils.logIdFromLocation(loc1), (Matcher)Matchers.equalTo((Object)EntryLogTestUtils.logIdFromLocation(loc2)));
            int n = EntryLogTestUtils.logIdFromLocation(loc2);
            return n;
        }
    }

    int writeLogData1000(File ledgerDir) throws Exception {
        try (DirectEntryLogger entryLogger = EntryLogTestUtils.newDirectEntryLogger(0x200000, ledgerDir);){
            long loc2 = -1L;
            for (int i = 0; i < 1000; ++i) {
                long loc1 = entryLogger.addEntry(1L, EntryLogTestUtils.makeEntry(1L, i, 1000, (byte)(222 + i)));
                if (loc2 != -1L) {
                    MatcherAssert.assertThat((Object)EntryLogTestUtils.logIdFromLocation(loc1), (Matcher)Matchers.equalTo((Object)EntryLogTestUtils.logIdFromLocation(loc2)));
                }
                loc2 = entryLogger.addEntry(2L, EntryLogTestUtils.makeEntry(2L, i, 1000, (byte)(250 + i)));
                MatcherAssert.assertThat((Object)EntryLogTestUtils.logIdFromLocation(loc1), (Matcher)Matchers.equalTo((Object)EntryLogTestUtils.logIdFromLocation(loc2)));
            }
            int n = EntryLogTestUtils.logIdFromLocation(loc2);
            return n;
        }
    }

    private static DirectEntryLogger newDirectEntryLoggerFailAdd(File ledgerDir) throws Exception {
        return TestTransactionalEntryLogCompactor.newDirectEntryLoggerCompactionOverride(ledgerDir, cel -> new CompactionEntryLogProxy((CompactionEntryLog)cel){

            @Override
            public long addEntry(long ledgerId, ByteBuf entry) throws IOException {
                throw new IOException("Don't allow adds");
            }
        });
    }

    private static DirectEntryLogger newDirectEntryLoggerFailAddNoAbort(File ledgerDir) throws Exception {
        return TestTransactionalEntryLogCompactor.newDirectEntryLoggerCompactionOverride(ledgerDir, cel -> new CompactionEntryLogProxy((CompactionEntryLog)cel){

            @Override
            public long addEntry(long ledgerId, ByteBuf entry) throws IOException {
                throw new IOException("Don't allow adds");
            }

            @Override
            public void abort() {
            }
        });
    }

    private static DirectEntryLogger newDirectEntryLoggerFailFlush(File ledgerDir) throws Exception {
        return TestTransactionalEntryLogCompactor.newDirectEntryLoggerCompactionOverride(ledgerDir, cel -> new CompactionEntryLogProxy((CompactionEntryLog)cel){

            @Override
            public void flush() throws IOException {
                throw new IOException("No flushing");
            }
        });
    }

    private static DirectEntryLogger newDirectEntryLoggerFailMarkCompactedNoAbort(File ledgerDir) throws Exception {
        return TestTransactionalEntryLogCompactor.newDirectEntryLoggerCompactionOverride(ledgerDir, cel -> new CompactionEntryLogProxy((CompactionEntryLog)cel){

            @Override
            public void markCompacted() throws IOException {
                super.markCompacted();
                throw new IOException("No compact");
            }

            @Override
            public void abort() {
            }
        });
    }

    private static DirectEntryLogger newDirectEntryLoggerCompactionOverride(File ledgerDir, final Function<CompactionEntryLog, CompactionEntryLog> override) throws Exception {
        File curDir = new File(ledgerDir, "current");
        curDir.mkdirs();
        return new DirectEntryLogger(curDir, (EntryLogIds)new EntryLogIdsImpl(EntryLogTestUtils.newDirsManager(ledgerDir), slog), (NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, (ExecutorService)MoreExecutors.newDirectExecutorService(), (ExecutorService)MoreExecutors.newDirectExecutorService(), 0x200000L, 0xA00000, 0x100000L, 0x100000L, 4096, 1, 300, slog, (StatsLogger)NullStatsLogger.INSTANCE){

            public CompactionEntryLog newCompactionLog(long logToCompact) throws IOException {
                return (CompactionEntryLog)override.apply(super.newCompactionLog(logToCompact));
            }
        };
    }

    private static class CompactionEntryLogProxy
    implements CompactionEntryLog {
        protected final CompactionEntryLog delegate;

        CompactionEntryLogProxy(CompactionEntryLog delegate) {
            this.delegate = delegate;
        }

        public long addEntry(long ledgerId, ByteBuf entry) throws IOException {
            return this.delegate.addEntry(ledgerId, entry);
        }

        public void scan(EntryLogScanner scanner) throws IOException {
            this.delegate.scan(scanner);
        }

        public void flush() throws IOException {
            this.delegate.flush();
        }

        public void abort() {
            this.delegate.abort();
        }

        public void markCompacted() throws IOException {
            this.delegate.markCompacted();
        }

        public void makeAvailable() throws IOException {
            this.delegate.makeAvailable();
        }

        public void finalizeAndCleanup() {
            this.delegate.finalizeAndCleanup();
        }

        public long getDstLogId() {
            return this.delegate.getDstLogId();
        }

        public long getSrcLogId() {
            return this.delegate.getSrcLogId();
        }
    }
}

