/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeSet;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.BookieShell;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.Checkpointer;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorage;
import org.apache.bookkeeper.bookie.storage.ldb.LocationsIndexRebuildOp;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.TmpDirs;
import org.apache.bookkeeper.util.DiskChecker;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;

public class LocationsIndexRebuildTest {
    CheckpointSource checkpointSource = new CheckpointSource(){

        public CheckpointSource.Checkpoint newCheckpoint() {
            return CheckpointSource.Checkpoint.MAX;
        }

        public void checkpointComplete(CheckpointSource.Checkpoint checkpoint, boolean compact) throws IOException {
        }
    };
    Checkpointer checkpointer = new Checkpointer(){

        public void startCheckpoint(CheckpointSource.Checkpoint checkpoint) {
        }

        public void start() {
        }
    };
    protected final TmpDirs tmpDirs = new TmpDirs();

    private String newDirectory() throws Exception {
        File d = this.tmpDirs.createNew("bkTest", ".dir");
        d.delete();
        d.mkdir();
        File curDir = BookieImpl.getCurrentDirectory((File)d);
        BookieImpl.checkDirectoryStructure((File)curDir);
        return d.getPath();
    }

    @Test
    public void test() throws Exception {
        File tmpDir = File.createTempFile("bkTest", ".dir");
        tmpDir.delete();
        tmpDir.mkdir();
        File curDir = BookieImpl.getCurrentDirectory((File)tmpDir);
        BookieImpl.checkDirectoryStructure((File)curDir);
        System.out.println(tmpDir);
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setLedgerDirNames(new String[]{tmpDir.toString()});
        conf.setLedgerStorageClass(DbLedgerStorage.class.getName());
        LedgerDirsManager ledgerDirsManager = new LedgerDirsManager(conf, conf.getLedgerDirs(), new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold()));
        DbLedgerStorage ledgerStorage = new DbLedgerStorage();
        ledgerStorage.initialize(conf, null, ledgerDirsManager, ledgerDirsManager, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        ledgerStorage.setCheckpointer(this.checkpointer);
        ledgerStorage.setCheckpointSource(this.checkpointSource);
        for (long ledgerId = 0L; ledgerId < 5L; ++ledgerId) {
            ledgerStorage.setMasterKey(ledgerId, ("ledger-" + ledgerId).getBytes());
            ledgerStorage.setFenced(ledgerId);
            for (long entryId = 0L; entryId < 100L; ++entryId) {
                ByteBuf entry = Unpooled.buffer((int)128);
                entry.writeLong(ledgerId);
                entry.writeLong(entryId);
                entry.writeBytes(("entry-" + entryId).getBytes());
                ledgerStorage.addEntry(entry);
            }
        }
        ledgerStorage.flush();
        ledgerStorage.shutdown();
        BookieShell shell = new BookieShell();
        shell.setConf((CompositeConfiguration)conf);
        int res = shell.run(new String[]{"rebuild-db-ledger-locations-index"});
        Assert.assertEquals((long)0L, (long)res);
        ledgerStorage = new DbLedgerStorage();
        ledgerStorage.initialize(conf, null, ledgerDirsManager, ledgerDirsManager, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        ledgerStorage.setCheckpointSource(this.checkpointSource);
        ledgerStorage.setCheckpointer(this.checkpointer);
        TreeSet ledgers = Sets.newTreeSet((Iterable)ledgerStorage.getActiveLedgersInRange(0L, Long.MAX_VALUE));
        Assert.assertEquals((Object)Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])new Long[]{0L, 1L, 2L, 3L, 4L})), (Object)ledgers);
        for (long ledgerId = 0L; ledgerId < 5L; ++ledgerId) {
            Assert.assertEquals((Object)true, (Object)ledgerStorage.isFenced(ledgerId));
            Assert.assertEquals((Object)("ledger-" + ledgerId), (Object)new String(ledgerStorage.readMasterKey(ledgerId)));
            ByteBuf lastEntry = ledgerStorage.getLastEntry(ledgerId);
            Assert.assertEquals((long)ledgerId, (long)lastEntry.readLong());
            long lastEntryId = lastEntry.readLong();
            Assert.assertEquals((long)99L, (long)lastEntryId);
            for (long entryId = 0L; entryId < 100L; ++entryId) {
                ByteBuf entry = Unpooled.buffer((int)1024);
                entry.writeLong(ledgerId);
                entry.writeLong(entryId);
                entry.writeBytes(("entry-" + entryId).getBytes());
                ByteBuf result = ledgerStorage.getEntry(ledgerId, entryId);
                Assert.assertEquals((Object)entry, (Object)result);
            }
        }
        ledgerStorage.shutdown();
        FileUtils.forceDelete((File)tmpDir);
    }

    @Test
    public void testMultiLedgerIndexDiffDirs() throws Exception {
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setLedgerDirNames(new String[]{this.newDirectory(), this.newDirectory()});
        conf.setIndexDirName(new String[]{this.newDirectory(), this.newDirectory()});
        conf.setLedgerStorageClass(DbLedgerStorage.class.getName());
        DiskChecker diskChecker = new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold());
        LedgerDirsManager ledgerDirsManager = new LedgerDirsManager(conf, conf.getLedgerDirs(), diskChecker);
        LedgerDirsManager indexDirsManager = new LedgerDirsManager(conf, conf.getIndexDirs(), diskChecker);
        DbLedgerStorage ledgerStorage = new DbLedgerStorage();
        ledgerStorage.initialize(conf, null, ledgerDirsManager, indexDirsManager, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        ledgerStorage.setCheckpointer(this.checkpointer);
        ledgerStorage.setCheckpointSource(this.checkpointSource);
        for (long ledgerId = 0L; ledgerId < 5L; ++ledgerId) {
            ledgerStorage.setMasterKey(ledgerId, ("ledger-" + ledgerId).getBytes());
            ledgerStorage.setFenced(ledgerId);
            for (long entryId = 0L; entryId < 100L; ++entryId) {
                ByteBuf entry = Unpooled.buffer((int)128);
                entry.writeLong(ledgerId);
                entry.writeLong(entryId);
                entry.writeBytes(("entry-" + entryId).getBytes());
                ledgerStorage.addEntry(entry);
            }
        }
        ledgerStorage.flush();
        ledgerStorage.shutdown();
        new LocationsIndexRebuildOp(conf).initiate();
        ledgerStorage = new DbLedgerStorage();
        ledgerStorage.initialize(conf, null, ledgerDirsManager, indexDirsManager, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        ledgerStorage.setCheckpointSource(this.checkpointSource);
        ledgerStorage.setCheckpointer(this.checkpointer);
        TreeSet ledgers = Sets.newTreeSet((Iterable)ledgerStorage.getActiveLedgersInRange(0L, Long.MAX_VALUE));
        Assert.assertEquals((Object)Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])new Long[]{0L, 1L, 2L, 3L, 4L})), (Object)ledgers);
        for (long ledgerId = 0L; ledgerId < 5L; ++ledgerId) {
            Assert.assertEquals((Object)true, (Object)ledgerStorage.isFenced(ledgerId));
            Assert.assertEquals((Object)("ledger-" + ledgerId), (Object)new String(ledgerStorage.readMasterKey(ledgerId)));
            ByteBuf lastEntry = ledgerStorage.getLastEntry(ledgerId);
            Assert.assertEquals((long)ledgerId, (long)lastEntry.readLong());
            long lastEntryId = lastEntry.readLong();
            Assert.assertEquals((long)99L, (long)lastEntryId);
            for (long entryId = 0L; entryId < 100L; ++entryId) {
                ByteBuf entry = Unpooled.buffer((int)1024);
                entry.writeLong(ledgerId);
                entry.writeLong(entryId);
                entry.writeBytes(("entry-" + entryId).getBytes());
                ByteBuf result = ledgerStorage.getEntry(ledgerId, entryId);
                Assert.assertEquals((Object)entry, (Object)result);
            }
        }
        ledgerStorage.shutdown();
        ArrayList toDeleted = Lists.newArrayList((Object[])conf.getLedgerDirNames());
        toDeleted.addAll(Lists.newArrayList((Object[])conf.getIndexDirNames()));
        toDeleted.forEach(d -> {
            try {
                FileUtils.forceDelete((File)new File((String)d));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }
}

