/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.api.LedgerEntries;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.client.api.WriteHandle;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.discover.ZKRegistrationClient;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieNetworkAddressChangeTest
extends BookKeeperClusterTestCase {
    private static final Logger log = LoggerFactory.getLogger(BookieNetworkAddressChangeTest.class);

    public BookieNetworkAddressChangeTest() {
        super(1);
        this.useUUIDasBookieId = true;
    }

    @Test
    public void testFollowBookieAddressChange() throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        try (org.apache.bookkeeper.client.api.BookKeeper bkc = org.apache.bookkeeper.client.api.BookKeeper.newBuilder((ClientConfiguration)conf).build();){
            long lId;
            try (WriteHandle h = (WriteHandle)bkc.newCreateLedgerOp().withAckQuorumSize(1).withEnsembleSize(1).withWriteQuorumSize(1).withPassword(new byte[0]).execute().get();){
                lId = h.getId();
                h.append("foo".getBytes("utf-8"));
            }
            this.restartBookies(c -> c);
            h = (ReadHandle)bkc.newOpenLedgerOp().withLedgerId(lId).withRecovery(true).withPassword(new byte[0]).execute().get();
            try {
                Assert.assertEquals((long)0L, (long)h.getLastAddConfirmed());
                try (LedgerEntries entries = h.read(0L, 0L);){
                    Assert.assertEquals((Object)"foo", (Object)new String(entries.getEntry(0L).getEntryBytes(), "utf-8"));
                }
            }
            finally {
                if (h != null) {
                    h.close();
                }
            }
        }
    }

    @Test
    @Ignore(value="PLSR-1850 Seems like restart of the bookie always comes up on same port hence failing this test")
    public void testFollowBookieAddressChangeTrckingDisabled() throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        conf.setEnableBookieAddressTracking(false);
        try (org.apache.bookkeeper.client.api.BookKeeper bkc = org.apache.bookkeeper.client.api.BookKeeper.newBuilder((ClientConfiguration)conf).build();){
            long lId;
            try (WriteHandle h = (WriteHandle)bkc.newCreateLedgerOp().withAckQuorumSize(1).withEnsembleSize(1).withWriteQuorumSize(1).withPassword(new byte[0]).execute().get();){
                lId = h.getId();
                h.append("foo".getBytes("utf-8"));
            }
            this.restartBookie(this.getBookie(0));
            h = (ReadHandle)bkc.newOpenLedgerOp().withLedgerId(lId).withRecovery(true).withPassword(new byte[0]).execute().get();
            try {
                try (LedgerEntries entries = h.read(0L, 0L);){
                    Assert.fail((String)"Should not be able to connect to the bookie with Bookie Address Tracking Disabled");
                }
                catch (BKException.BKBookieHandleNotAvailableException bKBookieHandleNotAvailableException) {
                    // empty catch block
                }
            }
            finally {
                if (h != null) {
                    h.close();
                }
            }
        }
    }

    @Test
    public void testFollowBookieAddressChangeZkSessionExpire() throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        try (org.apache.bookkeeper.client.api.BookKeeper bkc = org.apache.bookkeeper.client.api.BookKeeper.newBuilder((ClientConfiguration)conf).build();){
            long lId;
            try (WriteHandle h = (WriteHandle)bkc.newCreateLedgerOp().withAckQuorumSize(1).withEnsembleSize(1).withWriteQuorumSize(1).withPassword(new byte[0]).execute().get();){
                lId = h.getId();
                h.append("foo".getBytes("utf-8"));
            }
            log.error("expiring ZK session!");
            ZKRegistrationClient regClient = (ZKRegistrationClient)((BookKeeper)bkc).getMetadataClientDriver().getRegistrationClient();
            regClient.getZk().getTestable().injectSessionExpiration();
            this.restartBookies(c -> c);
            try (ReadHandle h = (ReadHandle)bkc.newOpenLedgerOp().withLedgerId(lId).withRecovery(true).withPassword(new byte[0]).execute().get();){
                Assert.assertEquals((long)0L, (long)h.getLastAddConfirmed());
                try (LedgerEntries entries = h.read(0L, 0L);){
                    Assert.assertEquals((Object)"foo", (Object)new String(entries.getEntry(0L).getEntryBytes(), "utf-8"));
                }
            }
        }
    }
}

