/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.versioning.Versioned;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieRecoveryTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(BookieRecoveryTest.class);
    BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
    String ledgerManagerFactory = "org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory";
    SyncObject sync;
    BookieRecoverCallback bookieRecoverCb;
    BookKeeperAdmin bkAdmin;

    public BookieRecoveryTest() {
        super(3);
        LOG.info("Using ledger manager " + this.ledgerManagerFactory);
        this.baseConf.setLedgerManagerFactoryClassName(this.ledgerManagerFactory);
        this.baseConf.setOpenFileLimit(200);
        this.baseClientConf.setLedgerManagerFactoryClassName(this.ledgerManagerFactory);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.baseClientConf.setBookieRecoveryDigestType(this.digestType);
        this.baseClientConf.setBookieRecoveryPasswd("".getBytes());
        super.setUp();
        this.sync = new SyncObject();
        this.bookieRecoverCb = new BookieRecoverCallback();
        ClientConfiguration adminConf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        adminConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        this.bkAdmin = new BookKeeperAdmin(adminConf);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.bkAdmin != null) {
            this.bkAdmin.close();
        }
        super.tearDown();
    }

    private List<LedgerHandle> createLedgers(int numLedgers) throws BKException, IOException, InterruptedException {
        return this.createLedgers(numLedgers, 3, 2);
    }

    private List<LedgerHandle> createLedgers(int numLedgers, int ensemble, int quorum) throws BKException, IOException, InterruptedException {
        ArrayList<LedgerHandle> lhs = new ArrayList<LedgerHandle>();
        for (int i = 0; i < numLedgers; ++i) {
            lhs.add(this.bkc.createLedger(ensemble, quorum, this.digestType, this.baseClientConf.getBookieRecoveryPasswd()));
        }
        return lhs;
    }

    private List<LedgerHandle> openLedgers(List<LedgerHandle> oldLhs) throws Exception {
        ArrayList<LedgerHandle> newLhs = new ArrayList<LedgerHandle>();
        for (LedgerHandle oldLh : oldLhs) {
            newLhs.add(this.bkc.openLedger(oldLh.getId(), this.digestType, this.baseClientConf.getBookieRecoveryPasswd()));
        }
        return newLhs;
    }

    private void writeEntriestoLedgers(int numEntries, long startEntryId, List<LedgerHandle> lhs) throws BKException, InterruptedException {
        for (LedgerHandle lh : lhs) {
            for (int i = 0; i < numEntries; ++i) {
                lh.addEntry(("LedgerId: " + lh.getId() + ", EntryId: " + (startEntryId + (long)i)).getBytes());
            }
        }
    }

    private void closeLedgers(List<LedgerHandle> lhs) throws BKException, InterruptedException {
        for (LedgerHandle lh : lhs) {
            lh.close();
        }
    }

    private void verifyRecoveredLedgers(List<LedgerHandle> oldLhs, long startEntryId, long endEntryId) throws BKException, InterruptedException {
        ArrayList<LedgerHandle> lhs = new ArrayList<LedgerHandle>();
        for (int i = 0; i < oldLhs.size(); ++i) {
            lhs.add(this.bkc.openLedger(oldLhs.get(i).getId(), this.digestType, this.baseClientConf.getBookieRecoveryPasswd()));
        }
        for (LedgerHandle lh : lhs) {
            Enumeration entries = lh.readEntries(startEntryId, endEntryId);
            while (entries.hasMoreElements()) {
                LedgerEntry entry = (LedgerEntry)entries.nextElement();
                Assert.assertTrue((boolean)new String(entry.getEntry()).equals("LedgerId: " + entry.getLedgerId() + ", EntryId: " + entry.getEntryId()));
            }
        }
    }

    @Test
    public void testMetadataConflictWithRecovery() throws Exception {
        this.metadataConflictWithRecovery(this.bkc);
    }

    @Test
    public void testMetadataConflictWhenDelayingEnsembleChange() throws Exception {
        ClientConfiguration newConf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        newConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        newConf.setDelayEnsembleChange(true);
        try (BookKeeper newBkc = new BookKeeper(newConf);){
            this.metadataConflictWithRecovery(newBkc);
        }
    }

    void metadataConflictWithRecovery(BookKeeper bkc) throws Exception {
        int numEntries = 10;
        byte[] data = "testMetadataConflictWithRecovery".getBytes();
        LedgerHandle lh = bkc.createLedger(2, 2, this.digestType, this.baseClientConf.getBookieRecoveryPasswd());
        for (int i = 0; i < numEntries; ++i) {
            lh.addEntry(data);
        }
        BookieId bookieToKill = (BookieId)lh.getLedgerMetadata().getEnsembleAt((long)(numEntries - 1)).get(1);
        this.killBookie(bookieToKill);
        this.startNewBookie();
        for (int i = 0; i < numEntries; ++i) {
            lh.addEntry(data);
        }
        this.bkAdmin.recoverBookieData(bookieToKill);
        bookieToKill = (BookieId)lh.getLedgerMetadata().getEnsembleAt((long)(2 * numEntries - 1)).get(1);
        ServerConfiguration confOfKilledBookie = this.killBookie(bookieToKill);
        this.startNewBookie();
        for (int i = 0; i < numEntries; ++i) {
            lh.addEntry(data);
        }
        this.startAndAddBookie(confOfKilledBookie);
        Assert.assertTrue((String)"Not fully replicated", (boolean)this.verifyFullyReplicated(lh, 3 * numEntries));
        lh.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncBookieRecoveryToSpecificBookie() throws Exception {
        int numLedgers = 3;
        List<LedgerHandle> lhs = this.createLedgers(numLedgers);
        int numMsgs = 10;
        this.writeEntriestoLedgers(numMsgs, 0L, lhs);
        LOG.info("Finished writing all ledger entries so shutdown one of the bookies.");
        BookieId bookieSrc = this.addressByIndex(0);
        this.killBookie(0);
        this.startNewBookie();
        this.writeEntriestoLedgers(numMsgs, 10L, lhs);
        this.sync.value = false;
        this.bkAdmin.asyncRecoverBookieData(bookieSrc, (AsyncCallback.RecoverCallback)this.bookieRecoverCb, (Object)this.sync);
        SyncObject syncObject = this.sync;
        synchronized (syncObject) {
            while (!this.sync.value) {
                this.sync.wait();
            }
            Assert.assertTrue((boolean)this.bookieRecoverCb.success);
        }
        this.verifyRecoveredLedgers(lhs, 0L, 2 * numMsgs - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncBookieRecoveryToRandomBookies() throws Exception {
        int numLedgers = 3;
        List<LedgerHandle> lhs = this.createLedgers(numLedgers);
        int numMsgs = 10;
        this.writeEntriestoLedgers(numMsgs, 0L, lhs);
        LOG.info("Finished writing all ledger entries so shutdown one of the bookies.");
        BookieId bookieSrc = this.addressByIndex(0);
        this.killBookie(0);
        for (int i = 0; i < 3; ++i) {
            this.startNewBookie();
        }
        this.writeEntriestoLedgers(numMsgs, 10L, lhs);
        LOG.info("Now recover the data on the killed bookie (" + bookieSrc + ") and replicate it to a random available one");
        this.sync.value = false;
        this.bkAdmin.asyncRecoverBookieData(bookieSrc, (AsyncCallback.RecoverCallback)this.bookieRecoverCb, (Object)this.sync);
        SyncObject syncObject = this.sync;
        synchronized (syncObject) {
            while (!this.sync.value) {
                this.sync.wait();
            }
            Assert.assertTrue((boolean)this.bookieRecoverCb.success);
        }
        this.verifyRecoveredLedgers(lhs, 0L, 2 * numMsgs - 1);
    }

    @Test
    public void testSyncBookieRecoveryToSpecificBookie() throws Exception {
        int numLedgers = 3;
        List<LedgerHandle> lhs = this.createLedgers(numLedgers);
        int numMsgs = 10;
        this.writeEntriestoLedgers(numMsgs, 0L, lhs);
        LOG.info("Finished writing all ledger entries so shutdown one of the bookies.");
        BookieId bookieSrc = this.addressByIndex(0);
        this.killBookie(0);
        int newBookiePort = this.startNewBookie();
        this.writeEntriestoLedgers(numMsgs, 10L, lhs);
        LOG.info("Now recover the data on the killed bookie (" + bookieSrc + ") and replicate it to other bookies");
        this.bkAdmin.recoverBookieData(bookieSrc);
        this.verifyRecoveredLedgers(lhs, 0L, 2 * numMsgs - 1);
    }

    @Test
    public void testSyncBookieRecoveryToRandomBookies() throws Exception {
        int numLedgers = 3;
        List<LedgerHandle> lhs = this.createLedgers(numLedgers);
        int numMsgs = 10;
        this.writeEntriestoLedgers(numMsgs, 0L, lhs);
        LOG.info("Finished writing all ledger entries so shutdown one of the bookies.");
        BookieId bookieSrc = this.addressByIndex(0);
        this.killBookie(0);
        for (int i = 0; i < 3; ++i) {
            this.startNewBookie();
        }
        this.writeEntriestoLedgers(numMsgs, 10L, lhs);
        LOG.info("Now recover the data on the killed bookie (" + bookieSrc + ") and replicate it to a random available one");
        this.bkAdmin.recoverBookieData(bookieSrc);
        this.verifyRecoveredLedgers(lhs, 0L, 2 * numMsgs - 1);
    }

    private boolean verifyFullyReplicated(LedgerHandle lh, long untilEntry) throws Exception {
        LedgerMetadata md = this.getLedgerMetadata(lh);
        NavigableMap ensembles = md.getAllEnsembles();
        HashMap<Long, Long> ranges = new HashMap<Long, Long>();
        ArrayList keyList = Collections.list(Collections.enumeration(ensembles.keySet()));
        Collections.sort(keyList);
        for (int i = 0; i < keyList.size() - 1; ++i) {
            ranges.put((Long)keyList.get(i), (Long)keyList.get(i + 1));
        }
        ranges.put((Long)keyList.get(keyList.size() - 1), untilEntry);
        for (Map.Entry e : ensembles.entrySet()) {
            int quorum = md.getAckQuorumSize();
            long startEntryId = (Long)e.getKey();
            long endEntryId = (Long)ranges.get(startEntryId);
            long expectedSuccess = (long)quorum * (endEntryId - startEntryId);
            int numRequests = ((List)e.getValue()).size() * (int)(endEntryId - startEntryId);
            ReplicationVerificationCallback cb = new ReplicationVerificationCallback(numRequests);
            for (long i = startEntryId; i < endEntryId; ++i) {
                for (BookieId addr : (List)e.getValue()) {
                    this.bkc.getBookieClient().readEntry(addr, lh.getId(), i, (BookkeeperInternalCallbacks.ReadEntryCallback)cb, (Object)addr, 0);
                }
            }
            long numSuccess = cb.await();
            if (numSuccess >= expectedSuccess) continue;
            LOG.warn("Fragment not fully replicated ledgerId = " + lh.getId() + " startEntryId = " + startEntryId + " endEntryId = " + endEntryId + " expectedSuccess = " + expectedSuccess + " gotSuccess = " + numSuccess);
            return false;
        }
        return true;
    }

    private LedgerMetadata getLedgerMetadata(LedgerHandle lh) throws Exception {
        return (LedgerMetadata)((Versioned)this.bkc.getLedgerManager().readLedgerMetadata(lh.getId()).get()).getValue();
    }

    private boolean findDupesInEnsembles(List<LedgerHandle> lhs) throws Exception {
        long numDupes = 0L;
        for (LedgerHandle lh : lhs) {
            LedgerMetadata md = this.getLedgerMetadata(lh);
            for (Map.Entry e : md.getAllEnsembles().entrySet()) {
                HashSet<BookieId> set = new HashSet<BookieId>();
                long fragment = (Long)e.getKey();
                for (BookieId addr : (List)e.getValue()) {
                    if (set.contains(addr)) {
                        LOG.error("Dupe " + addr + " found in ensemble for fragment " + fragment + " of ledger " + lh.getId());
                        ++numDupes;
                    }
                    set.add(addr);
                }
            }
        }
        return numDupes > 0L;
    }

    @Test
    public void testBookieRecoveryOnClosedLedgers() throws Exception {
        int numLedgers = 3;
        List<LedgerHandle> lhs = this.createLedgers(numLedgers, this.numBookies, 2);
        int numMsgs = 10;
        this.writeEntriestoLedgers(numMsgs, 0L, lhs);
        this.closeLedgers(lhs);
        List lastEnsemble = (List)lhs.get(0).getLedgerMetadata().getAllEnsembles().entrySet().iterator().next().getValue();
        BookieId bookieToKill = (BookieId)lastEnsemble.get(lastEnsemble.size() - 1);
        this.killBookie(bookieToKill);
        this.startNewBookie();
        LOG.info("Now recover the data on the killed bookie (" + bookieToKill + ") and replicate it to a random available one");
        this.bkAdmin.recoverBookieData(bookieToKill);
        for (LedgerHandle lh : lhs) {
            Assert.assertTrue((String)"Not fully replicated", (boolean)this.verifyFullyReplicated(lh, numMsgs));
            lh.close();
        }
    }

    @Test
    public void testBookieRecoveryOnOpenedLedgers() throws Exception {
        int numLedgers = 3;
        List<LedgerHandle> lhs = this.createLedgers(numLedgers, this.numBookies, 2);
        int numMsgs = 10;
        this.writeEntriestoLedgers(numMsgs, 0L, lhs);
        List lastEnsemble = (List)lhs.get(0).getLedgerMetadata().getAllEnsembles().entrySet().iterator().next().getValue();
        BookieId bookieToKill = (BookieId)lastEnsemble.get(lastEnsemble.size() - 1);
        this.killBookie(bookieToKill);
        this.startNewBookie();
        LOG.info("Now recover the data on the killed bookie (" + bookieToKill + ") and replicate it to a random available one");
        this.bkAdmin.recoverBookieData(bookieToKill);
        for (LedgerHandle lh : lhs) {
            Assert.assertTrue((String)"Not fully replicated", (boolean)this.verifyFullyReplicated(lh, numMsgs));
        }
        try {
            this.writeEntriestoLedgers(numMsgs, 0L, lhs);
            Assert.fail((String)"should not reach here");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testBookieRecoveryOnInRecoveryLedger() throws Exception {
        int numMsgs = 10;
        int numLedgers = 1;
        List<LedgerHandle> lhs = this.createLedgers(numLedgers, 2, 2);
        this.writeEntriestoLedgers(numMsgs, 0L, lhs);
        List lastEnsemble = (List)lhs.get(0).getLedgerMetadata().getAllEnsembles().entrySet().iterator().next().getValue();
        BookieId bookieToKill = (BookieId)lastEnsemble.get(0);
        this.killBookie(bookieToKill);
        BookieId bookieToKill2 = (BookieId)lastEnsemble.get(1);
        ServerConfiguration conf2 = this.killBookie(bookieToKill2);
        this.startNewBookie();
        for (LedgerHandle oldLh : lhs) {
            try {
                this.bkc.openLedger(oldLh.getId(), this.digestType, this.baseClientConf.getBookieRecoveryPasswd());
                Assert.fail((String)"Should have thrown exception");
            }
            catch (Exception exception) {}
        }
        try {
            this.bkAdmin.recoverBookieData(bookieToKill);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (BKException.BKLedgerRecoveryException bKLedgerRecoveryException) {
            // empty catch block
        }
        this.startAndAddBookie(conf2);
        this.bkAdmin.recoverBookieData(bookieToKill);
        for (LedgerHandle lh : lhs) {
            Assert.assertTrue((String)"Not fully replicated", (boolean)this.verifyFullyReplicated(lh, numMsgs));
        }
        List<LedgerHandle> newLhs = this.openLedgers(lhs);
        for (LedgerHandle newLh : newLhs) {
            Map.Entry entry = newLh.getLedgerMetadata().getAllEnsembles().entrySet().iterator().next();
            Assert.assertFalse((boolean)((List)entry.getValue()).contains(bookieToKill));
            Assert.assertTrue((boolean)((List)entry.getValue()).contains(bookieToKill2));
        }
    }

    @Test
    public void testAsyncBookieRecoveryToRandomBookiesNotEnoughBookies() throws Exception {
        int numLedgers = 3;
        List<LedgerHandle> lhs = this.createLedgers(numLedgers, this.numBookies, 2);
        int numMsgs = 10;
        this.writeEntriestoLedgers(numMsgs, 0L, lhs);
        LOG.info("Finished writing all ledger entries so shutdown one of the bookies.");
        BookieId bookieSrc = this.addressByIndex(0);
        this.killBookie(0);
        LOG.info("Now recover the data on the killed bookie (" + bookieSrc + ") and replicate it to a random available one");
        this.sync.value = false;
        try {
            this.bkAdmin.recoverBookieData(bookieSrc);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (BKException.BKLedgerRecoveryException bKLedgerRecoveryException) {
            // empty catch block
        }
    }

    @Test
    public void testSyncBookieRecoveryToRandomBookiesCheckForDupes() throws Exception {
        Random r = new Random();
        int numLedgers = 3;
        List<LedgerHandle> lhs = this.createLedgers(numLedgers, this.numBookies, 2);
        int numMsgs = 10;
        this.writeEntriestoLedgers(numMsgs, 0L, lhs);
        LOG.info("Finished writing all ledger entries so shutdown one of the bookies.");
        int removeIndex = r.nextInt(this.bookieCount());
        BookieId bookieSrc = this.addressByIndex(removeIndex);
        this.killBookie(removeIndex);
        this.startNewBookie();
        this.writeEntriestoLedgers(numMsgs, numMsgs, lhs);
        LOG.info("Now recover the data on the killed bookie (" + bookieSrc + ") and replicate it to a random available one");
        this.sync.value = false;
        this.bkAdmin.recoverBookieData(bookieSrc);
        Assert.assertFalse((String)"Dupes exist in ensembles", (boolean)this.findDupesInEnsembles(lhs));
        this.writeEntriestoLedgers(numMsgs, numMsgs * 2, lhs);
        for (LedgerHandle lh : lhs) {
            Assert.assertTrue((String)"Not fully replicated", (boolean)this.verifyFullyReplicated(lh, numMsgs * 3));
            lh.close();
        }
    }

    @Test
    public void recoverWithoutPasswordInConf() throws Exception {
        byte[] passwdCorrect = "AAAAAA".getBytes();
        byte[] passwdBad = "BBBBBB".getBytes();
        BookKeeper.DigestType digestCorrect = this.digestType;
        LedgerHandle lh = this.bkc.createLedger(3, 2, digestCorrect, passwdCorrect);
        long ledgerId = lh.getId();
        for (int i = 0; i < 100; ++i) {
            lh.addEntry("foobar".getBytes());
        }
        lh.close();
        BookieId bookieSrc = this.addressByIndex(0);
        this.killBookie(0);
        this.startNewBookie();
        lh = this.bkc.openLedgerNoRecovery(ledgerId, digestCorrect, passwdCorrect);
        Assert.assertFalse((String)"Should be entries missing", (boolean)this.verifyFullyReplicated(lh, 100L));
        lh.close();
        ClientConfiguration adminConf = new ClientConfiguration();
        adminConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        adminConf.setBookieRecoveryDigestType(digestCorrect);
        adminConf.setBookieRecoveryPasswd(passwdBad);
        this.setMetastoreImplClass((AbstractConfiguration)adminConf);
        BookKeeperAdmin bka = new BookKeeperAdmin(adminConf);
        bka.recoverBookieData(bookieSrc);
        bka.close();
        lh = this.bkc.openLedgerNoRecovery(ledgerId, digestCorrect, passwdCorrect);
        Assert.assertTrue((String)"Should be back to fully replication", (boolean)this.verifyFullyReplicated(lh, 100L));
        lh.close();
        bookieSrc = this.addressByIndex(0);
        this.killBookie(0);
        this.startNewBookie();
        lh = this.bkc.openLedgerNoRecovery(ledgerId, digestCorrect, passwdCorrect);
        Assert.assertFalse((String)"Should be entries missing", (boolean)this.verifyFullyReplicated(lh, 100L));
        lh.close();
        adminConf = new ClientConfiguration();
        adminConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        this.setMetastoreImplClass((AbstractConfiguration)adminConf);
        bka = new BookKeeperAdmin(adminConf);
        bka.recoverBookieData(bookieSrc);
        bka.close();
        lh = this.bkc.openLedgerNoRecovery(ledgerId, digestCorrect, passwdCorrect);
        Assert.assertTrue((String)"Should be back to fully replication", (boolean)this.verifyFullyReplicated(lh, 100L));
        lh.close();
    }

    class SyncLedgerMetaObject {
        boolean value = false;
        int rc;
        LedgerMetadata meta = null;
    }

    private static class ReplicationVerificationCallback
    implements BookkeeperInternalCallbacks.ReadEntryCallback {
        final CountDownLatch latch;
        final AtomicLong numSuccess;

        ReplicationVerificationCallback(int numRequests) {
            this.latch = new CountDownLatch(numRequests);
            this.numSuccess = new AtomicLong(0L);
        }

        public void readEntryComplete(int rc, long ledgerId, long entryId, ByteBuf buffer, Object ctx) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got " + rc + " for ledger " + ledgerId + " entry " + entryId + " from " + ctx);
            }
            if (rc == 0) {
                this.numSuccess.incrementAndGet();
            }
            this.latch.countDown();
        }

        long await() throws InterruptedException {
            if (!this.latch.await(60L, TimeUnit.SECONDS)) {
                LOG.warn("Didn't get all responses in verification");
                return 0L;
            }
            return this.numSuccess.get();
        }
    }

    class BookieRecoverCallback
    implements AsyncCallback.RecoverCallback {
        boolean success = false;

        BookieRecoverCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recoverComplete(int rc, Object ctx) {
            SyncObject sync;
            LOG.info("Recovered bookie operation completed with rc: " + rc);
            this.success = rc == 0;
            SyncObject syncObject = sync = (SyncObject)ctx;
            synchronized (syncObject) {
                sync.value = true;
                sync.notify();
            }
        }
    }

    class SyncObject {
        boolean value = false;
    }
}

