/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.util.HashedWheelTimer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.TestRackawareEnsemblePlacementPolicy;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.feature.SettableFeatureProvider;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.StaticDNSResolver;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRackawarePolicyNotificationUpdates
extends TestCase {
    static final Logger LOG = LoggerFactory.getLogger(TestRackawarePolicyNotificationUpdates.class);
    RackawareEnsemblePlacementPolicy repp;
    HashedWheelTimer timer;
    ClientConfiguration conf = new ClientConfiguration();

    protected void setUp() throws Exception {
        super.setUp();
        this.conf.setProperty("reppDnsResolverClass", (Object)StaticDNSResolver.class.getName());
        StaticDNSResolver.reset();
        StaticDNSResolver.addNodeToRack(InetAddress.getLocalHost().getHostAddress(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack("127.0.0.1", "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack("localhost", "/default-region/default-rack");
        LOG.info("Set up static DNS Resolver.");
        this.timer = new HashedWheelTimer(new ThreadFactoryBuilder().setNameFormat("TestTimer-%d").build(), this.conf.getTimeoutTimerTickDurationMs(), TimeUnit.MILLISECONDS, this.conf.getTimeoutTimerNumTicks());
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
    }

    protected void tearDown() throws Exception {
        this.repp.uninitalize();
        super.tearDown();
    }

    @Test
    public void testNotifyRackChange() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.1.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.1.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.1.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.1.4", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/rack-1");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/default-region/rack-2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/default-region/rack-2");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/default-region/rack-2");
        int numOfAvailableRacks = 2;
        HashSet addrs = Sets.newHashSet((Object[])new BookieId[]{addr1.toBookieId(), addr2.toBookieId(), addr3.toBookieId(), addr4.toBookieId()});
        this.repp.onClusterChanged((Set)addrs, new HashSet());
        int ensembleSize = 3;
        int writeQuorumSize = 2;
        int acqQuorumSize = 2;
        List ensemble = (List)this.repp.newEnsemble(ensembleSize, writeQuorumSize, acqQuorumSize, Collections.emptyMap(), Collections.emptySet()).getResult();
        int numCovered = TestRackawareEnsemblePlacementPolicy.getNumCoveredWriteQuorums(ensemble, writeQuorumSize, this.conf.getMinNumRacksPerWriteQuorum(), this.repp.bookieAddressResolver);
        TestRackawarePolicyNotificationUpdates.assertTrue((numCovered >= 1 && numCovered < 3 ? 1 : 0) != 0);
        TestRackawarePolicyNotificationUpdates.assertTrue((boolean)ensemble.contains(addr1.toBookieId()));
        ArrayList<BookieSocketAddress> bookieAddressList = new ArrayList<BookieSocketAddress>();
        ArrayList<String> rackList = new ArrayList<String>();
        bookieAddressList.add(addr2);
        rackList.add("/default-region/rack-3");
        StaticDNSResolver.changeRack(bookieAddressList, rackList);
        ++numOfAvailableRacks;
        acqQuorumSize = 1;
        ensemble = (List)this.repp.newEnsemble(ensembleSize, writeQuorumSize, acqQuorumSize, Collections.emptyMap(), Collections.emptySet()).getResult();
        TestRackawarePolicyNotificationUpdates.assertEquals((int)3, (int)TestRackawareEnsemblePlacementPolicy.getNumCoveredWriteQuorums(ensemble, writeQuorumSize, this.conf.getMinNumRacksPerWriteQuorum(), this.repp.bookieAddressResolver));
        TestRackawarePolicyNotificationUpdates.assertTrue((boolean)ensemble.contains(addr1.toBookieId()));
        TestRackawarePolicyNotificationUpdates.assertTrue((boolean)ensemble.contains(addr2.toBookieId()));
    }
}

