/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta.zk;

import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.bookkeeper.discover.ZKRegistrationClient;
import org.apache.bookkeeper.meta.zk.ZKMetadataClientDriver;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverTestBase;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.zookeeper.ZooKeeper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ZKMetadataClientDriverTest
extends ZKMetadataDriverTestBase {
    private ZKMetadataClientDriver driver;
    private ClientConfiguration conf;

    @Before
    public void setup() throws Exception {
        this.conf = new ClientConfiguration();
        super.setup((AbstractConfiguration<?>)this.conf);
        this.driver = (ZKMetadataClientDriver)Mockito.spy((Object)new ZKMetadataClientDriver());
    }

    @Test
    public void testGetRegClient() throws Exception {
        ScheduledExecutorService mockExecutor = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        this.driver.initialize(this.conf, mockExecutor, (StatsLogger)NullStatsLogger.INSTANCE, Optional.empty());
        Assert.assertSame((Object)this.conf, (Object)this.driver.clientConf);
        Assert.assertSame((Object)mockExecutor, (Object)this.driver.scheduler);
        Assert.assertNull((Object)this.driver.regClient);
        ZKRegistrationClient mockRegClient = (ZKRegistrationClient)Mockito.mock(ZKRegistrationClient.class);
        ((ZKMetadataClientDriver)Mockito.doReturn((Object)mockRegClient).when((Object)this.driver)).newZKRegistrationClient((ZooKeeper)ArgumentMatchers.any(ZooKeeper.class), ArgumentMatchers.anyString(), (ScheduledExecutorService)ArgumentMatchers.any(ScheduledExecutorService.class), ArgumentMatchers.anyBoolean());
        RegistrationClient client = this.driver.getRegistrationClient();
        Assert.assertSame((Object)mockRegClient, (Object)client);
        Assert.assertSame((Object)mockRegClient, (Object)this.driver.regClient);
        ((ZKMetadataClientDriver)Mockito.verify((Object)this.driver, (VerificationMode)Mockito.times((int)1))).newZKRegistrationClient((ZooKeeper)ArgumentMatchers.eq((Object)this.mockZkc), (String)ArgumentMatchers.eq((Object)this.ledgersRootPath), (ScheduledExecutorService)ArgumentMatchers.eq((Object)mockExecutor), ArgumentMatchers.anyBoolean());
        this.driver.close();
        ((ZKRegistrationClient)Mockito.verify((Object)mockRegClient, (VerificationMode)Mockito.times((int)1))).close();
        Assert.assertNull((Object)this.driver.regClient);
    }
}

