/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.EventLoop;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.proto.BatchedReadEntryProcessor;
import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.proto.BookieRequestHandler;
import org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.bookkeeper.proto.RequestStats;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;

public class BatchedReadEntryProcessorTest {
    private Channel channel;
    private BookieRequestHandler requestHandler;
    private BookieRequestProcessor requestProcessor;
    private Bookie bookie;

    @Before
    public void setup() throws IOException, BookieException {
        this.channel = (Channel)Mockito.mock(Channel.class);
        Mockito.when((Object)this.channel.isOpen()).thenReturn((Object)true);
        this.requestHandler = (BookieRequestHandler)Mockito.mock(BookieRequestHandler.class);
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Mockito.when((Object)ctx.channel()).thenReturn((Object)this.channel);
        Mockito.when((Object)this.requestHandler.ctx()).thenReturn((Object)ctx);
        this.bookie = (Bookie)Mockito.mock(Bookie.class);
        this.requestProcessor = (BookieRequestProcessor)Mockito.mock(BookieRequestProcessor.class);
        Mockito.when((Object)this.requestProcessor.getBookie()).thenReturn((Object)this.bookie);
        Mockito.when((Object)this.requestProcessor.getWaitTimeoutOnBackpressureMillis()).thenReturn((Object)-1L);
        Mockito.when((Object)this.requestProcessor.getRequestStats()).thenReturn((Object)new RequestStats((StatsLogger)NullStatsLogger.INSTANCE));
        Mockito.when((Object)this.channel.voidPromise()).thenReturn((Object)((ChannelPromise)Mockito.mock(ChannelPromise.class)));
        Mockito.when((Object)this.channel.writeAndFlush(ArgumentMatchers.any())).thenReturn((Object)((ChannelFuture)Mockito.mock(ChannelPromise.class)));
        EventLoop eventLoop = (EventLoop)Mockito.mock(EventLoop.class);
        Mockito.when((Object)eventLoop.inEventLoop()).thenReturn((Object)true);
        Mockito.when((Object)this.channel.eventLoop()).thenReturn((Object)eventLoop);
        ByteBuf buffer0 = ByteBufAllocator.DEFAULT.buffer(4);
        ByteBuf buffer1 = ByteBufAllocator.DEFAULT.buffer(4);
        ByteBuf buffer2 = ByteBufAllocator.DEFAULT.buffer(4);
        ByteBuf buffer3 = ByteBufAllocator.DEFAULT.buffer(4);
        ByteBuf buffer4 = ByteBufAllocator.DEFAULT.buffer(4);
        Mockito.when((Object)this.bookie.readEntry(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn((Object)buffer0).thenReturn((Object)buffer1).thenReturn((Object)buffer2).thenReturn((Object)buffer3).thenReturn((Object)buffer4);
    }

    @Test
    public void testSuccessfulAsynchronousFenceRequest() throws Exception {
        this.testAsynchronousRequest(true, 0);
    }

    @Test
    public void testFailedAsynchronousFenceRequest() throws Exception {
        this.testAsynchronousRequest(false, 101);
    }

    private void testAsynchronousRequest(boolean result, int errorCode) throws Exception {
        CompletableFuture fenceResult = FutureUtils.createFuture();
        Mockito.when((Object)this.bookie.fenceLedger(ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any())).thenReturn((Object)fenceResult);
        DefaultChannelPromise promise = new DefaultChannelPromise(this.channel);
        AtomicReference writtenObject = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        ((Channel)Mockito.doAnswer(arg_0 -> BatchedReadEntryProcessorTest.lambda$testAsynchronousRequest$0(writtenObject, (ChannelPromise)promise, latch, arg_0)).when((Object)this.channel)).writeAndFlush(ArgumentMatchers.any(BookieProtocol.Response.class));
        long requestId = 0L;
        int maxCount = 5;
        long maxSize = 1024L;
        ExecutorService service = Executors.newCachedThreadPool();
        long ledgerId = System.currentTimeMillis();
        BookieProtocol.BatchedReadRequest request = BookieProtocol.BatchedReadRequest.create((byte)2, (long)ledgerId, (long)1L, (short)1, (byte[])new byte[0], (long)requestId, (int)maxCount, (long)maxSize);
        BatchedReadEntryProcessor processor = BatchedReadEntryProcessor.create((BookieProtocol.BatchedReadRequest)request, (BookieRequestHandler)this.requestHandler, (BookieRequestProcessor)this.requestProcessor, (ExecutorService)service, (boolean)true, (long)0x500000L);
        processor.run();
        fenceResult.complete(result);
        latch.await();
        ((Channel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).writeAndFlush(ArgumentMatchers.any(BookieProtocol.Response.class));
        Assert.assertTrue((boolean)(writtenObject.get() instanceof BookieProtocol.Response));
        BookieProtocol.Response response = (BookieProtocol.Response)writtenObject.get();
        Assert.assertEquals((long)1L, (long)response.getEntryId());
        Assert.assertEquals((long)ledgerId, (long)response.getLedgerId());
        Assert.assertEquals((long)7L, (long)response.getOpCode());
        Assert.assertEquals((long)errorCode, (long)response.getErrorCode());
        service.shutdown();
    }

    @Test
    public void testSuccessfulSynchronousFenceRequest() throws Exception {
        this.testSynchronousRequest(true, 0);
    }

    @Test
    public void testFailedSynchronousFenceRequest() throws Exception {
        this.testSynchronousRequest(false, 101);
    }

    private void testSynchronousRequest(boolean result, int errorCode) throws Exception {
        CompletableFuture fenceResult = FutureUtils.createFuture();
        Mockito.when((Object)this.bookie.fenceLedger(ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any())).thenReturn((Object)fenceResult);
        DefaultChannelPromise promise = new DefaultChannelPromise(this.channel);
        AtomicReference writtenObject = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        ((Channel)Mockito.doAnswer(arg_0 -> BatchedReadEntryProcessorTest.lambda$testSynchronousRequest$1(writtenObject, (ChannelPromise)promise, latch, arg_0)).when((Object)this.channel)).writeAndFlush(ArgumentMatchers.any(BookieProtocol.Response.class));
        long requestId = 0L;
        int maxCount = 5;
        long maxSize = 1024L;
        ExecutorService service = Executors.newCachedThreadPool();
        long ledgerId = System.currentTimeMillis();
        BookieProtocol.BatchedReadRequest request = BookieProtocol.BatchedReadRequest.create((byte)2, (long)ledgerId, (long)1L, (short)1, (byte[])new byte[0], (long)requestId, (int)maxCount, (long)maxSize);
        BatchedReadEntryProcessor processor = BatchedReadEntryProcessor.create((BookieProtocol.BatchedReadRequest)request, (BookieRequestHandler)this.requestHandler, (BookieRequestProcessor)this.requestProcessor, (ExecutorService)service, (boolean)true, (long)0x500000L);
        fenceResult.complete(result);
        processor.run();
        latch.await();
        ((Channel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).writeAndFlush(ArgumentMatchers.any(BookieProtocol.Response.class));
        Assert.assertTrue((boolean)(writtenObject.get() instanceof BookieProtocol.Response));
        BookieProtocol.Response response = (BookieProtocol.Response)writtenObject.get();
        Assert.assertEquals((long)1L, (long)response.getEntryId());
        Assert.assertEquals((long)ledgerId, (long)response.getLedgerId());
        Assert.assertEquals((long)7L, (long)response.getOpCode());
        Assert.assertEquals((long)errorCode, (long)response.getErrorCode());
    }

    @Test
    public void testNonFenceRequest() throws Exception {
        DefaultChannelPromise promise = new DefaultChannelPromise(this.channel);
        AtomicReference writtenObject = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        ((Channel)Mockito.doAnswer(arg_0 -> BatchedReadEntryProcessorTest.lambda$testNonFenceRequest$2(writtenObject, (ChannelPromise)promise, latch, arg_0)).when((Object)this.channel)).writeAndFlush(ArgumentMatchers.any(BookieProtocol.Response.class));
        long requestId = 0L;
        int maxCount = 5;
        long maxSize = 1024L;
        ExecutorService service = Executors.newCachedThreadPool();
        long ledgerId = System.currentTimeMillis();
        BookieProtocol.BatchedReadRequest request = BookieProtocol.BatchedReadRequest.create((byte)2, (long)ledgerId, (long)1L, (short)1, (byte[])new byte[0], (long)requestId, (int)maxCount, (long)maxSize);
        BatchedReadEntryProcessor processor = BatchedReadEntryProcessor.create((BookieProtocol.BatchedReadRequest)request, (BookieRequestHandler)this.requestHandler, (BookieRequestProcessor)this.requestProcessor, (ExecutorService)service, (boolean)true, (long)0x500000L);
        processor.run();
        latch.await();
        ((Channel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).writeAndFlush(ArgumentMatchers.any(BookieProtocol.Response.class));
        Assert.assertTrue((boolean)(writtenObject.get() instanceof BookieProtocol.Response));
        BookieProtocol.Response response = (BookieProtocol.Response)writtenObject.get();
        Assert.assertEquals((long)1L, (long)response.getEntryId());
        Assert.assertEquals((long)ledgerId, (long)response.getLedgerId());
        Assert.assertEquals((long)7L, (long)response.getOpCode());
        Assert.assertEquals((long)0L, (long)response.getErrorCode());
    }

    private static /* synthetic */ Object lambda$testNonFenceRequest$2(AtomicReference writtenObject, ChannelPromise promise, CountDownLatch latch, InvocationOnMock invocationOnMock) throws Throwable {
        writtenObject.set(invocationOnMock.getArgument(0));
        promise.setSuccess();
        latch.countDown();
        return promise;
    }

    private static /* synthetic */ Object lambda$testSynchronousRequest$1(AtomicReference writtenObject, ChannelPromise promise, CountDownLatch latch, InvocationOnMock invocationOnMock) throws Throwable {
        writtenObject.set(invocationOnMock.getArgument(0));
        promise.setSuccess();
        latch.countDown();
        return promise;
    }

    private static /* synthetic */ Object lambda$testAsynchronousRequest$0(AtomicReference writtenObject, ChannelPromise promise, CountDownLatch latch, InvocationOnMock invocationOnMock) throws Throwable {
        writtenObject.set(invocationOnMock.getArgument(0));
        promise.setSuccess();
        latch.countDown();
        return promise;
    }
}

