/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.proto.BookieRequestHandler;
import org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.proto.ForceLedgerProcessorV3;
import org.apache.bookkeeper.proto.RequestStats;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;

public class ForceLedgerProcessorV3Test {
    private BookkeeperProtocol.Request request;
    private ForceLedgerProcessorV3 processor;
    private BookieRequestHandler requestHandler;
    private Channel channel;
    private BookieRequestProcessor requestProcessor;
    private Bookie bookie;

    @Before
    public void setup() {
        this.request = BookkeeperProtocol.Request.newBuilder().setHeader(BookkeeperProtocol.BKPacketHeader.newBuilder().setTxnId(System.currentTimeMillis()).setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE).setOperation(BookkeeperProtocol.OperationType.ADD_ENTRY).build()).setForceLedgerRequest(BookkeeperProtocol.ForceLedgerRequest.newBuilder().setLedgerId(System.currentTimeMillis()).build()).build();
        this.channel = (Channel)Mockito.mock(Channel.class);
        Mockito.when((Object)this.channel.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.channel.isActive()).thenReturn((Object)true);
        this.requestHandler = (BookieRequestHandler)Mockito.mock(BookieRequestHandler.class);
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Mockito.when((Object)ctx.channel()).thenReturn((Object)this.channel);
        Mockito.when((Object)this.requestHandler.ctx()).thenReturn((Object)ctx);
        this.bookie = (Bookie)Mockito.mock(Bookie.class);
        this.requestProcessor = (BookieRequestProcessor)Mockito.mock(BookieRequestProcessor.class);
        Mockito.when((Object)this.requestProcessor.getBookie()).thenReturn((Object)this.bookie);
        Mockito.when((Object)this.requestProcessor.getWaitTimeoutOnBackpressureMillis()).thenReturn((Object)-1L);
        Mockito.when((Object)this.requestProcessor.getRequestStats()).thenReturn((Object)new RequestStats((StatsLogger)NullStatsLogger.INSTANCE));
        this.processor = new ForceLedgerProcessorV3(this.request, this.requestHandler, this.requestProcessor);
    }

    @Test
    public void testForceLedger() throws Exception {
        Mockito.when((Object)this.channel.voidPromise()).thenReturn((Object)((ChannelPromise)Mockito.mock(ChannelPromise.class)));
        Mockito.when((Object)this.channel.writeAndFlush(ArgumentMatchers.any())).thenReturn((Object)((ChannelFuture)Mockito.mock(ChannelPromise.class)));
        ((Bookie)Mockito.doAnswer(invocationOnMock -> {
            BookkeeperInternalCallbacks.WriteCallback wc = (BookkeeperInternalCallbacks.WriteCallback)invocationOnMock.getArgument(1);
            wc.writeComplete(0, this.request.getForceLedgerRequest().getLedgerId(), -16384L, null, null);
            return null;
        }).when((Object)this.bookie)).forceLedger(ArgumentMatchers.eq((long)this.request.getForceLedgerRequest().getLedgerId()), (BookkeeperInternalCallbacks.WriteCallback)ArgumentMatchers.any(BookkeeperInternalCallbacks.WriteCallback.class), ArgumentMatchers.same((Object)this.requestHandler));
        DefaultChannelPromise promise = new DefaultChannelPromise(this.channel);
        AtomicReference writtenObject = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        ((Channel)Mockito.doAnswer(arg_0 -> ForceLedgerProcessorV3Test.lambda$testForceLedger$1(writtenObject, latch, (ChannelPromise)promise, arg_0)).when((Object)this.channel)).writeAndFlush(ArgumentMatchers.any());
        this.processor.run();
        ((Bookie)Mockito.verify((Object)this.bookie, (VerificationMode)Mockito.times((int)1))).forceLedger(ArgumentMatchers.eq((long)this.request.getForceLedgerRequest().getLedgerId()), (BookkeeperInternalCallbacks.WriteCallback)ArgumentMatchers.any(BookkeeperInternalCallbacks.WriteCallback.class), ArgumentMatchers.same((Object)this.requestHandler));
        ((Channel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).writeAndFlush(ArgumentMatchers.any(BookkeeperProtocol.Response.class));
        latch.await();
        Assert.assertTrue((boolean)(writtenObject.get() instanceof BookkeeperProtocol.Response));
        BookkeeperProtocol.Response response = (BookkeeperProtocol.Response)writtenObject.get();
        Assert.assertEquals((Object)BookkeeperProtocol.StatusCode.EOK, (Object)response.getStatus());
    }

    private static /* synthetic */ Object lambda$testForceLedger$1(AtomicReference writtenObject, CountDownLatch latch, ChannelPromise promise, InvocationOnMock invocationOnMock) throws Throwable {
        writtenObject.set(invocationOnMock.getArgument(0));
        latch.countDown();
        return promise;
    }
}

