/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.channel.Channel;
import io.netty.channel.local.LocalChannel;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;

public class NetworkLessBookieTest
extends BookKeeperClusterTestCase {
    public NetworkLessBookieTest() {
        super(1);
        this.baseConf.setDisableServerSocketBind(true);
        this.baseConf.setEnableLocalTransport(true);
    }

    @Test
    public void testUseLocalBookie() throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        conf.setZkTimeout(20000);
        try (BookKeeper bkc = new BookKeeper(conf);
             LedgerHandle h = bkc.createLedger(1, 1, BookKeeper.DigestType.CRC32, "testPasswd".getBytes());){
            h.addEntry("test".getBytes());
        }
        for (int i = 0; i < this.bookieCount(); ++i) {
            for (Channel channel : this.serverByIndex((int)i).nettyServer.allChannels) {
                if (channel instanceof LocalChannel) continue;
                Assert.fail();
            }
        }
    }
}

