/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.proto.BookieRequestHandler;
import org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.RequestStats;
import org.apache.bookkeeper.proto.WriteEntryProcessor;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;

public class WriteEntryProcessorTest {
    private BookieProtocol.ParsedAddRequest request;
    private WriteEntryProcessor processor;
    private Channel channel;
    private ChannelHandlerContext ctx;
    private BookieRequestHandler requestHandler;
    private BookieRequestProcessor requestProcessor;
    private Bookie bookie;

    @Before
    public void setup() {
        this.request = BookieProtocol.ParsedAddRequest.create((byte)2, (long)System.currentTimeMillis(), (long)(System.currentTimeMillis() + 1L), (short)0, (byte[])new byte[0], (ByteBuf)Unpooled.wrappedBuffer((byte[])"test-entry-data".getBytes(StandardCharsets.UTF_8)));
        this.channel = (Channel)Mockito.mock(Channel.class);
        Mockito.when((Object)this.channel.isOpen()).thenReturn((Object)true);
        this.requestHandler = (BookieRequestHandler)Mockito.mock(BookieRequestHandler.class);
        this.ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Mockito.when((Object)this.ctx.channel()).thenReturn((Object)this.channel);
        Mockito.when((Object)this.requestHandler.ctx()).thenReturn((Object)this.ctx);
        this.bookie = (Bookie)Mockito.mock(Bookie.class);
        this.requestProcessor = (BookieRequestProcessor)Mockito.mock(BookieRequestProcessor.class);
        Mockito.when((Object)this.requestProcessor.getBookie()).thenReturn((Object)this.bookie);
        Mockito.when((Object)this.requestProcessor.getRequestStats()).thenReturn((Object)new RequestStats((StatsLogger)NullStatsLogger.INSTANCE));
        Mockito.when((Object)this.channel.isActive()).thenReturn((Object)true);
        Mockito.when((Object)this.channel.isWritable()).thenReturn((Object)true);
        this.processor = WriteEntryProcessor.create((BookieProtocol.ParsedAddRequest)this.request, (BookieRequestHandler)this.requestHandler, (BookieRequestProcessor)this.requestProcessor);
    }

    private void reinitRequest(short flags) {
        this.request.release();
        this.request.recycle();
        this.processor.recycle();
        this.request = BookieProtocol.ParsedAddRequest.create((byte)2, (long)System.currentTimeMillis(), (long)(System.currentTimeMillis() + 1L), (short)flags, (byte[])new byte[0], (ByteBuf)Unpooled.wrappedBuffer((byte[])"test-entry-data".getBytes(StandardCharsets.UTF_8)));
        this.processor = WriteEntryProcessor.create((BookieProtocol.ParsedAddRequest)this.request, (BookieRequestHandler)this.requestHandler, (BookieRequestProcessor)this.requestProcessor);
    }

    @Test
    public void testNoneHighPriorityWritesOnReadOnlyBookie() throws Exception {
        Mockito.when((Object)this.bookie.isReadOnly()).thenReturn((Object)true);
        ChannelPromise mockPromise = (ChannelPromise)Mockito.mock(ChannelPromise.class);
        Mockito.when((Object)this.channel.newPromise()).thenReturn((Object)mockPromise);
        Mockito.when((Object)mockPromise.addListener((GenericFutureListener)ArgumentMatchers.any())).thenReturn((Object)mockPromise);
        AtomicReference writtenObject = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        ((Channel)Mockito.doAnswer(invocationOnMock -> {
            writtenObject.set(invocationOnMock.getArgument(0));
            latch.countDown();
            return null;
        }).when((Object)this.channel)).writeAndFlush(ArgumentMatchers.any(), (ChannelPromise)ArgumentMatchers.any());
        this.processor.run();
        ((Channel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).writeAndFlush(ArgumentMatchers.any(), (ChannelPromise)ArgumentMatchers.any());
        latch.await();
        Assert.assertTrue((boolean)(writtenObject.get() instanceof BookieProtocol.Response));
        BookieProtocol.Response response = (BookieProtocol.Response)writtenObject.get();
        Assert.assertEquals((long)105L, (long)response.getErrorCode());
        response.release();
        response.recycle();
    }

    @Test
    public void testHighPriorityWritesOnReadOnlyBookieWhenHighPriorityWritesDisallowed() throws Exception {
        this.reinitRequest((short)4);
        Mockito.when((Object)this.bookie.isReadOnly()).thenReturn((Object)true);
        Mockito.when((Object)this.bookie.isAvailableForHighPriorityWrites()).thenReturn((Object)false);
        ChannelPromise mockPromise = (ChannelPromise)Mockito.mock(ChannelPromise.class);
        Mockito.when((Object)this.channel.newPromise()).thenReturn((Object)mockPromise);
        Mockito.when((Object)mockPromise.addListener((GenericFutureListener)ArgumentMatchers.any())).thenReturn((Object)mockPromise);
        AtomicReference writtenObject = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        ((Channel)Mockito.doAnswer(invocationOnMock -> {
            writtenObject.set(invocationOnMock.getArgument(0));
            latch.countDown();
            return null;
        }).when((Object)this.channel)).writeAndFlush(ArgumentMatchers.any(), (ChannelPromise)ArgumentMatchers.any());
        this.processor.run();
        ((Channel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).writeAndFlush(ArgumentMatchers.any(), (ChannelPromise)ArgumentMatchers.any());
        latch.await();
        Assert.assertTrue((boolean)(writtenObject.get() instanceof BookieProtocol.Response));
        BookieProtocol.Response response = (BookieProtocol.Response)writtenObject.get();
        Assert.assertEquals((long)105L, (long)response.getErrorCode());
        response.release();
        response.recycle();
    }

    @Test
    public void testHighPriorityWritesOnReadOnlyBookieWhenHighPriorityWritesAllowed() throws Exception {
        this.reinitRequest((short)4);
        Mockito.when((Object)this.bookie.isReadOnly()).thenReturn((Object)true);
        Mockito.when((Object)this.bookie.isAvailableForHighPriorityWrites()).thenReturn((Object)true);
        ChannelPromise mockPromise = (ChannelPromise)Mockito.mock(ChannelPromise.class);
        Mockito.when((Object)this.channel.newPromise()).thenReturn((Object)mockPromise);
        Mockito.when((Object)mockPromise.addListener((GenericFutureListener)ArgumentMatchers.any())).thenReturn((Object)mockPromise);
        ((Bookie)Mockito.doAnswer(invocationOnMock -> {
            this.processor.writeComplete(0, this.request.ledgerId, this.request.entryId, null, null);
            return null;
        }).when((Object)this.bookie)).addEntry((ByteBuf)ArgumentMatchers.any(ByteBuf.class), ArgumentMatchers.eq((boolean)false), (BookkeeperInternalCallbacks.WriteCallback)ArgumentMatchers.same((Object)this.processor), ArgumentMatchers.same((Object)this.requestHandler), (byte[])ArgumentMatchers.eq((Object)new byte[0]));
        AtomicReference writtenObject = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        ((BookieRequestHandler)Mockito.doAnswer(invocationOnMock -> {
            writtenObject.set((Integer)invocationOnMock.getArgument(0));
            latch.countDown();
            return null;
        }).when((Object)this.requestHandler)).prepareSendResponseV2(ArgumentMatchers.anyInt(), (BookieProtocol.ParsedAddRequest)ArgumentMatchers.any());
        this.processor.run();
        ((Bookie)Mockito.verify((Object)this.bookie, (VerificationMode)Mockito.times((int)1))).addEntry((ByteBuf)ArgumentMatchers.any(ByteBuf.class), ArgumentMatchers.eq((boolean)false), (BookkeeperInternalCallbacks.WriteCallback)ArgumentMatchers.same((Object)this.processor), ArgumentMatchers.same((Object)this.requestHandler), (byte[])ArgumentMatchers.eq((Object)new byte[0]));
        ((BookieRequestHandler)Mockito.verify((Object)this.requestHandler, (VerificationMode)Mockito.times((int)1))).prepareSendResponseV2(ArgumentMatchers.anyInt(), (BookieProtocol.ParsedAddRequest)ArgumentMatchers.any());
        latch.await();
        Assert.assertTrue((boolean)(writtenObject.get() instanceof Integer));
        Assert.assertEquals((long)0L, (long)((Integer)writtenObject.get()).intValue());
    }

    @Test
    public void testNormalWritesOnWritableBookie() throws Exception {
        Mockito.when((Object)this.bookie.isReadOnly()).thenReturn((Object)false);
        ChannelPromise mockPromise = (ChannelPromise)Mockito.mock(ChannelPromise.class);
        Mockito.when((Object)this.channel.newPromise()).thenReturn((Object)mockPromise);
        Mockito.when((Object)mockPromise.addListener((GenericFutureListener)ArgumentMatchers.any())).thenReturn((Object)mockPromise);
        ((Bookie)Mockito.doAnswer(invocationOnMock -> {
            this.processor.writeComplete(0, this.request.ledgerId, this.request.entryId, null, null);
            return null;
        }).when((Object)this.bookie)).addEntry((ByteBuf)ArgumentMatchers.any(ByteBuf.class), ArgumentMatchers.eq((boolean)false), (BookkeeperInternalCallbacks.WriteCallback)ArgumentMatchers.same((Object)this.processor), ArgumentMatchers.same((Object)this.requestHandler), (byte[])ArgumentMatchers.eq((Object)new byte[0]));
        AtomicReference writtenObject = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        ((BookieRequestHandler)Mockito.doAnswer(invocationOnMock -> {
            writtenObject.set((Integer)invocationOnMock.getArgument(0));
            latch.countDown();
            return null;
        }).when((Object)this.requestHandler)).prepareSendResponseV2(ArgumentMatchers.anyInt(), (BookieProtocol.ParsedAddRequest)ArgumentMatchers.any());
        this.processor.run();
        ((Bookie)Mockito.verify((Object)this.bookie, (VerificationMode)Mockito.times((int)1))).addEntry((ByteBuf)ArgumentMatchers.any(ByteBuf.class), ArgumentMatchers.eq((boolean)false), (BookkeeperInternalCallbacks.WriteCallback)ArgumentMatchers.same((Object)this.processor), ArgumentMatchers.same((Object)this.requestHandler), (byte[])ArgumentMatchers.eq((Object)new byte[0]));
        ((BookieRequestHandler)Mockito.verify((Object)this.requestHandler, (VerificationMode)Mockito.times((int)1))).prepareSendResponseV2(ArgumentMatchers.anyInt(), (BookieProtocol.ParsedAddRequest)ArgumentMatchers.any());
        latch.await();
        Assert.assertEquals((long)0L, (long)((Integer)writtenObject.get()).intValue());
    }

    @Test
    public void testWritesCacheFlushTimeout() throws Exception {
        Mockito.when((Object)this.bookie.isReadOnly()).thenReturn((Object)false);
        ChannelPromise mockPromise = (ChannelPromise)Mockito.mock(ChannelPromise.class);
        Mockito.when((Object)this.channel.newPromise()).thenReturn((Object)mockPromise);
        Mockito.when((Object)mockPromise.addListener((GenericFutureListener)ArgumentMatchers.any())).thenReturn((Object)mockPromise);
        Mockito.when((Object)this.channel.writeAndFlush(ArgumentMatchers.any())).thenReturn((Object)((ChannelFuture)Mockito.mock(ChannelPromise.class)));
        ((Bookie)Mockito.doAnswer(invocationOnMock -> {
            throw new BookieException.OperationRejectedException();
        }).when((Object)this.bookie)).addEntry((ByteBuf)ArgumentMatchers.any(ByteBuf.class), ArgumentMatchers.eq((boolean)false), (BookkeeperInternalCallbacks.WriteCallback)ArgumentMatchers.same((Object)this.processor), ArgumentMatchers.same((Object)this.requestHandler), (byte[])ArgumentMatchers.eq((Object)new byte[0]));
        DefaultChannelPromise promise = new DefaultChannelPromise(this.channel);
        AtomicReference writtenObject = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        ((Channel)Mockito.doAnswer(arg_0 -> WriteEntryProcessorTest.lambda$testWritesCacheFlushTimeout$7(writtenObject, latch, (ChannelPromise)promise, arg_0)).when((Object)this.channel)).writeAndFlush(ArgumentMatchers.any(), (ChannelPromise)ArgumentMatchers.any());
        this.processor.run();
        ((Bookie)Mockito.verify((Object)this.bookie, (VerificationMode)Mockito.times((int)1))).addEntry((ByteBuf)ArgumentMatchers.any(ByteBuf.class), ArgumentMatchers.eq((boolean)false), (BookkeeperInternalCallbacks.WriteCallback)ArgumentMatchers.same((Object)this.processor), ArgumentMatchers.same((Object)this.requestHandler), (byte[])ArgumentMatchers.eq((Object)new byte[0]));
        ((Channel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).writeAndFlush(ArgumentMatchers.any(BookieProtocol.Response.class), (ChannelPromise)ArgumentMatchers.any());
        latch.await();
        Assert.assertTrue((boolean)(writtenObject.get() instanceof BookieProtocol.Response));
        BookieProtocol.Response response = (BookieProtocol.Response)writtenObject.get();
        Assert.assertEquals((long)106L, (long)response.getErrorCode());
    }

    private static /* synthetic */ Object lambda$testWritesCacheFlushTimeout$7(AtomicReference writtenObject, CountDownLatch latch, ChannelPromise promise, InvocationOnMock invocationOnMock) throws Throwable {
        writtenObject.set(invocationOnMock.getArgument(0));
        latch.countDown();
        return promise;
    }
}

