/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.sasl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.login.Configuration;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.sasl.MiniKdc;
import org.apache.bookkeeper.sasl.SASLBookieAuthProviderFactory;
import org.apache.bookkeeper.sasl.SASLClientProviderFactory;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSSAPIBookKeeperTest
extends BookKeeperClusterTestCase {
    static final Logger LOG = LoggerFactory.getLogger(GSSAPIBookKeeperTest.class);
    private static final byte[] PASSWD = "testPasswd".getBytes();
    private static final byte[] ENTRY = "TestEntry".getBytes();
    private static MiniKdc kdc;
    private static Properties conf;
    private static final String non_default_sasl_service_name = "non_default_servicename";
    @ClassRule
    public static TemporaryFolder kdcDir;
    @ClassRule
    public static TemporaryFolder kerberosWorkDir;

    @BeforeClass
    public static void startMiniKdc() throws Exception {
        conf = MiniKdc.createConf();
        kdc = new MiniKdc(conf, kdcDir.getRoot());
        kdc.start();
        ServerConfiguration bookieConf = TestBKConfiguration.newServerConfiguration();
        bookieConf.setUseHostNameAsBookieID(true);
        String localhostName = BookieImpl.getBookieAddress((ServerConfiguration)bookieConf).getHostName();
        String principalServerNoRealm = "non_default_servicename/" + localhostName;
        String principalServer = "non_default_servicename/" + localhostName + "@" + kdc.getRealm();
        LOG.info("principalServer: " + principalServer);
        String principalClientNoRealm = "bookkeeperclient/" + localhostName;
        String principalClient = principalClientNoRealm + "@" + kdc.getRealm();
        LOG.info("principalClient: " + principalClient);
        File keytabClient = new File(kerberosWorkDir.getRoot(), "bookkeeperclient.keytab");
        kdc.createPrincipal(keytabClient, principalClientNoRealm);
        File keytabServer = new File(kerberosWorkDir.getRoot(), "bookkeeperserver.keytab");
        kdc.createPrincipal(keytabServer, principalServerNoRealm);
        File jaasFile = new File(kerberosWorkDir.getRoot(), "jaas.conf");
        try (FileWriter writer = new FileWriter(jaasFile);){
            writer.write("\nBookie {\n  com.sun.security.auth.module.Krb5LoginModule required debug=true\n  useKeyTab=true\n  keyTab=\"" + keytabServer.getAbsolutePath() + "\n  storeKey=true\n  useTicketCache=false\n  principal=\"" + principalServer + "\";\n};\n\n\n\nBookKeeper {\n  com.sun.security.auth.module.Krb5LoginModule required debug=true\n  useKeyTab=true\n  keyTab=\"" + keytabClient.getAbsolutePath() + "\n  storeKey=true\n  useTicketCache=false\n  principal=\"" + principalClient + "\";\n};\n");
        }
        File krb5file = new File(kerberosWorkDir.getRoot(), "krb5.conf");
        try (FileWriter writer = new FileWriter(krb5file);){
            String conf = "[libdefaults]\n default_realm = " + kdc.getRealm() + "\n udp_preference_limit = 1\n\n\n[realms]\n " + kdc.getRealm() + "  = {\n  kdc = " + kdc.getHost() + ":" + kdc.getPort() + "\n }";
            writer.write(conf);
            LOG.info("krb5.conf:\n" + conf);
        }
        System.setProperty("java.security.auth.login.config", jaasFile.getAbsolutePath());
        System.setProperty("java.security.krb5.conf", krb5file.getAbsolutePath());
        Configuration.getConfiguration().refresh();
    }

    @AfterClass
    public static void stopMiniKdc() {
        System.clearProperty("java.security.auth.login.config");
        System.clearProperty("java.security.krb5.conf");
        if (kdc != null) {
            kdc.stop();
        }
    }

    public GSSAPIBookKeeperTest() {
        super(0);
    }

    private void connectAndWriteToBookie(ClientConfiguration conf, AtomicLong ledgerWritten) throws BKException, InterruptedException, IOException, KeeperException {
        LOG.info("Connecting to bookie");
        try (BookKeeper bkc = new BookKeeper(conf, this.zkc);){
            LedgerHandle l = bkc.createLedger(1, 1, BookKeeper.DigestType.CRC32, PASSWD);
            ledgerWritten.set(l.getId());
            l.addEntry(ENTRY);
            l.close();
        }
    }

    private int entryCount(long ledgerId, ClientConfiguration clientConf) throws Exception {
        LOG.info("Counting entries in {}", (Object)ledgerId);
        clientConf.setClientAuthProviderFactoryClass(SASLClientProviderFactory.class.getName());
        this.restartBookies(c -> {
            c.setUseHostNameAsBookieID(true);
            c.setBookieAuthProviderFactoryClass(SASLBookieAuthProviderFactory.class.getName());
            return c;
        });
        try (BookKeeper bkc = new BookKeeper(clientConf, this.zkc);){
            int n;
            block16: {
                LedgerHandle lh;
                block14: {
                    int n2;
                    block15: {
                        lh = bkc.openLedger(ledgerId, BookKeeper.DigestType.CRC32, PASSWD);
                        if (lh.getLastAddConfirmed() >= 0L) break block14;
                        n2 = 0;
                        if (lh == null) break block15;
                        lh.close();
                    }
                    return n2;
                }
                try {
                    Enumeration e = lh.readEntries(0L, lh.getLastAddConfirmed());
                    int count = 0;
                    while (e.hasMoreElements()) {
                        ++count;
                        Assert.assertTrue((String)"Should match what we wrote", (boolean)Arrays.equals(((LedgerEntry)e.nextElement()).getEntry(), ENTRY));
                    }
                    n = count;
                    if (lh == null) break block16;
                }
                catch (Throwable throwable) {
                    if (lh != null) {
                        try {
                            lh.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                lh.close();
            }
            return n;
        }
    }

    @Test
    public void testSingleMessageAuth() throws Exception {
        ServerConfiguration bookieConf = this.newServerConfiguration();
        bookieConf.setUseHostNameAsBookieID(true);
        bookieConf.setBookieAuthProviderFactoryClass(SASLBookieAuthProviderFactory.class.getName());
        ClientConfiguration clientConf = this.newClientConfiguration();
        clientConf.setClientAuthProviderFactoryClass(SASLClientProviderFactory.class.getName());
        this.startAndStoreBookie(bookieConf);
        AtomicLong ledgerId = new AtomicLong(-1L);
        this.connectAndWriteToBookie(clientConf, ledgerId);
        Assert.assertFalse((ledgerId.get() == -1L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Should have entry", (long)1L, (long)this.entryCount(ledgerId.get(), clientConf));
    }

    @Test
    public void testNotAllowedClientId() throws Exception {
        ServerConfiguration bookieConf = this.newServerConfiguration();
        bookieConf.setUseHostNameAsBookieID(true);
        bookieConf.setBookieAuthProviderFactoryClass(SASLBookieAuthProviderFactory.class.getName());
        bookieConf.setProperty("saslJaasClientAllowedIds", (Object)"nobody");
        ClientConfiguration clientConf = this.newClientConfiguration();
        clientConf.setClientAuthProviderFactoryClass(SASLClientProviderFactory.class.getName());
        this.startAndStoreBookie(bookieConf);
        AtomicLong ledgerId = new AtomicLong(-1L);
        try {
            this.connectAndWriteToBookie(clientConf, ledgerId);
            Assert.fail((String)"should not be able to access the bookie");
        }
        catch (BKException.BKUnauthorizedAccessException bKUnauthorizedAccessException) {
            // empty catch block
        }
    }

    BookieServer startAndStoreBookie(ServerConfiguration conf) throws Exception {
        System.setProperty("bookkeeper.sasl.servicename", non_default_sasl_service_name);
        return this.startAndAddBookie(conf).getServer();
    }

    @AfterClass
    public static void resetJAAS() {
        System.clearProperty("java.security.auth.login.config");
        Configuration.getConfiguration().refresh();
    }

    static {
        kdcDir = new TemporaryFolder();
        kerberosWorkDir = new TemporaryFolder();
    }
}

