/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.sasl;

import java.io.File;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.login.Configuration;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.sasl.SASLBookieAuthProviderFactory;
import org.apache.bookkeeper.sasl.SASLClientProviderFactory;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5DigestBookKeeperTest
extends BookKeeperClusterTestCase {
    static final Logger LOG = LoggerFactory.getLogger(MD5DigestBookKeeperTest.class);
    private static final byte[] PASSWD = "testPasswd".getBytes();
    private static final byte[] ENTRY = "TestEntry".getBytes();

    public MD5DigestBookKeeperTest() {
        super(0);
    }

    private void connectAndWriteToBookie(ClientConfiguration conf, AtomicLong ledgerWritten) throws Exception {
        LOG.info("Connecting to bookie");
        BookKeeper bkc = new BookKeeper(conf, this.zkc);
        LedgerHandle l = bkc.createLedger(1, 1, BookKeeper.DigestType.CRC32, PASSWD);
        ledgerWritten.set(l.getId());
        l.addEntry(ENTRY);
        l.close();
        bkc.close();
    }

    private int entryCount(long ledgerId, ServerConfiguration bookieConf, ClientConfiguration clientConf) throws Exception {
        LOG.info("Counting entries in {}", (Object)ledgerId);
        clientConf.setClientAuthProviderFactoryClass(SASLClientProviderFactory.class.getName());
        this.restartBookies(c -> {
            c.setBookieAuthProviderFactoryClass(SASLBookieAuthProviderFactory.class.getName());
            c.setProperty("saslJaasClientAllowedIds", (Object)".*hd.*");
            return c;
        });
        try (BookKeeper bkc = new BookKeeper(clientConf, this.zkc);){
            int n;
            block16: {
                LedgerHandle lh;
                block14: {
                    int n2;
                    block15: {
                        lh = bkc.openLedger(ledgerId, BookKeeper.DigestType.CRC32, PASSWD);
                        if (lh.getLastAddConfirmed() >= 0L) break block14;
                        n2 = 0;
                        if (lh == null) break block15;
                        lh.close();
                    }
                    return n2;
                }
                try {
                    Enumeration e = lh.readEntries(0L, lh.getLastAddConfirmed());
                    int count = 0;
                    while (e.hasMoreElements()) {
                        ++count;
                        Assert.assertTrue((String)"Should match what we wrote", (boolean)Arrays.equals(((LedgerEntry)e.nextElement()).getEntry(), ENTRY));
                    }
                    n = count;
                    if (lh == null) break block16;
                }
                catch (Throwable throwable) {
                    if (lh != null) {
                        try {
                            lh.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                lh.close();
            }
            return n;
        }
    }

    @Test
    public void testSingleMessageAuth() throws Exception {
        ServerConfiguration bookieConf = this.newServerConfiguration();
        bookieConf.setBookieAuthProviderFactoryClass(SASLBookieAuthProviderFactory.class.getName());
        bookieConf.setProperty("saslJaasClientAllowedIds", (Object)".*hd.*");
        ClientConfiguration clientConf = this.newClientConfiguration();
        clientConf.setClientAuthProviderFactoryClass(SASLClientProviderFactory.class.getName());
        this.startAndStoreBookie(bookieConf);
        AtomicLong ledgerId = new AtomicLong(-1L);
        this.connectAndWriteToBookie(clientConf, ledgerId);
        Assert.assertFalse((ledgerId.get() == -1L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Should have entry", (long)1L, (long)this.entryCount(ledgerId.get(), bookieConf, clientConf));
    }

    BookieServer startAndStoreBookie(ServerConfiguration conf) throws Exception {
        return this.startAndAddBookie(conf).getServer();
    }

    @AfterClass
    public static void resetJAAS() {
        System.clearProperty("java.security.auth.login.config");
        Configuration.getConfiguration().refresh();
    }

    static {
        System.setProperty("java.security.auth.login.config", new File("src/test/resources/jaas_md5.conf").getAbsolutePath());
    }
}

