/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server;

import java.io.File;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.client.BookKeeperTestClient;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerEntries;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.client.api.WriteHandle;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.server.Main;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.util.PortManager;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBookieBoot
extends BookKeeperClusterTestCase {
    private static final Logger log = LoggerFactory.getLogger(TestBookieBoot.class);

    public TestBookieBoot() throws Exception {
        super(0);
    }

    @Test
    public void testBootFromConfig() throws Exception {
        long ledgerId;
        ServerConfiguration conf = new ServerConfiguration();
        conf.setMetadataServiceUri(this.metadataServiceUri);
        conf.setAllowLoopback(true);
        conf.setBookiePort(PortManager.nextFreePort());
        conf.setLedgerStorageClass("org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorage");
        File storageDir = this.tmpDirs.createNew("bookie", "storage");
        conf.setLedgerDirNames(new String[]{storageDir.toString()});
        conf.setJournalDirName(storageDir.toString());
        PropertiesConfiguration propsConf = new PropertiesConfiguration();
        Iterator iter = conf.getKeys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            propsConf.setProperty(key, conf.getProperty(key));
        }
        File confFile = File.createTempFile("test", "conf");
        propsConf.save(confFile);
        log.info("Conf: {}", (Object)confFile);
        CompletableFuture promise = new CompletableFuture();
        Thread t = new Thread(() -> {
            try {
                int ret = Main.doMain((String[])new String[]{"-c", confFile.toString()});
                promise.complete(ret);
            }
            catch (Exception e) {
                promise.completeExceptionally(e);
            }
        }, "bookie-main");
        t.start();
        BookieSocketAddress addr = BookieImpl.getBookieAddress((ServerConfiguration)conf);
        BookKeeperTestClient bkc = new BookKeeperTestClient(this.baseClientConf);
        bkc.waitForWritableBookie(addr.toBookieId()).get();
        boolean connected = false;
        for (int i = 0; i < 100 && t.isAlive(); ++i) {
            try (Socket s = new Socket(addr.getSocketAddress().getAddress(), addr.getPort());){
                connected = true;
                break;
            }
            catch (Exception exception) {
                Thread.sleep(100L);
                continue;
            }
        }
        MatcherAssert.assertThat((Object)connected, (Matcher)Matchers.equalTo((Object)true));
        try (WriteHandle wh = (WriteHandle)bkc.newCreateLedgerOp().withEnsembleSize(1).withWriteQuorumSize(1).withAckQuorumSize(1).withDigestType(DigestType.CRC32C).withPassword(new byte[0]).execute().get();){
            ledgerId = wh.getId();
            wh.append("foobar".getBytes(StandardCharsets.UTF_8));
        }
        try (ReadHandle rh = (ReadHandle)bkc.newOpenLedgerOp().withLedgerId(ledgerId).withDigestType(DigestType.CRC32C).withPassword(new byte[0]).withRecovery(true).execute().get();){
            MatcherAssert.assertThat((Object)rh.getLastAddConfirmed(), (Matcher)Matchers.equalTo((Object)0L));
            try (LedgerEntries entries = rh.read(0L, 0L);){
                MatcherAssert.assertThat((Object)new String(entries.getEntry(0L).getEntryBytes(), StandardCharsets.UTF_8), (Matcher)Matchers.equalTo((Object)"foobar"));
            }
        }
        t.interrupt();
        MatcherAssert.assertThat((Object)((Integer)promise.get(10L, TimeUnit.SECONDS)), (Matcher)Matchers.equalTo((Object)0));
    }
}

