/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.MockUncleanShutdownDetection;
import org.apache.bookkeeper.bookie.TestBookieImpl;
import org.apache.bookkeeper.bookie.UncleanShutdownDetection;
import org.apache.bookkeeper.client.BookieInfoReader;
import org.apache.bookkeeper.client.api.WriteFlag;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieClientImpl;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.DataFormats;
import org.apache.bookkeeper.proto.checksum.DigestManager;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.TestStatsProvider;
import org.apache.bookkeeper.util.ByteBufList;
import org.apache.bookkeeper.util.IOUtils;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BookieClientTest {
    BookieServer bs;
    File tmpDir;
    public int port = 13645;
    public EventLoopGroup eventLoopGroup;
    public OrderedExecutor executor;
    private ScheduledExecutorService scheduler;
    BookkeeperInternalCallbacks.ReadEntryCallback recb = new BookkeeperInternalCallbacks.ReadEntryCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readEntryComplete(int rc, long ledgerId, long entryId, ByteBuf bb, Object ctx) {
            ResultStruct rs;
            ResultStruct resultStruct = rs = (ResultStruct)ctx;
            synchronized (resultStruct) {
                rs.rc = rc;
                if (0 == rc && bb != null) {
                    bb.readerIndex(24);
                    rs.entry = bb.nioBuffer();
                }
                rs.notifyAll();
            }
        }
    };
    BookkeeperInternalCallbacks.WriteCallback wrcb = new BookkeeperInternalCallbacks.WriteCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeComplete(int rc, long ledgerId, long entryId, BookieId addr, Object ctx) {
            if (ctx != null) {
                Object object = ctx;
                synchronized (object) {
                    if (ctx instanceof ResultStruct) {
                        ResultStruct rs = (ResultStruct)ctx;
                        rs.rc = rc;
                    }
                    ctx.notifyAll();
                }
            }
        }
    };

    @Before
    public void setUp() throws Exception {
        this.tmpDir = IOUtils.createTempDir((String)"bookieClient", (String)"test");
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setGcWaitTime(100000L);
        conf.setBookiePort(this.port).setJournalDirName(this.tmpDir.getPath()).setLedgerDirNames(new String[]{this.tmpDir.getPath()}).setMetadataServiceUri(null);
        this.bs = new BookieServer(conf, (Bookie)new TestBookieImpl(conf), (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (UncleanShutdownDetection)new MockUncleanShutdownDetection());
        this.bs.start();
        this.eventLoopGroup = new NioEventLoopGroup();
        this.executor = OrderedExecutor.newBuilder().name("BKClientOrderedSafeExecutor").numThreads(2).build();
        this.scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("BookKeeperClientScheduler"));
    }

    @After
    public void tearDown() throws Exception {
        this.scheduler.shutdown();
        this.bs.shutdown();
        BookieClientTest.recursiveDelete(this.tmpDir);
        this.eventLoopGroup.shutdownGracefully();
        this.executor.shutdown();
    }

    private static void recursiveDelete(File dir) {
        File[] children = dir.listFiles();
        if (children != null) {
            for (File child : children) {
                BookieClientTest.recursiveDelete(child);
            }
        }
        dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteGaps() throws Exception {
        Object notifyObject = new Object();
        byte[] passwd = new byte[20];
        Arrays.fill(passwd, (byte)97);
        BookieId addr = this.bs.getBookieId();
        ResultStruct arc = new ResultStruct();
        BookieClientImpl bc = new BookieClientImpl(new ClientConfiguration(), this.eventLoopGroup, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, this.executor, this.scheduler, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        ByteBufList bb = this.createByteBuffer(1, 1L, 1L);
        bc.addEntry(addr, 1L, passwd, 1L, (ReferenceCounted)bb, this.wrcb, (Object)arc, 0, false, WriteFlag.NONE);
        Object object = arc;
        synchronized (object) {
            arc.wait(1000L);
            Assert.assertEquals((long)0L, (long)arc.rc);
            bc.readEntry(addr, 1L, 1L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)0L, (long)arc.rc);
            Assert.assertEquals((long)1L, (long)arc.entry.getInt());
        }
        bb = this.createByteBuffer(2, 1L, 2L);
        bc.addEntry(addr, 1L, passwd, 2L, (ReferenceCounted)bb, this.wrcb, null, 0, false, WriteFlag.NONE);
        bb = this.createByteBuffer(3, 1L, 3L);
        bc.addEntry(addr, 1L, passwd, 3L, (ReferenceCounted)bb, this.wrcb, null, 0, false, WriteFlag.NONE);
        bb = this.createByteBuffer(5, 1L, 5L);
        bc.addEntry(addr, 1L, passwd, 5L, (ReferenceCounted)bb, this.wrcb, null, 0, false, WriteFlag.NONE);
        bb = this.createByteBuffer(7, 1L, 7L);
        bc.addEntry(addr, 1L, passwd, 7L, (ReferenceCounted)bb, this.wrcb, null, 0, false, WriteFlag.NONE);
        object = notifyObject;
        synchronized (object) {
            bb = this.createByteBuffer(11, 1L, 11L);
            bc.addEntry(addr, 1L, passwd, 11L, (ReferenceCounted)bb, this.wrcb, notifyObject, 0, false, WriteFlag.NONE);
            notifyObject.wait();
        }
        object = arc;
        synchronized (object) {
            bc.readEntry(addr, 1L, 6L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)-13L, (long)arc.rc);
        }
        object = arc;
        synchronized (object) {
            bc.readEntry(addr, 1L, 7L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)0L, (long)arc.rc);
            Assert.assertEquals((float)7.0f, (float)arc.entry.getInt(), (float)0.0f);
        }
        object = arc;
        synchronized (object) {
            bc.readEntry(addr, 1L, 1L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)0L, (long)arc.rc);
            Assert.assertEquals((long)1L, (long)arc.entry.getInt());
        }
        object = arc;
        synchronized (object) {
            bc.readEntry(addr, 1L, 2L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)0L, (long)arc.rc);
            Assert.assertEquals((long)2L, (long)arc.entry.getInt());
        }
        object = arc;
        synchronized (object) {
            bc.readEntry(addr, 1L, 3L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)0L, (long)arc.rc);
            Assert.assertEquals((long)3L, (long)arc.entry.getInt());
        }
        object = arc;
        synchronized (object) {
            bc.readEntry(addr, 1L, 4L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)-13L, (long)arc.rc);
        }
        object = arc;
        synchronized (object) {
            bc.readEntry(addr, 1L, 11L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)0L, (long)arc.rc);
            Assert.assertEquals((long)11L, (long)arc.entry.getInt());
        }
        object = arc;
        synchronized (object) {
            bc.readEntry(addr, 1L, 5L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)0L, (long)arc.rc);
            Assert.assertEquals((long)5L, (long)arc.entry.getInt());
        }
        object = arc;
        synchronized (object) {
            bc.readEntry(addr, 1L, 10L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)-13L, (long)arc.rc);
        }
        object = arc;
        synchronized (object) {
            bc.readEntry(addr, 1L, 12L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)-13L, (long)arc.rc);
        }
        object = arc;
        synchronized (object) {
            bc.readEntry(addr, 1L, 13L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)-13L, (long)arc.rc);
        }
    }

    private ByteBufList createByteBuffer(int i, long lid, long eid) {
        ByteBuf bb = Unpooled.buffer((int)28);
        bb.writeLong(lid);
        bb.writeLong(eid);
        bb.writeLong(eid - 1L);
        bb.writeInt(i);
        return ByteBufList.get((ByteBuf)bb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoLedger() throws Exception {
        ResultStruct arc = new ResultStruct();
        BookieId addr = this.bs.getBookieId();
        BookieClientImpl bc = new BookieClientImpl(new ClientConfiguration(), this.eventLoopGroup, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, this.executor, this.scheduler, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        ResultStruct resultStruct = arc;
        synchronized (resultStruct) {
            bc.readEntry(addr, 2L, 13L, this.recb, (Object)arc, 0);
            arc.wait(1000L);
            Assert.assertEquals((long)-7L, (long)arc.rc);
        }
    }

    @Test
    public void testGetBookieInfoWithLimitStatsLogging() throws IOException, InterruptedException {
        this.testGetBookieInfo(true);
    }

    @Test
    public void testGetBookieInfoWithoutLimitStatsLogging() throws IOException, InterruptedException {
        this.testGetBookieInfo(false);
    }

    public void testGetBookieInfo(boolean limitStatsLogging) throws IOException, InterruptedException {
        BookieId bookieId = this.bs.getBookieId();
        BookieSocketAddress addr = this.bs.getLocalAddress();
        ClientConfiguration clientConf = new ClientConfiguration();
        clientConf.setLimitStatsLogging(limitStatsLogging);
        TestStatsProvider statsProvider = new TestStatsProvider();
        TestStatsProvider.TestStatsLogger statsLogger = statsProvider.getStatsLogger("");
        BookieClientImpl bc = new BookieClientImpl(clientConf, (EventLoopGroup)new NioEventLoopGroup(), (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, this.executor, this.scheduler, (StatsLogger)statsLogger, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        long flags = 3L;
        class CallbackObj {
            int rc;
            long requested;
            long freeDiskSpace;
            long totalDiskCapacity;
            CountDownLatch latch = new CountDownLatch(1);

            CallbackObj(long requested) {
                this.requested = requested;
                this.rc = 0;
                this.freeDiskSpace = 0L;
                this.totalDiskCapacity = 0L;
            }
        }
        CallbackObj obj = new CallbackObj(flags);
        bc.getBookieInfo(bookieId, flags, new BookkeeperInternalCallbacks.GetBookieInfoCallback(){

            public void getBookieInfoComplete(int rc, BookieInfoReader.BookieInfo bInfo, Object ctx) {
                CallbackObj obj = (CallbackObj)ctx;
                obj.rc = rc;
                if (rc == 0) {
                    if ((obj.requested & 2L) != 0L) {
                        obj.freeDiskSpace = bInfo.getFreeDiskSpace();
                    }
                    if ((obj.requested & 1L) != 0L) {
                        obj.totalDiskCapacity = bInfo.getTotalDiskSpace();
                    }
                }
                obj.latch.countDown();
            }
        }, (Object)obj);
        obj.latch.await();
        System.out.println("Return code: " + obj.rc + "FreeDiskSpace: " + obj.freeDiskSpace + " TotalCapacity: " + obj.totalDiskCapacity);
        Assert.assertTrue((String)("GetBookieInfo failed with error " + obj.rc), (obj.rc == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("GetBookieInfo failed with error " + obj.rc), (obj.freeDiskSpace <= obj.totalDiskCapacity ? 1 : 0) != 0);
        Assert.assertTrue((String)("GetBookieInfo failed with error " + obj.rc), (obj.totalDiskCapacity > 0L ? 1 : 0) != 0);
        TestStatsProvider.TestOpStatsLogger perChannelBookieClientScopeOfThisAddr = (TestStatsProvider.TestOpStatsLogger)statsLogger.scope("per_channel_bookie_client").scopeLabel("bookie", addr.toBookieId().toString()).getOpStatsLogger("GET_BOOKIE_INFO");
        int expectedBookieInfoSuccessCount = limitStatsLogging ? 0 : 1;
        Assert.assertEquals((String)"BookieInfoSuccessCount", (long)expectedBookieInfoSuccessCount, (long)perChannelBookieClientScopeOfThisAddr.getSuccessCount());
    }

    @Test
    public void testBatchRead() throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setUseV2WireProtocol(true);
        BookieClientImpl bc = new BookieClientImpl(conf, this.eventLoopGroup, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, this.executor, this.scheduler, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        BookieId addr = this.bs.getBookieId();
        byte[] passwd = new byte[20];
        Arrays.fill(passwd, (byte)97);
        DigestManager digestManager = DigestManager.instantiate((long)1L, (byte[])passwd, (DataFormats.LedgerMetadataFormat.DigestType)DataFormats.LedgerMetadataFormat.DigestType.CRC32C, (ByteBufAllocator)ByteBufAllocator.DEFAULT, (boolean)true);
        byte[] masterKey = DigestManager.generateMasterKey((byte[])passwd);
        int entries = 10;
        int length = 0;
        for (int i = 0; i < 10; ++i) {
            ByteBuf bb = Unpooled.buffer((int)4);
            bb.writeInt(i);
            ReferenceCounted content = digestManager.computeDigestAndPackageForSending((long)i, (long)(i - 1), (long)(length += 4), bb, masterKey, 0);
            ResultStruct arc = new ResultStruct();
            bc.addEntry(addr, 1L, passwd, (long)i, content, this.wrcb, (Object)arc, 0, false, WriteFlag.NONE);
            Awaitility.await().untilAsserted(() -> Assert.assertEquals((long)0L, (long)arc.rc));
        }
        AtomicReference result = new AtomicReference();
        AtomicInteger resCode = new AtomicInteger();
        bc.batchReadEntries(addr, 1L, 0L, 5, 0x500000L, (rc, ledgerId, startEntryId, bufList, ctx) -> {
            resCode.set(rc);
            result.set(bufList);
        }, null, 0);
        Awaitility.await().untilAsserted(() -> {
            ByteBufList byteBufList = (ByteBufList)result.get();
            Assert.assertNotNull((Object)byteBufList);
        });
        Assert.assertEquals((long)0L, (long)resCode.get());
        ByteBufList byteBufList = (ByteBufList)result.get();
        Assert.assertEquals((long)5L, (long)byteBufList.size());
        for (int i = 0; i < byteBufList.size(); ++i) {
            ByteBuf buffer = byteBufList.getBuffer(i);
            Assert.assertEquals((long)1L, (long)buffer.readLong());
            Assert.assertEquals((long)i, (long)buffer.readLong());
            Assert.assertEquals((long)(i - 1), (long)buffer.readLong());
            Assert.assertEquals((long)((i + 1) * 4), (long)buffer.readLong());
            int i1 = buffer.readInt();
            ByteBuf byteBuf = buffer.readBytes(buffer.readableBytes());
            Assert.assertEquals((long)i, (long)byteBuf.readInt());
        }
    }

    @Test
    public void testBatchedReadWittLostFourthEntry() throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setUseV2WireProtocol(true);
        BookieClientImpl bc = new BookieClientImpl(conf, this.eventLoopGroup, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, this.executor, this.scheduler, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        BookieId addr = this.bs.getBookieId();
        byte[] passwd = new byte[20];
        Arrays.fill(passwd, (byte)97);
        DigestManager digestManager = DigestManager.instantiate((long)1L, (byte[])passwd, (DataFormats.LedgerMetadataFormat.DigestType)DataFormats.LedgerMetadataFormat.DigestType.CRC32C, (ByteBufAllocator)ByteBufAllocator.DEFAULT, (boolean)true);
        byte[] masterKey = DigestManager.generateMasterKey((byte[])passwd);
        int entries = 10;
        int length = 0;
        for (int i = 0; i < 10; ++i) {
            if (i == 3) continue;
            ByteBuf bb = Unpooled.buffer((int)4);
            bb.writeInt(i);
            ReferenceCounted content = digestManager.computeDigestAndPackageForSending((long)i, (long)(i - 1), (long)(length += 4), bb, masterKey, 0);
            ResultStruct arc = new ResultStruct();
            bc.addEntry(addr, 1L, passwd, (long)i, content, this.wrcb, (Object)arc, 0, false, WriteFlag.NONE);
            Awaitility.await().untilAsserted(() -> Assert.assertEquals((long)0L, (long)arc.rc));
        }
        AtomicReference result = new AtomicReference();
        AtomicInteger resCode = new AtomicInteger();
        bc.batchReadEntries(addr, 1L, 0L, 5, 0x500000L, (rc, ledgerId, startEntryId, bufList, ctx) -> {
            resCode.set(rc);
            result.set(bufList);
        }, null, 0);
        Awaitility.await().untilAsserted(() -> {
            ByteBufList byteBufList = (ByteBufList)result.get();
            Assert.assertNotNull((Object)byteBufList);
        });
        Assert.assertEquals((long)0L, (long)resCode.get());
        ByteBufList byteBufList = (ByteBufList)result.get();
        Assert.assertEquals((long)3L, (long)byteBufList.size());
        for (int i = 0; i < byteBufList.size(); ++i) {
            ByteBuf buffer = byteBufList.getBuffer(i);
            Assert.assertEquals((long)1L, (long)buffer.readLong());
            Assert.assertEquals((long)i, (long)buffer.readLong());
            Assert.assertEquals((long)(i - 1), (long)buffer.readLong());
            Assert.assertEquals((long)((i + 1) * 4), (long)buffer.readLong());
            int i1 = buffer.readInt();
            ByteBuf byteBuf = buffer.readBytes(buffer.readableBytes());
            Assert.assertEquals((long)i, (long)byteBuf.readInt());
        }
    }

    @Test
    public void testBatchedReadWittLostFirstEntry() throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setUseV2WireProtocol(true);
        BookieClientImpl bc = new BookieClientImpl(conf, this.eventLoopGroup, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, this.executor, this.scheduler, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        BookieId addr = this.bs.getBookieId();
        byte[] passwd = new byte[20];
        Arrays.fill(passwd, (byte)97);
        DigestManager digestManager = DigestManager.instantiate((long)1L, (byte[])passwd, (DataFormats.LedgerMetadataFormat.DigestType)DataFormats.LedgerMetadataFormat.DigestType.CRC32C, (ByteBufAllocator)ByteBufAllocator.DEFAULT, (boolean)true);
        byte[] masterKey = DigestManager.generateMasterKey((byte[])passwd);
        int entries = 10;
        int length = 0;
        for (int i = 0; i < 10; ++i) {
            if (i == 0) continue;
            ByteBuf bb = Unpooled.buffer((int)4);
            bb.writeInt(i);
            ReferenceCounted content = digestManager.computeDigestAndPackageForSending((long)i, (long)(i - 1), (long)(length += 4), bb, masterKey, 0);
            ResultStruct arc = new ResultStruct();
            bc.addEntry(addr, 1L, passwd, (long)i, content, this.wrcb, (Object)arc, 0, false, WriteFlag.NONE);
            Awaitility.await().untilAsserted(() -> Assert.assertEquals((long)0L, (long)arc.rc));
        }
        AtomicReference result = new AtomicReference();
        AtomicInteger resCode = new AtomicInteger();
        bc.batchReadEntries(addr, 1L, 0L, 5, 0x500000L, (rc, ledgerId, startEntryId, bufList, ctx) -> {
            resCode.set(rc);
            result.set(bufList);
        }, null, 0);
        Awaitility.await().untilAsserted(() -> {
            ByteBufList byteBufList = (ByteBufList)result.get();
            Assert.assertNotNull((Object)byteBufList);
        });
        Assert.assertEquals((long)-13L, (long)resCode.get());
        ByteBufList byteBufList = (ByteBufList)result.get();
        Assert.assertEquals((long)0L, (long)byteBufList.size());
    }

    @Test
    public void testBatchedReadWittBigPayload() throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setUseV2WireProtocol(true);
        BookieClientImpl bc = new BookieClientImpl(conf, this.eventLoopGroup, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, this.executor, this.scheduler, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        BookieId addr = this.bs.getBookieId();
        byte[] passwd = new byte[20];
        Arrays.fill(passwd, (byte)97);
        DigestManager digestManager = DigestManager.instantiate((long)1L, (byte[])passwd, (DataFormats.LedgerMetadataFormat.DigestType)DataFormats.LedgerMetadataFormat.DigestType.CRC32C, (ByteBufAllocator)ByteBufAllocator.DEFAULT, (boolean)true);
        byte[] masterKey = DigestManager.generateMasterKey((byte[])passwd);
        byte[] kbData = new byte[1024];
        for (int i = 0; i < 1024; ++i) {
            kbData[i] = (byte)i;
        }
        int entries = 20;
        int length = 0;
        for (int i = 0; i < 20; ++i) {
            ByteBuf bb = Unpooled.buffer((int)1024);
            bb.writeBytes(kbData);
            ReferenceCounted content = digestManager.computeDigestAndPackageForSending((long)i, (long)(i - 1), (long)(length += 1024), bb, masterKey, 0);
            ResultStruct arc = new ResultStruct();
            bc.addEntry(addr, 1L, passwd, (long)i, content, this.wrcb, (Object)arc, 0, false, WriteFlag.NONE);
            Awaitility.await().untilAsserted(() -> Assert.assertEquals((long)0L, (long)arc.rc));
        }
        AtomicReference result = new AtomicReference();
        AtomicInteger resCode = new AtomicInteger();
        bc.batchReadEntries(addr, 1L, 0L, 20, 0x500000L, (rc, ledgerId, startEntryId, bufList, ctx) -> {
            result.set(bufList);
            resCode.set(rc);
        }, null, 0);
        Awaitility.await().untilAsserted(() -> {
            ByteBufList byteBufList = (ByteBufList)result.get();
            Assert.assertNotNull((Object)byteBufList);
        });
        ByteBufList byteBufList = (ByteBufList)result.get();
        Assert.assertEquals((long)0L, (long)resCode.get());
        Assert.assertEquals((long)20L, (long)byteBufList.size());
        for (int i = 0; i < byteBufList.size(); ++i) {
            ByteBuf buffer = byteBufList.getBuffer(i);
            Assert.assertEquals((long)1L, (long)buffer.readLong());
            Assert.assertEquals((long)i, (long)buffer.readLong());
            Assert.assertEquals((long)(i - 1), (long)buffer.readLong());
            Assert.assertEquals((long)((i + 1) * 1024), (long)buffer.readLong());
            int i1 = buffer.readInt();
            ByteBuf byteBuf = buffer.readBytes(buffer.readableBytes());
            Assert.assertEquals((long)1024L, (long)byteBuf.readableBytes());
            byte[] bytes = ByteBufUtil.getBytes((ByteBuf)byteBuf);
            Assert.assertTrue((boolean)Arrays.equals(kbData, bytes));
        }
    }

    @Test
    public void testBatchedReadWithMaxSizeLimitCase1() throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setUseV2WireProtocol(true);
        BookieClientImpl bc = new BookieClientImpl(conf, this.eventLoopGroup, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, this.executor, this.scheduler, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        BookieId addr = this.bs.getBookieId();
        byte[] passwd = new byte[20];
        Arrays.fill(passwd, (byte)97);
        DigestManager digestManager = DigestManager.instantiate((long)1L, (byte[])passwd, (DataFormats.LedgerMetadataFormat.DigestType)DataFormats.LedgerMetadataFormat.DigestType.CRC32C, (ByteBufAllocator)ByteBufAllocator.DEFAULT, (boolean)true);
        byte[] masterKey = DigestManager.generateMasterKey((byte[])passwd);
        byte[] kbData = new byte[1024];
        for (int i = 0; i < 1024; ++i) {
            kbData[i] = (byte)i;
        }
        int entries = 20;
        int length = 0;
        for (int i = 0; i < 20; ++i) {
            ByteBuf bb = Unpooled.buffer((int)1024);
            bb.writeBytes(kbData);
            ReferenceCounted content = digestManager.computeDigestAndPackageForSending((long)i, (long)(i - 1), (long)(length += 1024), bb, masterKey, 0);
            ResultStruct arc = new ResultStruct();
            bc.addEntry(addr, 1L, passwd, (long)i, content, this.wrcb, (Object)arc, 0, false, WriteFlag.NONE);
            Awaitility.await().untilAsserted(() -> Assert.assertEquals((long)0L, (long)arc.rc));
        }
        AtomicReference result = new AtomicReference();
        AtomicInteger resCode = new AtomicInteger();
        int entrySize = 1060;
        bc.batchReadEntries(addr, 1L, 0L, 20, (long)(5 * entrySize), (rc, ledgerId, startEntryId, bufList, ctx) -> {
            result.set(bufList);
            resCode.set(rc);
        }, null, 0);
        Awaitility.await().untilAsserted(() -> {
            ByteBufList byteBufList = (ByteBufList)result.get();
            Assert.assertNotNull((Object)byteBufList);
        });
        ByteBufList byteBufList = (ByteBufList)result.get();
        Assert.assertEquals((long)0L, (long)resCode.get());
        Assert.assertEquals((long)4L, (long)byteBufList.size());
        for (int i = 0; i < byteBufList.size(); ++i) {
            ByteBuf buffer = byteBufList.getBuffer(i);
            Assert.assertEquals((long)1L, (long)buffer.readLong());
            Assert.assertEquals((long)i, (long)buffer.readLong());
            Assert.assertEquals((long)(i - 1), (long)buffer.readLong());
            Assert.assertEquals((long)((i + 1) * 1024), (long)buffer.readLong());
            int i1 = buffer.readInt();
            ByteBuf byteBuf = buffer.readBytes(buffer.readableBytes());
            Assert.assertEquals((long)1024L, (long)byteBuf.readableBytes());
            byte[] bytes = ByteBufUtil.getBytes((ByteBuf)byteBuf);
            Assert.assertTrue((boolean)Arrays.equals(kbData, bytes));
        }
    }

    @Test
    public void testBatchedReadWithMaxSizeLimitCase2() throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setUseV2WireProtocol(true);
        BookieClientImpl bc = new BookieClientImpl(conf, this.eventLoopGroup, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, this.executor, this.scheduler, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        BookieId addr = this.bs.getBookieId();
        byte[] passwd = new byte[20];
        Arrays.fill(passwd, (byte)97);
        DigestManager digestManager = DigestManager.instantiate((long)1L, (byte[])passwd, (DataFormats.LedgerMetadataFormat.DigestType)DataFormats.LedgerMetadataFormat.DigestType.CRC32C, (ByteBufAllocator)ByteBufAllocator.DEFAULT, (boolean)true);
        byte[] masterKey = DigestManager.generateMasterKey((byte[])passwd);
        byte[] kbData = new byte[1024];
        for (int i = 0; i < 1024; ++i) {
            kbData[i] = (byte)i;
        }
        int entries = 20;
        int length = 0;
        for (int i = 0; i < 20; ++i) {
            ByteBuf bb = Unpooled.buffer((int)1024);
            bb.writeBytes(kbData);
            ReferenceCounted content = digestManager.computeDigestAndPackageForSending((long)i, (long)(i - 1), (long)(length += 1024), bb, masterKey, 0);
            ResultStruct arc = new ResultStruct();
            bc.addEntry(addr, 1L, passwd, (long)i, content, this.wrcb, (Object)arc, 0, false, WriteFlag.NONE);
            Awaitility.await().untilAsserted(() -> Assert.assertEquals((long)0L, (long)arc.rc));
        }
        AtomicReference result = new AtomicReference();
        AtomicInteger resCode = new AtomicInteger();
        int entrySize = 1060;
        int headerSize = 36;
        bc.batchReadEntries(addr, 1L, 0L, 20, (long)(5 * entrySize + headerSize + 20), (rc, ledgerId, startEntryId, bufList, ctx) -> {
            result.set(bufList);
            resCode.set(rc);
        }, null, 0);
        Awaitility.await().untilAsserted(() -> {
            ByteBufList byteBufList = (ByteBufList)result.get();
            Assert.assertNotNull((Object)byteBufList);
        });
        ByteBufList byteBufList = (ByteBufList)result.get();
        Assert.assertEquals((long)0L, (long)resCode.get());
        Assert.assertEquals((long)5L, (long)byteBufList.size());
        for (int i = 0; i < byteBufList.size(); ++i) {
            ByteBuf buffer = byteBufList.getBuffer(i);
            Assert.assertEquals((long)1L, (long)buffer.readLong());
            Assert.assertEquals((long)i, (long)buffer.readLong());
            Assert.assertEquals((long)(i - 1), (long)buffer.readLong());
            Assert.assertEquals((long)((i + 1) * 1024), (long)buffer.readLong());
            int i1 = buffer.readInt();
            ByteBuf byteBuf = buffer.readBytes(buffer.readableBytes());
            Assert.assertEquals((long)1024L, (long)byteBuf.readableBytes());
            byte[] bytes = ByteBufUtil.getBytes((ByteBuf)byteBuf);
            Assert.assertTrue((boolean)Arrays.equals(kbData, bytes));
        }
    }

    static class ResultStruct {
        int rc = -123456;
        ByteBuffer entry;

        ResultStruct() {
        }
    }
}

