/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.ChannelPromise;
import io.netty.channel.VoidChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;
import org.apache.bookkeeper.util.NettyChannelUtil;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class NettyChannelUtilTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteAndFlushWithVoidPromise() {
        ChannelOutboundInvoker ctx = (ChannelOutboundInvoker)Mockito.mock(ChannelOutboundInvoker.class);
        VoidChannelPromise voidChannelPromise = new VoidChannelPromise((Channel)Mockito.mock(Channel.class), true);
        Mockito.when((Object)ctx.voidPromise()).thenReturn((Object)voidChannelPromise);
        byte[] data = "test".getBytes(StandardCharsets.UTF_8);
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])data, (int)0, (int)data.length);
        try {
            NettyChannelUtil.writeAndFlushWithVoidPromise((ChannelOutboundInvoker)ctx, (Object)byteBuf);
            ((ChannelOutboundInvoker)Mockito.verify((Object)ctx)).writeAndFlush(ArgumentMatchers.same((Object)byteBuf), (ChannelPromise)ArgumentMatchers.same((Object)voidChannelPromise));
            ((ChannelOutboundInvoker)Mockito.verify((Object)ctx)).voidPromise();
        }
        finally {
            byteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteAndFlushWithClosePromise() {
        ChannelOutboundInvoker ctx = (ChannelOutboundInvoker)Mockito.mock(ChannelOutboundInvoker.class);
        ChannelPromise promise = (ChannelPromise)Mockito.mock(ChannelPromise.class);
        byte[] data = "test".getBytes(StandardCharsets.UTF_8);
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])data, (int)0, (int)data.length);
        Mockito.when((Object)ctx.writeAndFlush(ArgumentMatchers.same((Object)byteBuf))).thenReturn((Object)promise);
        try {
            NettyChannelUtil.writeAndFlushWithClosePromise((ChannelOutboundInvoker)ctx, (Object)byteBuf);
            ((ChannelOutboundInvoker)Mockito.verify((Object)ctx)).writeAndFlush(ArgumentMatchers.same((Object)byteBuf));
            ((ChannelPromise)Mockito.verify((Object)promise)).addListener((GenericFutureListener)ArgumentMatchers.same((Object)ChannelFutureListener.CLOSE));
        }
        finally {
            byteBuf.release();
        }
    }
}

