/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.bookkeeper.util.HardLink;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHardLink {
    private File tempDir;

    @Before
    public void setup() throws IOException {
        this.tempDir = IOUtils.createTempDir((String)"TestHardLink", (String)"test-hardlink");
    }

    @After
    public void tearDown() throws IOException {
        FileUtils.deleteDirectory((File)this.tempDir);
    }

    private void verifyHardLink(File origin, File linkedOrigin) throws IOException {
        Assert.assertTrue((boolean)origin.exists());
        Assert.assertFalse((boolean)linkedOrigin.exists());
        HardLink.createHardLink((File)origin, (File)linkedOrigin);
        Assert.assertTrue((boolean)origin.exists());
        Assert.assertTrue((boolean)linkedOrigin.exists());
        origin.delete();
        Assert.assertFalse((boolean)origin.exists());
        Assert.assertTrue((boolean)linkedOrigin.exists());
    }

    @Test
    public void testHardLink() throws IOException {
        String uuidSuffix = UUID.randomUUID().toString();
        File origin = new File(this.tempDir, "originFile." + uuidSuffix);
        File linkedOrigin = new File(this.tempDir, "linkedOrigin." + uuidSuffix);
        origin.createNewFile();
        HardLink.enableJdkLinkApi((boolean)false);
        this.verifyHardLink(origin, linkedOrigin);
        File jdkorigin = new File(this.tempDir, "jdkoriginFile." + uuidSuffix);
        File jdklinkedOrigin = new File(this.tempDir, "jdklinkedOrigin." + uuidSuffix);
        jdkorigin.createNewFile();
        HardLink.enableJdkLinkApi((boolean)true);
        this.verifyHardLink(jdkorigin, jdklinkedOrigin);
    }
}

