/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util.collections;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.bookkeeper.util.collections.ConcurrentLongHashSet;
import org.apache.bookkeeper.util.collections.ConcurrentOpenHashSet;
import org.junit.Assert;
import org.junit.Test;

public class ConcurrentLongHashSetTest {
    @Test
    public void testConstructor() {
        try {
            ConcurrentLongHashSet.newBuilder().concurrencyLevel(0).build();
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ConcurrentLongHashSet.newBuilder().expectedItems(16).concurrencyLevel(0).build();
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ConcurrentLongHashSet.newBuilder().expectedItems(4).concurrencyLevel(8).build();
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void simpleInsertions() {
        ConcurrentLongHashSet set = ConcurrentLongHashSet.newBuilder().expectedItems(16).build();
        Assert.assertTrue((boolean)set.isEmpty());
        Assert.assertTrue((boolean)set.add(1L));
        Assert.assertFalse((boolean)set.isEmpty());
        Assert.assertTrue((boolean)set.add(2L));
        Assert.assertTrue((boolean)set.add(3L));
        Assert.assertEquals((long)set.size(), (long)3L);
        Assert.assertTrue((boolean)set.contains(1L));
        Assert.assertEquals((long)set.size(), (long)3L);
        Assert.assertTrue((boolean)set.remove(1L));
        Assert.assertEquals((long)set.size(), (long)2L);
        Assert.assertFalse((boolean)set.contains(1L));
        Assert.assertFalse((boolean)set.contains(5L));
        Assert.assertEquals((long)set.size(), (long)2L);
        Assert.assertTrue((boolean)set.add(1L));
        Assert.assertEquals((long)set.size(), (long)3L);
        Assert.assertFalse((boolean)set.add(1L));
        Assert.assertEquals((long)set.size(), (long)3L);
    }

    @Test
    public void testReduceUnnecessaryExpansions() {
        ConcurrentLongHashSet set = ConcurrentLongHashSet.newBuilder().expectedItems(2).concurrencyLevel(1).build();
        Assert.assertTrue((boolean)set.add(1L));
        Assert.assertTrue((boolean)set.add(2L));
        Assert.assertTrue((boolean)set.add(3L));
        Assert.assertTrue((boolean)set.add(4L));
        Assert.assertTrue((boolean)set.remove(1L));
        Assert.assertTrue((boolean)set.remove(2L));
        Assert.assertTrue((boolean)set.remove(3L));
        Assert.assertTrue((boolean)set.remove(4L));
        Assert.assertEquals((long)0L, (long)set.getUsedBucketCount());
    }

    @Test
    public void testRemove() {
        ConcurrentLongHashSet set = ConcurrentLongHashSet.newBuilder().build();
        Assert.assertTrue((boolean)set.isEmpty());
        Assert.assertTrue((boolean)set.add(1L));
        Assert.assertFalse((boolean)set.isEmpty());
        Assert.assertFalse((boolean)set.remove(0L));
        Assert.assertFalse((boolean)set.isEmpty());
        Assert.assertTrue((boolean)set.remove(1L));
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void testRehashing() {
        int n = 16;
        ConcurrentLongHashSet set = ConcurrentLongHashSet.newBuilder().expectedItems(n / 2).concurrencyLevel(1).build();
        Assert.assertEquals((long)set.capacity(), (long)n);
        Assert.assertEquals((long)set.size(), (long)0L);
        for (int i = 0; i < n; ++i) {
            set.add((long)i);
        }
        Assert.assertEquals((long)set.capacity(), (long)(2 * n));
        Assert.assertEquals((long)set.size(), (long)n);
    }

    @Test
    public void testRehashingWithDeletes() {
        int i;
        int n = 16;
        ConcurrentLongHashSet set = ConcurrentLongHashSet.newBuilder().expectedItems(n / 2).concurrencyLevel(1).build();
        Assert.assertEquals((long)set.capacity(), (long)n);
        Assert.assertEquals((long)set.size(), (long)0L);
        for (i = 0; i < n / 2; ++i) {
            set.add((long)i);
        }
        for (i = 0; i < n / 2; ++i) {
            set.remove((long)i);
        }
        for (i = n; i < 2 * n; ++i) {
            set.add((long)i);
        }
        Assert.assertEquals((long)set.capacity(), (long)(2 * n));
        Assert.assertEquals((long)set.size(), (long)n);
    }

    @Test
    public void concurrentInsertions() throws Throwable {
        ConcurrentLongHashSet set = ConcurrentLongHashSet.newBuilder().build();
        ExecutorService executor = Executors.newCachedThreadPool();
        int nThreads = 16;
        int n = 100000;
        ArrayList futures = new ArrayList();
        int i = 0;
        while (i < 16) {
            int n2 = i++;
            futures.add(executor.submit(() -> {
                Random random = new Random();
                for (int j = 0; j < 100000; ++j) {
                    long key = Math.abs(random.nextLong());
                    key -= key % (long)(threadIdx + 1);
                    set.add(key);
                }
            }));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)set.size(), (long)1600000L);
        executor.shutdown();
    }

    @Test
    public void concurrentInsertionsAndReads() throws Throwable {
        ConcurrentLongHashSet map = ConcurrentLongHashSet.newBuilder().build();
        ExecutorService executor = Executors.newCachedThreadPool();
        int nThreads = 16;
        int n = 100000;
        ArrayList futures = new ArrayList();
        int i = 0;
        while (i < 16) {
            int n2 = i++;
            futures.add(executor.submit(() -> {
                Random random = new Random();
                for (int j = 0; j < 100000; ++j) {
                    long key = Math.abs(random.nextLong());
                    key -= key % (long)(threadIdx + 1);
                    map.add(key);
                }
            }));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)map.size(), (long)1600000L);
        executor.shutdown();
    }

    @Test
    public void testClear() {
        ConcurrentLongHashSet map = ConcurrentLongHashSet.newBuilder().expectedItems(2).concurrencyLevel(1).autoShrink(true).mapIdleFactor(0.25f).build();
        Assert.assertTrue((map.capacity() == 4L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.add(1L));
        Assert.assertTrue((boolean)map.add(2L));
        Assert.assertTrue((boolean)map.add(3L));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
        map.clear();
        Assert.assertTrue((map.capacity() == 4L ? 1 : 0) != 0);
    }

    @Test
    public void testExpandAndShrink() {
        ConcurrentLongHashSet map = ConcurrentLongHashSet.newBuilder().expectedItems(2).concurrencyLevel(1).autoShrink(true).mapIdleFactor(0.25f).build();
        Assert.assertTrue((map.capacity() == 4L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.add(1L));
        Assert.assertTrue((boolean)map.add(2L));
        Assert.assertTrue((boolean)map.add(3L));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.remove(1L));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.remove(2L));
        Assert.assertTrue((map.capacity() == 4L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.add(4L));
        Assert.assertTrue((boolean)map.add(5L));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.add(6L));
        Assert.assertTrue((boolean)map.remove(6L));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
    }

    @Test
    public void testExpandShrinkAndClear() {
        ConcurrentLongHashSet map = ConcurrentLongHashSet.newBuilder().expectedItems(2).concurrencyLevel(1).autoShrink(true).mapIdleFactor(0.25f).build();
        long initCapacity = map.capacity();
        Assert.assertTrue((map.capacity() == 4L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.add(1L));
        Assert.assertTrue((boolean)map.add(2L));
        Assert.assertTrue((boolean)map.add(3L));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.remove(1L));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.remove(2L));
        Assert.assertTrue((map.capacity() == 4L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.remove(3L));
        Assert.assertTrue((map.capacity() == initCapacity ? 1 : 0) != 0);
        map.clear();
        Assert.assertTrue((map.capacity() == initCapacity ? 1 : 0) != 0);
    }

    @Test
    public void testIteration() {
        ConcurrentLongHashSet set = ConcurrentLongHashSet.newBuilder().build();
        Assert.assertEquals((Object)set.items(), Collections.emptySet());
        set.add(0L);
        Assert.assertEquals((Object)set.items(), (Object)Sets.newHashSet((Object[])new Long[]{0L}));
        set.remove(0L);
        Assert.assertEquals((Object)set.items(), Collections.emptySet());
        set.add(0L);
        set.add(1L);
        set.add(2L);
        ArrayList values = Lists.newArrayList((Iterable)set.items());
        Collections.sort(values);
        Assert.assertEquals((Object)values, (Object)Lists.newArrayList((Object[])new Long[]{0L, 1L, 2L}));
        set.clear();
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void testHashConflictWithDeletion() {
        int buckets = 16;
        ConcurrentLongHashSet set = ConcurrentLongHashSet.newBuilder().expectedItems(16).concurrencyLevel(1).build();
        long key1 = 1L;
        long key2 = 27L;
        int bucket1 = ConcurrentOpenHashSet.signSafeMod((long)ConcurrentOpenHashSet.hash((Object)key1), (int)16);
        int bucket2 = ConcurrentOpenHashSet.signSafeMod((long)ConcurrentOpenHashSet.hash((Object)key2), (int)16);
        Assert.assertEquals((long)bucket1, (long)bucket2);
        Assert.assertTrue((boolean)set.add(key1));
        Assert.assertTrue((boolean)set.add(key2));
        Assert.assertEquals((long)set.size(), (long)2L);
        Assert.assertTrue((boolean)set.remove(key1));
        Assert.assertEquals((long)set.size(), (long)1L);
        Assert.assertTrue((boolean)set.add(key1));
        Assert.assertEquals((long)set.size(), (long)2L);
        Assert.assertTrue((boolean)set.remove(key1));
        Assert.assertEquals((long)set.size(), (long)1L);
        Assert.assertFalse((boolean)set.add(key2));
        Assert.assertTrue((boolean)set.contains(key2));
        Assert.assertEquals((long)set.size(), (long)1L);
        Assert.assertTrue((boolean)set.remove(key2));
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void testSizeInBytes() {
        ConcurrentLongHashSet set = new ConcurrentLongHashSet(4, 2);
        Assert.assertEquals((long)64L, (long)set.sizeInBytes());
        set.add(1L);
        Assert.assertEquals((long)64L, (long)set.sizeInBytes());
        set.add(2L);
        Assert.assertEquals((long)64L, (long)set.sizeInBytes());
        set.add(3L);
        Assert.assertEquals((long)64L, (long)set.sizeInBytes());
        set.add(4L);
        Assert.assertEquals((long)96L, (long)set.sizeInBytes());
        set.add(5L);
        Assert.assertEquals((long)96L, (long)set.sizeInBytes());
        set.add(6L);
        Assert.assertEquals((long)128L, (long)set.sizeInBytes());
        set.add(7L);
        Assert.assertEquals((long)128L, (long)set.sizeInBytes());
    }
}

