/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Collection;
import org.apache.bookkeeper.bookie.AbstractLogCompactor;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.EntryLogMetadata;
import org.apache.bookkeeper.bookie.storage.CompactionEntryLog;
import org.apache.bookkeeper.bookie.storage.EntryLogScanner;

public interface EntryLogger
extends AutoCloseable {
    public static final long UNASSIGNED_LEDGERID = -1L;
    public static final String LOG_FILE_SUFFIX = ".log";

    public long addEntry(long var1, ByteBuf var3) throws IOException;

    public ByteBuf readEntry(long var1) throws IOException, Bookie.NoEntryException;

    public ByteBuf readEntry(long var1, long var3, long var5) throws IOException, Bookie.NoEntryException;

    public void flush() throws IOException;

    @Override
    public void close() throws IOException;

    public CompactionEntryLog newCompactionLog(long var1) throws IOException;

    public Collection<CompactionEntryLog> incompleteCompactionLogs();

    public Collection<Long> getFlushedLogIds();

    public void scanEntryLog(long var1, EntryLogScanner var3) throws IOException;

    default public EntryLogMetadata getEntryLogMetadata(long entryLogId) throws IOException {
        return this.getEntryLogMetadata(entryLogId, null);
    }

    public EntryLogMetadata getEntryLogMetadata(long var1, AbstractLogCompactor.Throttler var3) throws IOException;

    public boolean logExists(long var1);

    public boolean removeEntryLog(long var1);
}

