/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.BookieShell;
import org.apache.bookkeeper.bookie.BufferedChannelBase;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.Checkpointer;
import org.apache.bookkeeper.bookie.CompactableLedgerStorage;
import org.apache.bookkeeper.bookie.DefaultEntryLogger;
import org.apache.bookkeeper.bookie.EntryLogCompactor;
import org.apache.bookkeeper.bookie.InterleavedLedgerStorage;
import org.apache.bookkeeper.bookie.LedgerCache;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LedgerEntryPage;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.bookie.storage.EntryLogger;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.TestStatsProvider;
import org.apache.bookkeeper.util.DiskChecker;
import org.apache.bookkeeper.util.EntryFormatter;
import org.apache.bookkeeper.util.LedgerIdFormatter;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.commons.lang.mutable.MutableLong;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class InterleavedLedgerStorageTest {
    private static final Logger LOG = LoggerFactory.getLogger(InterleavedLedgerStorageTest.class);
    CheckpointSource checkpointSource = new CheckpointSource(){

        public CheckpointSource.Checkpoint newCheckpoint() {
            return CheckpointSource.Checkpoint.MAX;
        }

        public void checkpointComplete(CheckpointSource.Checkpoint checkpoint, boolean compact) throws IOException {
        }
    };
    Checkpointer checkpointer = new Checkpointer(){

        public void startCheckpoint(CheckpointSource.Checkpoint checkpoint) {
        }

        public void start() {
        }
    };
    TestStatsProvider statsProvider = new TestStatsProvider();
    ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
    LedgerDirsManager ledgerDirsManager;
    TestableDefaultEntryLogger entryLogger;
    InterleavedLedgerStorage interleavedStorage = new InterleavedLedgerStorage();
    final long numWrites = 2000L;
    final long moreNumOfWrites = 3000L;
    final long entriesPerWrite = 2L;
    final long numOfLedgers = 5L;

    @Parameterized.Parameters
    public static Iterable<Boolean> elplSetting() {
        return Arrays.asList(true, false);
    }

    public InterleavedLedgerStorageTest(boolean elplSetting) {
        this.conf.setEntryLogSizeLimit(2048L);
        this.conf.setEntryLogPerLedgerEnabled(elplSetting);
    }

    @Before
    public void setUp() throws Exception {
        File tmpDir = File.createTempFile("bkTest", ".dir");
        tmpDir.delete();
        tmpDir.mkdir();
        File curDir = BookieImpl.getCurrentDirectory((File)tmpDir);
        BookieImpl.checkDirectoryStructure((File)curDir);
        this.conf.setLedgerDirNames(new String[]{tmpDir.toString()});
        this.ledgerDirsManager = new LedgerDirsManager(this.conf, this.conf.getLedgerDirs(), new DiskChecker(this.conf.getDiskUsageThreshold(), this.conf.getDiskUsageWarnThreshold()));
        this.entryLogger = new TestableDefaultEntryLogger(this.conf, this.ledgerDirsManager, null, (StatsLogger)NullStatsLogger.INSTANCE);
        this.interleavedStorage.initializeWithEntryLogger(this.conf, null, this.ledgerDirsManager, this.ledgerDirsManager, (EntryLogger)this.entryLogger, (StatsLogger)this.statsProvider.getStatsLogger("bookie"));
        this.interleavedStorage.setCheckpointer(this.checkpointer);
        this.interleavedStorage.setCheckpointSource(this.checkpointSource);
        for (long entryId = 0L; entryId < 2000L; ++entryId) {
            for (long ledgerId = 0L; ledgerId < 5L; ++ledgerId) {
                if (entryId == 0L) {
                    this.interleavedStorage.setMasterKey(ledgerId, ("ledger-" + ledgerId).getBytes());
                    this.interleavedStorage.setFenced(ledgerId);
                }
                ByteBuf entry = Unpooled.buffer((int)128);
                entry.writeLong(ledgerId);
                entry.writeLong(entryId * 2L);
                entry.writeBytes(("entry-" + entryId).getBytes());
                this.interleavedStorage.addEntry(entry);
            }
        }
    }

    @Test
    public void testIndexEntryIterator() throws Exception {
        try (LedgerCache.PageEntriesIterable pages = this.interleavedStorage.getIndexEntries(0L);){
            MutableLong curEntry = new MutableLong(0L);
            for (LedgerCache.PageEntries page : pages) {
                LedgerEntryPage lep = page.getLEP();
                Throwable throwable = null;
                try {
                    lep.getEntries((entry, offset) -> {
                        Assert.assertEquals((long)curEntry.longValue(), (long)entry);
                        Assert.assertNotEquals((long)0L, (long)offset);
                        curEntry.setValue(2L + entry);
                        return true;
                    });
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (lep == null) continue;
                    if (throwable != null) {
                        try {
                            lep.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    lep.close();
                }
            }
            Assert.assertEquals((long)4000L, (long)curEntry.longValue());
        }
    }

    @Test
    public void testGetListOfEntriesOfLedger() throws IOException {
        PrimitiveIterator.OfLong entriesOfLedger;
        for (long ledgerId = 0L; ledgerId < 5L; ++ledgerId) {
            entriesOfLedger = this.interleavedStorage.getListOfEntriesOfLedger(ledgerId);
            ArrayList arrayList = new ArrayList();
            Consumer<Long> addMethod = arrayList::add;
            entriesOfLedger.forEachRemaining((Consumer<? super Long>)addMethod);
            Assert.assertEquals((String)"Number of entries", (long)2000L, (long)arrayList.size());
            Assert.assertTrue((String)"Entries of Ledger", (boolean)IntStream.range(0, arrayList.size()).allMatch(i -> (Long)arrayList.get(i) == (long)i * 2L));
        }
        long nonExistingLedger = 456789L;
        entriesOfLedger = this.interleavedStorage.getListOfEntriesOfLedger(nonExistingLedger);
        Assert.assertFalse((String)"There shouldn't be any entry", (boolean)entriesOfLedger.hasNext());
    }

    @Test
    public void testGetListOfEntriesOfLedgerAfterFlush() throws IOException {
        this.interleavedStorage.flush();
        for (long entryId = 2000L; entryId < 3000L; ++entryId) {
            for (long ledgerId = 0L; ledgerId < 5L; ++ledgerId) {
                ByteBuf entry = Unpooled.buffer((int)128);
                entry.writeLong(ledgerId);
                entry.writeLong(entryId * 2L);
                entry.writeBytes(("entry-" + entryId).getBytes());
                this.interleavedStorage.addEntry(entry);
            }
        }
        for (long ledgerId = 0L; ledgerId < 5L; ++ledgerId) {
            PrimitiveIterator.OfLong entriesOfLedger = this.interleavedStorage.getListOfEntriesOfLedger(ledgerId);
            ArrayList arrayList = new ArrayList();
            Consumer<Long> addMethod = arrayList::add;
            entriesOfLedger.forEachRemaining((Consumer<? super Long>)addMethod);
            Assert.assertEquals((String)"Number of entries", (long)3000L, (long)arrayList.size());
            Assert.assertTrue((String)"Entries of Ledger", (boolean)IntStream.range(0, arrayList.size()).allMatch(i -> (Long)arrayList.get(i) == (long)i * 2L));
        }
    }

    @Test
    public void testConsistencyCheckConcurrentGC() throws Exception {
        long signalDone = -1L;
        ArrayList asyncErrors = new ArrayList();
        LinkedBlockingQueue<Long> toCompact = new LinkedBlockingQueue<Long>();
        Semaphore awaitingCompaction = new Semaphore(0);
        this.interleavedStorage.flush();
        long lastLogId = this.entryLogger.getLeastUnflushedLogId();
        MutableInt counter = new MutableInt(0);
        this.entryLogger.setCheckEntryTestPoint((ledgerId, entryId, entryLogId, pos) -> {
            if (entryLogId < lastLogId) {
                if (counter.intValue() % 100 == 0) {
                    try {
                        toCompact.put(entryLogId);
                        awaitingCompaction.acquire();
                    }
                    catch (InterruptedException e) {
                        asyncErrors.add(e);
                    }
                }
                counter.increment();
            }
        });
        Thread mutator = new Thread(() -> {
            EntryLogCompactor compactor = new EntryLogCompactor(this.conf, (EntryLogger)this.entryLogger, (CompactableLedgerStorage)this.interleavedStorage, arg_0 -> ((TestableDefaultEntryLogger)this.entryLogger).removeEntryLog(arg_0));
            while (true) {
                Long next = null;
                try {
                    next = (Long)toCompact.take();
                    if (next == null) return;
                    if (next == -1L) {
                        return;
                    }
                    compactor.compact(this.entryLogger.getEntryLogMetadata(next));
                    continue;
                }
                catch (BufferedChannelBase.BufferedChannelClosedException bufferedChannelClosedException) {
                    continue;
                }
                catch (Exception e) {
                    asyncErrors.add(e);
                    return;
                }
                finally {
                    if (next == null) continue;
                    awaitingCompaction.release();
                    continue;
                }
                break;
            }
        });
        mutator.start();
        List inconsistencies = this.interleavedStorage.localConsistencyCheck(Optional.empty());
        for (Object e : inconsistencies) {
            LOG.error("Found: {}", e);
        }
        Assert.assertEquals((long)0L, (long)inconsistencies.size());
        toCompact.offer(-1L);
        mutator.join();
        Iterator iterator = asyncErrors.iterator();
        if (iterator.hasNext()) {
            Object e;
            e = (Exception)iterator.next();
            throw e;
        }
        if (!this.conf.isEntryLogPerLedgerEnabled()) {
            Assert.assertNotEquals((long)0L, (long)this.statsProvider.getCounter("bookie.STORAGE_SCRUB_PAGE_RETRIES").get());
        }
    }

    @Test
    public void testConsistencyMissingEntry() throws Exception {
        this.interleavedStorage.ledgerCache.putEntryOffset(1L, 1L, -1L);
        List errors = this.interleavedStorage.localConsistencyCheck(Optional.empty());
        Assert.assertEquals((long)1L, (long)errors.size());
        LedgerStorage.DetectedInconsistency inconsistency = (LedgerStorage.DetectedInconsistency)errors.remove(0);
        Assert.assertEquals((long)1L, (long)inconsistency.getEntryId());
        Assert.assertEquals((long)1L, (long)inconsistency.getLedgerId());
    }

    @Test
    public void testWrongEntry() throws Exception {
        this.interleavedStorage.ledgerCache.putEntryOffset(1L, 1L, this.interleavedStorage.ledgerCache.getEntryOffset(0L, 0L));
        List errors = this.interleavedStorage.localConsistencyCheck(Optional.empty());
        Assert.assertEquals((long)1L, (long)errors.size());
        LedgerStorage.DetectedInconsistency inconsistency = (LedgerStorage.DetectedInconsistency)errors.remove(0);
        Assert.assertEquals((long)1L, (long)inconsistency.getEntryId());
        Assert.assertEquals((long)1L, (long)inconsistency.getLedgerId());
    }

    @Test
    public void testShellCommands() throws Exception {
        this.interleavedStorage.flush();
        this.interleavedStorage.shutdown();
        final Pattern entryPattern = Pattern.compile("entry (?<entry>\\d+)\t:\t((?<na>N/A)|\\(log:(?<logid>\\d+), pos: (?<pos>\\d+)\\))");
        class Metadata {
            final Pattern keyPattern = Pattern.compile("master key +: ([0-9a-f])");
            final Pattern sizePattern = Pattern.compile("size +: (\\d+)");
            final Pattern entriesPattern = Pattern.compile("entries +: (\\d+)");
            final Pattern isFencedPattern = Pattern.compile("isFenced +: (\\w+)");
            public String masterKey;
            public long size = -1L;
            public long entries = -1L;
            public boolean foundFenced = false;

            Metadata() {
            }

            void check(String s) {
                Matcher keyMatcher = this.keyPattern.matcher(s);
                if (keyMatcher.matches()) {
                    this.masterKey = keyMatcher.group(1);
                    return;
                }
                Matcher sizeMatcher = this.sizePattern.matcher(s);
                if (sizeMatcher.matches()) {
                    this.size = Long.parseLong(sizeMatcher.group(1));
                    return;
                }
                Matcher entriesMatcher = this.entriesPattern.matcher(s);
                if (entriesMatcher.matches()) {
                    this.entries = Long.parseLong(entriesMatcher.group(1));
                    return;
                }
                Matcher isFencedMatcher = this.isFencedPattern.matcher(s);
                if (isFencedMatcher.matches()) {
                    Assert.assertEquals((Object)"true", (Object)isFencedMatcher.group(1));
                    this.foundFenced = true;
                    return;
                }
            }

            void validate(long foundEntries) {
                Assert.assertTrue((this.entries >= 4000L ? 1 : 0) != 0);
                Assert.assertEquals((long)this.entries, (long)foundEntries);
                Assert.assertTrue((boolean)this.foundFenced);
                Assert.assertNotEquals((long)-1L, (long)this.size);
            }
        }
        final Metadata foundMetadata = new Metadata();
        final AtomicLong curEntry = new AtomicLong(0L);
        final AtomicLong someEntryLogger = new AtomicLong(-1L);
        BookieShell shell = new BookieShell(LedgerIdFormatter.LONG_LEDGERID_FORMATTER, EntryFormatter.STRING_FORMATTER){
            {
                super(x0, x1);
            }

            void printInfoLine(String s) {
                Matcher matcher = entryPattern.matcher(s);
                System.out.println(s);
                if (matcher.matches()) {
                    Assert.assertEquals((Object)Long.toString(curEntry.get()), (Object)matcher.group("entry"));
                    if (matcher.group("na") == null) {
                        String logId = matcher.group("logid");
                        Assert.assertNotEquals((Object)matcher.group("logid"), null);
                        Assert.assertNotEquals((Object)matcher.group("pos"), null);
                        Assert.assertTrue((curEntry.get() % 2L == 0L ? 1 : 0) != 0);
                        Assert.assertTrue((curEntry.get() <= 4000L ? 1 : 0) != 0);
                        if (someEntryLogger.get() == -1L) {
                            someEntryLogger.set(Long.parseLong(logId));
                        }
                    } else {
                        Assert.assertEquals((Object)matcher.group("logid"), null);
                        Assert.assertEquals((Object)matcher.group("pos"), null);
                        Assert.assertTrue((curEntry.get() % 2L != 0L || curEntry.get() >= 4000L ? 1 : 0) != 0);
                    }
                    curEntry.incrementAndGet();
                } else {
                    foundMetadata.check(s);
                }
            }
        };
        shell.setConf((CompositeConfiguration)this.conf);
        int res = shell.run(new String[]{"ledger", "-m", "0"});
        Assert.assertEquals((long)0L, (long)res);
        Assert.assertTrue((curEntry.get() >= 4000L ? 1 : 0) != 0);
        foundMetadata.validate(curEntry.get());
        res = shell.run(new String[]{"localconsistencycheck"});
        Assert.assertEquals((long)0L, (long)res);
        DefaultEntryLogger entryLogger = new DefaultEntryLogger(this.conf);
        entryLogger.removeEntryLog(someEntryLogger.get());
        res = shell.run(new String[]{"localconsistencycheck"});
        Assert.assertEquals((long)1L, (long)res);
    }

    static class TestableDefaultEntryLogger
    extends DefaultEntryLogger {
        volatile CheckEntryListener testPoint;

        public TestableDefaultEntryLogger(ServerConfiguration conf, LedgerDirsManager ledgerDirsManager, DefaultEntryLogger.EntryLogListener listener, StatsLogger statsLogger) throws IOException {
            super(conf, ledgerDirsManager, listener, statsLogger, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        }

        void setCheckEntryTestPoint(CheckEntryListener testPoint) throws InterruptedException {
            this.testPoint = testPoint;
        }

        void checkEntry(long ledgerId, long entryId, long location) throws DefaultEntryLogger.EntryLookupException, IOException {
            CheckEntryListener runBefore = this.testPoint;
            if (runBefore != null) {
                runBefore.accept(ledgerId, entryId, TestableDefaultEntryLogger.logIdForOffset((long)location), TestableDefaultEntryLogger.posForOffset((long)location));
            }
            super.checkEntry(ledgerId, entryId, location);
        }

        public static interface CheckEntryListener {
            public void accept(long var1, long var3, long var5, long var7);
        }
    }
}

