/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.directentrylogger;

import com.google.common.util.concurrent.MoreExecutors;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import org.apache.bookkeeper.bookie.DefaultEntryLogger;
import org.apache.bookkeeper.bookie.EntryLogMetadata;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.storage.EntryLogIds;
import org.apache.bookkeeper.bookie.storage.EntryLogTestUtils;
import org.apache.bookkeeper.bookie.storage.EntryLogger;
import org.apache.bookkeeper.bookie.storage.MockEntryLogIds;
import org.apache.bookkeeper.bookie.storage.directentrylogger.DirectEntryLogger;
import org.apache.bookkeeper.common.util.nativeio.NativeIO;
import org.apache.bookkeeper.common.util.nativeio.NativeIOImpl;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.slogger.Slogger;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.TmpDirs;
import org.apache.bookkeeper.util.DiskChecker;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Test;

public class TestDirectEntryLoggerCompat {
    private final Slogger slog = Slogger.CONSOLE;
    private static final long ledgerId1 = 1234L;
    private static final long ledgerId2 = 4567L;
    private static final long ledgerId3 = 7890L;
    private final TmpDirs tmpDirs = new TmpDirs();

    @After
    public void cleanup() throws Exception {
        this.tmpDirs.cleanup();
    }

    @Test
    public void testLegacyCanReadDirect() throws Exception {
        long loc3;
        long loc2;
        long loc1;
        File ledgerDir = this.tmpDirs.createNew("legacyCanRead", "ledgers");
        File curDir = new File(ledgerDir, "current");
        curDir.mkdirs();
        ByteBuf e1 = EntryLogTestUtils.makeEntry(1234L, 1L, 1000);
        ByteBuf e2 = EntryLogTestUtils.makeEntry(1234L, 2L, 1000);
        ByteBuf e3 = EntryLogTestUtils.makeEntry(1234L, 3L, 1000);
        try (DirectEntryLogger elog = new DirectEntryLogger(curDir, (EntryLogIds)new MockEntryLogIds(), (NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, (ExecutorService)MoreExecutors.newDirectExecutorService(), (ExecutorService)MoreExecutors.newDirectExecutorService(), 0xA00000L, 0xA00000, 0x100000L, 0x100000L, 65536, 1, 300, this.slog, (StatsLogger)NullStatsLogger.INSTANCE);){
            loc1 = elog.addEntry(1234L, e1.slice());
            loc2 = elog.addEntry(1234L, e2.slice());
            loc3 = elog.addEntry(1234L, e3.slice());
        }
        var13_7 = null;
        try (EntryLogger legacy = EntryLogTestUtils.newLegacyEntryLogger(2000000, ledgerDir);){
            EntryLogTestUtils.assertEntryEquals(legacy.readEntry(1234L, 1L, loc1), e1);
            EntryLogTestUtils.assertEntryEquals(legacy.readEntry(1234L, 2L, loc2), e2);
            EntryLogTestUtils.assertEntryEquals(legacy.readEntry(1234L, 3L, loc3), e3);
        }
        catch (Throwable throwable) {
            var13_7 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testDirectCanReadLegacy() throws Exception {
        long loc3;
        long loc2;
        long loc1;
        File ledgerDir = this.tmpDirs.createNew("legacyCanRead", "ledgers");
        ByteBuf e1 = EntryLogTestUtils.makeEntry(1234L, 1L, 1000);
        ByteBuf e2 = EntryLogTestUtils.makeEntry(1234L, 2L, 1000);
        ByteBuf e3 = EntryLogTestUtils.makeEntry(1234L, 3L, 1000);
        try (EntryLogger legacy = EntryLogTestUtils.newLegacyEntryLogger(2000000, ledgerDir);){
            loc1 = legacy.addEntry(1234L, e1.slice());
            loc2 = legacy.addEntry(1234L, e2.slice());
            loc3 = legacy.addEntry(1234L, e3.slice());
            legacy.flush();
        }
        var12_6 = null;
        try (DirectEntryLogger elog = new DirectEntryLogger(new File(ledgerDir, "current"), (EntryLogIds)new MockEntryLogIds(), (NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, (ExecutorService)MoreExecutors.newDirectExecutorService(), (ExecutorService)MoreExecutors.newDirectExecutorService(), 0xA00000L, 0xA00000, 0x100000L, 0x100000L, 65536, 1, 300, this.slog, (StatsLogger)NullStatsLogger.INSTANCE);){
            EntryLogTestUtils.assertEntryEquals(elog.readEntry(1234L, 1L, loc1), e1);
            EntryLogTestUtils.assertEntryEquals(elog.readEntry(1234L, 2L, loc2), e2);
            EntryLogTestUtils.assertEntryEquals(elog.readEntry(1234L, 3L, loc3), e3);
        }
        catch (Throwable throwable) {
            var12_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testLegacyCanReadDirectAfterMultipleRolls() throws Exception {
        long loc3;
        long loc2;
        long loc1;
        File ledgerDir = this.tmpDirs.createNew("legacyCanRead", "ledgers");
        File curDir = new File(ledgerDir, "current");
        curDir.mkdirs();
        ByteBuf e1 = EntryLogTestUtils.makeEntry(1234L, 1L, 4000);
        ByteBuf e2 = EntryLogTestUtils.makeEntry(1234L, 2L, 4000);
        ByteBuf e3 = EntryLogTestUtils.makeEntry(1234L, 3L, 4000);
        try (DirectEntryLogger elog = new DirectEntryLogger(curDir, (EntryLogIds)new MockEntryLogIds(), (NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, (ExecutorService)MoreExecutors.newDirectExecutorService(), (ExecutorService)MoreExecutors.newDirectExecutorService(), 6000L, 0xA00000, 0x100000L, 0x100000L, 65536, 1, 300, this.slog, (StatsLogger)NullStatsLogger.INSTANCE);){
            loc1 = elog.addEntry(1234L, e1.slice());
            loc2 = elog.addEntry(1234L, e2.slice());
            loc3 = elog.addEntry(1234L, e3.slice());
        }
        var13_7 = null;
        try (EntryLogger legacy = EntryLogTestUtils.newLegacyEntryLogger(2000000, ledgerDir);){
            EntryLogTestUtils.assertEntryEquals(legacy.readEntry(1234L, 1L, loc1), e1);
            EntryLogTestUtils.assertEntryEquals(legacy.readEntry(1234L, 2L, loc2), e2);
            EntryLogTestUtils.assertEntryEquals(legacy.readEntry(1234L, 3L, loc3), e3);
        }
        catch (Throwable throwable) {
            var13_7 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testLegacyCanReadMetadataOfDirectWithIndexWritten() throws Exception {
        long loc4;
        long loc3;
        long loc2;
        long loc1;
        File ledgerDir = this.tmpDirs.createNew("legacyCanReadMeta", "ledgers");
        File curDir = new File(ledgerDir, "current");
        curDir.mkdirs();
        ByteBuf e1 = EntryLogTestUtils.makeEntry(1234L, 1L, 1000);
        ByteBuf e2 = EntryLogTestUtils.makeEntry(4567L, 2L, 2000);
        ByteBuf e3 = EntryLogTestUtils.makeEntry(1234L, 3L, 3000);
        ByteBuf e4 = EntryLogTestUtils.makeEntry(1234L, 4L, 4000);
        int maxFileSize = 10108;
        try (DirectEntryLogger elog = new DirectEntryLogger(curDir, (EntryLogIds)new MockEntryLogIds(), (NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, (ExecutorService)MoreExecutors.newDirectExecutorService(), (ExecutorService)MoreExecutors.newDirectExecutorService(), (long)maxFileSize, 0xA00000, 0x100000L, 0x100000L, 65536, 1, 300, this.slog, (StatsLogger)NullStatsLogger.INSTANCE);){
            loc1 = elog.addEntry(1234L, e1);
            loc2 = elog.addEntry(4567L, e2);
            loc3 = elog.addEntry(1234L, e3);
            loc4 = elog.addEntry(1234L, e4);
        }
        var17_9 = null;
        try (EntryLogger legacy = EntryLogTestUtils.newLegacyEntryLogger(maxFileSize, ledgerDir);){
            int logId = EntryLogTestUtils.logIdFromLocation(loc1);
            MatcherAssert.assertThat((Object)logId, (Matcher)Matchers.equalTo((Object)EntryLogTestUtils.logIdFromLocation(loc2)));
            MatcherAssert.assertThat((Object)logId, (Matcher)Matchers.equalTo((Object)EntryLogTestUtils.logIdFromLocation(loc3)));
            MatcherAssert.assertThat((Object)logId, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)EntryLogTestUtils.logIdFromLocation(loc4))));
            EntryLogMetadata meta = legacy.getEntryLogMetadata((long)logId);
            MatcherAssert.assertThat((Object)meta.getEntryLogId(), (Matcher)Matchers.equalTo((Object)logId));
            MatcherAssert.assertThat((Object)meta.getTotalSize(), (Matcher)Matchers.equalTo((Object)6012L));
            MatcherAssert.assertThat((Object)meta.getRemainingSize(), (Matcher)Matchers.equalTo((Object)meta.getTotalSize()));
            MatcherAssert.assertThat((Object)meta.getLedgersMap().get(1234L), (Matcher)Matchers.equalTo((Object)4008L));
            MatcherAssert.assertThat((Object)meta.getLedgersMap().get(4567L), (Matcher)Matchers.equalTo((Object)2004L));
        }
        catch (Throwable throwable) {
            var17_9 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testLegacyCanReadMetadataOfDirectWithNoIndexWritten() throws Exception {
        long loc3;
        long loc2;
        long loc1;
        File ledgerDir = this.tmpDirs.createNew("legacyCanReadMeta", "ledgers");
        File curDir = new File(ledgerDir, "current");
        curDir.mkdirs();
        ByteBuf e1 = EntryLogTestUtils.makeEntry(1234L, 1L, 1000);
        ByteBuf e2 = EntryLogTestUtils.makeEntry(4567L, 2L, 2000);
        ByteBuf e3 = EntryLogTestUtils.makeEntry(1234L, 3L, 3000);
        ByteBuf e4 = EntryLogTestUtils.makeEntry(1234L, 4L, 4000);
        int maxFileSize = 10108;
        try (DirectEntryLogger elog = new DirectEntryLogger(curDir, (EntryLogIds)new MockEntryLogIds(), (NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, (ExecutorService)MoreExecutors.newDirectExecutorService(), (ExecutorService)MoreExecutors.newDirectExecutorService(), (long)(maxFileSize * 10), 0xA00000, 0x100000L, 0x100000L, 65536, 1, 300, this.slog, (StatsLogger)NullStatsLogger.INSTANCE);){
            loc1 = elog.addEntry(1234L, e1);
            loc2 = elog.addEntry(4567L, e2);
            loc3 = elog.addEntry(1234L, e3);
        }
        var15_9 = null;
        try (EntryLogger legacy = EntryLogTestUtils.newLegacyEntryLogger(maxFileSize, ledgerDir);){
            int logId = EntryLogTestUtils.logIdFromLocation(loc1);
            MatcherAssert.assertThat((Object)logId, (Matcher)Matchers.equalTo((Object)EntryLogTestUtils.logIdFromLocation(loc2)));
            MatcherAssert.assertThat((Object)logId, (Matcher)Matchers.equalTo((Object)EntryLogTestUtils.logIdFromLocation(loc3)));
            EntryLogMetadata meta = legacy.getEntryLogMetadata((long)logId);
            MatcherAssert.assertThat((Object)meta.getEntryLogId(), (Matcher)Matchers.equalTo((Object)logId));
            MatcherAssert.assertThat((Object)meta.getTotalSize(), (Matcher)Matchers.equalTo((Object)6012L));
            MatcherAssert.assertThat((Object)meta.getRemainingSize(), (Matcher)Matchers.equalTo((Object)meta.getTotalSize()));
            MatcherAssert.assertThat((Object)meta.getLedgersMap().get(1234L), (Matcher)Matchers.equalTo((Object)4008L));
            MatcherAssert.assertThat((Object)meta.getLedgersMap().get(4567L), (Matcher)Matchers.equalTo((Object)2004L));
        }
        catch (Throwable throwable) {
            var15_9 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testDirectCanReadMetadataAndScanFromLegacy() throws Exception {
        long loc4;
        long loc3;
        long loc2;
        long loc1;
        File ledgerDir = this.tmpDirs.createNew("directCanReadLegacyMeta", "ledgers");
        File curDir = new File(ledgerDir, "current");
        curDir.mkdirs();
        ByteBuf e1 = EntryLogTestUtils.makeEntry(1234L, 1L, 1000);
        ByteBuf e2 = EntryLogTestUtils.makeEntry(4567L, 2L, 2000);
        ByteBuf e3 = EntryLogTestUtils.makeEntry(1234L, 3L, 3000);
        ByteBuf e4 = EntryLogTestUtils.makeEntry(1234L, 4L, 4000);
        int maxFileSize = 10108;
        try (EntryLogger legacy = EntryLogTestUtils.newLegacyEntryLogger(maxFileSize, ledgerDir);){
            loc1 = legacy.addEntry(1234L, e1);
            loc2 = legacy.addEntry(4567L, e2);
            loc3 = legacy.addEntry(1234L, e3);
            loc4 = legacy.addEntry(1234L, e4);
        }
        var17_9 = null;
        try (DirectEntryLogger elog = new DirectEntryLogger(curDir, (EntryLogIds)new MockEntryLogIds(), (NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, (ExecutorService)MoreExecutors.newDirectExecutorService(), (ExecutorService)MoreExecutors.newDirectExecutorService(), (long)(maxFileSize * 10), 0xA00000, 0x100000L, 0x100000L, 65536, 1, 300, this.slog, (StatsLogger)NullStatsLogger.INSTANCE);){
            int logId = EntryLogTestUtils.logIdFromLocation(loc1);
            MatcherAssert.assertThat((Object)logId, (Matcher)Matchers.equalTo((Object)EntryLogTestUtils.logIdFromLocation(loc2)));
            MatcherAssert.assertThat((Object)logId, (Matcher)Matchers.equalTo((Object)EntryLogTestUtils.logIdFromLocation(loc3)));
            MatcherAssert.assertThat((Object)logId, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)EntryLogTestUtils.logIdFromLocation(loc4))));
            EntryLogMetadata metaRead = elog.readEntryLogIndex((long)logId);
            MatcherAssert.assertThat((Object)metaRead.getEntryLogId(), (Matcher)Matchers.equalTo((Object)logId));
            MatcherAssert.assertThat((Object)metaRead.getTotalSize(), (Matcher)Matchers.equalTo((Object)6012L));
            MatcherAssert.assertThat((Object)metaRead.getRemainingSize(), (Matcher)Matchers.equalTo((Object)metaRead.getTotalSize()));
            MatcherAssert.assertThat((Object)metaRead.getLedgersMap().get(1234L), (Matcher)Matchers.equalTo((Object)4008L));
            MatcherAssert.assertThat((Object)metaRead.getLedgersMap().get(4567L), (Matcher)Matchers.equalTo((Object)2004L));
            EntryLogMetadata metaScan = elog.scanEntryLogMetadata((long)logId, null);
            MatcherAssert.assertThat((Object)metaScan.getEntryLogId(), (Matcher)Matchers.equalTo((Object)logId));
            MatcherAssert.assertThat((Object)metaScan.getTotalSize(), (Matcher)Matchers.equalTo((Object)6012L));
            MatcherAssert.assertThat((Object)metaScan.getRemainingSize(), (Matcher)Matchers.equalTo((Object)metaScan.getTotalSize()));
            MatcherAssert.assertThat((Object)metaScan.getLedgersMap().get(1234L), (Matcher)Matchers.equalTo((Object)4008L));
            MatcherAssert.assertThat((Object)metaScan.getLedgersMap().get(4567L), (Matcher)Matchers.equalTo((Object)2004L));
        }
        catch (Throwable throwable) {
            var17_9 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testCompatFromDirectToDefaultToDirectLogger() throws Exception {
        long loc3;
        long loc2;
        long loc1;
        File ledgerDir = this.tmpDirs.createNew("entryCompatTest", "ledgers");
        File curDir = new File(ledgerDir, "current");
        curDir.mkdirs();
        MockEntryLogIds entryLogIds = new MockEntryLogIds();
        ByteBuf e1 = this.buildEntry(1234L, 1L, 1024, "entry-1".getBytes(StandardCharsets.UTF_8));
        ByteBuf e2 = this.buildEntry(1234L, 2L, 1024, "entry-2".getBytes(StandardCharsets.UTF_8));
        ByteBuf e3 = this.buildEntry(1234L, 3L, 1024, "entry-3".getBytes(StandardCharsets.UTF_8));
        ByteBuf e4 = this.buildEntry(1234L, 4L, 1024, "entry-4".getBytes(StandardCharsets.UTF_8));
        ByteBuf e5 = this.buildEntry(1234L, 5L, 1024, "entry-5".getBytes(StandardCharsets.UTF_8));
        ByteBuf e6 = this.buildEntry(1234L, 6L, 1024, "entry-6".getBytes(StandardCharsets.UTF_8));
        ByteBuf e7 = this.buildEntry(1234L, 7L, 1024, "entry-7".getBytes(StandardCharsets.UTF_8));
        try (DirectEntryLogger elog = new DirectEntryLogger(curDir, (EntryLogIds)entryLogIds, (NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, (ExecutorService)MoreExecutors.newDirectExecutorService(), (ExecutorService)MoreExecutors.newDirectExecutorService(), 9000L, 0xA00000, 0x100000L, 0x100000L, 65536, 1, 300, this.slog, (StatsLogger)NullStatsLogger.INSTANCE);){
            loc1 = elog.addEntry(1234L, e1.slice());
            loc2 = elog.addEntry(1234L, e2.slice());
            loc3 = elog.addEntry(1234L, e3.slice());
            elog.flush();
            ByteBuf entry1 = elog.readEntry(1234L, 1L, loc1);
            ByteBuf entry2 = elog.readEntry(1234L, 2L, loc2);
            ByteBuf entry3 = elog.readEntry(1234L, 3L, loc3);
            EntryLogTestUtils.assertEntryEquals(entry1, e1);
            EntryLogTestUtils.assertEntryEquals(entry2, e2);
            EntryLogTestUtils.assertEntryEquals(entry3, e3);
            entry1.release();
            entry2.release();
            entry3.release();
        }
        ServerConfiguration conf = new ServerConfiguration();
        LedgerDirsManager dirsMgr = new LedgerDirsManager(conf, new File[]{ledgerDir}, new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold()));
        DefaultEntryLogger entryLogger = new DefaultEntryLogger(conf, dirsMgr);
        long loc4 = entryLogger.addEntry(1234L, e4.slice());
        long loc5 = entryLogger.addEntry(1234L, e5.slice());
        entryLogger.flush();
        ByteBuf entry1 = entryLogger.readEntry(1234L, 1L, loc1);
        ByteBuf entry2 = entryLogger.readEntry(1234L, 2L, loc2);
        ByteBuf entry3 = entryLogger.readEntry(1234L, 3L, loc3);
        ByteBuf entry4 = entryLogger.readEntry(1234L, 4L, loc4);
        ByteBuf entry5 = entryLogger.readEntry(1234L, 5L, loc5);
        EntryLogTestUtils.assertEntryEquals(entry1, e1);
        EntryLogTestUtils.assertEntryEquals(entry2, e2);
        EntryLogTestUtils.assertEntryEquals(entry3, e3);
        EntryLogTestUtils.assertEntryEquals(entry4, e4);
        EntryLogTestUtils.assertEntryEquals(entry5, e5);
        entry1.release();
        entry2.release();
        entry3.release();
        entry4.release();
        entry5.release();
        entryLogIds.nextId();
        try (DirectEntryLogger elog = new DirectEntryLogger(curDir, (EntryLogIds)entryLogIds, (NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, (ExecutorService)MoreExecutors.newDirectExecutorService(), (ExecutorService)MoreExecutors.newDirectExecutorService(), 9000L, 0xA00000, 0x100000L, 0x100000L, 65536, 1, 300, this.slog, (StatsLogger)NullStatsLogger.INSTANCE);){
            long loc6 = elog.addEntry(1234L, e6.slice());
            long loc7 = elog.addEntry(1234L, e7.slice());
            elog.flush();
            entry1 = elog.readEntry(1234L, 1L, loc1);
            entry2 = elog.readEntry(1234L, 2L, loc2);
            entry3 = elog.readEntry(1234L, 3L, loc3);
            entry4 = elog.readEntry(1234L, 4L, loc4);
            entry5 = elog.readEntry(1234L, 5L, loc5);
            ByteBuf entry6 = elog.readEntry(1234L, 6L, loc6);
            ByteBuf entry7 = elog.readEntry(1234L, 7L, loc7);
            EntryLogTestUtils.assertEntryEquals(entry1, e1);
            EntryLogTestUtils.assertEntryEquals(entry2, e2);
            EntryLogTestUtils.assertEntryEquals(entry3, e3);
            EntryLogTestUtils.assertEntryEquals(entry4, e4);
            EntryLogTestUtils.assertEntryEquals(entry5, e5);
            EntryLogTestUtils.assertEntryEquals(entry6, e6);
            EntryLogTestUtils.assertEntryEquals(entry7, e7);
            entry1.release();
            entry2.release();
            entry3.release();
            entry4.release();
            entry5.release();
            entry6.release();
            entry7.release();
        }
        ledgerDir.deleteOnExit();
    }

    @Test
    public void testCompatFromDefaultToDirectToDefaultToDirectLogger() throws Exception {
        long loc5;
        long loc4;
        long loc3;
        File ledgerDir = this.tmpDirs.createNew("entryCompatTest", "ledgers");
        File curDir = new File(ledgerDir, "current");
        curDir.mkdirs();
        MockEntryLogIds entryLogIds = new MockEntryLogIds();
        ByteBuf e1 = this.buildEntry(1234L, 1L, 1024, "entry-1".getBytes(StandardCharsets.UTF_8));
        ByteBuf e2 = this.buildEntry(1234L, 2L, 1024, "entry-2".getBytes(StandardCharsets.UTF_8));
        ByteBuf e3 = this.buildEntry(1234L, 3L, 1024, "entry-3".getBytes(StandardCharsets.UTF_8));
        ByteBuf e4 = this.buildEntry(1234L, 4L, 1024, "entry-4".getBytes(StandardCharsets.UTF_8));
        ByteBuf e5 = this.buildEntry(1234L, 5L, 1024, "entry-5".getBytes(StandardCharsets.UTF_8));
        ByteBuf e6 = this.buildEntry(1234L, 6L, 1024, "entry-6".getBytes(StandardCharsets.UTF_8));
        ByteBuf e7 = this.buildEntry(1234L, 7L, 1024, "entry-7".getBytes(StandardCharsets.UTF_8));
        ByteBuf e8 = this.buildEntry(1234L, 8L, 1024, "entry-8".getBytes(StandardCharsets.UTF_8));
        ByteBuf e9 = this.buildEntry(1234L, 9L, 1024, "entry-9".getBytes(StandardCharsets.UTF_8));
        ServerConfiguration conf = new ServerConfiguration();
        LedgerDirsManager dirsMgr = new LedgerDirsManager(conf, new File[]{ledgerDir}, new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold()));
        DefaultEntryLogger entryLogger = new DefaultEntryLogger(conf, dirsMgr);
        long loc1 = entryLogger.addEntry(1234L, e1.slice());
        long loc2 = entryLogger.addEntry(1234L, e2.slice());
        entryLogger.flush();
        ByteBuf entry1 = entryLogger.readEntry(1234L, 1L, loc1);
        ByteBuf entry2 = entryLogger.readEntry(1234L, 2L, loc2);
        EntryLogTestUtils.assertEntryEquals(entry1, e1);
        EntryLogTestUtils.assertEntryEquals(entry2, e2);
        entry1.release();
        entry2.release();
        entryLogIds.nextId();
        try (DirectEntryLogger elog = new DirectEntryLogger(curDir, (EntryLogIds)entryLogIds, (NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, (ExecutorService)MoreExecutors.newDirectExecutorService(), (ExecutorService)MoreExecutors.newDirectExecutorService(), 9000L, 0xA00000, 0x100000L, 0x100000L, 65536, 1, 300, this.slog, (StatsLogger)NullStatsLogger.INSTANCE);){
            loc3 = elog.addEntry(1234L, e3.slice());
            loc4 = elog.addEntry(1234L, e4.slice());
            loc5 = elog.addEntry(1234L, e5.slice());
            elog.flush();
            entry1 = elog.readEntry(1234L, 1L, loc1);
            entry2 = elog.readEntry(1234L, 2L, loc2);
            ByteBuf entry3 = elog.readEntry(1234L, 3L, loc3);
            ByteBuf entry4 = elog.readEntry(1234L, 4L, loc4);
            ByteBuf entry5 = elog.readEntry(1234L, 5L, loc5);
            EntryLogTestUtils.assertEntryEquals(entry1, e1);
            EntryLogTestUtils.assertEntryEquals(entry2, e2);
            EntryLogTestUtils.assertEntryEquals(entry3, e3);
            EntryLogTestUtils.assertEntryEquals(entry4, e4);
            EntryLogTestUtils.assertEntryEquals(entry5, e5);
            entry1.release();
            entry2.release();
            entry3.release();
            entry4.release();
            entry5.release();
        }
        entryLogger = new DefaultEntryLogger(conf, dirsMgr);
        long loc6 = entryLogger.addEntry(1234L, e6.slice());
        long loc7 = entryLogger.addEntry(1234L, e7.slice());
        entryLogger.flush();
        entry1 = entryLogger.readEntry(1234L, 1L, loc1);
        entry2 = entryLogger.readEntry(1234L, 2L, loc2);
        ByteBuf entry3 = entryLogger.readEntry(1234L, 3L, loc3);
        ByteBuf entry4 = entryLogger.readEntry(1234L, 4L, loc4);
        ByteBuf entry5 = entryLogger.readEntry(1234L, 5L, loc5);
        ByteBuf entry6 = entryLogger.readEntry(1234L, 6L, loc6);
        ByteBuf entry7 = entryLogger.readEntry(1234L, 7L, loc7);
        EntryLogTestUtils.assertEntryEquals(entry1, e1);
        EntryLogTestUtils.assertEntryEquals(entry2, e2);
        EntryLogTestUtils.assertEntryEquals(entry3, e3);
        EntryLogTestUtils.assertEntryEquals(entry4, e4);
        EntryLogTestUtils.assertEntryEquals(entry5, e5);
        EntryLogTestUtils.assertEntryEquals(entry6, e6);
        EntryLogTestUtils.assertEntryEquals(entry7, e7);
        entry1.release();
        entry2.release();
        entry3.release();
        entry4.release();
        entry5.release();
        entry6.release();
        entry7.release();
        entryLogIds.nextId();
        try (DirectEntryLogger elog = new DirectEntryLogger(curDir, (EntryLogIds)entryLogIds, (NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, (ExecutorService)MoreExecutors.newDirectExecutorService(), (ExecutorService)MoreExecutors.newDirectExecutorService(), 9000L, 0xA00000, 0x100000L, 0x100000L, 65536, 1, 300, this.slog, (StatsLogger)NullStatsLogger.INSTANCE);){
            long loc8 = elog.addEntry(1234L, e8.slice());
            long loc9 = elog.addEntry(1234L, e9.slice());
            elog.flush();
            entry1 = elog.readEntry(1234L, 1L, loc1);
            entry2 = elog.readEntry(1234L, 2L, loc2);
            entry3 = elog.readEntry(1234L, 3L, loc3);
            entry4 = elog.readEntry(1234L, 4L, loc4);
            entry5 = elog.readEntry(1234L, 5L, loc5);
            entry6 = elog.readEntry(1234L, 6L, loc6);
            entry7 = elog.readEntry(1234L, 7L, loc7);
            ByteBuf entry8 = elog.readEntry(1234L, 8L, loc8);
            ByteBuf entry9 = elog.readEntry(1234L, 9L, loc9);
            EntryLogTestUtils.assertEntryEquals(entry1, e1);
            EntryLogTestUtils.assertEntryEquals(entry2, e2);
            EntryLogTestUtils.assertEntryEquals(entry3, e3);
            EntryLogTestUtils.assertEntryEquals(entry4, e4);
            EntryLogTestUtils.assertEntryEquals(entry5, e5);
            EntryLogTestUtils.assertEntryEquals(entry6, e6);
            EntryLogTestUtils.assertEntryEquals(entry7, e7);
            EntryLogTestUtils.assertEntryEquals(entry8, e8);
            EntryLogTestUtils.assertEntryEquals(entry9, e9);
            entry1.release();
            entry2.release();
            entry3.release();
            entry4.release();
            entry5.release();
            entry6.release();
            entry7.release();
            entry8.release();
            entry9.release();
        }
        ledgerDir.deleteOnExit();
    }

    private ByteBuf buildEntry(long ledgerId, long entryId, int size, byte[] bytes) {
        ByteBuf entry = Unpooled.buffer((int)size);
        entry.writeLong(ledgerId);
        entry.writeLong(entryId);
        entry.writeBytes(bytes);
        return entry;
    }
}

