/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.junit.Assert;
import org.junit.Test;

public class LedgerMetadataTest {
    private static final byte[] passwd = "testPasswd".getBytes(StandardCharsets.UTF_8);

    @Test
    public void testGetters() {
        ArrayList ensemble = Lists.newArrayList((Object[])new BookieId[]{new BookieSocketAddress("192.0.2.1", 1234).toBookieId(), new BookieSocketAddress("192.0.2.2", 1234).toBookieId(), new BookieSocketAddress("192.0.2.3", 1234).toBookieId()});
        LedgerMetadata metadata = LedgerMetadataBuilder.create().withEnsembleSize(3).withWriteQuorumSize(2).withAckQuorumSize(1).withDigestType(BookKeeper.DigestType.CRC32.toApiDigestType()).withPassword(passwd).newEnsembleEntry(0L, (List)ensemble).withId(100L).build();
        Assert.assertEquals((long)100L, (long)metadata.getLedgerId());
        Assert.assertEquals((long)3L, (long)metadata.getEnsembleSize());
        Assert.assertEquals((long)2L, (long)metadata.getWriteQuorumSize());
        Assert.assertEquals((long)1L, (long)metadata.getAckQuorumSize());
        Assert.assertEquals((Object)DigestType.CRC32, (Object)metadata.getDigestType());
        Assert.assertEquals(Collections.emptyMap(), (Object)metadata.getCustomMetadata());
        Assert.assertEquals((long)-1L, (long)metadata.getCtime());
        Assert.assertEquals((long)-1L, (long)metadata.getLastEntryId());
        Assert.assertEquals((long)0L, (long)metadata.getLength());
        Assert.assertFalse((boolean)metadata.isClosed());
        Assert.assertEquals((long)1L, (long)metadata.getAllEnsembles().size());
        Assert.assertEquals((Object)ensemble, metadata.getAllEnsembles().get(0L));
        Assert.assertEquals((Object)ensemble, (Object)metadata.getEnsembleAt(99L));
    }

    @Test
    public void testToString() {
        ArrayList ensemble = Lists.newArrayList((Object[])new BookieId[]{new BookieSocketAddress("192.0.2.1", 1234).toBookieId(), new BookieSocketAddress("192.0.2.2", 1234).toBookieId(), new BookieSocketAddress("192.0.2.3", 1234).toBookieId()});
        LedgerMetadata lm1 = LedgerMetadataBuilder.create().withDigestType(BookKeeper.DigestType.CRC32.toApiDigestType()).withPassword(passwd).newEnsembleEntry(0L, (List)ensemble).withId(100L).build();
        Assert.assertTrue((String)"toString should contain password value", (boolean)lm1.toString().contains(Base64.getEncoder().encodeToString(passwd)));
        Assert.assertTrue((String)"toSafeString should not contain password value", (boolean)lm1.toSafeString().contains("OMITTED"));
    }
}

