/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.util.ReferenceCounted;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperClientStats;
import org.apache.bookkeeper.client.BookieWatcher;
import org.apache.bookkeeper.client.ClientContext;
import org.apache.bookkeeper.client.ClientInternalConf;
import org.apache.bookkeeper.client.DefaultEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.client.LedgerCreateOp;
import org.apache.bookkeeper.client.LedgerDeleteOp;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.LedgerOpenOp;
import org.apache.bookkeeper.client.api.CreateBuilder;
import org.apache.bookkeeper.client.api.DeleteBuilder;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.client.api.OpenBuilder;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.meta.LedgerIdGenerator;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieAddressResolver;
import org.apache.bookkeeper.proto.BookieClient;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.DataFormats;
import org.apache.bookkeeper.proto.MockBookieClient;
import org.apache.bookkeeper.proto.checksum.DigestManager;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.ByteBufList;
import org.apache.bookkeeper.versioning.LongVersion;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.junit.After;
import org.junit.Before;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.Stubber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MockBookKeeperTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(MockBookKeeperTestCase.class);
    protected OrderedScheduler scheduler;
    protected OrderedExecutor executor;
    protected BookKeeper bk;
    protected BookieClient bookieClient;
    protected LedgerManager ledgerManager;
    protected LedgerIdGenerator ledgerIdGenerator;
    protected EnsemblePlacementPolicy placementPolicy;
    private BookieWatcher bookieWatcher;
    protected ConcurrentMap<Long, LedgerMetadata> mockLedgerMetadataRegistry;
    protected AtomicLong mockNextLedgerId;
    protected ConcurrentSkipListSet<Long> fencedLedgers;
    protected ConcurrentMap<Long, Map<BookieId, Map<Long, MockEntry>>> mockLedgerData;
    private Map<BookieId, List<Runnable>> deferredBookieForceLedgerResponses;
    private Set<BookieId> suspendedBookiesForForceLedgerAcks;
    List<BookieId> failedBookies;
    Set<BookieId> availableBookies;
    private int lastIndexForBK;
    protected int maxNumberOfAvailableBookies = Integer.MAX_VALUE;

    private Map<BookieId, Map<Long, MockEntry>> getMockLedgerContents(long ledgerId) {
        return this.mockLedgerData.computeIfAbsent(ledgerId, id -> new ConcurrentHashMap());
    }

    private Map<Long, MockEntry> getMockLedgerContentsInBookie(long ledgerId, BookieId bookieSocketAddress) {
        return this.getMockLedgerContents(ledgerId).computeIfAbsent(bookieSocketAddress, addr -> new ConcurrentHashMap());
    }

    private MockEntry getMockLedgerEntry(long ledgerId, BookieId bookieSocketAddress, long entryId) throws BKException {
        if (this.failedBookies.contains(bookieSocketAddress)) {
            throw BKException.create((int)-3);
        }
        return this.getMockLedgerContentsInBookie(ledgerId, bookieSocketAddress).get(entryId);
    }

    @Before
    public void setup() throws Exception {
        this.maxNumberOfAvailableBookies = Integer.MAX_VALUE;
        this.deferredBookieForceLedgerResponses = new ConcurrentHashMap<BookieId, List<Runnable>>();
        this.suspendedBookiesForForceLedgerAcks = Collections.synchronizedSet(new HashSet());
        this.mockLedgerMetadataRegistry = new ConcurrentHashMap<Long, LedgerMetadata>();
        this.mockLedgerData = new ConcurrentHashMap<Long, Map<BookieId, Map<Long, MockEntry>>>();
        this.mockNextLedgerId = new AtomicLong(1L);
        this.fencedLedgers = new ConcurrentSkipListSet();
        this.scheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().numThreads(4).name("bk-test").build();
        this.executor = OrderedExecutor.newBuilder().build();
        this.bookieWatcher = (BookieWatcher)Mockito.mock(BookieWatcher.class);
        this.placementPolicy = new DefaultEnsemblePlacementPolicy();
        this.bookieClient = (BookieClient)Mockito.mock(BookieClient.class);
        this.ledgerManager = (LedgerManager)Mockito.mock(LedgerManager.class);
        this.ledgerIdGenerator = (LedgerIdGenerator)Mockito.mock(LedgerIdGenerator.class);
        BookieAddressResolver bookieAddressResolver = BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER;
        Mockito.when((Object)this.bookieWatcher.getBookieAddressResolver()).thenReturn((Object)bookieAddressResolver);
        this.bk = (BookKeeper)Mockito.mock(BookKeeper.class);
        ((BookKeeper)Mockito.doReturn((Object)new ClientConfiguration()).when((Object)this.bk)).getConf();
        this.failedBookies = new ArrayList<BookieId>();
        this.availableBookies = new HashSet<BookieId>();
        Mockito.when((Object)this.bk.getCloseLock()).thenReturn((Object)new ReentrantReadWriteLock());
        Mockito.when((Object)this.bk.isClosed()).thenReturn((Object)false);
        Mockito.when((Object)this.bk.getBookieWatcher()).thenReturn((Object)this.bookieWatcher);
        Mockito.when((Object)this.bk.getBookieAddressResolver()).thenReturn((Object)bookieAddressResolver);
        Mockito.when((Object)this.bk.getMainWorkerPool()).thenReturn((Object)this.executor);
        Mockito.when((Object)this.bk.getBookieClient()).thenReturn((Object)this.bookieClient);
        Mockito.when((Object)this.bk.getScheduler()).thenReturn((Object)this.scheduler);
        this.setBookKeeperConfig(new ClientConfiguration());
        Mockito.when((Object)this.bk.getStatsLogger()).thenReturn((Object)NullStatsLogger.INSTANCE);
        final BookKeeperClientStats clientStats = BookKeeperClientStats.newInstance((StatsLogger)NullStatsLogger.INSTANCE);
        ClientContext clientCtx = new ClientContext(){

            public ClientInternalConf getConf() {
                return ClientInternalConf.fromConfig((ClientConfiguration)MockBookKeeperTestCase.this.bk.getConf());
            }

            public LedgerManager getLedgerManager() {
                return MockBookKeeperTestCase.this.ledgerManager;
            }

            public BookieWatcher getBookieWatcher() {
                return MockBookKeeperTestCase.this.bookieWatcher;
            }

            public EnsemblePlacementPolicy getPlacementPolicy() {
                return MockBookKeeperTestCase.this.placementPolicy;
            }

            public BookieClient getBookieClient() {
                return MockBookKeeperTestCase.this.bookieClient;
            }

            public OrderedExecutor getMainWorkerPool() {
                return MockBookKeeperTestCase.this.scheduler;
            }

            public OrderedScheduler getScheduler() {
                return MockBookKeeperTestCase.this.scheduler;
            }

            public BookKeeperClientStats getClientStats() {
                return clientStats;
            }

            public boolean isClientClosed() {
                return MockBookKeeperTestCase.this.bk.isClosed();
            }

            public ByteBufAllocator getByteBufAllocator() {
                return UnpooledByteBufAllocator.DEFAULT;
            }
        };
        Mockito.when((Object)this.bk.getClientCtx()).thenReturn((Object)clientCtx);
        Mockito.when((Object)this.bk.getLedgerManager()).thenReturn((Object)this.ledgerManager);
        Mockito.when((Object)this.bk.getLedgerIdGenerator()).thenReturn((Object)this.ledgerIdGenerator);
        Mockito.when((Object)this.bk.getReturnRc(ArgumentMatchers.anyInt())).thenAnswer(invocationOnMock -> invocationOnMock.getArgument(0));
        Mockito.when((Object)this.bookieClient.isWritable((BookieId)ArgumentMatchers.any(), ArgumentMatchers.anyLong())).thenReturn((Object)true);
        this.setupLedgerIdGenerator();
        this.setupCreateLedgerMetadata();
        this.setupReadLedgerMetadata();
        this.setupWriteLedgerMetadata();
        this.setupRemoveLedgerMetadata();
        this.setupRegisterLedgerMetadataListener();
        this.setupBookieWatcherForNewEnsemble();
        this.setupBookieWatcherForEnsembleChange();
        this.setupBookieClientReadEntry();
        this.setupBookieClientReadLac();
        this.setupBookieClientAddEntry();
        this.setupBookieClientForceLedger();
    }

    protected void setBookKeeperConfig(ClientConfiguration conf) {
        Mockito.when((Object)this.bk.getConf()).thenReturn((Object)conf);
    }

    private DigestManager getDigestType(long ledgerId) throws GeneralSecurityException {
        LedgerMetadata metadata = (LedgerMetadata)this.mockLedgerMetadataRegistry.get(ledgerId);
        return DigestManager.instantiate((long)ledgerId, (byte[])metadata.getPassword(), (DataFormats.LedgerMetadataFormat.DigestType)BookKeeper.DigestType.toProtoDigestType((BookKeeper.DigestType)BookKeeper.DigestType.fromApiDigestType((DigestType)metadata.getDigestType())), (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (boolean)false);
    }

    @After
    public void tearDown() {
        this.scheduler.shutdown();
        this.executor.shutdown();
    }

    protected CreateBuilder newCreateLedgerOp() {
        return new LedgerCreateOp.CreateBuilderImpl(this.bk);
    }

    protected OpenBuilder newOpenLedgerOp() {
        return new LedgerOpenOp.OpenBuilderImpl(this.bk);
    }

    protected DeleteBuilder newDeleteLedgerOp() {
        return new LedgerDeleteOp.DeleteBuilderImpl(this.bk);
    }

    protected void closeBookkeeper() {
        Mockito.when((Object)this.bk.isClosed()).thenReturn((Object)true);
    }

    protected void killBookie(BookieId killedBookieSocketAddress) {
        this.failedBookies.add(killedBookieSocketAddress);
        this.availableBookies.remove(killedBookieSocketAddress);
    }

    protected void startKilledBookie(BookieId killedBookieSocketAddress) {
        Preconditions.checkState((boolean)this.failedBookies.contains(killedBookieSocketAddress));
        Preconditions.checkState((!this.availableBookies.contains(killedBookieSocketAddress) ? 1 : 0) != 0);
        this.failedBookies.remove(killedBookieSocketAddress);
        this.availableBookies.add(killedBookieSocketAddress);
    }

    protected void suspendBookieForceLedgerAcks(BookieId address) {
        this.suspendedBookiesForForceLedgerAcks.add(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resumeBookieWriteAcks(BookieId address) {
        List<Runnable> pendingResponses;
        BookieId bookieId = address;
        synchronized (bookieId) {
            this.suspendedBookiesForForceLedgerAcks.remove(address);
            pendingResponses = this.deferredBookieForceLedgerResponses.remove(address);
        }
        if (pendingResponses != null) {
            pendingResponses.forEach(Runnable::run);
        }
    }

    protected BookieId startNewBookie() {
        BookieId address = this.generateBookieSocketAddress(this.lastIndexForBK++);
        this.availableBookies.add(address);
        return address;
    }

    protected BookieId generateBookieSocketAddress(int index) {
        return new BookieSocketAddress("localhost", 1111 + index).toBookieId();
    }

    protected ArrayList<BookieId> generateNewEnsemble(int ensembleSize) throws BKException.BKNotEnoughBookiesException {
        LOG.info("generateNewEnsemble {}", (Object)ensembleSize);
        if (ensembleSize > this.maxNumberOfAvailableBookies) {
            throw new BKException.BKNotEnoughBookiesException();
        }
        ArrayList<BookieId> ensemble = new ArrayList<BookieId>(ensembleSize);
        for (int i = 0; i < ensembleSize; ++i) {
            ensemble.add(this.generateBookieSocketAddress(i));
        }
        this.availableBookies.addAll(ensemble);
        this.lastIndexForBK = ensembleSize;
        return ensemble;
    }

    private void setupBookieWatcherForNewEnsemble() throws BKException.BKNotEnoughBookiesException {
        Mockito.when((Object)this.bookieWatcher.newEnsemble(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), (Map)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<ArrayList<BookieId>>(){

            public ArrayList<BookieId> answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                int ensembleSize = (Integer)args[0];
                return MockBookKeeperTestCase.this.generateNewEnsemble(ensembleSize);
            }
        });
    }

    private void setupBookieWatcherForEnsembleChange() throws BKException.BKNotEnoughBookiesException {
        Mockito.when((Object)this.bookieWatcher.replaceBookie(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyMap(), ArgumentMatchers.anyList(), ArgumentMatchers.anyInt(), ArgumentMatchers.anySet())).thenAnswer((Answer)new Answer<BookieId>(){

            public BookieId answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                List existingBookies = (List)args[4];
                Set excludeBookies = (Set)args[6];
                excludeBookies.addAll(existingBookies);
                HashSet<BookieId> remainBookies = new HashSet<BookieId>(MockBookKeeperTestCase.this.availableBookies);
                remainBookies.removeAll(excludeBookies);
                if (remainBookies.iterator().hasNext()) {
                    return (BookieId)remainBookies.iterator().next();
                }
                throw BKException.create((int)-6);
            }
        });
    }

    protected void registerMockEntryForRead(long ledgerId, long entryId, BookieId bookieSocketAddress, byte[] entryData, long lastAddConfirmed) {
        this.getMockLedgerContentsInBookie(ledgerId, bookieSocketAddress).put(entryId, new MockEntry(entryData, lastAddConfirmed));
    }

    protected void registerMockLedgerMetadata(long ledgerId, LedgerMetadata ledgerMetadata) {
        this.mockLedgerMetadataRegistry.put(ledgerId, ledgerMetadata);
    }

    protected void setNewGeneratedLedgerId(long ledgerId) {
        this.mockNextLedgerId.set(ledgerId);
        this.setupLedgerIdGenerator();
    }

    protected LedgerMetadata getLedgerMetadata(long ledgerId) {
        return (LedgerMetadata)this.mockLedgerMetadataRegistry.get(ledgerId);
    }

    private void setupReadLedgerMetadata() {
        ((LedgerManager)Mockito.doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            Long ledgerId = (Long)args[0];
            CompletableFuture promise = new CompletableFuture();
            this.executor.executeOrdered((Object)ledgerId, () -> {
                LedgerMetadata ledgerMetadata = (LedgerMetadata)this.mockLedgerMetadataRegistry.get(ledgerId);
                if (ledgerMetadata == null) {
                    promise.completeExceptionally((Throwable)new BKException.BKNoSuchLedgerExistsOnMetadataServerException());
                } else {
                    promise.complete(new Versioned((Object)ledgerMetadata, (Version)new LongVersion(1L)));
                }
            });
            return promise;
        }).when((Object)this.ledgerManager)).readLedgerMetadata(ArgumentMatchers.anyLong());
    }

    private void setupRemoveLedgerMetadata() {
        ((LedgerManager)Mockito.doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            Long ledgerId = (Long)args[0];
            CompletableFuture promise = new CompletableFuture();
            this.executor.executeOrdered((Object)ledgerId, () -> {
                if (this.mockLedgerMetadataRegistry.remove(ledgerId) != null) {
                    promise.complete(null);
                } else {
                    promise.completeExceptionally((Throwable)new BKException.BKNoSuchLedgerExistsOnMetadataServerException());
                }
            });
            return promise;
        }).when((Object)this.ledgerManager)).removeLedgerMetadata(ArgumentMatchers.anyLong(), (Version)ArgumentMatchers.any());
    }

    private void setupRegisterLedgerMetadataListener() {
        ((LedgerManager)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                return null;
            }
        }).when((Object)this.ledgerManager)).registerLedgerMetadataListener(ArgumentMatchers.anyLong(), (BookkeeperInternalCallbacks.LedgerMetadataListener)ArgumentMatchers.any());
    }

    private void setupLedgerIdGenerator() {
        ((LedgerIdGenerator)Mockito.doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            BookkeeperInternalCallbacks.GenericCallback cb = (BookkeeperInternalCallbacks.GenericCallback)args[0];
            cb.operationComplete(0, (Object)this.mockNextLedgerId.getAndIncrement());
            return null;
        }).when((Object)this.ledgerIdGenerator)).generateLedgerId((BookkeeperInternalCallbacks.GenericCallback)ArgumentMatchers.any());
    }

    private void setupCreateLedgerMetadata() {
        ((LedgerManager)Mockito.doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            Long ledgerId = (Long)args[0];
            CompletableFuture promise = new CompletableFuture();
            this.executor.executeOrdered((Object)ledgerId, () -> {
                LedgerMetadata ledgerMetadata = (LedgerMetadata)args[1];
                this.mockLedgerMetadataRegistry.put(ledgerId, ledgerMetadata);
                promise.complete(new Versioned((Object)ledgerMetadata, (Version)new LongVersion(1L)));
            });
            return promise;
        }).when((Object)this.ledgerManager)).createLedgerMetadata(ArgumentMatchers.anyLong(), (LedgerMetadata)ArgumentMatchers.any());
    }

    private void setupWriteLedgerMetadata() {
        ((LedgerManager)Mockito.doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            Long ledgerId = (Long)args[0];
            LedgerMetadata metadata = (LedgerMetadata)args[1];
            Version currentVersion = (Version)args[2];
            CompletableFuture promise = new CompletableFuture();
            this.executor.executeOrdered((Object)ledgerId, () -> {
                LedgerMetadata newMetadata = LedgerMetadataBuilder.from((LedgerMetadata)metadata).build();
                this.mockLedgerMetadataRegistry.put(ledgerId, newMetadata);
                promise.complete(new Versioned((Object)newMetadata, (Version)new LongVersion(1234L)));
            });
            return promise;
        }).when((Object)this.ledgerManager)).writeLedgerMetadata(ArgumentMatchers.anyLong(), (LedgerMetadata)ArgumentMatchers.any(), (Version)ArgumentMatchers.any());
    }

    protected void setupBookieClientReadEntry() {
        Stubber stub = Mockito.doAnswer(invokation -> {
            Object[] args = invokation.getArguments();
            BookieId bookieSocketAddress = (BookieId)args[0];
            long ledgerId = (Long)args[1];
            long entryId = (Long)args[2];
            BookkeeperInternalCallbacks.ReadEntryCallback callback = (BookkeeperInternalCallbacks.ReadEntryCallback)args[3];
            boolean fenced = ((Integer)args[5] & 1) == 1;
            this.executor.executeOrdered(ledgerId, () -> {
                DigestManager macManager = null;
                try {
                    macManager = this.getDigestType(ledgerId);
                }
                catch (GeneralSecurityException gse) {
                    LOG.error("Initialize macManager fail", (Throwable)gse);
                }
                MockEntry mockEntry = null;
                try {
                    mockEntry = this.getMockLedgerEntry(ledgerId, bookieSocketAddress, entryId);
                }
                catch (BKException bke) {
                    LOG.info("readEntryAndFenceLedger - occur BKException {}@{} at {}", new Object[]{entryId, ledgerId, bookieSocketAddress});
                    callback.readEntryComplete(bke.getCode(), ledgerId, entryId, null, args[5]);
                }
                if (fenced) {
                    this.fencedLedgers.add(ledgerId);
                }
                if (mockEntry != null) {
                    LOG.info("readEntry - found mock entry {}@{} at {}", new Object[]{entryId, ledgerId, bookieSocketAddress});
                    ReferenceCounted entry = macManager.computeDigestAndPackageForSending(entryId, mockEntry.lastAddConfirmed, (long)mockEntry.payload.length, Unpooled.wrappedBuffer((byte[])mockEntry.payload), new byte[20], 0);
                    callback.readEntryComplete(0, ledgerId, entryId, MockBookieClient.copyData(entry), args[4]);
                    entry.release();
                } else {
                    LOG.info("readEntry - no such mock entry {}@{} at {}", new Object[]{entryId, ledgerId, bookieSocketAddress});
                    callback.readEntryComplete(-13, ledgerId, entryId, null, args[4]);
                }
            });
            return null;
        });
        ((BookieClient)stub.when((Object)this.bookieClient)).readEntry((BookieId)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (BookkeeperInternalCallbacks.ReadEntryCallback)ArgumentMatchers.any(BookkeeperInternalCallbacks.ReadEntryCallback.class), ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        ((BookieClient)stub.when((Object)this.bookieClient)).readEntry((BookieId)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (BookkeeperInternalCallbacks.ReadEntryCallback)ArgumentMatchers.any(BookkeeperInternalCallbacks.ReadEntryCallback.class), ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (byte[])ArgumentMatchers.any());
        ((BookieClient)stub.when((Object)this.bookieClient)).readEntry((BookieId)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (BookkeeperInternalCallbacks.ReadEntryCallback)ArgumentMatchers.any(BookkeeperInternalCallbacks.ReadEntryCallback.class), ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
    }

    protected void setupBookieClientReadLac() {
        Stubber stub = Mockito.doAnswer(invokation -> {
            Object[] args = invokation.getArguments();
            BookieId bookieSocketAddress = (BookieId)args[0];
            long ledgerId = (Long)args[1];
            final BookkeeperInternalCallbacks.ReadLacCallback callback = (BookkeeperInternalCallbacks.ReadLacCallback)args[2];
            Object ctx = args[3];
            long entryId = -1L;
            this.bookieClient.readEntry(bookieSocketAddress, ledgerId, entryId, new BookkeeperInternalCallbacks.ReadEntryCallback(){

                public void readEntryComplete(int rc, long ledgerId, long entryId, ByteBuf buffer, Object ctx) {
                    callback.readLacComplete(rc, ledgerId, null, buffer, ctx);
                }
            }, ctx, 0);
            return null;
        });
        ((BookieClient)stub.when((Object)this.bookieClient)).readLac((BookieId)ArgumentMatchers.any(BookieId.class), ArgumentMatchers.anyLong(), (BookkeeperInternalCallbacks.ReadLacCallback)ArgumentMatchers.any(BookkeeperInternalCallbacks.ReadLacCallback.class), ArgumentMatchers.any());
    }

    private byte[] extractEntryPayload(long ledgerId, long entryId, ByteBufList toSend) throws BKException.BKDigestMatchException {
        ByteBuf toSendCopy = Unpooled.copiedBuffer((byte[])toSend.toArray());
        toSendCopy.resetReaderIndex();
        DigestManager macManager = null;
        try {
            macManager = this.getDigestType(ledgerId);
        }
        catch (GeneralSecurityException gse) {
            LOG.error("Initialize macManager fail", (Throwable)gse);
        }
        ByteBuf content = macManager.verifyDigestAndReturnData(entryId, toSendCopy);
        byte[] entry = new byte[content.readableBytes()];
        content.readBytes(entry);
        content.resetReaderIndex();
        content.release();
        return entry;
    }

    protected void setupBookieClientAddEntry() {
        Stubber stub = Mockito.doAnswer(invokation -> {
            Object[] args = invokation.getArguments();
            BookkeeperInternalCallbacks.WriteCallback callback = (BookkeeperInternalCallbacks.WriteCallback)args[5];
            BookieId bookieSocketAddress = (BookieId)args[0];
            long ledgerId = (Long)args[1];
            long entryId = (Long)args[3];
            ByteBufList toSend = (ByteBufList)args[4];
            Object ctx = args[6];
            int options = (Integer)args[7];
            boolean isRecoveryAdd = ((short)options & 2) == 2;
            toSend.retain();
            this.executor.executeOrdered(ledgerId, () -> {
                byte[] entry;
                try {
                    entry = this.extractEntryPayload(ledgerId, entryId, toSend);
                }
                catch (BKException.BKDigestMatchException e) {
                    callback.writeComplete(-5, ledgerId, entryId, bookieSocketAddress, ctx);
                    toSend.release();
                    return;
                }
                boolean fenced = this.fencedLedgers.contains(ledgerId);
                if (fenced && !isRecoveryAdd) {
                    callback.writeComplete(-101, ledgerId, entryId, bookieSocketAddress, ctx);
                } else {
                    if (this.failedBookies.contains(bookieSocketAddress)) {
                        callback.writeComplete(-3, ledgerId, entryId, bookieSocketAddress, ctx);
                        toSend.release();
                        return;
                    }
                    if (this.getMockLedgerContentsInBookie(ledgerId, bookieSocketAddress).isEmpty()) {
                        this.registerMockEntryForRead(ledgerId, -1L, bookieSocketAddress, new byte[0], -1L);
                    }
                    this.registerMockEntryForRead(ledgerId, entryId, bookieSocketAddress, entry, ledgerId);
                    callback.writeComplete(0, ledgerId, entryId, bookieSocketAddress, ctx);
                }
                toSend.release();
            });
            return null;
        });
        ((BookieClient)stub.when((Object)this.bookieClient)).addEntry((BookieId)ArgumentMatchers.any(BookieId.class), ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyLong(), (ReferenceCounted)ArgumentMatchers.any(ByteBufList.class), (BookkeeperInternalCallbacks.WriteCallback)ArgumentMatchers.any(BookkeeperInternalCallbacks.WriteCallback.class), ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean(), (EnumSet)ArgumentMatchers.any(EnumSet.class));
    }

    protected void setupBookieClientForceLedger() {
        Stubber stub = Mockito.doAnswer(invokation -> {
            Object[] args = invokation.getArguments();
            BookieId bookieSocketAddress = (BookieId)args[0];
            long ledgerId = (Long)args[1];
            BookkeeperInternalCallbacks.ForceLedgerCallback callback = (BookkeeperInternalCallbacks.ForceLedgerCallback)args[2];
            Object ctx = args[3];
            Runnable activity = () -> this.executor.executeOrdered(ledgerId, () -> {
                if (this.failedBookies.contains(bookieSocketAddress)) {
                    callback.forceLedgerComplete(-3, ledgerId, bookieSocketAddress, ctx);
                    return;
                }
                callback.forceLedgerComplete(0, ledgerId, bookieSocketAddress, ctx);
            });
            List queue = null;
            BookieId bookieId = bookieSocketAddress;
            synchronized (bookieId) {
                if (this.suspendedBookiesForForceLedgerAcks.contains(bookieSocketAddress)) {
                    queue = this.deferredBookieForceLedgerResponses.computeIfAbsent(bookieSocketAddress, k -> new CopyOnWriteArrayList());
                    queue.add(activity);
                }
            }
            if (queue == null) {
                activity.run();
            }
            return null;
        });
        ((BookieClient)stub.when((Object)this.bookieClient)).forceLedger((BookieId)ArgumentMatchers.any(BookieId.class), ArgumentMatchers.anyLong(), (BookkeeperInternalCallbacks.ForceLedgerCallback)ArgumentMatchers.any(BookkeeperInternalCallbacks.ForceLedgerCallback.class), ArgumentMatchers.any());
    }

    private static final class MockEntry {
        byte[] payload;
        long lastAddConfirmed;

        public MockEntry(byte[] payload, long lastAddConfirmed) {
            this.payload = payload;
            this.lastAddConfirmed = lastAddConfirmed;
        }
    }
}

