/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.MockBookKeeper;
import org.apache.bookkeeper.client.api.LastConfirmedAndEntry;
import org.apache.bookkeeper.client.api.LedgerEntries;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.client.impl.LedgerEntriesImpl;
import org.apache.bookkeeper.client.impl.LedgerEntryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MockReadHandle
implements ReadHandle {
    private static final Logger log = LoggerFactory.getLogger(MockReadHandle.class);
    private final MockBookKeeper bk;
    private final long ledgerId;
    private final LedgerMetadata metadata;
    private final List<LedgerEntryImpl> entries;

    MockReadHandle(MockBookKeeper bk, long ledgerId, LedgerMetadata metadata, List<LedgerEntryImpl> entries) {
        this.bk = bk;
        this.ledgerId = ledgerId;
        this.metadata = metadata;
        this.entries = entries;
    }

    public CompletableFuture<LedgerEntries> readAsync(long firstEntry, long lastEntry) {
        CompletableFuture<LedgerEntries> promise = new CompletableFuture<LedgerEntries>();
        if (this.bk.isStopped()) {
            promise.completeExceptionally(new BKException.BKClientClosedException());
            return promise;
        }
        this.bk.orderedExecutor.chooseThread().execute(() -> {
            if (this.bk.getProgrammedFailStatus()) {
                promise.completeExceptionally(BKException.create((int)this.bk.failReturnCode));
                return;
            }
            if (this.bk.isStopped()) {
                promise.completeExceptionally(new BKException.BKClientClosedException());
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("readEntries: first={} last={} total={}", new Object[]{firstEntry, lastEntry, this.entries.size()});
            }
            ArrayList<LedgerEntryImpl> seq = new ArrayList<LedgerEntryImpl>();
            long entryId = firstEntry;
            while (entryId <= lastEntry && entryId < (long)this.entries.size()) {
                seq.add(this.entries.get((int)entryId++).duplicate());
            }
            if (log.isDebugEnabled()) {
                log.debug("Entries read: {}", seq);
            }
            promise.complete((LedgerEntries)LedgerEntriesImpl.create(seq));
        });
        return promise;
    }

    public CompletableFuture<LedgerEntries> readUnconfirmedAsync(long firstEntry, long lastEntry) {
        return this.readAsync(firstEntry, lastEntry);
    }

    public CompletableFuture<Long> readLastAddConfirmedAsync() {
        return CompletableFuture.completedFuture(this.getLastAddConfirmed());
    }

    public CompletableFuture<Long> tryReadLastAddConfirmedAsync() {
        return this.readLastAddConfirmedAsync();
    }

    public long getLastAddConfirmed() {
        return this.entries.get(this.entries.size() - 1).getEntryId();
    }

    public long getLength() {
        long length = 0L;
        for (LedgerEntryImpl entry : this.entries) {
            length += entry.getLength();
        }
        return length;
    }

    public boolean isClosed() {
        return this.metadata.isClosed();
    }

    public CompletableFuture<LastConfirmedAndEntry> readLastAddConfirmedAndEntryAsync(long entryId, long timeOutInMillis, boolean parallel) {
        CompletableFuture<LastConfirmedAndEntry> promise = new CompletableFuture<LastConfirmedAndEntry>();
        promise.completeExceptionally(new UnsupportedOperationException("Long poll not implemented"));
        return promise;
    }

    public long getId() {
        return this.ledgerId;
    }

    public CompletableFuture<Void> closeAsync() {
        return CompletableFuture.completedFuture(null);
    }

    public LedgerMetadata getLedgerMetadata() {
        return this.metadata;
    }
}

