/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.client.BookKeeperClientStats;
import org.apache.bookkeeper.client.ClientContext;
import org.apache.bookkeeper.client.ClientInternalConf;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.PendingAddOp;
import org.apache.bookkeeper.client.RoundRobinDistributionSchedule;
import org.apache.bookkeeper.client.api.WriteFlag;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.proto.BookieClient;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class PendingAddOpTest {
    private LedgerHandle lh;
    private ClientContext mockClientContext;
    private ByteBuf payload;

    @Before
    public void setup() {
        BookKeeperClientStats clientStats = BookKeeperClientStats.newInstance((StatsLogger)NullStatsLogger.INSTANCE);
        BookieClient bookieClient = (BookieClient)Mockito.mock(BookieClient.class);
        OrderedExecutor mainWorkerPool = (OrderedExecutor)Mockito.mock(OrderedExecutor.class);
        this.mockClientContext = (ClientContext)Mockito.mock(ClientContext.class);
        Mockito.when((Object)this.mockClientContext.getBookieClient()).thenReturn((Object)bookieClient);
        Mockito.when((Object)this.mockClientContext.getConf()).thenReturn((Object)ClientInternalConf.defaultValues());
        Mockito.when((Object)this.mockClientContext.getMainWorkerPool()).thenReturn((Object)mainWorkerPool);
        Mockito.when((Object)this.mockClientContext.getClientStats()).thenReturn((Object)clientStats);
        this.lh = (LedgerHandle)Mockito.mock(LedgerHandle.class);
        Mockito.when((Object)this.lh.getDistributionSchedule()).thenReturn((Object)new RoundRobinDistributionSchedule(3, 3, 2));
        byte[] data = "test-pending-add-op".getBytes(StandardCharsets.UTF_8);
        this.payload = Unpooled.wrappedBuffer((byte[])data);
        this.payload.writerIndex(data.length);
    }

    @Test
    public void testExecuteAfterCancelled() {
        AtomicInteger rcHolder = new AtomicInteger(-57005);
        PendingAddOp op = PendingAddOp.create((LedgerHandle)this.lh, (ClientContext)this.mockClientContext, (List)this.lh.getCurrentEnsemble(), (ByteBuf)this.payload, (EnumSet)WriteFlag.NONE, (rc, handle, entryId, qwcLatency, ctx) -> rcHolder.set(rc), null);
        Assert.assertSame((Object)this.lh, (Object)op.lh);
        op.submitCallback(-6);
        Assert.assertSame((Object)this.lh, (Object)op.lh);
        Assert.assertEquals((long)-6L, (long)rcHolder.get());
        op.initiate();
        Assert.assertNull((Object)op.lh);
    }
}

