/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.util.HashedWheelTimer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicy;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.feature.SettableFeatureProvider;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.net.ScriptBasedMapping;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRackawareEnsemblePlacementPolicyUsingScript {
    static final Logger LOG = LoggerFactory.getLogger(TestRackawareEnsemblePlacementPolicyUsingScript.class);
    HashedWheelTimer timer;
    RackawareEnsemblePlacementPolicy repp;
    ClientConfiguration conf = new ClientConfiguration();

    @Before
    public void setUp() throws Exception {
        this.conf.setProperty("reppDnsResolverClass", (Object)ScriptBasedMapping.class.getName());
        this.conf.setProperty("networkTopologyScriptFileName", (Object)"src/test/resources/networkmappingscript.sh");
        this.timer = new HashedWheelTimer(new ThreadFactoryBuilder().setNameFormat("TestTimer-%d").build(), this.conf.getTimeoutTimerTickDurationMs(), TimeUnit.MILLISECONDS, this.conf.getTimeoutTimerNumTicks());
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
    }

    @After
    public void tearDown() throws Exception {
        this.repp.uninitalize();
    }

    private void ignoreTestIfItIsWindowsOS() {
        Assume.assumeTrue((!Shell.WINDOWS ? 1 : 0) != 0);
    }

    @Test
    public void testReplaceBookieWithEnoughBookiesInSameRack() throws Exception {
        this.ignoreTestIfItIsWindowsOS();
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.1.2", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        BookieId replacedBookie = (BookieId)this.repp.replaceBookie(1, 1, 1, null, new ArrayList(), addr2.toBookieId(), new HashSet()).getResult();
        Assert.assertEquals((Object)addr3.toBookieId(), (Object)replacedBookie);
    }

    @Test
    public void testReplaceBookieWithEnoughBookiesInDifferentRack() throws Exception {
        this.ignoreTestIfItIsWindowsOS();
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        HashSet<BookieId> excludedAddrs = new HashSet<BookieId>();
        excludedAddrs.add(addr1.toBookieId());
        BookieId replacedBookie = (BookieId)this.repp.replaceBookie(1, 1, 1, null, new ArrayList(), addr2.toBookieId(), excludedAddrs).getResult();
        Assert.assertFalse((boolean)addr1.toBookieId().equals((Object)replacedBookie));
        Assert.assertTrue((addr3.toBookieId().equals((Object)replacedBookie) || addr4.toBookieId().equals((Object)replacedBookie) ? 1 : 0) != 0);
    }

    @Test
    public void testReplaceBookieWithNotEnoughBookies() throws Exception {
        this.ignoreTestIfItIsWindowsOS();
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        HashSet<BookieId> excludedAddrs = new HashSet<BookieId>();
        excludedAddrs.add(addr1.toBookieId());
        excludedAddrs.add(addr3.toBookieId());
        excludedAddrs.add(addr4.toBookieId());
        try {
            this.repp.replaceBookie(1, 1, 1, null, new ArrayList(), addr2.toBookieId(), excludedAddrs);
            Assert.fail((String)"Should throw BKNotEnoughBookiesException when there is not enough bookies");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
    }

    @Test
    public void testReplaceBookieWithScriptMappingError() throws Exception {
        this.ignoreTestIfItIsWindowsOS();
        BookieSocketAddress addr0 = new BookieSocketAddress("127.0.0.0", 3181);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs = new HashSet();
        addrs.add(addr0.toBookieId());
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        HashSet<BookieId> excludedAddrs = new HashSet<BookieId>();
        excludedAddrs.add(addr1.toBookieId());
        BookieId replacedBookie = (BookieId)this.repp.replaceBookie(1, 1, 1, null, new ArrayList(), addr2.toBookieId(), excludedAddrs).getResult();
        Assert.assertFalse((boolean)addr1.toBookieId().equals((Object)replacedBookie));
        Assert.assertFalse((boolean)addr2.toBookieId().equals((Object)replacedBookie));
        Assert.assertTrue((boolean)addr0.toBookieId().equals((Object)replacedBookie));
    }

    @Test
    public void testReplaceBookieWithScriptMappingError2() throws Exception {
        this.ignoreTestIfItIsWindowsOS();
        BookieSocketAddress addr0 = new BookieSocketAddress("127.0.0.0", 3181);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr0.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs = new HashSet();
        addrs.add(addr0.toBookieId());
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        HashSet<BookieId> excludedAddrs = new HashSet<BookieId>();
        excludedAddrs.add(addr1.toBookieId());
        BookieId replacedBookie = (BookieId)this.repp.replaceBookie(1, 1, 1, null, new ArrayList(), addr2.toBookieId(), excludedAddrs).getResult();
        Assert.assertFalse((boolean)addr1.toBookieId().equals((Object)replacedBookie));
        Assert.assertFalse((boolean)addr2.toBookieId().equals((Object)replacedBookie));
        Assert.assertTrue((boolean)addr0.toBookieId().equals((Object)replacedBookie));
    }

    @Test
    public void testNewEnsembleWithSingleRack() throws Exception {
        this.ignoreTestIfItIsWindowsOS();
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.1.1", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.2.1", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.3.1", 3181);
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            List ensemble = (List)this.repp.newEnsemble(3, 2, 2, null, new HashSet()).getResult();
            Assert.assertEquals((long)0L, (long)this.getNumCoveredWriteQuorums(ensemble, 2));
            List ensemble2 = (List)this.repp.newEnsemble(4, 2, 2, null, new HashSet()).getResult();
            Assert.assertEquals((long)0L, (long)this.getNumCoveredWriteQuorums(ensemble2, 2));
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            Assert.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
    }

    @Test
    public void testNewEnsembleWithMultipleRacks() throws Exception {
        this.ignoreTestIfItIsWindowsOS();
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.1.2", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.2.2", 3181);
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            List ensemble = (List)this.repp.newEnsemble(3, 2, 2, null, new HashSet()).getResult();
            int numCovered = this.getNumCoveredWriteQuorums(ensemble, 2);
            Assert.assertTrue((numCovered == 2 ? 1 : 0) != 0);
            List ensemble2 = (List)this.repp.newEnsemble(4, 2, 2, null, new HashSet()).getResult();
            numCovered = this.getNumCoveredWriteQuorums(ensemble2, 2);
            Assert.assertTrue((numCovered == 2 ? 1 : 0) != 0);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            Assert.fail((String)"Should not get not enough bookies exception");
        }
    }

    @Test
    public void testNewEnsembleWithEnoughRacks() throws Exception {
        this.ignoreTestIfItIsWindowsOS();
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.1.1", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.1.2", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.1.3", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.1.4", 3181);
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        addrs.add(addr5.toBookieId());
        addrs.add(addr6.toBookieId());
        addrs.add(addr7.toBookieId());
        addrs.add(addr8.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            List ensemble1 = (List)this.repp.newEnsemble(3, 2, 2, null, new HashSet()).getResult();
            Assert.assertEquals((long)3L, (long)this.getNumCoveredWriteQuorums(ensemble1, 2));
            List ensemble2 = (List)this.repp.newEnsemble(4, 2, 2, null, new HashSet()).getResult();
            Assert.assertEquals((long)4L, (long)this.getNumCoveredWriteQuorums(ensemble2, 2));
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            Assert.fail((String)"Should not get not enough bookies exception.");
        }
    }

    @Test
    public void testRemoveBookieFromCluster() {
        this.ignoreTestIfItIsWindowsOS();
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.1.2", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs.remove(addr1.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
    }

    @Test
    public void testNetworkTopologyScriptFileNameIsEmpty() throws Exception {
        this.ignoreTestIfItIsWindowsOS();
        this.repp.uninitalize();
        ClientConfiguration newConf = new ClientConfiguration();
        newConf.setProperty("reppDnsResolverClass", (Object)ScriptBasedMapping.class.getName());
        newConf.setProperty("networkTopologyScriptFileName", (Object)"");
        newConf.setEnforceMinNumRacksPerWriteQuorum(false);
        this.timer = new HashedWheelTimer(new ThreadFactoryBuilder().setNameFormat("TestTimer-%d").build(), newConf.getTimeoutTimerTickDurationMs(), TimeUnit.MILLISECONDS, newConf.getTimeoutTimerNumTicks());
        this.repp = new RackawareEnsemblePlacementPolicy();
        try {
            this.repp.initialize(newConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        }
        catch (RuntimeException re) {
            Assert.fail((String)"EnforceMinNumRacksPerWriteQuorum is not set, so repp.initialize should succeed even if networkTopologyScriptFileName is empty");
        }
        this.repp.uninitalize();
        newConf.setEnforceMinNumRacksPerWriteQuorum(true);
        this.repp = new RackawareEnsemblePlacementPolicy();
        try {
            this.repp.initialize(newConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
            Assert.fail((String)"EnforceMinNumRacksPerWriteQuorum is set, so repp.initialize should fail if networkTopologyScriptFileName is empty");
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        this.repp.uninitalize();
        newConf.setProperty("networkTopologyScriptFileName", (Object)"src/test/resources/networkmappingscript.sh");
        try {
            this.repp.initialize(newConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        }
        catch (RuntimeException re) {
            Assert.fail((String)"EnforceMinNumRacksPerWriteQuorum is set and networkTopologyScriptFileName is not empty, so it should succeed");
        }
        this.repp.uninitalize();
    }

    @Test
    public void testIfValidateConfFails() throws Exception {
        this.ignoreTestIfItIsWindowsOS();
        this.repp.uninitalize();
        ClientConfiguration newConf = new ClientConfiguration();
        newConf.setProperty("reppDnsResolverClass", (Object)ScriptBasedMapping.class.getName());
        newConf.setProperty("networkTopologyScriptFileName", (Object)"src/test/resources/networkmappingscriptwithargs.sh");
        this.timer = new HashedWheelTimer(new ThreadFactoryBuilder().setNameFormat("TestTimer-%d").build(), newConf.getTimeoutTimerTickDurationMs(), TimeUnit.MILLISECONDS, newConf.getTimeoutTimerNumTicks());
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(newConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.uninitalize();
        this.repp = new RackawareEnsemblePlacementPolicy();
        try {
            this.repp.initialize(newConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        }
        catch (RuntimeException re) {
            Assert.fail((String)"EnforceMinNumRacksPerWriteQuorum is not set, so repp.initialize should succeed even if mapping.validateConf fails");
        }
        newConf.setEnforceMinNumRacksPerWriteQuorum(true);
        this.repp.uninitalize();
        this.repp = new RackawareEnsemblePlacementPolicy();
        try {
            this.repp.initialize(newConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
            Assert.fail((String)"EnforceMinNumRacksPerWriteQuorum is set, so repp.initialize should fail if mapping.validateConf fails");
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        newConf.setProperty("networkTopologyScriptFileName", (Object)"src/test/resources/networkmappingscript.sh");
        this.repp.uninitalize();
        this.repp = new RackawareEnsemblePlacementPolicy();
        try {
            this.repp.initialize(newConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        }
        catch (RuntimeException re) {
            Assert.fail((String)"EnforceMinNumRacksPerWriteQuorum is set, and mapping.validateConf succeeds. So repp.initialize should succeed");
        }
    }

    private int getNumCoveredWriteQuorums(List<BookieId> ensemble, int writeQuorumSize) throws Exception {
        int ensembleSize = ensemble.size();
        int numCoveredWriteQuorums = 0;
        for (int i = 0; i < ensembleSize; ++i) {
            HashSet<String> racks = new HashSet<String>();
            for (int j = 0; j < writeQuorumSize; ++j) {
                int bookieIdx = (i + j) % ensembleSize;
                BookieId addr = ensemble.get(bookieIdx);
                String hostAddress = this.repp.bookieAddressResolver.resolve(addr).getSocketAddress().getAddress().getHostAddress();
                String rack = "/" + hostAddress.charAt(hostAddress.length() - 1);
                racks.add(rack);
            }
            numCoveredWriteQuorums += racks.size() > 1 ? 1 : 0;
        }
        return numCoveredWriteQuorums;
    }
}

