/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.util.HashedWheelTimer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookieInfoReader;
import org.apache.bookkeeper.client.BookiesHealthInfo;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.client.RoundRobinDistributionSchedule;
import org.apache.bookkeeper.client.ZoneawareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.ZoneawareEnsemblePlacementPolicyImpl;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.feature.SettableFeatureProvider;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.StaticDNSResolver;
import org.apache.commons.configuration.Configuration;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestZoneawareEnsemblePlacementPolicy
extends TestCase {
    static final Logger LOG = LoggerFactory.getLogger(TestZoneawareEnsemblePlacementPolicy.class);
    ZoneawareEnsemblePlacementPolicy zepp;
    final List<BookieId> ensemble = new ArrayList<BookieId>();
    DistributionSchedule.WriteSet writeSet = DistributionSchedule.NULL_WRITE_SET;
    ClientConfiguration conf = new ClientConfiguration();
    BookieSocketAddress addr1;
    BookieSocketAddress addr2;
    BookieSocketAddress addr3;
    BookieSocketAddress addr4;
    HashedWheelTimer timer;

    protected void setUp() throws Exception {
        super.setUp();
        StaticDNSResolver.reset();
        StaticDNSResolver.addNodeToRack(InetAddress.getLocalHost().getHostAddress(), "/default-zone/default-upgradedomain");
        StaticDNSResolver.addNodeToRack("127.0.0.1", "/default-zone/default-upgradedomain");
        StaticDNSResolver.addNodeToRack("localhost", "/default-zone/default-upgradedomain");
        LOG.info("Set up static DNS Resolver.");
        this.conf.setProperty("reppDnsResolverClass", (Object)StaticDNSResolver.class.getName());
        this.addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        this.addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        this.addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        this.addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(this.addr1.getHostName(), "/default-zone/ud1");
        StaticDNSResolver.addNodeToRack(this.addr2.getHostName(), "/default-zone/default-upgradedomain");
        StaticDNSResolver.addNodeToRack(this.addr3.getHostName(), "/default-zone/default-upgradedomain");
        StaticDNSResolver.addNodeToRack(this.addr4.getHostName(), "/default-zone/ud2");
        this.ensemble.add(this.addr1.toBookieId());
        this.ensemble.add(this.addr2.toBookieId());
        this.ensemble.add(this.addr3.toBookieId());
        this.ensemble.add(this.addr4.toBookieId());
        this.writeSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{0, 1, 2, 3});
        this.timer = new HashedWheelTimer(new ThreadFactoryBuilder().setNameFormat("TestTimer-%d").build(), this.conf.getTimeoutTimerTickDurationMs(), TimeUnit.MILLISECONDS, this.conf.getTimeoutTimerNumTicks());
        this.zepp = new ZoneawareEnsemblePlacementPolicy();
        this.zepp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.zepp.withDefaultFaultDomain("/default-zone/default-upgradedomain");
    }

    protected void tearDown() throws Exception {
        this.zepp.uninitalize();
        super.tearDown();
    }

    static BookiesHealthInfo getBookiesHealthInfo() {
        return TestZoneawareEnsemblePlacementPolicy.getBookiesHealthInfo(new HashMap<BookieId, Long>(), new HashMap<BookieId, Long>());
    }

    static BookiesHealthInfo getBookiesHealthInfo(final Map<BookieId, Long> bookieFailureHistory, final Map<BookieId, Long> bookiePendingRequests) {
        return new BookiesHealthInfo(){

            public long getBookieFailureHistory(BookieId bookieSocketAddress) {
                return bookieFailureHistory.getOrDefault(bookieSocketAddress, -1L);
            }

            public long getBookiePendingRequests(BookieId bookieSocketAddress) {
                return bookiePendingRequests.getOrDefault(bookieSocketAddress, 0L);
            }
        };
    }

    static void updateMyUpgradeDomain(String zoneAndUD) throws Exception {
        StaticDNSResolver.addNodeToRack(InetAddress.getLocalHost().getHostAddress(), zoneAndUD);
        StaticDNSResolver.addNodeToRack(InetAddress.getLocalHost().getHostName(), zoneAndUD);
        StaticDNSResolver.addNodeToRack("127.0.0.1", zoneAndUD);
        StaticDNSResolver.addNodeToRack("localhost", zoneAndUD);
    }

    @Test
    public void testNotEnoughRWBookies() throws Exception {
        this.zepp.uninitalize();
        TestZoneawareEnsemblePlacementPolicy.updateMyUpgradeDomain("/default-zone/default-upgradedomain");
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        StaticDNSResolver.addNodeToRack(this.addr1.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(this.addr2.getHostName(), "/zone2/ud1");
        StaticDNSResolver.addNodeToRack(this.addr3.getHostName(), "/zone3/ud1");
        StaticDNSResolver.addNodeToRack(this.addr4.getHostName(), "/zone4/ud1");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/zone5/ud1");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/zone6/ud1");
        ClientConfiguration newConf = (ClientConfiguration)this.conf.clone();
        newConf.setDesiredNumZonesPerWriteQuorum(1);
        newConf.setMinNumZonesPerWriteQuorum(1);
        this.zepp = new ZoneawareEnsemblePlacementPolicy();
        this.zepp.initialize(newConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.zepp.withDefaultFaultDomain("/default-zone/default-upgradedomain");
        HashSet<BookieId> rwAddrs = new HashSet<BookieId>();
        HashSet<BookieId> roAddrs = new HashSet<BookieId>();
        rwAddrs.add(this.addr1.toBookieId());
        rwAddrs.add(this.addr2.toBookieId());
        rwAddrs.add(this.addr3.toBookieId());
        this.zepp.onClusterChanged(rwAddrs, roAddrs);
        try {
            this.zepp.newEnsemble(6, 3, 2, null, new HashSet());
            TestZoneawareEnsemblePlacementPolicy.fail((String)"newEnsemble is expected to fail because enough writable nodes are not available");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        roAddrs.add(this.addr4.toBookieId());
        roAddrs.add(addr5.toBookieId());
        roAddrs.add(addr6.toBookieId());
        this.zepp.onClusterChanged(rwAddrs, roAddrs);
        try {
            this.zepp.newEnsemble(6, 3, 2, null, new HashSet());
            TestZoneawareEnsemblePlacementPolicy.fail((String)"newEnsemble is expected to fail because enough writable nodes are not available");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        rwAddrs.clear();
        roAddrs.add(this.addr1.toBookieId());
        roAddrs.add(this.addr2.toBookieId());
        roAddrs.add(this.addr3.toBookieId());
        this.zepp.onClusterChanged(rwAddrs, roAddrs);
        try {
            this.zepp.newEnsemble(6, 3, 2, null, new HashSet());
            TestZoneawareEnsemblePlacementPolicy.fail((String)"newEnsemble is expected to fail because enough writable nodes are not available");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
    }

    @Test
    public void testEnoughRWBookies() throws Exception {
        this.zepp.uninitalize();
        TestZoneawareEnsemblePlacementPolicy.updateMyUpgradeDomain("/default-zone/default-upgradedomain");
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        StaticDNSResolver.addNodeToRack(this.addr1.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(this.addr2.getHostName(), "/zone2/ud1");
        StaticDNSResolver.addNodeToRack(this.addr3.getHostName(), "/zone3/ud1");
        StaticDNSResolver.addNodeToRack(this.addr4.getHostName(), "/zone4/ud1");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/zone5/ud1");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/zone6/ud1");
        ClientConfiguration newConf = (ClientConfiguration)this.conf.clone();
        newConf.setDesiredNumZonesPerWriteQuorum(4);
        newConf.setMinNumZonesPerWriteQuorum(2);
        this.zepp = new ZoneawareEnsemblePlacementPolicy();
        this.zepp.initialize(newConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.zepp.withDefaultFaultDomain("/default-zone/default-upgradedomain");
        HashSet<BookieId> rwAddrs = new HashSet<BookieId>();
        HashSet roAddrs = new HashSet();
        rwAddrs.add(this.addr1.toBookieId());
        rwAddrs.add(this.addr2.toBookieId());
        rwAddrs.add(this.addr3.toBookieId());
        rwAddrs.add(this.addr4.toBookieId());
        rwAddrs.add(addr5.toBookieId());
        rwAddrs.add(addr6.toBookieId());
        this.zepp.onClusterChanged(rwAddrs, roAddrs);
        EnsemblePlacementPolicy.PlacementResult newEnsemblePlacementResult = this.zepp.newEnsemble(6, 3, 2, null, new HashSet());
        HashSet newEnsembleSet = new HashSet((Collection)newEnsemblePlacementResult.getResult());
        TestZoneawareEnsemblePlacementPolicy.assertTrue((String)"New ensemble should contain all 6 rw bookies", (boolean)newEnsembleSet.containsAll(rwAddrs));
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"PlacementPolicyAdherence", (Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT, (Object)newEnsemblePlacementResult.getAdheringToPolicy());
        newEnsemblePlacementResult = this.zepp.newEnsemble(3, 3, 2, null, new HashSet());
        newEnsembleSet = new HashSet((Collection)newEnsemblePlacementResult.getResult());
        TestZoneawareEnsemblePlacementPolicy.assertTrue((String)"New ensemble should contain 3 rw bookies", (newEnsembleSet.size() == 3 && rwAddrs.containsAll(newEnsembleSet) ? 1 : 0) != 0);
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"PlacementPolicyAdherence", (Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT, (Object)newEnsemblePlacementResult.getAdheringToPolicy());
    }

    @Test
    public void testWithDefaultBookies() throws Exception {
        this.zepp.uninitalize();
        TestZoneawareEnsemblePlacementPolicy.updateMyUpgradeDomain("/default-zone/default-upgradedomain");
        StaticDNSResolver.addNodeToRack(this.addr1.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(this.addr2.getHostName(), "/zone2/ud1");
        StaticDNSResolver.addNodeToRack(this.addr3.getHostName(), "/zone3/ud1");
        StaticDNSResolver.addNodeToRack(this.addr4.getHostName(), "/zone4/ud1");
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.8", 3181);
        HashSet<BookieId> bookiesInDefaultFaultDomain = new HashSet<BookieId>();
        bookiesInDefaultFaultDomain.add(addr5.toBookieId());
        bookiesInDefaultFaultDomain.add(addr6.toBookieId());
        bookiesInDefaultFaultDomain.add(addr7.toBookieId());
        ClientConfiguration newConf = (ClientConfiguration)this.conf.clone();
        newConf.setDesiredNumZonesPerWriteQuorum(4);
        this.zepp = new ZoneawareEnsemblePlacementPolicy();
        this.zepp.initialize(newConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.zepp.withDefaultFaultDomain("/default-zone/default-upgradedomain");
        HashSet<BookieId> rwAddrs = new HashSet<BookieId>();
        HashSet roAddrs = new HashSet();
        rwAddrs.add(this.addr1.toBookieId());
        rwAddrs.add(this.addr2.toBookieId());
        rwAddrs.add(this.addr3.toBookieId());
        rwAddrs.add(this.addr4.toBookieId());
        rwAddrs.add(addr5.toBookieId());
        rwAddrs.add(addr6.toBookieId());
        rwAddrs.add(addr7.toBookieId());
        this.zepp.onClusterChanged(rwAddrs, roAddrs);
        for (int i = 0; i < 3; ++i) {
            EnsemblePlacementPolicy.PlacementResult newEnsemblePlacementResult = this.zepp.newEnsemble(4, 4, 2, null, new HashSet());
            HashSet newEnsembleSet = new HashSet((Collection)newEnsemblePlacementResult.getResult());
            TestZoneawareEnsemblePlacementPolicy.assertTrue((String)"Bookie from default faultDomain shouldn't be part of ensemble", (boolean)Collections.disjoint(newEnsembleSet, bookiesInDefaultFaultDomain));
            newEnsemblePlacementResult = this.zepp.newEnsemble(3, 3, 2, null, new HashSet());
            newEnsembleSet = new HashSet((Collection)newEnsemblePlacementResult.getResult());
            TestZoneawareEnsemblePlacementPolicy.assertTrue((String)"Bookie from default faultDomain shouldn't be part of ensemble", (boolean)Collections.disjoint(newEnsembleSet, bookiesInDefaultFaultDomain));
            TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"PlacementPolicyAdherence", (Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT, (Object)newEnsemblePlacementResult.getAdheringToPolicy());
        }
    }

    @Test
    public void testMinZonesPerWriteQuorum() throws Exception {
        this.zepp.uninitalize();
        TestZoneawareEnsemblePlacementPolicy.updateMyUpgradeDomain("/default-zone/default-upgradedomain");
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.9", 3181);
        BookieSocketAddress addr9 = new BookieSocketAddress("127.0.0.10", 3181);
        BookieSocketAddress addr10 = new BookieSocketAddress("127.0.0.11", 3181);
        StaticDNSResolver.addNodeToRack(this.addr1.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(this.addr2.getHostName(), "/zone2/ud1");
        StaticDNSResolver.addNodeToRack(this.addr3.getHostName(), "/zone3/ud1");
        StaticDNSResolver.addNodeToRack(this.addr4.getHostName(), "/zone1/ud2");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/zone2/ud2");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/zone3/ud2");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/zone1/ud3");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/zone2/ud3");
        StaticDNSResolver.addNodeToRack(addr9.getHostName(), "/default-zone/default-upgradedomain");
        StaticDNSResolver.addNodeToRack(addr10.getHostName(), "/default-zone/default-upgradedomain");
        ClientConfiguration newConf = (ClientConfiguration)this.conf.clone();
        newConf.setDesiredNumZonesPerWriteQuorum(4);
        newConf.setMinNumZonesPerWriteQuorum(3);
        this.zepp = new ZoneawareEnsemblePlacementPolicy();
        this.zepp.initialize(newConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.zepp.withDefaultFaultDomain("/default-zone/default-upgradedomain");
        HashSet<BookieId> rwAddrs = new HashSet<BookieId>();
        HashSet<BookieId> roAddrs = new HashSet<BookieId>();
        HashSet<BookieId> bookiesInDefaultFaultDomain = new HashSet<BookieId>();
        rwAddrs.add(this.addr1.toBookieId());
        rwAddrs.add(this.addr2.toBookieId());
        rwAddrs.add(this.addr3.toBookieId());
        rwAddrs.add(this.addr4.toBookieId());
        rwAddrs.add(addr5.toBookieId());
        rwAddrs.add(addr6.toBookieId());
        rwAddrs.add(addr9.toBookieId());
        rwAddrs.add(addr10.toBookieId());
        roAddrs.add(addr7.toBookieId());
        roAddrs.add(addr8.toBookieId());
        bookiesInDefaultFaultDomain.add(addr9.toBookieId());
        bookiesInDefaultFaultDomain.add(addr10.toBookieId());
        this.zepp.onClusterChanged(rwAddrs, roAddrs);
        EnsemblePlacementPolicy.PlacementResult newEnsemblePlacementResult = this.zepp.newEnsemble(4, 4, 2, null, new HashSet());
        HashSet newEnsembleSet = new HashSet((Collection)newEnsemblePlacementResult.getResult());
        TestZoneawareEnsemblePlacementPolicy.assertTrue((String)"New ensemble should contain all 6 rw bookies in non-default fault domains", (rwAddrs.containsAll(newEnsembleSet) && newEnsembleSet.size() == 4 ? 1 : 0) != 0);
        TestZoneawareEnsemblePlacementPolicy.assertTrue((String)"Bookie from default faultDomain shouldn't be part of ensemble", (boolean)Collections.disjoint(newEnsembleSet, bookiesInDefaultFaultDomain));
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"PlacementPolicyAdherence", (Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_SOFT, (Object)newEnsemblePlacementResult.getAdheringToPolicy());
        try {
            this.zepp.newEnsemble(4, 3, 2, null, new HashSet());
            TestZoneawareEnsemblePlacementPolicy.fail((String)"newEnsemble is expected to fail with IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.zepp.uninitalize();
        newConf = (ClientConfiguration)this.conf.clone();
        newConf.setDesiredNumZonesPerWriteQuorum(4);
        newConf.setMinNumZonesPerWriteQuorum(3);
        newConf.setEnforceStrictZoneawarePlacement(false);
        this.zepp = new ZoneawareEnsemblePlacementPolicy();
        this.zepp.initialize(newConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.zepp.withDefaultFaultDomain("/default-zone/default-upgradedomain");
        this.zepp.onClusterChanged(rwAddrs, roAddrs);
        newEnsemblePlacementResult = this.zepp.newEnsemble(4, 3, 2, null, new HashSet());
        newEnsembleSet = new HashSet((Collection)newEnsemblePlacementResult.getResult());
        TestZoneawareEnsemblePlacementPolicy.assertTrue((String)"New ensemble should contain 4 different bookies", (newEnsembleSet.size() == 4 ? 1 : 0) != 0);
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"PlacementPolicyAdherence", (Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL, (Object)newEnsemblePlacementResult.getAdheringToPolicy());
    }

    @Test
    public void testMinUDsNotAvailable() throws Exception {
        this.zepp.uninitalize();
        TestZoneawareEnsemblePlacementPolicy.updateMyUpgradeDomain("/default-zone/default-upgradedomain");
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.9", 3181);
        BookieSocketAddress addr9 = new BookieSocketAddress("127.0.0.10", 3181);
        BookieSocketAddress addr10 = new BookieSocketAddress("127.0.0.11", 3181);
        StaticDNSResolver.addNodeToRack(this.addr1.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(this.addr2.getHostName(), "/zone2/ud1");
        StaticDNSResolver.addNodeToRack(this.addr3.getHostName(), "/zone3/ud1");
        StaticDNSResolver.addNodeToRack(this.addr4.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/zone2/ud1");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/zone3/ud1");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/zone1/ud3");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/zone2/ud3");
        StaticDNSResolver.addNodeToRack(addr9.getHostName(), "/default-zone/default-upgradedomain");
        StaticDNSResolver.addNodeToRack(addr10.getHostName(), "/default-zone/default-upgradedomain");
        ClientConfiguration newConf = (ClientConfiguration)this.conf.clone();
        newConf.setDesiredNumZonesPerWriteQuorum(4);
        newConf.setMinNumZonesPerWriteQuorum(2);
        this.zepp = new ZoneawareEnsemblePlacementPolicy();
        this.zepp.initialize(newConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.zepp.withDefaultFaultDomain("/default-zone/default-upgradedomain");
        HashSet<BookieId> rwAddrs = new HashSet<BookieId>();
        HashSet<BookieId> roAddrs = new HashSet<BookieId>();
        HashSet<BookieId> bookiesInDefaultFaultDomain = new HashSet<BookieId>();
        rwAddrs.add(this.addr1.toBookieId());
        rwAddrs.add(this.addr2.toBookieId());
        rwAddrs.add(this.addr3.toBookieId());
        rwAddrs.add(this.addr4.toBookieId());
        rwAddrs.add(addr5.toBookieId());
        rwAddrs.add(addr6.toBookieId());
        rwAddrs.add(addr9.toBookieId());
        rwAddrs.add(addr10.toBookieId());
        roAddrs.add(addr7.toBookieId());
        roAddrs.add(addr8.toBookieId());
        bookiesInDefaultFaultDomain.add(addr9.toBookieId());
        bookiesInDefaultFaultDomain.add(addr10.toBookieId());
        this.zepp.onClusterChanged(rwAddrs, roAddrs);
        try {
            this.zepp.newEnsemble(6, 6, 2, null, new HashSet());
            TestZoneawareEnsemblePlacementPolicy.fail((String)"newEnsemble is expected to fail because writeQuorum cannt be created with insufficient UDs");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        int ensSize = 6;
        int writeQuorum = 3;
        EnsemblePlacementPolicy.PlacementResult newEnsemblePlacementResult = this.zepp.newEnsemble(ensSize, writeQuorum, 2, null, new HashSet());
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"PlacementPolicyAdherence", (Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT, (Object)newEnsemblePlacementResult.getAdheringToPolicy());
        List newEnsemble = (List)newEnsemblePlacementResult.getResult();
        HashSet newEnsembleSet = new HashSet(newEnsemble);
        TestZoneawareEnsemblePlacementPolicy.assertTrue((String)"New ensemble should contain all 6 rw bookies in non-default fault domains", (rwAddrs.containsAll(newEnsembleSet) && newEnsembleSet.size() == 6 ? 1 : 0) != 0);
        TestZoneawareEnsemblePlacementPolicy.assertTrue((String)"Bookie from default faultDomain shouldn't be part of ensemble", (boolean)Collections.disjoint(newEnsembleSet, bookiesInDefaultFaultDomain));
        HashSet<String> zonesOfBookiesInAWriteQuorum = new HashSet<String>();
        for (int i = 0; i < 6; ++i) {
            zonesOfBookiesInAWriteQuorum.clear();
            for (int j = 0; j < writeQuorum; ++j) {
                zonesOfBookiesInAWriteQuorum.add(this.zepp.getZoneAwareNodeLocation((BookieId)newEnsemble.get((i + j) % ensSize)).getZone());
            }
            TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"Since bookies are not spread across multiple UDs in a zone, write quorum should contain bookies from all 3 zones", (int)3, (int)zonesOfBookiesInAWriteQuorum.size());
        }
    }

    @Test
    public void testUniqueUds() throws Exception {
        this.zepp.uninitalize();
        TestZoneawareEnsemblePlacementPolicy.updateMyUpgradeDomain("/default-zone/default-upgradedomain");
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.9", 3181);
        BookieSocketAddress addr9 = new BookieSocketAddress("127.0.0.10", 3181);
        BookieSocketAddress addr10 = new BookieSocketAddress("127.0.0.11", 3181);
        BookieSocketAddress addr11 = new BookieSocketAddress("127.0.0.12", 3181);
        BookieSocketAddress addr12 = new BookieSocketAddress("127.0.0.13", 3181);
        StaticDNSResolver.addNodeToRack(this.addr1.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(this.addr2.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(this.addr3.getHostName(), "/zone1/ud2");
        StaticDNSResolver.addNodeToRack(this.addr4.getHostName(), "/zone1/ud2");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/zone1/ud3");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/zone1/ud3");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/zone2/ud1");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/zone2/ud1");
        StaticDNSResolver.addNodeToRack(addr9.getHostName(), "/zone2/ud2");
        StaticDNSResolver.addNodeToRack(addr10.getHostName(), "/zone2/ud2");
        StaticDNSResolver.addNodeToRack(addr11.getHostName(), "/zone2/ud3");
        StaticDNSResolver.addNodeToRack(addr12.getHostName(), "/zone2/ud3");
        ClientConfiguration newConf = (ClientConfiguration)this.conf.clone();
        newConf.setDesiredNumZonesPerWriteQuorum(4);
        newConf.setMinNumZonesPerWriteQuorum(2);
        this.zepp = new ZoneawareEnsemblePlacementPolicy();
        this.zepp.initialize(newConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.zepp.withDefaultFaultDomain("/default-zone/default-upgradedomain");
        HashSet<BookieId> rwAddrs = new HashSet<BookieId>();
        HashSet roAddrs = new HashSet();
        rwAddrs.add(this.addr1.toBookieId());
        rwAddrs.add(this.addr2.toBookieId());
        rwAddrs.add(this.addr3.toBookieId());
        rwAddrs.add(this.addr4.toBookieId());
        rwAddrs.add(addr5.toBookieId());
        rwAddrs.add(addr6.toBookieId());
        rwAddrs.add(addr7.toBookieId());
        rwAddrs.add(addr8.toBookieId());
        rwAddrs.add(addr9.toBookieId());
        rwAddrs.add(addr10.toBookieId());
        rwAddrs.add(addr11.toBookieId());
        rwAddrs.add(addr12.toBookieId());
        this.zepp.onClusterChanged(rwAddrs, roAddrs);
        EnsemblePlacementPolicy.PlacementResult newEnsemblePlacementResult = this.zepp.newEnsemble(6, 6, 2, null, new HashSet());
        List newEnsembleList = (List)newEnsemblePlacementResult.getResult();
        HashSet newEnsembleSet = new HashSet(newEnsembleList);
        TestZoneawareEnsemblePlacementPolicy.assertTrue((String)"New ensemble should contain 6 rw bookies in non-default fault domains", (rwAddrs.containsAll(newEnsembleSet) && newEnsembleSet.size() == 6 ? 1 : 0) != 0);
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"PlacementPolicyAdherence", (Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_SOFT, (Object)newEnsemblePlacementResult.getAdheringToPolicy());
        HashSet<String> bookiesNetworkLocations = new HashSet<String>();
        for (Object bookieAddr : newEnsembleSet) {
            bookiesNetworkLocations.add(this.zepp.resolveNetworkLocation((BookieId)bookieAddr));
        }
        TestZoneawareEnsemblePlacementPolicy.assertTrue((String)"Bookies should be from different UpgradeDomains if they belong to same zone", (bookiesNetworkLocations.size() == 6 ? 1 : 0) != 0);
        ArrayList<ZoneawareEnsemblePlacementPolicyImpl.ZoneAwareNodeLocation> bookiesNodeLocationList = new ArrayList<ZoneawareEnsemblePlacementPolicyImpl.ZoneAwareNodeLocation>();
        for (BookieId bookieAddr : newEnsembleList) {
            bookiesNodeLocationList.add(this.zepp.getZoneAwareNodeLocation(bookieAddr));
        }
        for (int i = 0; i < 5; ++i) {
            Assert.assertNotEquals((String)"Alternate bookies should be from different zones", (Object)((ZoneawareEnsemblePlacementPolicyImpl.ZoneAwareNodeLocation)bookiesNodeLocationList.get(i)).getZone(), (Object)((ZoneawareEnsemblePlacementPolicyImpl.ZoneAwareNodeLocation)bookiesNodeLocationList.get(i + 1)).getZone());
        }
    }

    @Test
    public void testNewBookieUniformDistributionWithMinZoneAndMinUDs() throws Exception {
        int i;
        this.zepp.uninitalize();
        TestZoneawareEnsemblePlacementPolicy.updateMyUpgradeDomain("/default-zone/default-upgradedomain");
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.9", 3181);
        BookieSocketAddress addr9 = new BookieSocketAddress("127.0.0.10", 3181);
        BookieSocketAddress addr10 = new BookieSocketAddress("127.0.0.11", 3181);
        BookieSocketAddress addr11 = new BookieSocketAddress("127.0.0.12", 3181);
        BookieSocketAddress addr12 = new BookieSocketAddress("127.0.0.13", 3181);
        BookieSocketAddress addr13 = new BookieSocketAddress("127.0.0.14", 3181);
        BookieSocketAddress addr14 = new BookieSocketAddress("127.0.0.15", 3181);
        StaticDNSResolver.addNodeToRack(this.addr1.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(this.addr2.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(this.addr3.getHostName(), "/zone1/ud2");
        StaticDNSResolver.addNodeToRack(this.addr4.getHostName(), "/zone1/ud2");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/zone2/ud1");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/zone2/ud1");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/zone2/ud2");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/zone2/ud2");
        StaticDNSResolver.addNodeToRack(addr9.getHostName(), "/zone3/ud1");
        StaticDNSResolver.addNodeToRack(addr10.getHostName(), "/zone3/ud1");
        StaticDNSResolver.addNodeToRack(addr11.getHostName(), "/zone3/ud2");
        StaticDNSResolver.addNodeToRack(addr12.getHostName(), "/zone3/ud2");
        StaticDNSResolver.addNodeToRack(addr13.getHostName(), "/default-zone/default-upgradedomain");
        StaticDNSResolver.addNodeToRack(addr14.getHostName(), "/default-zone/default-upgradedomain");
        HashSet<BookieId> rwAddrs = new HashSet<BookieId>();
        HashSet roAddrs = new HashSet();
        rwAddrs.add(this.addr1.toBookieId());
        rwAddrs.add(this.addr2.toBookieId());
        rwAddrs.add(this.addr3.toBookieId());
        rwAddrs.add(this.addr4.toBookieId());
        rwAddrs.add(addr5.toBookieId());
        rwAddrs.add(addr6.toBookieId());
        rwAddrs.add(addr7.toBookieId());
        rwAddrs.add(addr8.toBookieId());
        rwAddrs.add(addr9.toBookieId());
        rwAddrs.add(addr10.toBookieId());
        rwAddrs.add(addr11.toBookieId());
        rwAddrs.add(addr12.toBookieId());
        rwAddrs.add(addr13.toBookieId());
        rwAddrs.add(addr14.toBookieId());
        int minNumZonesPerWriteQuorum = 3;
        ClientConfiguration newConf = (ClientConfiguration)this.conf.clone();
        newConf.setDesiredNumZonesPerWriteQuorum(5);
        newConf.setMinNumZonesPerWriteQuorum(minNumZonesPerWriteQuorum);
        this.zepp = new ZoneawareEnsemblePlacementPolicy();
        this.zepp.initialize(newConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.zepp.withDefaultFaultDomain("/default-zone/default-upgradedomain");
        this.zepp.onClusterChanged(rwAddrs, roAddrs);
        HashSet excludedBookies = new HashSet();
        EnsemblePlacementPolicy.PlacementResult newEnsemblePlacementResult = this.zepp.newEnsemble(6, 6, 4, null, excludedBookies);
        List newEnsembleList = (List)newEnsemblePlacementResult.getResult();
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"PlacementPolicyAdherence", (Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_SOFT, (Object)newEnsemblePlacementResult.getAdheringToPolicy());
        HashSet newEnsembleSet = new HashSet(newEnsembleList);
        HashSet<String> bookiesNetworkLocationsSet = new HashSet<String>();
        ArrayList<ZoneawareEnsemblePlacementPolicyImpl.ZoneAwareNodeLocation> bookiesNodeLocationList = new ArrayList<ZoneawareEnsemblePlacementPolicyImpl.ZoneAwareNodeLocation>();
        for (BookieId bookieAddr : newEnsembleSet) {
            bookiesNetworkLocationsSet.add(this.zepp.resolveNetworkLocation(bookieAddr));
        }
        for (BookieId bookieAddr : newEnsembleList) {
            bookiesNodeLocationList.add(this.zepp.getZoneAwareNodeLocation(bookieAddr));
        }
        TestZoneawareEnsemblePlacementPolicy.assertTrue((String)"Bookies should be from different UpgradeDomains if they belong to same zone", (bookiesNetworkLocationsSet.size() == 6 ? 1 : 0) != 0);
        HashSet<String> zonesOfFirstNodes = new HashSet<String>();
        for (i = 0; i < minNumZonesPerWriteQuorum; ++i) {
            zonesOfFirstNodes.add(((ZoneawareEnsemblePlacementPolicyImpl.ZoneAwareNodeLocation)bookiesNodeLocationList.get(i)).getZone());
        }
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"Num of zones", (int)minNumZonesPerWriteQuorum, (int)zonesOfFirstNodes.size());
        for (i = 0; i < minNumZonesPerWriteQuorum; ++i) {
            TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"Zone", (String)((ZoneawareEnsemblePlacementPolicyImpl.ZoneAwareNodeLocation)bookiesNodeLocationList.get(i)).getZone(), (String)((ZoneawareEnsemblePlacementPolicyImpl.ZoneAwareNodeLocation)bookiesNodeLocationList.get(i + minNumZonesPerWriteQuorum)).getZone());
            Assert.assertNotEquals((String)"UpgradeDomain", (Object)((ZoneawareEnsemblePlacementPolicyImpl.ZoneAwareNodeLocation)bookiesNodeLocationList.get(i)).getUpgradeDomain(), (Object)((ZoneawareEnsemblePlacementPolicyImpl.ZoneAwareNodeLocation)bookiesNodeLocationList.get(i + minNumZonesPerWriteQuorum)).getUpgradeDomain());
        }
    }

    @Test
    public void testReplaceBookie() throws Exception {
        this.zepp.uninitalize();
        TestZoneawareEnsemblePlacementPolicy.updateMyUpgradeDomain("/default-zone/default-upgradedomain");
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.9", 3181);
        BookieSocketAddress addr9 = new BookieSocketAddress("127.0.0.10", 3181);
        BookieSocketAddress addr10 = new BookieSocketAddress("127.0.0.11", 3181);
        BookieSocketAddress addr11 = new BookieSocketAddress("127.0.0.12", 3181);
        BookieSocketAddress addr12 = new BookieSocketAddress("127.0.0.13", 3181);
        BookieSocketAddress addr13 = new BookieSocketAddress("127.0.0.14", 3181);
        BookieSocketAddress addr14 = new BookieSocketAddress("127.0.0.15", 3181);
        StaticDNSResolver.addNodeToRack(this.addr1.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(this.addr2.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(this.addr3.getHostName(), "/zone1/ud2");
        StaticDNSResolver.addNodeToRack(this.addr4.getHostName(), "/zone1/ud2");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/zone2/ud1");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/zone2/ud1");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/zone2/ud2");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/zone2/ud2");
        StaticDNSResolver.addNodeToRack(addr9.getHostName(), "/zone3/ud1");
        StaticDNSResolver.addNodeToRack(addr10.getHostName(), "/zone3/ud1");
        StaticDNSResolver.addNodeToRack(addr11.getHostName(), "/zone3/ud2");
        StaticDNSResolver.addNodeToRack(addr12.getHostName(), "/zone3/ud2");
        StaticDNSResolver.addNodeToRack(addr13.getHostName(), "/default-zone/default-upgradedomain");
        StaticDNSResolver.addNodeToRack(addr14.getHostName(), "/default-zone/default-upgradedomain");
        ClientConfiguration newConf = (ClientConfiguration)this.conf.clone();
        newConf.setDesiredNumZonesPerWriteQuorum(3);
        newConf.setMinNumZonesPerWriteQuorum(3);
        this.zepp = new ZoneawareEnsemblePlacementPolicy();
        this.zepp.initialize(newConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.zepp.withDefaultFaultDomain("/default-zone/default-upgradedomain");
        HashSet<BookieId> rwAddrs = new HashSet<BookieId>();
        HashSet roAddrs = new HashSet();
        rwAddrs.add(this.addr1.toBookieId());
        rwAddrs.add(this.addr2.toBookieId());
        rwAddrs.add(this.addr3.toBookieId());
        rwAddrs.add(this.addr4.toBookieId());
        rwAddrs.add(addr5.toBookieId());
        rwAddrs.add(addr6.toBookieId());
        rwAddrs.add(addr7.toBookieId());
        rwAddrs.add(addr8.toBookieId());
        rwAddrs.add(addr9.toBookieId());
        rwAddrs.add(addr10.toBookieId());
        rwAddrs.add(addr11.toBookieId());
        rwAddrs.add(addr12.toBookieId());
        rwAddrs.add(addr13.toBookieId());
        rwAddrs.add(addr14.toBookieId());
        this.zepp.onClusterChanged(rwAddrs, roAddrs);
        ArrayList<BookieId> ensemble = new ArrayList<BookieId>();
        HashSet<BookieId> excludedBookies = new HashSet<BookieId>();
        ensemble.add(this.addr1.toBookieId());
        ensemble.add(addr5.toBookieId());
        ensemble.add(addr9.toBookieId());
        ensemble.add(this.addr3.toBookieId());
        ensemble.add(addr7.toBookieId());
        ensemble.add(addr11.toBookieId());
        EnsemblePlacementPolicy.PlacementResult replacePlacementResult = this.zepp.replaceBookie(6, 6, 2, null, ensemble, addr7.toBookieId(), excludedBookies);
        BookieId replacedBookie = (BookieId)replacePlacementResult.getResult();
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"replaced bookie", (Object)addr8.toBookieId(), (Object)replacedBookie);
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"PlacementPolicyAdherence", (Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT, (Object)replacePlacementResult.getAdheringToPolicy());
        excludedBookies.add(addr8.toBookieId());
        replacePlacementResult = this.zepp.replaceBookie(6, 3, 2, null, ensemble, addr7.toBookieId(), excludedBookies);
        replacedBookie = (BookieId)replacePlacementResult.getResult();
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"replaced bookie", (Object)addr6.toBookieId(), (Object)replacedBookie);
        excludedBookies.add(addr6.toBookieId());
        try {
            replacedBookie = (BookieId)this.zepp.replaceBookie(6, 3, 2, null, ensemble, addr7.toBookieId(), excludedBookies).getResult();
            TestZoneawareEnsemblePlacementPolicy.fail((String)"Expected BKNotEnoughBookiesException for replaceBookie with added excludedBookies");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
    }

    @Test
    public void testReplaceBookieMinUDs() throws Exception {
        this.zepp.uninitalize();
        TestZoneawareEnsemblePlacementPolicy.updateMyUpgradeDomain("/default-zone/default-upgradedomain");
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.9", 3181);
        BookieSocketAddress addr9 = new BookieSocketAddress("127.0.0.10", 3181);
        BookieSocketAddress addr10 = new BookieSocketAddress("127.0.0.11", 3181);
        BookieSocketAddress addr11 = new BookieSocketAddress("127.0.0.12", 3181);
        StaticDNSResolver.addNodeToRack(this.addr1.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(this.addr2.getHostName(), "/zone2/ud1");
        StaticDNSResolver.addNodeToRack(this.addr3.getHostName(), "/zone3/ud1");
        StaticDNSResolver.addNodeToRack(this.addr4.getHostName(), "/zone3/ud2");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/zone3/ud2");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/zone3/ud2");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/zone3/ud2");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/zone3/ud2");
        StaticDNSResolver.addNodeToRack(addr9.getHostName(), "/zone3/ud2");
        StaticDNSResolver.addNodeToRack(addr10.getHostName(), "/default-zone/default-upgradedomain");
        StaticDNSResolver.addNodeToRack(addr11.getHostName(), "/default-zone/default-upgradedomain");
        ClientConfiguration newConf = (ClientConfiguration)this.conf.clone();
        newConf.setDesiredNumZonesPerWriteQuorum(4);
        newConf.setMinNumZonesPerWriteQuorum(3);
        this.zepp = new ZoneawareEnsemblePlacementPolicy();
        this.zepp.initialize(newConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.zepp.withDefaultFaultDomain("/default-zone/default-upgradedomain");
        HashSet<BookieId> rwAddrs = new HashSet<BookieId>();
        HashSet roAddrs = new HashSet();
        rwAddrs.add(this.addr1.toBookieId());
        rwAddrs.add(this.addr2.toBookieId());
        rwAddrs.add(this.addr3.toBookieId());
        rwAddrs.add(this.addr4.toBookieId());
        rwAddrs.add(addr5.toBookieId());
        rwAddrs.add(addr6.toBookieId());
        rwAddrs.add(addr7.toBookieId());
        rwAddrs.add(addr8.toBookieId());
        rwAddrs.add(addr9.toBookieId());
        rwAddrs.add(addr10.toBookieId());
        rwAddrs.add(addr11.toBookieId());
        this.zepp.onClusterChanged(rwAddrs, roAddrs);
        ArrayList<BookieId> ensemble = new ArrayList<BookieId>();
        HashSet excludedBookies = new HashSet();
        ensemble.add(this.addr1.toBookieId());
        ensemble.add(this.addr2.toBookieId());
        ensemble.add(this.addr3.toBookieId());
        ensemble.add(this.addr4.toBookieId());
        ensemble.add(addr5.toBookieId());
        ensemble.add(addr6.toBookieId());
        EnsemblePlacementPolicy.PlacementResult replaceResponse = this.zepp.replaceBookie(6, 6, 2, null, ensemble, this.addr4.toBookieId(), excludedBookies);
        BookieId replacedBookie = (BookieId)replaceResponse.getResult();
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"replaced bookie", (String)"/zone3/ud2", (String)this.zepp.resolveNetworkLocation(replacedBookie));
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"PlacementPolicyAdherence", (Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_SOFT, (Object)replaceResponse.getAdheringToPolicy());
    }

    @Test
    public void testAreAckedBookiesAdheringToPlacementPolicy() throws Exception {
        this.zepp.uninitalize();
        TestZoneawareEnsemblePlacementPolicy.updateMyUpgradeDomain("/default-zone/default-upgradedomain");
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.9", 3181);
        BookieSocketAddress addr9 = new BookieSocketAddress("127.0.0.10", 3181);
        StaticDNSResolver.addNodeToRack(this.addr1.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(this.addr2.getHostName(), "/zone2/ud1");
        StaticDNSResolver.addNodeToRack(this.addr3.getHostName(), "/zone3/ud1");
        StaticDNSResolver.addNodeToRack(this.addr4.getHostName(), "/zone1/ud2");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/zone2/ud2");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/zone3/ud2");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/zone1/ud3");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/zone2/ud3");
        StaticDNSResolver.addNodeToRack(addr9.getHostName(), "/zone3/ud3");
        ClientConfiguration newConf = (ClientConfiguration)this.conf.clone();
        newConf.setDesiredNumZonesPerWriteQuorum(4);
        newConf.setMinNumZonesPerWriteQuorum(2);
        this.zepp = new ZoneawareEnsemblePlacementPolicy();
        this.zepp.initialize(newConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.zepp.withDefaultFaultDomain("/default-zone/default-upgradedomain");
        HashSet<BookieId> rwAddrs = new HashSet<BookieId>();
        HashSet roAddrs = new HashSet();
        rwAddrs.add(this.addr1.toBookieId());
        rwAddrs.add(this.addr2.toBookieId());
        rwAddrs.add(this.addr3.toBookieId());
        rwAddrs.add(this.addr4.toBookieId());
        rwAddrs.add(addr5.toBookieId());
        rwAddrs.add(addr6.toBookieId());
        rwAddrs.add(addr7.toBookieId());
        rwAddrs.add(addr8.toBookieId());
        rwAddrs.add(addr9.toBookieId());
        this.zepp.onClusterChanged(rwAddrs, roAddrs);
        HashSet<BookieId> ackedBookies = new HashSet<BookieId>();
        ackedBookies.add(this.addr1.toBookieId());
        ackedBookies.add(this.addr4.toBookieId());
        TestZoneawareEnsemblePlacementPolicy.assertFalse((String)"since both the bookies are in the same zone, it should return false", (boolean)this.zepp.areAckedBookiesAdheringToPlacementPolicy(ackedBookies, 10, 2));
        ackedBookies.clear();
        ackedBookies.add(this.addr1.toBookieId());
        ackedBookies.add(this.addr2.toBookieId());
        TestZoneawareEnsemblePlacementPolicy.assertFalse((String)"since ackQuorumSize is 3, it should return false", (boolean)this.zepp.areAckedBookiesAdheringToPlacementPolicy(ackedBookies, 10, 3));
        TestZoneawareEnsemblePlacementPolicy.assertTrue((String)"since ackQuorumSize is 2 and bookies are from minNumZonesPerWriteQuorum it should return true", (boolean)this.zepp.areAckedBookiesAdheringToPlacementPolicy(ackedBookies, 10, 2));
        this.zepp.uninitalize();
        newConf = (ClientConfiguration)this.conf.clone();
        newConf.setDesiredNumZonesPerWriteQuorum(4);
        newConf.setMinNumZonesPerWriteQuorum(4);
        this.zepp = new ZoneawareEnsemblePlacementPolicy();
        this.zepp.initialize(newConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.zepp.withDefaultFaultDomain("/default-zone/default-upgradedomain");
        this.zepp.onClusterChanged(rwAddrs, roAddrs);
        ackedBookies.clear();
        ackedBookies.add(this.addr1.toBookieId());
        ackedBookies.add(this.addr2.toBookieId());
        ackedBookies.add(this.addr3.toBookieId());
        TestZoneawareEnsemblePlacementPolicy.assertFalse((String)"since minNumZonesPerWriteQuorum is set to 4, it should return false", (boolean)this.zepp.areAckedBookiesAdheringToPlacementPolicy(ackedBookies, 4, 3));
        TestZoneawareEnsemblePlacementPolicy.assertTrue((String)"since writeQuorumSize is set to 3, it should return true", (boolean)this.zepp.areAckedBookiesAdheringToPlacementPolicy(ackedBookies, 3, 3));
        ackedBookies.clear();
        ackedBookies.add(this.addr1.toBookieId());
        ackedBookies.add(this.addr2.toBookieId());
        ackedBookies.add(this.addr4.toBookieId());
        TestZoneawareEnsemblePlacementPolicy.assertFalse((String)"since bookies are in just 2 zones but not in 3 zones, it should return false", (boolean)this.zepp.areAckedBookiesAdheringToPlacementPolicy(ackedBookies, 3, 3));
    }

    @Test
    public void testWeightedPlacement() throws Exception {
        ArrayList<BookieId> newEnsemble;
        this.zepp.uninitalize();
        TestZoneawareEnsemblePlacementPolicy.updateMyUpgradeDomain("/default-zone/default-upgradedomain");
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        StaticDNSResolver.addNodeToRack(this.addr1.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(this.addr2.getHostName(), "/zone1/ud2");
        StaticDNSResolver.addNodeToRack(this.addr3.getHostName(), "/zone2/ud1");
        StaticDNSResolver.addNodeToRack(this.addr4.getHostName(), "/zone2/ud2");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/default-zone/default-upgradedomain");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        addrs.add(addr5.toBookieId());
        int multiple = 10;
        ClientConfiguration newConf = new ClientConfiguration((AbstractConfiguration)this.conf);
        newConf.addConfiguration((Configuration)this.conf);
        newConf.setDiskWeightBasedPlacementEnabled(true);
        newConf.setBookieMaxWeightMultipleForWeightBasedPlacement(-1);
        newConf.setMinNumZonesPerWriteQuorum(0);
        this.zepp.initialize(newConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.zepp.withDefaultFaultDomain("/default-zone/default-upgradedomain");
        this.zepp.onClusterChanged(addrs, new HashSet());
        HashMap<BookieId, BookieInfoReader.BookieInfo> bookieInfoMap = new HashMap<BookieId, BookieInfoReader.BookieInfo>();
        bookieInfoMap.put(this.addr1.toBookieId(), new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(this.addr2.toBookieId(), new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(this.addr3.toBookieId(), new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(this.addr4.toBookieId(), new BookieInfoReader.BookieInfo((long)multiple * 100L, (long)multiple * 100L));
        bookieInfoMap.put(addr5.toBookieId(), new BookieInfoReader.BookieInfo(100L, 100L));
        this.zepp.updateBookieInfo(bookieInfoMap);
        HashMap<Object, Long> selectionCounts = new HashMap<Object, Long>();
        int numTries = 50000;
        for (BookieId addr : addrs) {
            selectionCounts.put(addr, 0L);
        }
        for (int i = 0; i < numTries; ++i) {
            EnsemblePlacementPolicy.PlacementResult newEnsembleResponse = this.zepp.newEnsemble(1, 1, 1, null, new HashSet());
            newEnsemble = (ArrayList<BookieId>)newEnsembleResponse.getResult();
            selectionCounts.put(newEnsemble.get(0), (Long)selectionCounts.get(newEnsemble.get(0)) + 1L);
        }
        double observedMultiple = (double)((Long)selectionCounts.get(this.addr4.toBookieId())).longValue() / (double)((Long)selectionCounts.get(this.addr3.toBookieId())).longValue();
        TestZoneawareEnsemblePlacementPolicy.assertTrue((String)("Weights not being honored " + observedMultiple), (Math.abs(observedMultiple - (double)multiple) < 1.0 ? 1 : 0) != 0);
        selectionCounts.clear();
        selectionCounts.put(this.addr3.toBookieId(), 0L);
        selectionCounts.put(this.addr4.toBookieId(), 0L);
        newEnsemble = new ArrayList<BookieId>();
        newEnsemble.add(this.addr2.toBookieId());
        HashSet<BookieId> excludedBookies = new HashSet<BookieId>();
        excludedBookies.add(this.addr1.toBookieId());
        for (int i = 0; i < numTries; ++i) {
            EnsemblePlacementPolicy.PlacementResult replacedBookieResponse = this.zepp.replaceBookie(1, 1, 1, null, newEnsemble, this.addr2.toBookieId(), excludedBookies);
            BookieId replacedBookie = (BookieId)replacedBookieResponse.getResult();
            TestZoneawareEnsemblePlacementPolicy.assertTrue((String)("replaced : " + replacedBookie), (this.addr3.toBookieId().equals((Object)replacedBookie) || this.addr4.toBookieId().equals((Object)replacedBookie) ? 1 : 0) != 0);
            selectionCounts.put(replacedBookie, (Long)selectionCounts.get(replacedBookie) + 1L);
        }
        observedMultiple = (double)((Long)selectionCounts.get(this.addr4.toBookieId())).longValue() / (double)((Long)selectionCounts.get(this.addr3.toBookieId())).longValue();
        TestZoneawareEnsemblePlacementPolicy.assertTrue((String)("Weights not being honored " + observedMultiple), (Math.abs(observedMultiple - (double)multiple) < 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testPlacementOnStabilizeNetworkTopology() throws Exception {
        this.zepp.uninitalize();
        TestZoneawareEnsemblePlacementPolicy.updateMyUpgradeDomain("/default-zone/default-upgradedomain");
        StaticDNSResolver.addNodeToRack(this.addr1.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(this.addr2.getHostName(), "/zone2/ud1");
        StaticDNSResolver.addNodeToRack(this.addr3.getHostName(), "/zone3/ud1");
        StaticDNSResolver.addNodeToRack(this.addr4.getHostName(), "/zone4/ud1");
        this.zepp = new ZoneawareEnsemblePlacementPolicy();
        ClientConfiguration confLocal = new ClientConfiguration();
        confLocal.addConfiguration((Configuration)this.conf);
        confLocal.setNetworkTopologyStabilizePeriodSeconds(99999);
        this.zepp.initialize(confLocal, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.zepp.withDefaultFaultDomain("/default-zone/default-upgradedomain");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        this.zepp.onClusterChanged(addrs, new HashSet());
        addrs.remove(this.addr4.toBookieId());
        Set deadBookies = this.zepp.onClusterChanged(addrs, new HashSet());
        TestZoneawareEnsemblePlacementPolicy.assertTrue((boolean)deadBookies.isEmpty());
        for (int i = 0; i < 5; ++i) {
            EnsemblePlacementPolicy.PlacementResult ensembleResponse = this.zepp.newEnsemble(3, 3, 2, null, new HashSet());
            List ensemble = (List)ensembleResponse.getResult();
            TestZoneawareEnsemblePlacementPolicy.assertFalse((boolean)ensemble.contains(this.addr4.toBookieId()));
            TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"PlacementPolicyAdherence", (Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT, (Object)ensembleResponse.getAdheringToPolicy());
        }
        EnsemblePlacementPolicy.PlacementResult ensembleResponse = this.zepp.newEnsemble(4, 4, 2, null, new HashSet());
        List ensemble = (List)ensembleResponse.getResult();
        TestZoneawareEnsemblePlacementPolicy.assertTrue((boolean)ensemble.contains(this.addr4.toBookieId()));
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"PlacementPolicyAdherence", (Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT, (Object)ensembleResponse.getAdheringToPolicy());
    }

    @Test
    public void testCreateNewEnsembleRandomly() throws Exception {
        this.zepp.uninitalize();
        TestZoneawareEnsemblePlacementPolicy.updateMyUpgradeDomain("/default-zone/default-upgradedomain");
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        StaticDNSResolver.addNodeToRack(this.addr1.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(this.addr2.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(this.addr3.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(this.addr4.getHostName(), "/default-zone/default-upgradedomain");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/zone1/ud1");
        this.zepp = new ZoneawareEnsemblePlacementPolicy();
        ClientConfiguration confLocal = new ClientConfiguration();
        confLocal.addConfiguration((Configuration)this.conf);
        confLocal.setEnforceStrictZoneawarePlacement(false);
        confLocal.setMinNumZonesPerWriteQuorum(3);
        confLocal.setDesiredNumZonesPerWriteQuorum(4);
        this.zepp.initialize(confLocal, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.zepp.withDefaultFaultDomain("/default-zone/default-upgradedomain");
        HashSet<BookieId> rwAddrs = new HashSet<BookieId>();
        HashSet<BookieId> roAddrs = new HashSet<BookieId>();
        HashSet<BookieId> excludeBookies = new HashSet<BookieId>();
        rwAddrs.add(this.addr1.toBookieId());
        rwAddrs.add(this.addr2.toBookieId());
        rwAddrs.add(this.addr3.toBookieId());
        rwAddrs.add(this.addr4.toBookieId());
        rwAddrs.add(addr5.toBookieId());
        excludeBookies.add(addr5.toBookieId());
        this.zepp.onClusterChanged(rwAddrs, roAddrs);
        EnsemblePlacementPolicy.PlacementResult newEnsemblePlacementResult = this.zepp.newEnsemble(4, 3, 2, null, excludeBookies);
        HashSet newEnsembleSet = new HashSet((Collection)newEnsemblePlacementResult.getResult());
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"New ensemble should contain 4 rw bookies", (int)4, (int)newEnsembleSet.size());
        TestZoneawareEnsemblePlacementPolicy.assertFalse((String)"excludeBookie should not be included in the ensemble", (boolean)newEnsembleSet.contains(addr5.toBookieId()));
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"PlacementPolicyAdherence", (Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL, (Object)newEnsemblePlacementResult.getAdheringToPolicy());
        rwAddrs.remove(this.addr4.toBookieId());
        roAddrs.add(this.addr4.toBookieId());
        this.zepp.onClusterChanged(rwAddrs, roAddrs);
        try {
            this.zepp.newEnsemble(4, 3, 2, null, excludeBookies);
            TestZoneawareEnsemblePlacementPolicy.fail((String)"Creation of new ensemble randomly should fail because of not sufficient bookies");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
    }

    @Test
    public void testReplaceBookieRandomly() throws Exception {
        this.zepp.uninitalize();
        TestZoneawareEnsemblePlacementPolicy.updateMyUpgradeDomain("/default-zone/default-upgradedomain");
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.8", 3181);
        StaticDNSResolver.addNodeToRack(this.addr1.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(this.addr2.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(this.addr3.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(this.addr4.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/default-zone/default-upgradedomain");
        this.zepp = new ZoneawareEnsemblePlacementPolicy();
        ClientConfiguration confLocal = new ClientConfiguration();
        confLocal.addConfiguration((Configuration)this.conf);
        confLocal.setEnforceStrictZoneawarePlacement(false);
        confLocal.setMinNumZonesPerWriteQuorum(3);
        confLocal.setDesiredNumZonesPerWriteQuorum(4);
        this.zepp.initialize(confLocal, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.zepp.withDefaultFaultDomain("/default-zone/default-upgradedomain");
        HashSet<BookieId> rwAddrs = new HashSet<BookieId>();
        HashSet<BookieId> roAddrs = new HashSet<BookieId>();
        HashSet<BookieId> excludeBookies = new HashSet<BookieId>();
        rwAddrs.add(this.addr1.toBookieId());
        rwAddrs.add(this.addr2.toBookieId());
        rwAddrs.add(this.addr3.toBookieId());
        rwAddrs.add(this.addr4.toBookieId());
        rwAddrs.add(addr5.toBookieId());
        rwAddrs.add(addr7.toBookieId());
        roAddrs.add(addr6.toBookieId());
        excludeBookies.add(addr5.toBookieId());
        this.zepp.onClusterChanged(rwAddrs, roAddrs);
        ArrayList<BookieId> ensembleList = new ArrayList<BookieId>();
        ensembleList.add(this.addr1.toBookieId());
        ensembleList.add(this.addr2.toBookieId());
        ensembleList.add(this.addr3.toBookieId());
        ensembleList.add(this.addr4.toBookieId());
        EnsemblePlacementPolicy.PlacementResult replaceResponse = this.zepp.replaceBookie(4, 3, 2, null, ensembleList, this.addr3.toBookieId(), excludeBookies);
        BookieId replaceBookie = (BookieId)replaceResponse.getResult();
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"ReplaceBookie candidate", (Object)addr7.toBookieId(), (Object)replaceBookie);
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"PlacementPolicyAdherence", (Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL, (Object)replaceResponse.getAdheringToPolicy());
        rwAddrs.remove(addr7.toBookieId());
        excludeBookies.add(addr7.toBookieId());
        this.zepp.onClusterChanged(rwAddrs, roAddrs);
        try {
            this.zepp.replaceBookie(4, 3, 2, null, ensembleList, this.addr3.toBookieId(), excludeBookies);
            TestZoneawareEnsemblePlacementPolicy.fail((String)"ReplaceBookie should fail because of unavailable bookies");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
    }

    @Test
    public void testIsEnsembleAdheringToPlacementPolicy() throws Exception {
        this.zepp.uninitalize();
        TestZoneawareEnsemblePlacementPolicy.updateMyUpgradeDomain("/default-zone/default-upgradedomain");
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.9", 3181);
        BookieSocketAddress addr9 = new BookieSocketAddress("127.0.0.10", 3181);
        BookieSocketAddress addr10 = new BookieSocketAddress("127.0.0.11", 3181);
        StaticDNSResolver.addNodeToRack(this.addr1.getHostName(), "/zone1/ud1");
        StaticDNSResolver.addNodeToRack(this.addr2.getHostName(), "/zone1/ud2");
        StaticDNSResolver.addNodeToRack(this.addr3.getHostName(), "/zone1/ud2");
        StaticDNSResolver.addNodeToRack(this.addr4.getHostName(), "/zone2/ud1");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/zone2/ud2");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/zone2/ud2");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/zone3/ud1");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/zone3/ud2");
        StaticDNSResolver.addNodeToRack(addr9.getHostName(), "/zone3/ud2");
        StaticDNSResolver.addNodeToRack(addr10.getHostName(), "/default-zone/default-upgradedomain");
        this.zepp = new ZoneawareEnsemblePlacementPolicy();
        ClientConfiguration confLocal = new ClientConfiguration();
        confLocal.addConfiguration((Configuration)this.conf);
        confLocal.setEnforceStrictZoneawarePlacement(true);
        confLocal.setMinNumZonesPerWriteQuorum(2);
        confLocal.setDesiredNumZonesPerWriteQuorum(3);
        this.zepp.initialize(confLocal, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.zepp.withDefaultFaultDomain("/default-zone/default-upgradedomain");
        ArrayList emptyEnsmeble = new ArrayList();
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"PlacementPolicyAdherence", (Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL, (Object)this.zepp.isEnsembleAdheringToPlacementPolicy(emptyEnsmeble, 3, 2));
        ArrayList<BookieId> ensemble = new ArrayList<BookieId>();
        ensemble.add(this.addr1.toBookieId());
        ensemble.add(this.addr2.toBookieId());
        ensemble.add(this.addr3.toBookieId());
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"PlacementPolicyAdherence", (Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL, (Object)this.zepp.isEnsembleAdheringToPlacementPolicy(ensemble, 3, 2));
        ensemble.clear();
        ensemble.add(this.addr1.toBookieId());
        ensemble.add(this.addr2.toBookieId());
        ensemble.add(this.addr4.toBookieId());
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"PlacementPolicyAdherence", (Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_SOFT, (Object)this.zepp.isEnsembleAdheringToPlacementPolicy(ensemble, 3, 2));
        ensemble.clear();
        ensemble.add(this.addr1.toBookieId());
        ensemble.add(this.addr4.toBookieId());
        ensemble.add(addr7.toBookieId());
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"PlacementPolicyAdherence", (Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT, (Object)this.zepp.isEnsembleAdheringToPlacementPolicy(ensemble, 3, 2));
        ensemble.clear();
        ensemble.add(this.addr1.toBookieId());
        ensemble.add(this.addr4.toBookieId());
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"PlacementPolicyAdherence", (Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL, (Object)this.zepp.isEnsembleAdheringToPlacementPolicy(ensemble, 2, 2));
        ensemble.clear();
        ensemble.add(this.addr2.toBookieId());
        ensemble.add(this.addr3.toBookieId());
        ensemble.add(this.addr4.toBookieId());
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"PlacementPolicyAdherence", (Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL, (Object)this.zepp.isEnsembleAdheringToPlacementPolicy(ensemble, 3, 2));
        ensemble.clear();
        ensemble.add(this.addr1.toBookieId());
        ensemble.add(this.addr4.toBookieId());
        ensemble.add(addr7.toBookieId());
        ensemble.add(addr10.toBookieId());
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"PlacementPolicyAdherence", (Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL, (Object)this.zepp.isEnsembleAdheringToPlacementPolicy(ensemble, 4, 2));
        ensemble.clear();
        ensemble.add(this.addr1.toBookieId());
        ensemble.add(this.addr4.toBookieId());
        ensemble.add(addr7.toBookieId());
        ensemble.add(addr8.toBookieId());
        ensemble.add(addr9.toBookieId());
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"PlacementPolicyAdherence", (Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT, (Object)this.zepp.isEnsembleAdheringToPlacementPolicy(ensemble, 5, 2));
        ensemble.clear();
        ensemble.add(this.addr1.toBookieId());
        ensemble.add(this.addr4.toBookieId());
        ensemble.add(addr7.toBookieId());
        ensemble.add(this.addr2.toBookieId());
        ensemble.add(addr8.toBookieId());
        ensemble.add(addr9.toBookieId());
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"PlacementPolicyAdherence", (Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL, (Object)this.zepp.isEnsembleAdheringToPlacementPolicy(ensemble, 3, 2));
        ensemble.clear();
        ensemble.add(this.addr1.toBookieId());
        ensemble.add(this.addr4.toBookieId());
        ensemble.add(addr9.toBookieId());
        ensemble.add(this.addr2.toBookieId());
        ensemble.add(addr8.toBookieId());
        ensemble.add(addr7.toBookieId());
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"PlacementPolicyAdherence", (Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL, (Object)this.zepp.isEnsembleAdheringToPlacementPolicy(ensemble, 3, 2));
        ensemble.clear();
        ensemble.add(this.addr1.toBookieId());
        ensemble.add(this.addr4.toBookieId());
        ensemble.add(addr9.toBookieId());
        ensemble.add(this.addr2.toBookieId());
        ensemble.add(addr7.toBookieId());
        ensemble.add(addr8.toBookieId());
        TestZoneawareEnsemblePlacementPolicy.assertEquals((String)"PlacementPolicyAdherence", (Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_SOFT, (Object)this.zepp.isEnsembleAdheringToPlacementPolicy(ensemble, 3, 2));
    }
}

