/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta.zk;

import java.util.Collections;
import java.util.Optional;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.meta.AbstractZkLedgerManagerFactory;
import org.apache.bookkeeper.meta.LayoutManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverTestBase;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.zookeeper.RetryPolicy;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ZKMetadataDriverBaseTest
extends ZKMetadataDriverTestBase {
    private ZKMetadataDriverBase driver;
    private RetryPolicy retryPolicy;

    @Before
    public void setup() throws Exception {
        super.setup((AbstractConfiguration<?>)new ClientConfiguration());
        this.driver = (ZKMetadataDriverBase)Mockito.mock(ZKMetadataDriverBase.class, (Answer)Mockito.CALLS_REAL_METHODS);
        this.retryPolicy = (RetryPolicy)Mockito.mock(RetryPolicy.class);
    }

    @Override
    @After
    public void teardown() {
        super.teardown();
    }

    @Test
    public void testInitialize() throws Exception {
        this.driver.initialize(this.conf, (StatsLogger)NullStatsLogger.INSTANCE, this.retryPolicy, Optional.empty());
        Assert.assertEquals((Object)"/path/to/ledgers", (Object)this.driver.ledgersRootPath);
        Assert.assertTrue((boolean)this.driver.ownZKHandle);
        String readonlyPath = "/path/to/ledgers/available/readonly";
        Assert.assertSame((Object)this.mockZkc, (Object)this.driver.zk);
        ZooKeeperClient.newBuilder();
        ((ZooKeeperClient.Builder)Mockito.verify((Object)this.mockZkBuilder, (VerificationMode)Mockito.times((int)1))).build();
        ((ZooKeeperClient)Mockito.verify((Object)this.mockZkc, (VerificationMode)Mockito.times((int)1))).exists((String)ArgumentMatchers.eq((Object)readonlyPath), ArgumentMatchers.eq((boolean)false));
        Assert.assertNotNull((Object)this.driver.layoutManager);
        Assert.assertNull((Object)this.driver.lmFactory);
        this.driver.close();
        ((ZooKeeperClient)Mockito.verify((Object)this.mockZkc, (VerificationMode)Mockito.times((int)1))).close(5000);
        Assert.assertNull((Object)this.driver.zk);
    }

    @Test
    public void testInitializeExternalZooKeeper() throws Exception {
        ZooKeeperClient anotherZk = (ZooKeeperClient)Mockito.mock(ZooKeeperClient.class);
        this.driver.initialize(this.conf, (StatsLogger)NullStatsLogger.INSTANCE, this.retryPolicy, Optional.of(anotherZk));
        Assert.assertEquals((Object)"/ledgers", (Object)this.driver.ledgersRootPath);
        Assert.assertFalse((boolean)this.driver.ownZKHandle);
        String readonlyPath = "/path/to/ledgers/available";
        Assert.assertSame((Object)anotherZk, (Object)this.driver.zk);
        ZooKeeperClient.newBuilder();
        ((ZooKeeperClient.Builder)Mockito.verify((Object)this.mockZkBuilder, (VerificationMode)Mockito.times((int)0))).build();
        ((ZooKeeperClient)Mockito.verify((Object)this.mockZkc, (VerificationMode)Mockito.times((int)0))).exists((String)ArgumentMatchers.eq((Object)readonlyPath), ArgumentMatchers.eq((boolean)false));
        Assert.assertNotNull((Object)this.driver.layoutManager);
        Assert.assertNull((Object)this.driver.lmFactory);
        this.driver.close();
        ((ZooKeeperClient)Mockito.verify((Object)this.mockZkc, (VerificationMode)Mockito.times((int)0))).close();
        Assert.assertNotNull((Object)this.driver.zk);
    }

    @Test
    public void testGetLedgerManagerFactory() throws Exception {
        this.driver.initialize(this.conf, (StatsLogger)NullStatsLogger.INSTANCE, this.retryPolicy, Optional.empty());
        MockedStatic abstractZkLedgerManagerFactoryMockedStatic = Mockito.mockStatic(AbstractZkLedgerManagerFactory.class);
        try {
            LedgerManagerFactory factory = (LedgerManagerFactory)Mockito.mock(LedgerManagerFactory.class);
            abstractZkLedgerManagerFactoryMockedStatic.when(() -> AbstractZkLedgerManagerFactory.newLedgerManagerFactory((AbstractConfiguration)((AbstractConfiguration)ArgumentMatchers.same((Object)this.conf)), (LayoutManager)((LayoutManager)ArgumentMatchers.same((Object)this.driver.layoutManager)))).thenReturn((Object)factory);
            Assert.assertSame((Object)factory, (Object)this.driver.getLedgerManagerFactory());
            Assert.assertSame((Object)factory, (Object)this.driver.lmFactory);
            AbstractZkLedgerManagerFactory.newLedgerManagerFactory((AbstractConfiguration)((AbstractConfiguration)ArgumentMatchers.same((Object)this.conf)), (LayoutManager)((LayoutManager)ArgumentMatchers.same((Object)this.driver.layoutManager)));
            this.driver.close();
            ((LedgerManagerFactory)Mockito.verify((Object)factory, (VerificationMode)Mockito.times((int)1))).close();
            Assert.assertNull((Object)this.driver.lmFactory);
        }
        finally {
            if (Collections.singletonList(abstractZkLedgerManagerFactoryMockedStatic).get(0) != null) {
                abstractZkLedgerManagerFactoryMockedStatic.close();
            }
        }
    }
}

