/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCounted;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.api.WriteFlag;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookieClient;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.MockBookies;
import org.apache.bookkeeper.util.AvailabilityOfEntriesOfLedger;
import org.apache.bookkeeper.util.ByteBufList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockBookieClient
implements BookieClient {
    static final Logger LOG = LoggerFactory.getLogger(MockBookieClient.class);
    final OrderedExecutor executor;
    final MockBookies mockBookies;
    final Set<BookieId> errorBookies = Collections.newSetFromMap(new ConcurrentHashMap());
    private Hook preReadHook = (bookie, ledgerId, entryId) -> FutureUtils.value(null);
    private Hook postReadHook = (bookie, ledgerId, entryId) -> FutureUtils.value(null);
    private Hook preWriteHook = (bookie, ledgerId, entryId) -> FutureUtils.value(null);
    private Hook postWriteHook = (bookie, ledgerId, entryId) -> FutureUtils.value(null);
    private BatchHook preBatchReadHook = (bookie, ledgerId, startEntryId, maxCount, maxSize) -> FutureUtils.value(null);
    private BatchHook postBatchReadHook = (bookie, ledgerId, startEntryId, maxCount, maxSize) -> FutureUtils.value(null);

    public MockBookieClient(OrderedExecutor executor) {
        this.executor = executor;
        this.mockBookies = new MockBookies();
    }

    public MockBookieClient(OrderedExecutor executor, MockBookies mockBookies) {
        this.executor = executor;
        this.mockBookies = mockBookies;
    }

    public void setPreReadHook(Hook hook) {
        this.preReadHook = hook;
    }

    public void setPostReadHook(Hook hook) {
        this.postReadHook = hook;
    }

    public void setPreWriteHook(Hook hook) {
        this.preWriteHook = hook;
    }

    public void setPostWriteHook(Hook hook) {
        this.postWriteHook = hook;
    }

    public void errorBookies(BookieId ... bookies) {
        this.errorBookies.addAll(Arrays.asList(bookies));
    }

    public void removeErrors(BookieId ... bookies) {
        for (BookieId b : bookies) {
            this.errorBookies.remove(b);
        }
    }

    public boolean isErrored(BookieId bookieId) {
        return this.errorBookies.contains(bookieId);
    }

    public MockBookies getMockBookies() {
        return this.mockBookies;
    }

    public List<BookieId> getFaultyBookies() {
        return Collections.emptyList();
    }

    public boolean isWritable(BookieId address, long ledgerId) {
        return true;
    }

    public long getNumPendingRequests(BookieId address, long ledgerId) {
        return 0L;
    }

    public void forceLedger(BookieId addr, long ledgerId, BookkeeperInternalCallbacks.ForceLedgerCallback cb, Object ctx) {
        this.executor.executeOrdered(ledgerId, () -> cb.forceLedgerComplete(-100, ledgerId, addr, ctx));
    }

    public void writeLac(BookieId addr, long ledgerId, byte[] masterKey, long lac, ByteBufList toSend, BookkeeperInternalCallbacks.WriteLacCallback cb, Object ctx) {
        this.executor.executeOrdered(ledgerId, () -> cb.writeLacComplete(-100, ledgerId, addr, ctx));
    }

    public void addEntry(BookieId addr, long ledgerId, byte[] masterKey, long entryId, ReferenceCounted toSend, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx, int options, boolean allowFastFail, EnumSet<WriteFlag> writeFlags) {
        toSend.retain();
        ((CompletableFuture)((CompletableFuture)this.preWriteHook.runHook(addr, ledgerId, entryId).thenComposeAsync(ignore -> {
            LOG.info("[{};L{}] write entry {}", new Object[]{addr, ledgerId, entryId});
            if (this.isErrored(addr)) {
                LOG.warn("[{};L{}] erroring write {}", new Object[]{addr, ledgerId, entryId});
                return FutureUtils.exception((Throwable)new BKException.BKWriteException());
            }
            try {
                if ((options & 2) == 2) {
                    this.mockBookies.recoveryAddEntry(addr, ledgerId, entryId, MockBookieClient.copyData(toSend));
                } else {
                    this.mockBookies.addEntry(addr, ledgerId, entryId, MockBookieClient.copyData(toSend));
                }
            }
            catch (BKException bke) {
                CompletableFuture completableFuture = FutureUtils.exception((Throwable)bke);
                return completableFuture;
            }
            finally {
                toSend.release();
            }
            return FutureUtils.value(null);
        }, (Executor)this.executor.chooseThread(ledgerId))).thenCompose(res -> this.postWriteHook.runHook(addr, ledgerId, entryId))).whenCompleteAsync((res, ex) -> {
            if (ex != null) {
                cb.writeComplete(BKException.getExceptionCode((Throwable)ex, (int)-12), ledgerId, entryId, addr, ctx);
            } else {
                cb.writeComplete(0, ledgerId, entryId, addr, ctx);
            }
        }, (Executor)this.executor.chooseThread(ledgerId));
    }

    public void readLac(BookieId addr, long ledgerId, BookkeeperInternalCallbacks.ReadLacCallback cb, Object ctx) {
        this.executor.executeOrdered(ledgerId, () -> cb.readLacComplete(-100, ledgerId, null, null, ctx));
    }

    public void readEntry(BookieId addr, long ledgerId, long entryId, BookkeeperInternalCallbacks.ReadEntryCallback cb, Object ctx, int flags, byte[] masterKey, boolean allowFastFail) {
        ((CompletableFuture)((CompletableFuture)this.preReadHook.runHook(addr, ledgerId, entryId).thenComposeAsync(res -> {
            LOG.info("[{};L{}] read entry {}", new Object[]{addr, ledgerId, entryId});
            if (this.isErrored(addr)) {
                LOG.warn("[{};L{}] erroring read {}", new Object[]{addr, ledgerId, entryId});
                return FutureUtils.exception((Throwable)new BKException.BKReadException());
            }
            try {
                ByteBuf entry = this.mockBookies.readEntry(addr, flags, ledgerId, entryId);
                return FutureUtils.value((Object)entry);
            }
            catch (BKException bke) {
                return FutureUtils.exception((Throwable)bke);
            }
        }, (Executor)this.executor.chooseThread(ledgerId))).thenCompose(buf -> this.postReadHook.runHook(addr, ledgerId, entryId).thenApply(res -> buf))).whenCompleteAsync((res, ex) -> {
            if (ex != null) {
                cb.readEntryComplete(BKException.getExceptionCode((Throwable)ex, (int)-1), ledgerId, entryId, null, ctx);
            } else {
                cb.readEntryComplete(0, ledgerId, entryId, res.slice(), ctx);
            }
        }, (Executor)this.executor.chooseThread(ledgerId));
    }

    public void batchReadEntries(BookieId addr, long ledgerId, long startEntryId, int maxCount, long maxSize, BookkeeperInternalCallbacks.BatchedReadEntryCallback cb, Object ctx, int flags, byte[] masterKey, boolean allowFastFail) {
        ((CompletableFuture)((CompletableFuture)this.preBatchReadHook.runHook(addr, ledgerId, startEntryId, maxCount, maxSize).thenComposeAsync(res -> {
            LOG.info("[{};L{}] batch read entries startEntryId:{} maxCount:{} maxSize:{}", new Object[]{addr, ledgerId, startEntryId, maxCount, maxSize});
            if (this.isErrored(addr)) {
                LOG.warn("[{};L{}] erroring batch read entries startEntryId:{} maxCount:{} maxSize:{}", new Object[]{addr, ledgerId, startEntryId, maxCount, maxSize});
                return FutureUtils.exception((Throwable)new BKException.BKReadException());
            }
            try {
                ByteBufList data = this.mockBookies.batchReadEntries(addr, flags, ledgerId, startEntryId, maxCount, maxSize);
                return FutureUtils.value((Object)data);
            }
            catch (BKException bke) {
                return FutureUtils.exception((Throwable)bke);
            }
        }, (Executor)this.executor.chooseThread(ledgerId))).thenCompose(buf -> this.postBatchReadHook.runHook(addr, ledgerId, startEntryId, maxCount, maxSize).thenApply(res -> buf))).whenCompleteAsync((res, ex) -> {
            if (ex != null) {
                cb.readEntriesComplete(BKException.getExceptionCode((Throwable)ex, (int)-1), ledgerId, startEntryId, null, ctx);
            } else {
                cb.readEntriesComplete(0, ledgerId, startEntryId, res, ctx);
            }
        }, (Executor)this.executor.chooseThread(ledgerId));
    }

    public void readEntryWaitForLACUpdate(BookieId addr, long ledgerId, long entryId, long previousLAC, long timeOutInMillis, boolean piggyBackEntry, BookkeeperInternalCallbacks.ReadEntryCallback cb, Object ctx) {
        this.executor.executeOrdered(ledgerId, () -> cb.readEntryComplete(-100, ledgerId, entryId, null, ctx));
    }

    public void getBookieInfo(BookieId addr, long requested, BookkeeperInternalCallbacks.GetBookieInfoCallback cb, Object ctx) {
        this.executor.executeOrdered((Object)addr, () -> cb.getBookieInfoComplete(-100, null, ctx));
    }

    public CompletableFuture<AvailabilityOfEntriesOfLedger> getListOfEntriesOfLedger(BookieId address, long ledgerId) {
        BookkeeperInternalCallbacks.FutureGetListOfEntriesOfLedger futureResult = new BookkeeperInternalCallbacks.FutureGetListOfEntriesOfLedger(ledgerId);
        this.executor.executeOrdered((Object)address, () -> futureResult.completeExceptionally(BKException.create((int)-100).fillInStackTrace()));
        return futureResult;
    }

    public boolean isClosed() {
        return false;
    }

    public void close() {
    }

    public static ByteBuf copyData(ReferenceCounted rc) {
        ByteBuf res = rc instanceof ByteBuf ? Unpooled.copiedBuffer((ByteBuf)((ByteBuf)rc)) : ByteBufList.coalesce((ByteBufList)((ByteBufList)rc));
        return res;
    }

    public static ByteBuf copyDataWithSkipHeader(ReferenceCounted rc) {
        ByteBuf res = rc instanceof ByteBuf ? Unpooled.copiedBuffer((ByteBuf)((ByteBuf)rc)) : ByteBufList.coalesce((ByteBufList)((ByteBufList)rc));
        res.skipBytes(28);
        rc.release();
        return res;
    }

    public OrderedExecutor getExecutor() {
        return this.executor;
    }

    public static interface BatchHook {
        public CompletableFuture<Void> runHook(BookieId var1, long var2, long var4, int var6, long var7);
    }

    public static interface Hook {
        public CompletableFuture<Void> runHook(BookieId var1, long var2, long var4);
    }
}

