/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import com.google.protobuf.ByteString;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.proto.BookieRequestHandler;
import org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.proto.RequestUtils;
import org.apache.bookkeeper.proto.WriteEntryProcessorV3;
import org.apache.bookkeeper.proto.WriteLacProcessorV3;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestBookieRequestProcessor {
    final BookieRequestProcessor requestProcessor = (BookieRequestProcessor)Mockito.mock(BookieRequestProcessor.class);
    private final ChannelGroup channelGroup = new DefaultChannelGroup(null);

    @Test
    public void testConstructLongPollThreads() throws Exception {
        ServerConfiguration conf = new ServerConfiguration();
        try (BookieRequestProcessor processor = new BookieRequestProcessor(conf, (Bookie)Mockito.mock(Bookie.class), (StatsLogger)NullStatsLogger.INSTANCE, null, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, this.channelGroup);){
            Assert.assertSame((Object)processor.getReadThreadPool(), (Object)processor.getLongPollThreadPool());
        }
        conf = new ServerConfiguration();
        conf.setNumReadWorkerThreads(0);
        processor = new BookieRequestProcessor(conf, (Bookie)Mockito.mock(Bookie.class), (StatsLogger)NullStatsLogger.INSTANCE, null, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, this.channelGroup);
        var3_3 = null;
        try {
            Assert.assertNull((Object)processor.getReadThreadPool());
            Assert.assertNotNull((Object)processor.getLongPollThreadPool());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (processor != null) {
                if (var3_3 != null) {
                    try {
                        processor.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    processor.close();
                }
            }
        }
        conf = new ServerConfiguration();
        conf.setNumReadWorkerThreads(2);
        conf.setNumLongPollWorkerThreads(2);
        processor = new BookieRequestProcessor(conf, (Bookie)Mockito.mock(Bookie.class), (StatsLogger)NullStatsLogger.INSTANCE, null, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, this.channelGroup);
        var3_3 = null;
        try {
            Assert.assertNotNull((Object)processor.getReadThreadPool());
            Assert.assertNotNull((Object)processor.getLongPollThreadPool());
            Assert.assertNotSame((Object)processor.getReadThreadPool(), (Object)processor.getLongPollThreadPool());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (processor != null) {
                if (var3_3 != null) {
                    try {
                        processor.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    processor.close();
                }
            }
        }
    }

    @Test
    public void testFlagsV3() {
        BookkeeperProtocol.ReadRequest read = BookkeeperProtocol.ReadRequest.newBuilder().setLedgerId(10L).setEntryId(1L).setFlag(BookkeeperProtocol.ReadRequest.Flag.FENCE_LEDGER).build();
        Assert.assertTrue((boolean)RequestUtils.hasFlag((BookkeeperProtocol.ReadRequest)read, (BookkeeperProtocol.ReadRequest.Flag)BookkeeperProtocol.ReadRequest.Flag.FENCE_LEDGER));
        Assert.assertFalse((boolean)RequestUtils.hasFlag((BookkeeperProtocol.ReadRequest)read, (BookkeeperProtocol.ReadRequest.Flag)BookkeeperProtocol.ReadRequest.Flag.ENTRY_PIGGYBACK));
        read = BookkeeperProtocol.ReadRequest.newBuilder().setLedgerId(10L).setEntryId(1L).setFlag(BookkeeperProtocol.ReadRequest.Flag.ENTRY_PIGGYBACK).build();
        Assert.assertFalse((boolean)RequestUtils.hasFlag((BookkeeperProtocol.ReadRequest)read, (BookkeeperProtocol.ReadRequest.Flag)BookkeeperProtocol.ReadRequest.Flag.FENCE_LEDGER));
        Assert.assertTrue((boolean)RequestUtils.hasFlag((BookkeeperProtocol.ReadRequest)read, (BookkeeperProtocol.ReadRequest.Flag)BookkeeperProtocol.ReadRequest.Flag.ENTRY_PIGGYBACK));
        read = BookkeeperProtocol.ReadRequest.newBuilder().setLedgerId(10L).setEntryId(1L).build();
        Assert.assertFalse((boolean)RequestUtils.hasFlag((BookkeeperProtocol.ReadRequest)read, (BookkeeperProtocol.ReadRequest.Flag)BookkeeperProtocol.ReadRequest.Flag.FENCE_LEDGER));
        Assert.assertFalse((boolean)RequestUtils.hasFlag((BookkeeperProtocol.ReadRequest)read, (BookkeeperProtocol.ReadRequest.Flag)BookkeeperProtocol.ReadRequest.Flag.ENTRY_PIGGYBACK));
        BookkeeperProtocol.AddRequest add = BookkeeperProtocol.AddRequest.newBuilder().setLedgerId(10L).setEntryId(1L).setFlag(BookkeeperProtocol.AddRequest.Flag.RECOVERY_ADD).setMasterKey(ByteString.EMPTY).setBody(ByteString.EMPTY).build();
        Assert.assertTrue((boolean)RequestUtils.hasFlag((BookkeeperProtocol.AddRequest)add, (BookkeeperProtocol.AddRequest.Flag)BookkeeperProtocol.AddRequest.Flag.RECOVERY_ADD));
        add = BookkeeperProtocol.AddRequest.newBuilder().setLedgerId(10L).setEntryId(1L).setMasterKey(ByteString.EMPTY).setBody(ByteString.EMPTY).build();
        Assert.assertFalse((boolean)RequestUtils.hasFlag((BookkeeperProtocol.AddRequest)add, (BookkeeperProtocol.AddRequest.Flag)BookkeeperProtocol.AddRequest.Flag.RECOVERY_ADD));
        add = BookkeeperProtocol.AddRequest.newBuilder().setLedgerId(10L).setEntryId(1L).setFlag(BookkeeperProtocol.AddRequest.Flag.RECOVERY_ADD).setMasterKey(ByteString.EMPTY).setBody(ByteString.EMPTY).build();
        Assert.assertTrue((boolean)RequestUtils.hasFlag((BookkeeperProtocol.AddRequest)add, (BookkeeperProtocol.AddRequest.Flag)BookkeeperProtocol.AddRequest.Flag.RECOVERY_ADD));
    }

    @Test
    public void testToString() {
        BookkeeperProtocol.BKPacketHeader.Builder headerBuilder = BookkeeperProtocol.BKPacketHeader.newBuilder();
        headerBuilder.setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE);
        headerBuilder.setOperation(BookkeeperProtocol.OperationType.ADD_ENTRY);
        headerBuilder.setTxnId(5L);
        BookkeeperProtocol.BKPacketHeader header = headerBuilder.build();
        BookkeeperProtocol.AddRequest addRequest = BookkeeperProtocol.AddRequest.newBuilder().setLedgerId(10L).setEntryId(1L).setMasterKey(ByteString.copyFrom((byte[])"masterKey".getBytes())).setBody(ByteString.copyFrom((byte[])"entrydata".getBytes())).build();
        BookkeeperProtocol.Request request = BookkeeperProtocol.Request.newBuilder().setHeader(header).setAddRequest(addRequest).build();
        Channel channel = (Channel)Mockito.mock(Channel.class);
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Mockito.when((Object)ctx.channel()).thenReturn((Object)channel);
        BookieRequestHandler requestHandler = (BookieRequestHandler)Mockito.mock(BookieRequestHandler.class);
        Mockito.when((Object)requestHandler.ctx()).thenReturn((Object)ctx);
        WriteEntryProcessorV3 writeEntryProcessorV3 = new WriteEntryProcessorV3(request, requestHandler, this.requestProcessor);
        String toString = writeEntryProcessorV3.toString();
        Assert.assertFalse((String)"writeEntryProcessorV3's toString should have filtered out body", (boolean)toString.contains("body"));
        Assert.assertFalse((String)"writeEntryProcessorV3's toString should have filtered out masterKey", (boolean)toString.contains("masterKey"));
        Assert.assertTrue((String)"writeEntryProcessorV3's toString should contain ledgerId", (boolean)toString.contains("ledgerId"));
        Assert.assertTrue((String)"writeEntryProcessorV3's toString should contain entryId", (boolean)toString.contains("entryId"));
        Assert.assertTrue((String)"writeEntryProcessorV3's toString should contain version", (boolean)toString.contains("version"));
        Assert.assertTrue((String)"writeEntryProcessorV3's toString should contain operation", (boolean)toString.contains("operation"));
        Assert.assertTrue((String)"writeEntryProcessorV3's toString should contain txnId", (boolean)toString.contains("txnId"));
        Assert.assertFalse((String)"writeEntryProcessorV3's toString shouldn't contain flag", (boolean)toString.contains("flag"));
        Assert.assertFalse((String)"writeEntryProcessorV3's toString shouldn't contain writeFlags", (boolean)toString.contains("writeFlags"));
        addRequest = BookkeeperProtocol.AddRequest.newBuilder().setLedgerId(10L).setEntryId(1L).setMasterKey(ByteString.copyFrom((byte[])"masterKey".getBytes())).setBody(ByteString.copyFrom((byte[])"entrydata".getBytes())).setFlag(BookkeeperProtocol.AddRequest.Flag.RECOVERY_ADD).setWriteFlags(0).build();
        request = BookkeeperProtocol.Request.newBuilder().setHeader(header).setAddRequest(addRequest).build();
        writeEntryProcessorV3 = new WriteEntryProcessorV3(request, requestHandler, this.requestProcessor);
        toString = writeEntryProcessorV3.toString();
        Assert.assertFalse((String)"writeEntryProcessorV3's toString should have filtered out body", (boolean)toString.contains("body"));
        Assert.assertFalse((String)"writeEntryProcessorV3's toString should have filtered out masterKey", (boolean)toString.contains("masterKey"));
        Assert.assertTrue((String)"writeEntryProcessorV3's toString should contain flag", (boolean)toString.contains("flag"));
        Assert.assertTrue((String)"writeEntryProcessorV3's toString should contain writeFlags", (boolean)toString.contains("writeFlags"));
        BookkeeperProtocol.ReadRequest readRequest = BookkeeperProtocol.ReadRequest.newBuilder().setLedgerId(10L).setEntryId(23L).setMasterKey(ByteString.copyFrom((byte[])"masterKey".getBytes())).build();
        request = BookkeeperProtocol.Request.newBuilder().setHeader(header).setReadRequest(readRequest).build();
        toString = RequestUtils.toSafeString((BookkeeperProtocol.Request)request);
        Assert.assertFalse((String)"ReadRequest's safeString should have filtered out masterKey", (boolean)toString.contains("masterKey"));
        Assert.assertTrue((String)"ReadRequest's safeString should contain ledgerId", (boolean)toString.contains("ledgerId"));
        Assert.assertTrue((String)"ReadRequest's safeString should contain entryId", (boolean)toString.contains("entryId"));
        Assert.assertTrue((String)"ReadRequest's safeString should contain version", (boolean)toString.contains("version"));
        Assert.assertTrue((String)"ReadRequest's safeString should contain operation", (boolean)toString.contains("operation"));
        Assert.assertTrue((String)"ReadRequest's safeString should contain txnId", (boolean)toString.contains("txnId"));
        Assert.assertFalse((String)"ReadRequest's safeString shouldn't contain flag", (boolean)toString.contains("flag"));
        Assert.assertFalse((String)"ReadRequest's safeString shouldn't contain previousLAC", (boolean)toString.contains("previousLAC"));
        Assert.assertFalse((String)"ReadRequest's safeString shouldn't contain timeOut", (boolean)toString.contains("timeOut"));
        readRequest = BookkeeperProtocol.ReadRequest.newBuilder().setLedgerId(10L).setEntryId(23L).setPreviousLAC(2L).setTimeOut(100L).setMasterKey(ByteString.copyFrom((byte[])"masterKey".getBytes())).setFlag(BookkeeperProtocol.ReadRequest.Flag.ENTRY_PIGGYBACK).build();
        request = BookkeeperProtocol.Request.newBuilder().setHeader(header).setReadRequest(readRequest).build();
        toString = RequestUtils.toSafeString((BookkeeperProtocol.Request)request);
        Assert.assertFalse((String)"ReadRequest's safeString should have filtered out masterKey", (boolean)toString.contains("masterKey"));
        Assert.assertTrue((String)"ReadRequest's safeString shouldn contain flag", (boolean)toString.contains("flag"));
        Assert.assertTrue((String)"ReadRequest's safeString shouldn contain previousLAC", (boolean)toString.contains("previousLAC"));
        Assert.assertTrue((String)"ReadRequest's safeString shouldn contain timeOut", (boolean)toString.contains("timeOut"));
        BookkeeperProtocol.WriteLacRequest writeLacRequest = BookkeeperProtocol.WriteLacRequest.newBuilder().setLedgerId(10L).setLac(23L).setMasterKey(ByteString.copyFrom((byte[])"masterKey".getBytes())).setBody(ByteString.copyFrom((byte[])"entrydata".getBytes())).build();
        request = BookkeeperProtocol.Request.newBuilder().setHeader(header).setWriteLacRequest(writeLacRequest).build();
        WriteLacProcessorV3 writeLacProcessorV3 = new WriteLacProcessorV3(request, null, this.requestProcessor);
        toString = writeLacProcessorV3.toString();
        Assert.assertFalse((String)"writeLacProcessorV3's toString should have filtered out body", (boolean)toString.contains("body"));
        Assert.assertFalse((String)"writeLacProcessorV3's toString should have filtered out masterKey", (boolean)toString.contains("masterKey"));
        Assert.assertTrue((String)"writeLacProcessorV3's toString should contain ledgerId", (boolean)toString.contains("ledgerId"));
        Assert.assertTrue((String)"writeLacProcessorV3's toString should contain lac", (boolean)toString.contains("lac"));
        Assert.assertTrue((String)"writeLacProcessorV3's toString should contain version", (boolean)toString.contains("version"));
        Assert.assertTrue((String)"writeLacProcessorV3's toString should contain operation", (boolean)toString.contains("operation"));
        Assert.assertTrue((String)"writeLacProcessorV3's toString should contain txnId", (boolean)toString.contains("txnId"));
    }
}

