/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto.checksum;

import com.scurrilous.circe.checksum.IntHash;
import com.scurrilous.circe.checksum.Java8IntHash;
import com.scurrilous.circe.checksum.Java9IntHash;
import com.scurrilous.circe.checksum.JniIntHash;
import com.scurrilous.circe.crc.Sse42Crc32C;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCounted;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.bookkeeper.proto.checksum.DigestManager;
import org.apache.bookkeeper.proto.checksum.MacDigestManager;
import org.apache.bookkeeper.util.ByteBufList;
import org.apache.bookkeeper.util.ByteBufVisitor;
import org.apache.commons.lang3.RandomUtils;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompositeByteBufUnwrapBugReproduceTest {
    final byte[] testPayLoad;
    final int defaultBufferPrefixLength;
    private final boolean useV2Protocol;
    private static final int RUN_SINGLE_SCENARIO_FOR_DEBUGGING = -1;

    @Parameterized.Parameters
    public static Collection<Object[]> testScenarios() {
        List<Object[]> scenarios = Arrays.asList({16383, true}, {16383, false}, {16384, true}, {16384, false});
        return scenarios;
    }

    public CompositeByteBufUnwrapBugReproduceTest(int payloadSize, boolean useV2Protocol) {
        this.testPayLoad = CompositeByteBufUnwrapBugReproduceTest.createTestPayLoad(payloadSize);
        this.defaultBufferPrefixLength = payloadSize / 7;
        this.useV2Protocol = useV2Protocol;
    }

    private static byte[] createTestPayLoad(int payloadSize) {
        byte[] payload = new byte[payloadSize];
        for (int i = 0; i < payloadSize; ++i) {
            payload[i] = (byte)i;
        }
        return payload;
    }

    @Test
    public void shouldCalculateChecksumForCompositeBuffer() {
        ByteBuf testPayload = Unpooled.wrappedBuffer((byte[])this.testPayLoad);
        byte[] referenceOutput = this.computeDigestAndPackageForSending((IntHash)new Java8IntHash(), testPayload.retainedDuplicate());
        this.assertDigestAndPackageMatchesReference((IntHash)new Java8IntHash(), testPayload, referenceOutput);
        this.assertDigestAndPackageMatchesReference((IntHash)new Java9IntHash(), testPayload, referenceOutput);
        if (Sse42Crc32C.isSupported()) {
            this.assertDigestAndPackageMatchesReference((IntHash)new JniIntHash(), testPayload, referenceOutput);
        }
        testPayload.release();
    }

    private void assertDigestAndPackageMatchesReference(IntHash intHash, ByteBuf payload, byte[] referenceOutput) {
        this.assertDigestAndPackageScenario(intHash, payload.retainedDuplicate(), referenceOutput, this.testPayLoad, "plain payload, no wrapping");
        ByteBuf payload2 = this.wrapWithPrefixAndCompositeByteBufWithReaderIndexState(payload.retainedDuplicate(), this.defaultBufferPrefixLength);
        this.assertDigestAndPackageScenario(intHash, payload2, referenceOutput, this.testPayLoad, "payload with prefix wrapped in CompositeByteBuf with readerIndex state");
        ByteBuf payload3 = this.wrapWithPrefixAndMultipleCompositeByteBufWithReaderIndexStateAndMultipleLayersOfDuplicate(payload.retainedDuplicate(), this.defaultBufferPrefixLength);
        this.assertDigestAndPackageScenario(intHash, payload3, referenceOutput, this.testPayLoad, "payload with prefix wrapped in 2 layers of CompositeByteBuf with readerIndex state in the outer composite. In addition, the outer composite is duplicated twice.");
        ByteBuf payload4 = this.wrapInCompositeByteBufAndSlice(payload.retainedDuplicate(), this.defaultBufferPrefixLength);
        this.assertDigestAndPackageScenario(intHash, payload4, referenceOutput, this.testPayLoad, "payload with prefix wrapped in CompositeByteBuf and sliced");
    }

    private void assertDigestAndPackageScenario(IntHash intHash, ByteBuf payload, byte[] referenceOutput, byte[] testPayLoadArray, String scenario) {
        Assertions.assertArrayEquals((byte[])testPayLoadArray, (byte[])ByteBufUtil.getBytes((ByteBuf)payload.duplicate()), (String)("input is invalid for scenario '" + scenario + "'"));
        final ByteBuf visitedCopy = Unpooled.buffer((int)payload.readableBytes());
        ByteBufVisitor.visitBuffers((ByteBuf)payload, (int)payload.readerIndex(), (int)payload.readableBytes(), (ByteBufVisitor.ByteBufVisitorCallback)new ByteBufVisitor.ByteBufVisitorCallback<Void>(){

            public void visitBuffer(Void context, ByteBuf visitBuffer, int visitIndex, int visitLength) {
                visitedCopy.writeBytes(visitBuffer, visitIndex, visitLength);
            }

            public void visitArray(Void context, byte[] visitArray, int visitIndex, int visitLength) {
                visitedCopy.writeBytes(visitArray, visitIndex, visitLength);
            }
        }, null);
        Assertions.assertArrayEquals((byte[])ByteBufUtil.getBytes((ByteBuf)visitedCopy), (byte[])testPayLoadArray, (String)("visited copy is invalid for scenario '" + scenario + "'. Bug in ByteBufVisitor?"));
        byte[] output = this.computeDigestAndPackageForSending(intHash, payload.duplicate());
        if (referenceOutput == null) {
            referenceOutput = this.computeDigestAndPackageForSending((IntHash)new Java8IntHash(), Unpooled.wrappedBuffer((byte[])testPayLoadArray));
        }
        Assertions.assertArrayEquals((byte[])referenceOutput, (byte[])output, (String)("output is invalid for scenario '" + scenario + "'"));
    }

    private byte[] computeDigestAndPackageForSending(IntHash intHash, ByteBuf data) {
        TestIntHashDigestManager digestManager = new TestIntHashDigestManager(intHash, 1L, this.useV2Protocol, ByteBufAllocator.DEFAULT);
        ReferenceCounted packagedBuffer = digestManager.computeDigestAndPackageForSending(1L, 0L, data.readableBytes(), data, MacDigestManager.EMPTY_LEDGER_KEY, 0);
        return CompositeByteBufUnwrapBugReproduceTest.packagedBufferToBytes(packagedBuffer);
    }

    ByteBuf wrapWithPrefixAndCompositeByteBufWithReaderIndexState(ByteBuf payload, int bufferPrefixLength) {
        ByteBuf prefixedPayload = ByteBufAllocator.DEFAULT.buffer(bufferPrefixLength + payload.readableBytes());
        prefixedPayload.writeBytes(RandomUtils.nextBytes((int)bufferPrefixLength));
        prefixedPayload.writeBytes(payload);
        CompositeByteBuf outerComposite = ByteBufAllocator.DEFAULT.compositeBuffer();
        outerComposite.addComponent(true, prefixedPayload);
        outerComposite.readerIndex(bufferPrefixLength);
        return outerComposite;
    }

    ByteBuf wrapWithPrefixAndMultipleCompositeByteBufWithReaderIndexStateAndMultipleLayersOfDuplicate(ByteBuf payload, int bufferPrefixLength) {
        ByteBuf prefixedPayload = ByteBufAllocator.DEFAULT.buffer(bufferPrefixLength + payload.readableBytes());
        prefixedPayload.writeBytes(RandomUtils.nextBytes((int)bufferPrefixLength));
        prefixedPayload.writeBytes(payload);
        CompositeByteBuf innerComposite = ByteBufAllocator.DEFAULT.compositeBuffer();
        innerComposite.addComponent(true, prefixedPayload);
        innerComposite.addComponent(true, Unpooled.EMPTY_BUFFER);
        CompositeByteBuf outerComposite = ByteBufAllocator.DEFAULT.compositeBuffer();
        outerComposite.addComponent(true, (ByteBuf)innerComposite);
        outerComposite.addComponent(true, Unpooled.EMPTY_BUFFER);
        outerComposite.readerIndex(bufferPrefixLength);
        return outerComposite.duplicate().duplicate();
    }

    ByteBuf wrapInCompositeByteBufAndSlice(ByteBuf payload, int bufferPrefixLength) {
        CompositeByteBuf compositeWithPrefix = ByteBufAllocator.DEFAULT.compositeBuffer();
        compositeWithPrefix.addComponent(true, Unpooled.wrappedBuffer((byte[])RandomUtils.nextBytes((int)bufferPrefixLength)));
        compositeWithPrefix.addComponent(true, payload);
        return compositeWithPrefix.slice(bufferPrefixLength, payload.readableBytes());
    }

    private static byte[] packagedBufferToBytes(ReferenceCounted packagedBuffer) {
        byte[] output;
        if (packagedBuffer instanceof ByteBufList) {
            ByteBufList bufList = (ByteBufList)packagedBuffer;
            output = new byte[bufList.readableBytes()];
            bufList.getBytes(output);
            for (int i = 0; i < bufList.size(); ++i) {
                bufList.getBuffer(i).release();
            }
        } else if (packagedBuffer instanceof ByteBuf) {
            output = ByteBufUtil.getBytes((ByteBuf)((ByteBuf)packagedBuffer));
            packagedBuffer.release();
        } else {
            throw new RuntimeException("Unexpected type: " + packagedBuffer.getClass());
        }
        return output;
    }

    static class TestIntHashDigestManager
    extends DigestManager {
        private final IntHash intHash;

        public TestIntHashDigestManager(IntHash intHash, long ledgerId, boolean useV2Protocol, ByteBufAllocator allocator) {
            super(ledgerId, useV2Protocol, allocator);
            this.intHash = intHash;
        }

        int getMacCodeLength() {
            return 4;
        }

        boolean isInt32Digest() {
            return true;
        }

        void populateValueAndReset(int digest, ByteBuf buf) {
            buf.writeInt(digest);
        }

        int internalUpdate(int digest, ByteBuf data, int offset, int len) {
            return this.intHash.resume(digest, data, offset, len);
        }

        int internalUpdate(int digest, byte[] buffer, int offset, int len) {
            return this.intHash.resume(digest, buffer, offset, len);
        }

        boolean acceptsMemoryAddressBuffer() {
            return this.intHash.acceptsMemoryAddressBuffer();
        }
    }
}

