/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Sets;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.replication.AuditorBookieCheckTask;
import org.apache.bookkeeper.replication.AuditorStats;
import org.apache.bookkeeper.replication.AuditorTask;
import org.apache.bookkeeper.replication.BookieLedgerIndexer;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.TestStatsProvider;
import org.apache.bookkeeper.versioning.LongVersion;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AuditorBookieCheckTaskTest {
    private AuditorStats auditorStats;
    private BookKeeperAdmin admin;
    private LedgerManager ledgerManager;
    private LedgerUnderreplicationManager underreplicationManager;
    private BookieLedgerIndexer ledgerIndexer;
    private AuditorBookieCheckTask bookieCheckTask;
    private final AtomicBoolean shutdownCompleted = new AtomicBoolean(false);
    private final AuditorTask.ShutdownTaskHandler shutdownTaskHandler = () -> this.shutdownCompleted.set(true);
    private long startLedgerId = 0L;

    @Before
    public void setup() {
        ServerConfiguration conf = (ServerConfiguration)Mockito.mock(ServerConfiguration.class);
        TestStatsProvider statsProvider = new TestStatsProvider();
        TestStatsProvider.TestStatsLogger statsLogger = statsProvider.getStatsLogger("auditor");
        AuditorStats auditorStats = new AuditorStats((StatsLogger)statsLogger);
        this.auditorStats = (AuditorStats)Mockito.spy((Object)auditorStats);
        this.admin = (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class);
        this.ledgerManager = (LedgerManager)Mockito.mock(LedgerManager.class);
        this.underreplicationManager = (LedgerUnderreplicationManager)Mockito.mock(LedgerUnderreplicationManager.class);
        this.ledgerIndexer = (BookieLedgerIndexer)Mockito.mock(BookieLedgerIndexer.class);
        AuditorBookieCheckTask bookieCheckTask1 = new AuditorBookieCheckTask(conf, this.auditorStats, this.admin, this.ledgerManager, this.underreplicationManager, this.shutdownTaskHandler, this.ledgerIndexer, null, null);
        this.bookieCheckTask = (AuditorBookieCheckTask)Mockito.spy((Object)bookieCheckTask1);
    }

    @Test
    public void testShutdownAuditBookiesException() throws BKException, ReplicationException.BKAuditException, InterruptedException {
        ((AuditorBookieCheckTask)Mockito.doThrow((Throwable[])new Throwable[]{new ReplicationException.BKAuditException("test failed")}).when((Object)this.bookieCheckTask)).auditBookies();
        this.bookieCheckTask.startAudit(true);
        Assert.assertTrue((String)"shutdownTaskHandler should be execute.", (boolean)this.shutdownCompleted.get());
    }

    @Test
    public void testAuditBookies() throws ReplicationException.UnavailableException, ReplicationException.BKAuditException, BKException {
        String bookieId1 = "127.0.0.1:1000";
        String bookieId2 = "127.0.0.1:1001";
        long bookie1LedgersCount = 10L;
        long bookie2LedgersCount = 20L;
        HashMap bookiesAndLedgers = Maps.newHashMap();
        bookiesAndLedgers.put("127.0.0.1:1000", this.getLedgers(10L));
        bookiesAndLedgers.put("127.0.0.1:1001", this.getLedgers(20L));
        Mockito.when((Object)this.ledgerIndexer.getBookieToLedgerIndex()).thenReturn((Object)bookiesAndLedgers);
        Mockito.when((Object)this.underreplicationManager.isLedgerReplicationEnabled()).thenReturn((Object)true);
        CompletableFuture<Versioned> metaPromise = new CompletableFuture<Versioned>();
        LongVersion version = (LongVersion)Mockito.mock(LongVersion.class);
        LedgerMetadata metadata = (LedgerMetadata)Mockito.mock(LedgerMetadata.class);
        metaPromise.complete(new Versioned((Object)metadata, (Version)version));
        Mockito.when((Object)this.ledgerManager.readLedgerMetadata(ArgumentMatchers.anyLong())).thenReturn(metaPromise);
        CompletableFuture<Object> markPromise = new CompletableFuture<Object>();
        markPromise.complete(null);
        Mockito.when((Object)this.underreplicationManager.markLedgerUnderreplicatedAsync(ArgumentMatchers.anyLong(), ArgumentMatchers.anyCollection())).thenReturn(markPromise);
        OpStatsLogger numUnderReplicatedLedgerStats = (OpStatsLogger)Mockito.mock(OpStatsLogger.class);
        Mockito.when((Object)this.auditorStats.getNumUnderReplicatedLedger()).thenReturn((Object)numUnderReplicatedLedgerStats);
        List availableBookies = Lists.newArrayList();
        List readOnlyBookies = Lists.newArrayList();
        availableBookies.add(BookieId.parse((String)"127.0.0.1:1001"));
        Mockito.when((Object)this.admin.getAvailableBookies()).thenReturn((Object)availableBookies);
        Mockito.when((Object)this.admin.getReadOnlyBookies()).thenReturn((Object)readOnlyBookies);
        this.bookieCheckTask.startAudit(true);
        ((OpStatsLogger)Mockito.verify((Object)numUnderReplicatedLedgerStats, (VerificationMode)Mockito.times((int)1))).registerSuccessfulValue(ArgumentMatchers.eq((long)10L));
        numUnderReplicatedLedgerStats = (OpStatsLogger)Mockito.mock(OpStatsLogger.class);
        Mockito.when((Object)this.auditorStats.getNumUnderReplicatedLedger()).thenReturn((Object)numUnderReplicatedLedgerStats);
        availableBookies.clear();
        availableBookies.add(BookieId.parse((String)"127.0.0.1:1000"));
        this.bookieCheckTask.startAudit(true);
        ((OpStatsLogger)Mockito.verify((Object)numUnderReplicatedLedgerStats, (VerificationMode)Mockito.times((int)1))).registerSuccessfulValue(ArgumentMatchers.eq((long)20L));
    }

    private Set<Long> getLedgers(long count) {
        Set ledgers = Sets.newHashSet();
        int i = 0;
        while ((long)i < count) {
            ledgers.add((long)i + this.startLedgerId++);
            ++i;
        }
        return ledgers;
    }
}

