/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import io.netty.util.HashedWheelTimer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperTestClient;
import org.apache.bookkeeper.client.ClientUtil;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.ZoneawareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.meta.AbstractZkLedgerManager;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.bookkeeper.meta.MetadataClientDriver;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.meta.ZkLedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.bookkeeper.proto.BookieAddressResolver;
import org.apache.bookkeeper.replication.Auditor;
import org.apache.bookkeeper.replication.AuditorPeriodicCheckTest;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.replication.ReplicationTestUtil;
import org.apache.bookkeeper.replication.ReplicationWorker;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.test.TestStatsProvider;
import org.apache.bookkeeper.util.StaticDNSResolver;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.bookkeeper.zookeeper.BoundExponentialBackoffRetryPolicy;
import org.apache.bookkeeper.zookeeper.RetryPolicy;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.bookkeeper.zookeeper.ZooKeeperWatcherBase;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestReplicationWorker
extends BookKeeperClusterTestCase {
    private static final byte[] TESTPASSWD = "testpasswd".getBytes();
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationWorker.class);
    private String basePath = "";
    private String baseLockPath = "";
    private MetadataBookieDriver driver;
    private LedgerManagerFactory mFactory;
    private LedgerUnderreplicationManager underReplicationManager;
    private LedgerManager ledgerManager;
    private static byte[] data = "TestReplicationWorker".getBytes();
    private OrderedScheduler scheduler;
    private String zkLedgersRootPath;

    public TestReplicationWorker() {
        this("org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory");
    }

    TestReplicationWorker(String ledgerManagerFactory) {
        super(3, 300);
        LOG.info("Running test case using ledger manager : " + ledgerManagerFactory);
        this.baseConf.setLedgerManagerFactoryClassName(ledgerManagerFactory);
        this.baseClientConf.setLedgerManagerFactoryClassName(ledgerManagerFactory);
        this.baseConf.setRereplicationEntryBatchSize(3L);
        this.baseConf.setZkTimeout(7000);
        this.baseConf.setZkRetryBackoffMaxMs(500);
        this.baseConf.setZkRetryBackoffStartMs(10);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.zkLedgersRootPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)this.baseClientConf);
        this.basePath = this.zkLedgersRootPath + '/' + "underreplication" + "/ledgers";
        this.baseLockPath = this.zkLedgersRootPath + '/' + "underreplication" + "/locks";
        this.scheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().name("test-scheduler").numThreads(1).build();
        this.driver = MetadataDrivers.getBookieDriver((URI)URI.create(this.baseConf.getMetadataServiceUri()));
        this.driver.initialize(this.baseConf, (StatsLogger)NullStatsLogger.INSTANCE);
        this.mFactory = this.driver.getLedgerManagerFactory();
        this.ledgerManager = this.mFactory.newLedgerManager();
        this.underReplicationManager = this.mFactory.newLedgerUnderreplicationManager();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        if (null != this.underReplicationManager) {
            this.underReplicationManager.close();
            this.underReplicationManager = null;
        }
        if (null != this.driver) {
            this.driver.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRWShouldReplicateFragmentsToTargetBookie() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(3, 3, BookKeeper.DigestType.CRC32, TESTPASSWD);
        for (int i = 0; i < 10; ++i) {
            lh.addEntry(data);
        }
        BookieId replicaToKill = (BookieId)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).get(0);
        LOG.info("Killing Bookie : {}", (Object)replicaToKill);
        this.killBookie(replicaToKill);
        BookieId newBkAddr = this.startNewBookieAndReturnBookieId();
        LOG.info("New Bookie addr : {}", (Object)newBkAddr);
        for (int i = 0; i < 10; ++i) {
            lh.addEntry(data);
        }
        ReplicationWorker rw = new ReplicationWorker(this.baseConf);
        rw.start();
        try {
            this.underReplicationManager.markLedgerUnderreplicated(lh.getId(), replicaToKill.toString());
            while (ReplicationTestUtil.isLedgerInUnderReplication(this.zkc, lh.getId(), this.basePath)) {
                Thread.sleep(100L);
            }
            this.killAllBookies(lh, newBkAddr);
            this.verifyRecoveredLedgers(lh, 0L, 9L);
        }
        finally {
            rw.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRWShouldRetryUntilThereAreEnoughBksAvailableForReplication() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(1, 1, BookKeeper.DigestType.CRC32, TESTPASSWD);
        for (int i = 0; i < 10; ++i) {
            lh.addEntry(data);
        }
        lh.close();
        BookieId replicaToKill = (BookieId)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).get(0);
        LOG.info("Killing Bookie : {}", (Object)replicaToKill);
        ServerConfiguration killedBookieConfig = this.killBookie(replicaToKill);
        BookieId newBkAddr = this.startNewBookieAndReturnBookieId();
        LOG.info("New Bookie addr :" + newBkAddr);
        this.killAllBookies(lh, newBkAddr);
        ReplicationWorker rw = new ReplicationWorker(this.baseConf);
        rw.start();
        try {
            this.underReplicationManager.markLedgerUnderreplicated(lh.getId(), replicaToKill.toString());
            int counter = 30;
            while (counter-- > 0) {
                Assert.assertTrue((String)"Expecting that replication should not complete", (boolean)ReplicationTestUtil.isLedgerInUnderReplication(this.zkc, lh.getId(), this.basePath));
                Thread.sleep(100L);
            }
            this.startAndAddBookie(killedBookieConfig);
            while (ReplicationTestUtil.isLedgerInUnderReplication(this.zkc, lh.getId(), this.basePath)) {
                Thread.sleep(100L);
            }
            this.verifyRecoveredLedgers(lh, 0L, 9L);
        }
        finally {
            rw.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test2RWsShouldCompeteForReplicationOf2FragmentsAndCompleteReplication() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(2, 2, BookKeeper.DigestType.CRC32, TESTPASSWD);
        for (int i = 0; i < 10; ++i) {
            lh.addEntry(data);
        }
        lh.close();
        BookieId replicaToKill = (BookieId)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).get(0);
        LOG.info("Killing Bookie : {}", (Object)replicaToKill);
        ServerConfiguration killedBookieConfig = this.killBookie(replicaToKill);
        this.killAllBookies(lh, null);
        BookieId newBkAddr1 = this.startNewBookieAndReturnBookieId();
        LOG.info("New Bookie addr : {}", (Object)newBkAddr1);
        ReplicationWorker rw1 = new ReplicationWorker(this.baseConf);
        BookieId newBkAddr2 = this.startNewBookieAndReturnBookieId();
        LOG.info("New Bookie addr : {}", (Object)newBkAddr2);
        ReplicationWorker rw2 = new ReplicationWorker(this.baseConf);
        rw1.start();
        rw2.start();
        try {
            this.underReplicationManager.markLedgerUnderreplicated(lh.getId(), replicaToKill.toString());
            int counter = 10;
            while (counter-- > 0) {
                Assert.assertTrue((String)"Expecting that replication should not complete", (boolean)ReplicationTestUtil.isLedgerInUnderReplication(this.zkc, lh.getId(), this.basePath));
                Thread.sleep(100L);
            }
            this.startAndAddBookie(killedBookieConfig);
            while (ReplicationTestUtil.isLedgerInUnderReplication(this.zkc, lh.getId(), this.basePath)) {
                Thread.sleep(100L);
            }
            this.verifyRecoveredLedgers(lh, 0L, 9L);
        }
        finally {
            rw1.shutdown();
            rw2.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRWShouldCleanTheLedgerFromUnderReplicationIfLedgerAlreadyDeleted() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(2, 2, BookKeeper.DigestType.CRC32, TESTPASSWD);
        for (int i = 0; i < 10; ++i) {
            lh.addEntry(data);
        }
        lh.close();
        BookieId replicaToKill = (BookieId)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).get(0);
        LOG.info("Killing Bookie : {}", (Object)replicaToKill);
        this.killBookie(replicaToKill);
        BookieId newBkAddr = this.startNewBookieAndReturnBookieId();
        LOG.info("New Bookie addr : {}", (Object)newBkAddr);
        ReplicationWorker rw = new ReplicationWorker(this.baseConf);
        rw.start();
        try {
            this.bkc.deleteLedger(lh.getId());
            this.underReplicationManager.markLedgerUnderreplicated(lh.getId(), replicaToKill.toString());
            while (ReplicationTestUtil.isLedgerInUnderReplication(this.zkc, lh.getId(), this.basePath)) {
                Thread.sleep(100L);
            }
        }
        finally {
            rw.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleLedgerReplicationWithReplicationWorker() throws Exception {
        LedgerHandle lh1 = this.bkc.createLedger(3, 3, BookKeeper.DigestType.CRC32, TESTPASSWD);
        for (int i = 0; i < 10; ++i) {
            lh1.addEntry(data);
        }
        BookieId replicaToKillFromFirstLedger = (BookieId)((List)lh1.getLedgerMetadata().getAllEnsembles().get(0L)).get(0);
        LOG.info("Killing Bookie : {}", (Object)replicaToKillFromFirstLedger);
        LedgerHandle lh2 = this.bkc.createLedger(3, 3, BookKeeper.DigestType.CRC32, TESTPASSWD);
        for (int i = 0; i < 10; ++i) {
            lh2.addEntry(data);
        }
        BookieId replicaToKillFromSecondLedger = (BookieId)((List)lh2.getLedgerMetadata().getAllEnsembles().get(0L)).get(0);
        LOG.info("Killing Bookie : {}", (Object)replicaToKillFromSecondLedger);
        this.killBookie(replicaToKillFromFirstLedger);
        lh1.close();
        this.killBookie(replicaToKillFromFirstLedger);
        lh2.close();
        BookieId newBkAddr = this.startNewBookieAndReturnBookieId();
        LOG.info("New Bookie addr : {}", (Object)newBkAddr);
        ReplicationWorker rw = new ReplicationWorker(this.baseConf);
        rw.start();
        try {
            this.underReplicationManager.markLedgerUnderreplicated(lh1.getId(), replicaToKillFromFirstLedger.toString());
            this.underReplicationManager.markLedgerUnderreplicated(lh2.getId(), replicaToKillFromSecondLedger.toString());
            while (ReplicationTestUtil.isLedgerInUnderReplication(this.zkc, lh1.getId(), this.basePath)) {
                Thread.sleep(100L);
            }
            while (ReplicationTestUtil.isLedgerInUnderReplication(this.zkc, lh2.getId(), this.basePath)) {
                Thread.sleep(100L);
            }
            this.killAllBookies(lh1, newBkAddr);
            this.verifyRecoveredLedgers(lh1, 0L, 9L);
            this.verifyRecoveredLedgers(lh2, 0L, 9L);
        }
        finally {
            rw.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleLedgerReplicationWithReplicationWorkerBatchRead() throws Exception {
        LedgerHandle lh1 = this.bkc.createLedger(3, 3, BookKeeper.DigestType.CRC32, TESTPASSWD);
        for (int i = 0; i < 200; ++i) {
            lh1.addEntry(data);
        }
        BookieId replicaToKillFromFirstLedger = (BookieId)((List)lh1.getLedgerMetadata().getAllEnsembles().get(0L)).get(0);
        LedgerHandle lh2 = this.bkc.createLedger(3, 3, BookKeeper.DigestType.CRC32, TESTPASSWD);
        for (int i = 0; i < 200; ++i) {
            lh2.addEntry(data);
        }
        BookieId replicaToKillFromSecondLedger = (BookieId)((List)lh2.getLedgerMetadata().getAllEnsembles().get(0L)).get(0);
        LOG.info("Killing Bookie : {}", (Object)replicaToKillFromFirstLedger);
        this.killBookie(replicaToKillFromFirstLedger);
        lh1.close();
        LOG.info("Killing Bookie : {}", (Object)replicaToKillFromSecondLedger);
        this.killBookie(replicaToKillFromSecondLedger);
        lh2.close();
        BookieId newBkAddr = this.startNewBookieAndReturnBookieId();
        LOG.info("New Bookie addr : {}", (Object)newBkAddr);
        if (replicaToKillFromFirstLedger != replicaToKillFromSecondLedger) {
            BookieId newBkAddr2 = this.startNewBookieAndReturnBookieId();
            LOG.info("New Bookie addr : {}", (Object)newBkAddr2);
        }
        ClientConfiguration clientConfiguration = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        clientConfiguration.setUseV2WireProtocol(true);
        clientConfiguration.setRecoveryBatchReadEnabled(true);
        clientConfiguration.setBatchReadEnabled(true);
        clientConfiguration.setRereplicationEntryBatchSize(100L);
        clientConfiguration.setReplicationRateByBytes(3072);
        ReplicationWorker rw = new ReplicationWorker(new ServerConfiguration((AbstractConfiguration)clientConfiguration));
        rw.start();
        try {
            this.underReplicationManager.markLedgerUnderreplicated(lh1.getId(), replicaToKillFromFirstLedger.toString());
            this.underReplicationManager.markLedgerUnderreplicated(lh2.getId(), replicaToKillFromSecondLedger.toString());
            while (ReplicationTestUtil.isLedgerInUnderReplication(this.zkc, lh1.getId(), this.basePath)) {
                Thread.sleep(100L);
            }
            while (ReplicationTestUtil.isLedgerInUnderReplication(this.zkc, lh2.getId(), this.basePath)) {
                Thread.sleep(100L);
            }
            this.killAllBookies(lh1, newBkAddr);
            this.verifyRecoveredLedgers(lh1, 0L, 199L);
            this.verifyRecoveredLedgers(lh2, 0L, 199L);
        }
        finally {
            rw.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRWShouldReplicateTheLedgersAfterTimeoutIfLastFragmentIsUR() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(3, 3, BookKeeper.DigestType.CRC32, TESTPASSWD);
        for (int i = 0; i < 10; ++i) {
            lh.addEntry(data);
        }
        BookieId replicaToKill = (BookieId)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).get(0);
        LOG.info("Killing Bookie : {}", (Object)replicaToKill);
        this.killBookie(replicaToKill);
        BookieId newBkAddr = this.startNewBookieAndReturnBookieId();
        LOG.info("New Bookie addr : {}", (Object)newBkAddr);
        this.baseConf.setOpenLedgerRereplicationGracePeriod("3000");
        ReplicationWorker rw = new ReplicationWorker(this.baseConf);
        MetadataClientDriver clientDriver = MetadataDrivers.getClientDriver((URI)URI.create(this.baseClientConf.getMetadataServiceUri()));
        try {
            clientDriver.initialize(this.baseClientConf, (ScheduledExecutorService)this.scheduler, (StatsLogger)NullStatsLogger.INSTANCE, Optional.empty());
            LedgerManagerFactory mFactory = clientDriver.getLedgerManagerFactory();
            LedgerUnderreplicationManager underReplicationManager = mFactory.newLedgerUnderreplicationManager();
            rw.start();
            try {
                underReplicationManager.markLedgerUnderreplicated(lh.getId(), replicaToKill.toString());
                while (ReplicationTestUtil.isLedgerInUnderReplication(this.zkc, lh.getId(), this.basePath)) {
                    Thread.sleep(100L);
                }
                this.killAllBookies(lh, newBkAddr);
                this.verifyRecoveredLedgers(lh, 0L, 9L);
                lh = this.bkc.openLedgerNoRecovery(lh.getId(), BookKeeper.DigestType.CRC32, TESTPASSWD);
                Assert.assertFalse((String)"Ledger must have been closed by RW", (boolean)ClientUtil.isLedgerOpen(lh));
            }
            finally {
                rw.shutdown();
                underReplicationManager.close();
            }
        }
        finally {
            if (Collections.singletonList(clientDriver).get(0) != null) {
                clientDriver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBookiesNotAvailableScenarioForReplicationWorker() throws Exception {
        int i;
        int ensembleSize = 3;
        LedgerHandle lh = this.bkc.createLedger(ensembleSize, ensembleSize, BookKeeper.DigestType.CRC32, TESTPASSWD);
        int numOfEntries = 7;
        for (int i2 = 0; i2 < numOfEntries; ++i2) {
            lh.addEntry(data);
        }
        lh.close();
        BookieId[] bookiesKilled = new BookieId[ensembleSize];
        final ServerConfiguration[] killedBookiesConfig = new ServerConfiguration[ensembleSize];
        for (i = 0; i < ensembleSize; ++i) {
            bookiesKilled[i] = (BookieId)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).get(i);
            killedBookiesConfig[i] = this.getBkConf(bookiesKilled[i]);
            LOG.info("Killing Bookie : {}", (Object)bookiesKilled[i]);
            this.killBookie(bookiesKilled[i]);
        }
        for (i = 0; i < ensembleSize; ++i) {
            BookieId bookieId = this.startNewBookieAndReturnBookieId();
        }
        ServerConfiguration newRWConf = new ServerConfiguration((AbstractConfiguration)this.baseConf);
        newRWConf.setLockReleaseOfFailedLedgerGracePeriod("64");
        ReplicationWorker rw1 = new ReplicationWorker(newRWConf);
        ReplicationWorker rw2 = new ReplicationWorker(newRWConf);
        MetadataClientDriver clientDriver = MetadataDrivers.getClientDriver((URI)URI.create(this.baseClientConf.getMetadataServiceUri()));
        try {
            clientDriver.initialize(this.baseClientConf, (ScheduledExecutorService)this.scheduler, (StatsLogger)NullStatsLogger.INSTANCE, Optional.empty());
            LedgerManagerFactory mFactory = clientDriver.getLedgerManagerFactory();
            LedgerUnderreplicationManager underReplicationManager = mFactory.newLedgerUnderreplicationManager();
            try {
                for (int i3 = 0; i3 < bookiesKilled.length; ++i3) {
                    underReplicationManager.markLedgerUnderreplicated(lh.getId(), bookiesKilled[i3].toString());
                }
                while (!ReplicationTestUtil.isLedgerInUnderReplication(this.zkc, lh.getId(), this.basePath)) {
                    Thread.sleep(100L);
                }
                rw1.start();
                rw2.start();
                final AtomicBoolean isBookieRestarted = new AtomicBoolean(false);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(3000L);
                            isBookieRestarted.set(true);
                            TestReplicationWorker.this.startBookie(killedBookiesConfig[0]);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }).start();
                int rw1PrevFailedAttemptsCount = 0;
                int rw2PrevFailedAttemptsCount = 0;
                while (!isBookieRestarted.get()) {
                    Assert.assertTrue((String)("Ledger: " + lh.getId() + " should be underreplicated"), (boolean)ReplicationTestUtil.isLedgerInUnderReplication(this.zkc, lh.getId(), this.basePath));
                    int rw1CurFailedAttemptsCount = ((AtomicInteger)rw1.replicationFailedLedgers.get((Object)lh.getId())).get();
                    Assert.assertTrue((String)("The current number of failed attempts: " + rw1CurFailedAttemptsCount + " should be greater than or equal to previous value: " + rw1PrevFailedAttemptsCount), (rw1CurFailedAttemptsCount >= rw1PrevFailedAttemptsCount ? 1 : 0) != 0);
                    rw1PrevFailedAttemptsCount = rw1CurFailedAttemptsCount;
                    int rw2CurFailedAttemptsCount = ((AtomicInteger)rw2.replicationFailedLedgers.get((Object)lh.getId())).get();
                    Assert.assertTrue((String)("The current number of failed attempts: " + rw2CurFailedAttemptsCount + " should be greater than or equal to previous value: " + rw2PrevFailedAttemptsCount), (rw2CurFailedAttemptsCount >= rw2PrevFailedAttemptsCount ? 1 : 0) != 0);
                    rw2PrevFailedAttemptsCount = rw2CurFailedAttemptsCount;
                    Thread.sleep(50L);
                }
                int timeToWaitForReplicationToComplete = 20000;
                int timeWaited = 0;
                while (ReplicationTestUtil.isLedgerInUnderReplication(this.zkc, lh.getId(), this.basePath)) {
                    Thread.sleep(100L);
                    if ((timeWaited += 100) != timeToWaitForReplicationToComplete) continue;
                    Assert.fail((String)"Ledger should be replicated by now");
                }
                rw1PrevFailedAttemptsCount = ((AtomicInteger)rw1.replicationFailedLedgers.get((Object)lh.getId())).get();
                rw2PrevFailedAttemptsCount = ((AtomicInteger)rw2.replicationFailedLedgers.get((Object)lh.getId())).get();
                Thread.sleep(2000L);
                Assert.assertEquals((String)"rw1 failedattempts", (long)rw1PrevFailedAttemptsCount, (long)((AtomicInteger)rw1.replicationFailedLedgers.get((Object)lh.getId())).get());
                Assert.assertEquals((String)"rw2 failed attempts ", (long)rw2PrevFailedAttemptsCount, (long)((AtomicInteger)rw2.replicationFailedLedgers.get((Object)lh.getId())).get());
                int rw1UnableToReadEntriesForReplication = ((ConcurrentSkipListSet)rw1.unableToReadEntriesForReplication.get((Object)lh.getId())).size();
                int rw2UnableToReadEntriesForReplication = ((ConcurrentSkipListSet)rw2.unableToReadEntriesForReplication.get((Object)lh.getId())).size();
                Assert.assertTrue((String)("unableToReadEntriesForReplication in RW1: " + rw1UnableToReadEntriesForReplication + " in RW2: " + rw2UnableToReadEntriesForReplication), (rw1UnableToReadEntriesForReplication == 0 || rw2UnableToReadEntriesForReplication == 0 ? 1 : 0) != 0);
            }
            finally {
                rw1.shutdown();
                rw2.shutdown();
                underReplicationManager.close();
            }
        }
        finally {
            if (Collections.singletonList(clientDriver).get(0) != null) {
                clientDriver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeferLedgerLockReleaseForReplicationWorker() throws Exception {
        int i;
        int ensembleSize = 3;
        LedgerHandle lh = this.bkc.createLedger(ensembleSize, ensembleSize, BookKeeper.DigestType.CRC32, TESTPASSWD);
        int numOfEntries = 7;
        for (int i2 = 0; i2 < numOfEntries; ++i2) {
            lh.addEntry(data);
        }
        lh.close();
        BookieId[] bookiesKilled = new BookieId[ensembleSize];
        ServerConfiguration[] killedBookiesConfig = new ServerConfiguration[ensembleSize];
        for (i = 0; i < ensembleSize; ++i) {
            bookiesKilled[i] = (BookieId)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).get(i);
            killedBookiesConfig[i] = this.getBkConf(bookiesKilled[i]);
            LOG.info("Killing Bookie : {}", (Object)bookiesKilled[i]);
            this.killBookie(bookiesKilled[i]);
        }
        for (i = 0; i < ensembleSize; ++i) {
            this.startNewBookieAndReturnBookieId();
        }
        long lockReleaseOfFailedLedgerGracePeriod = 64L;
        long baseBackoffForLockReleaseOfFailedLedger = lockReleaseOfFailedLedgerGracePeriod / (long)((int)Math.pow(2.0, 5.0));
        ServerConfiguration newRWConf = new ServerConfiguration((AbstractConfiguration)this.baseConf);
        newRWConf.setLockReleaseOfFailedLedgerGracePeriod(Long.toString(lockReleaseOfFailedLedgerGracePeriod));
        newRWConf.setRereplicationEntryBatchSize(1000L);
        CopyOnWriteArrayList<Long> rw1DelayReplicationPeriods = new CopyOnWriteArrayList<Long>();
        CopyOnWriteArrayList<Long> rw2DelayReplicationPeriods = new CopyOnWriteArrayList<Long>();
        TestStatsProvider statsProvider = new TestStatsProvider();
        TestStatsProvider.TestStatsLogger statsLogger1 = statsProvider.getStatsLogger("rw1");
        TestStatsProvider.TestStatsLogger statsLogger2 = statsProvider.getStatsLogger("rw2");
        InjectedReplicationWorker rw1 = new InjectedReplicationWorker(newRWConf, (StatsLogger)statsLogger1, rw1DelayReplicationPeriods);
        InjectedReplicationWorker rw2 = new InjectedReplicationWorker(newRWConf, (StatsLogger)statsLogger2, rw2DelayReplicationPeriods);
        Counter numEntriesUnableToReadForReplication1 = statsLogger1.getCounter("NUM_ENTRIES_UNABLE_TO_READ_FOR_REPLICATION");
        Counter numEntriesUnableToReadForReplication2 = statsLogger2.getCounter("NUM_ENTRIES_UNABLE_TO_READ_FOR_REPLICATION");
        MetadataClientDriver clientDriver = MetadataDrivers.getClientDriver((URI)URI.create(this.baseClientConf.getMetadataServiceUri()));
        try {
            clientDriver.initialize(this.baseClientConf, (ScheduledExecutorService)this.scheduler, (StatsLogger)NullStatsLogger.INSTANCE, Optional.empty());
            LedgerManagerFactory mFactory = clientDriver.getLedgerManagerFactory();
            LedgerUnderreplicationManager underReplicationManager = mFactory.newLedgerUnderreplicationManager();
            try {
                for (int i3 = 0; i3 < bookiesKilled.length; ++i3) {
                    underReplicationManager.markLedgerUnderreplicated(lh.getId(), bookiesKilled[i3].toString());
                }
                while (!ReplicationTestUtil.isLedgerInUnderReplication(this.zkc, lh.getId(), this.basePath)) {
                    Thread.sleep(100L);
                }
                rw1.start();
                rw2.start();
                int numOfAttemptsToWaitFor = 10;
                while (((AtomicInteger)rw1.replicationFailedLedgers.get((Object)lh.getId())).get() < numOfAttemptsToWaitFor || ((AtomicInteger)rw2.replicationFailedLedgers.get((Object)lh.getId())).get() < numOfAttemptsToWaitFor) {
                    Thread.sleep(500L);
                }
                Assert.assertTrue((String)("Ledger: " + lh.getId() + " should be underreplicated"), (boolean)ReplicationTestUtil.isLedgerInUnderReplication(this.zkc, lh.getId(), this.basePath));
                for (int i4 = 0; i4 < numOfAttemptsToWaitFor - 1; ++i4) {
                    long expectedDelayValue = Math.min(lockReleaseOfFailedLedgerGracePeriod, baseBackoffForLockReleaseOfFailedLedger * (long)(1 << i4));
                    Assert.assertEquals((String)"RW1 delayperiod", (Object)expectedDelayValue, (Object)rw1DelayReplicationPeriods.get(i4));
                    Assert.assertEquals((String)"RW2 delayperiod", (Object)expectedDelayValue, (Object)rw2DelayReplicationPeriods.get(i4));
                }
                Assert.assertEquals((String)"numEntriesUnableToReadForReplication for RW1", (Object)numOfEntries, (Object)numEntriesUnableToReadForReplication1.get());
                Assert.assertEquals((String)"numEntriesUnableToReadForReplication for RW2", (Object)numOfEntries, (Object)numEntriesUnableToReadForReplication2.get());
                Assert.assertEquals((String)"RW1 unabletoreadentries", (long)numOfEntries, (long)((ConcurrentSkipListSet)rw1.unableToReadEntriesForReplication.get((Object)lh.getId())).size());
                Assert.assertEquals((String)"RW2 unabletoreadentries", (long)numOfEntries, (long)((ConcurrentSkipListSet)rw2.unableToReadEntriesForReplication.get((Object)lh.getId())).size());
            }
            finally {
                rw1.shutdown();
                rw2.shutdown();
                underReplicationManager.close();
            }
        }
        finally {
            if (Collections.singletonList(clientDriver).get(0) != null) {
                clientDriver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRWShouldReplicateTheLedgersAfterTimeoutIfLastFragmentIsNotUR() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(3, 3, BookKeeper.DigestType.CRC32, TESTPASSWD);
        for (int i = 0; i < 10; ++i) {
            lh.addEntry(data);
        }
        BookieId replicaToKill = (BookieId)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).get(0);
        LOG.info("Killing Bookie : {}", (Object)replicaToKill);
        this.killBookie(replicaToKill);
        BookieId newBkAddr = this.startNewBookieAndReturnBookieId();
        LOG.info("New Bookie addr : {}", (Object)newBkAddr);
        for (int i = 0; i < 10; ++i) {
            lh.addEntry(data);
        }
        ReplicationWorker rw = new ReplicationWorker(this.baseConf);
        this.baseClientConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        MetadataClientDriver driver = MetadataDrivers.getClientDriver((URI)URI.create(this.baseClientConf.getMetadataServiceUri()));
        try {
            driver.initialize(this.baseClientConf, (ScheduledExecutorService)this.scheduler, (StatsLogger)NullStatsLogger.INSTANCE, Optional.empty());
            LedgerManagerFactory mFactory = driver.getLedgerManagerFactory();
            LedgerUnderreplicationManager underReplicationManager = mFactory.newLedgerUnderreplicationManager();
            rw.start();
            try {
                underReplicationManager.markLedgerUnderreplicated(lh.getId(), replicaToKill.toString());
                while (ReplicationTestUtil.isLedgerInUnderReplication(this.zkc, lh.getId(), this.basePath)) {
                    Thread.sleep(100L);
                }
                this.killAllBookies(lh, newBkAddr);
                this.verifyRecoveredLedgers(lh, 0L, 9L);
                lh = this.bkc.openLedgerNoRecovery(lh.getId(), BookKeeper.DigestType.CRC32, TESTPASSWD);
                Assert.assertTrue((String)"Ledger must have been closed by RW", (boolean)ClientUtil.isLedgerOpen(lh));
            }
            finally {
                rw.shutdown();
                underReplicationManager.close();
            }
        }
        finally {
            if (Collections.singletonList(driver).get(0) != null) {
                driver.close();
            }
        }
    }

    @Test
    public void testRWZKConnectionLost() throws Exception {
        try (ZooKeeperClient zk = ZooKeeperClient.newBuilder().connectString(this.zkUtil.getZooKeeperConnectString()).sessionTimeoutMs(10000).build();){
            ReplicationWorker rw = new ReplicationWorker(this.baseConf);
            rw.start();
            for (int i = 0; i < 10 && !rw.isRunning(); ++i) {
                Thread.sleep(1000L);
            }
            Assert.assertTrue((String)"Replication worker should be running", (boolean)rw.isRunning());
            this.stopZKCluster();
            Thread.sleep(1000L);
            this.startZKCluster();
            Assert.assertTrue((String)"Replication worker should not shutdown", (boolean)rw.isRunning());
        }
    }

    @Test
    public void testRWZKConnectionLostOnNonRecoverableZkError() throws Exception {
        int i;
        for (int j = 0; j < 3; ++j) {
            LedgerHandle lh = this.bkc.createLedger(1, 1, 1, BookKeeper.DigestType.CRC32, TESTPASSWD, null);
            long createdLedgerId = lh.getId();
            for (i = 0; i < 10; ++i) {
                lh.addEntry(data);
            }
            lh.close();
        }
        this.killBookie(2);
        this.killBookie(1);
        this.startNewBookie();
        this.startNewBookie();
        ((BookKeeperClusterTestCase.ServerTester)this.servers.get(0)).getConfiguration().setRwRereplicateBackoffMs(100);
        ((BookKeeperClusterTestCase.ServerTester)this.servers.get(0)).startAutoRecovery();
        Auditor auditor = this.getAuditor(10, TimeUnit.SECONDS);
        ReplicationWorker rw = ((BookKeeperClusterTestCase.ServerTester)this.servers.get(0)).getReplicationWorker();
        ZkLedgerUnderreplicationManager ledgerUnderreplicationManager = (ZkLedgerUnderreplicationManager)FieldUtils.readField((Object)auditor, (String)"ledgerUnderreplicationManager", (boolean)true);
        ZooKeeper zkc = (ZooKeeper)FieldUtils.readField((Object)ledgerUnderreplicationManager, (String)"zkc", (boolean)true);
        auditor.submitAuditTask().get();
        Assert.assertTrue((boolean)zkc.getState().isConnected());
        zkc.close();
        Assert.assertFalse((boolean)zkc.getState().isConnected());
        auditor.submitAuditTask();
        rw.run();
        for (i = 0; i < 10 && (rw.isRunning() || auditor.isRunning()); ++i) {
            Thread.sleep(1000L);
        }
        Assert.assertFalse((String)"Replication worker should NOT be running", (boolean)rw.isRunning());
        Assert.assertFalse((String)"Auditor should NOT be running", (boolean)auditor.isRunning());
    }

    private void killAllBookies(LedgerHandle lh, BookieId excludeBK) throws Exception {
        for (Map.Entry entry : lh.getLedgerMetadata().getAllEnsembles().entrySet()) {
            List bookies = (List)entry.getValue();
            for (BookieId bookie : bookies) {
                if (bookie.equals((Object)excludeBK)) continue;
                this.killBookie(bookie);
            }
        }
    }

    private void verifyRecoveredLedgers(LedgerHandle lh, long startEntryId, long endEntryId) throws BKException, InterruptedException {
        LedgerHandle lhs = this.bkc.openLedgerNoRecovery(lh.getId(), BookKeeper.DigestType.CRC32, TESTPASSWD);
        Enumeration entries = lhs.readEntries(startEntryId, endEntryId);
        Assert.assertTrue((String)"Should have the elements", (boolean)entries.hasMoreElements());
        while (entries.hasMoreElements()) {
            LedgerEntry entry = (LedgerEntry)entries.nextElement();
            Assert.assertEquals((Object)"TestReplicationWorker", (Object)new String(entry.getEntry()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRWShutDownInTheCaseOfZKOperationFailures() throws Exception {
        int i;
        int zkSessionTimeOut = 10000;
        ZooKeeperWatcherBase zooKeeperWatcherBase = new ZooKeeperWatcherBase(zkSessionTimeOut, (StatsLogger)NullStatsLogger.INSTANCE);
        MockZooKeeperClient zkFaultInjectionWrapper = new MockZooKeeperClient(this.zkUtil.getZooKeeperConnectString(), zkSessionTimeOut, zooKeeperWatcherBase);
        zkFaultInjectionWrapper.waitForConnection();
        Assert.assertEquals((String)"zkFaultInjectionWrapper should be in connected state", (Object)ZooKeeper.States.CONNECTED, (Object)zkFaultInjectionWrapper.getState());
        long oldZkInstanceSessionId = zkFaultInjectionWrapper.getSessionId();
        BookKeeper bkWithMockZK = new BookKeeper(this.baseClientConf, (ZooKeeper)zkFaultInjectionWrapper);
        long ledgerId = 567L;
        LedgerHandle lh = bkWithMockZK.createLedgerAdv(ledgerId, 2, 2, 2, BookKeeper.DigestType.CRC32, TESTPASSWD, null);
        for (i = 0; i < 10; ++i) {
            lh.addEntry((long)i, data);
        }
        lh.close();
        zooKeeperWatcherBase.process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, ""));
        zkFaultInjectionWrapper.waitForConnection();
        for (i = 0; i < 10 && zkFaultInjectionWrapper.getState() != ZooKeeper.States.CONNECTED; ++i) {
            Thread.sleep(200L);
        }
        Assert.assertEquals((String)"zkFaultInjectionWrapper should be in connected state", (Object)ZooKeeper.States.CONNECTED, (Object)zkFaultInjectionWrapper.getState());
        Assert.assertNotEquals((String)"Session Id of old and new ZK instance should be different", (long)oldZkInstanceSessionId, (long)zkFaultInjectionWrapper.getSessionId());
        BookieId replicaToKill = (BookieId)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).get(0);
        LOG.info("Killing Bookie id {}", (Object)replicaToKill);
        this.killBookie(replicaToKill);
        ReplicationWorker rw = new ReplicationWorker(this.baseConf, bkWithMockZK, false, (StatsLogger)NullStatsLogger.INSTANCE);
        rw.start();
        try {
            for (int i2 = 0; i2 < 40 && !rw.isRunning(); ++i2) {
                LOG.info("Waiting for the RW to start...");
                Thread.sleep(500L);
            }
            Assert.assertTrue((String)"RW should be running", (boolean)rw.isRunning());
            AbstractZkLedgerManager absZKLedgerManager = (AbstractZkLedgerManager)this.ledgerManager;
            String ledgerPath = absZKLedgerManager.getLedgerPath(ledgerId);
            String urLockPath = ZkLedgerUnderreplicationManager.getUrLedgerLockZnode((String)ZkLedgerUnderreplicationManager.getUrLockPath((String)this.zkLedgersRootPath), (long)ledgerId);
            zkFaultInjectionWrapper.setPathOfSetDataToFail(ledgerPath);
            zkFaultInjectionWrapper.setPathOfDeleteToFail(urLockPath);
            this.underReplicationManager.markLedgerUnderreplicated(lh.getId(), replicaToKill.toString());
            for (int i3 = 0; i3 < 40 && rw.isRunning(); ++i3) {
                LOG.info("Waiting for the RW to shutdown...");
                Thread.sleep(500L);
            }
            Assert.assertEquals((String)"NumOfTimesSetDataFailed", (long)1L, (long)zkFaultInjectionWrapper.getNumOfTimesSetDataFailed());
            Assert.assertEquals((String)"NumOfTimesDeleteFailed", (long)2L, (long)zkFaultInjectionWrapper.getNumOfTimesDeleteFailed());
            Assert.assertFalse((String)"RW should be shutdown", (boolean)rw.isRunning());
        }
        finally {
            rw.shutdown();
            zkFaultInjectionWrapper.close();
            bkWithMockZK.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplicateEmptyOpenStateLedger() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(3, 3, 2, BookKeeper.DigestType.CRC32, TESTPASSWD);
        Assert.assertFalse((boolean)lh.getLedgerMetadata().isClosed());
        List firstEnsemble = (List)lh.getLedgerMetadata().getAllEnsembles().firstEntry().getValue();
        List ensemble = (List)lh.getLedgerMetadata().getAllEnsembles().entrySet().iterator().next().getValue();
        this.killBookie((BookieId)ensemble.get(1));
        this.startNewBookie();
        this.baseConf.setOpenLedgerRereplicationGracePeriod(String.valueOf(30));
        ReplicationWorker replicationWorker = new ReplicationWorker(this.baseConf);
        replicationWorker.start();
        try {
            this.underReplicationManager.markLedgerUnderreplicated(lh.getId(), ((BookieId)ensemble.get(1)).toString());
            Awaitility.waitAtMost((long)60L, (TimeUnit)TimeUnit.SECONDS).untilAsserted(() -> Assert.assertFalse((boolean)ReplicationTestUtil.isLedgerInUnderReplication(this.zkc, lh.getId(), this.basePath)));
            LedgerHandle lh1 = this.bkc.openLedgerNoRecovery(lh.getId(), BookKeeper.DigestType.CRC32, TESTPASSWD);
            Assert.assertTrue((boolean)lh1.getLedgerMetadata().isClosed());
        }
        finally {
            replicationWorker.shutdown();
        }
    }

    @Test
    public void testRepairedNotAdheringPlacementPolicyLedgerFragmentsOnRack() throws Exception {
        this.testRepairedNotAdheringPlacementPolicyLedgerFragments(RackawareEnsemblePlacementPolicy.class, null);
    }

    @Test
    public void testReplicationStats() throws Exception {
        BiConsumer<Boolean, ReplicationWorker> checkReplicationStats = (first, rw) -> {
            try {
                Method rereplicate = rw.getClass().getDeclaredMethod("rereplicate", new Class[0]);
                rereplicate.setAccessible(true);
                Object result = rereplicate.invoke(rw, new Object[0]);
                Field statsLoggerField = rw.getClass().getDeclaredField("statsLogger");
                statsLoggerField.setAccessible(true);
                TestStatsProvider.TestStatsLogger statsLogger = (TestStatsProvider.TestStatsLogger)statsLoggerField.get(rw);
                Counter numDeferLedgerLockReleaseOfFailedLedgerCounter = statsLogger.getCounter("NUM_DEFER_LEDGER_LOCK_RELEASE_OF_FAILED_LEDGER");
                Counter numLedgersReplicatedCounter = statsLogger.getCounter("NUM_FULL_OR_PARTIAL_LEDGERS_REPLICATED");
                Counter numNotAdheringPlacementLedgersCounter = statsLogger.getCounter("NUM_NOT_ADHERING_PLACEMENT_LEDGERS_REPLICATED");
                Assert.assertEquals((String)"NUM_DEFER_LEDGER_LOCK_RELEASE_OF_FAILED_LEDGER", (long)1L, (long)numDeferLedgerLockReleaseOfFailedLedgerCounter.get());
                if (first.booleanValue()) {
                    Assert.assertFalse((boolean)((Boolean)result));
                    Assert.assertEquals((String)"NUM_FULL_OR_PARTIAL_LEDGERS_REPLICATED", (long)0L, (long)numLedgersReplicatedCounter.get());
                    Assert.assertEquals((String)"NUM_NOT_ADHERING_PLACEMENT_LEDGERS_REPLICATED", (long)0L, (long)numNotAdheringPlacementLedgersCounter.get());
                } else {
                    Assert.assertTrue((boolean)((Boolean)result));
                    Assert.assertEquals((String)"NUM_FULL_OR_PARTIAL_LEDGERS_REPLICATED", (long)1L, (long)numLedgersReplicatedCounter.get());
                    Assert.assertEquals((String)"NUM_NOT_ADHERING_PLACEMENT_LEDGERS_REPLICATED", (long)1L, (long)numNotAdheringPlacementLedgersCounter.get());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        this.testRepairedNotAdheringPlacementPolicyLedgerFragments(RackawareEnsemblePlacementPolicy.class, checkReplicationStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRepairedNotAdheringPlacementPolicyLedgerFragments(final Class<? extends EnsemblePlacementPolicy> placementPolicyClass, BiConsumer<Boolean, ReplicationWorker> checkReplicationStats) throws Exception {
        final List firstThreeBookies = this.servers.stream().map(ele -> {
            try {
                return ele.getServer().getBookieId();
            }
            catch (UnknownHostException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        this.baseClientConf.setProperty("reppDnsResolverClass", (Object)StaticDNSResolver.class.getName());
        this.baseClientConf.setProperty("enforceStrictZoneawarePlacement", (Object)false);
        this.bkc.close();
        this.bkc = new BookKeeperTestClient(this.baseClientConf){

            protected EnsemblePlacementPolicy initializeEnsemblePlacementPolicy(ClientConfiguration conf, DNSToSwitchMapping dnsResolver, HashedWheelTimer timer, FeatureProvider featureProvider, StatsLogger statsLogger, BookieAddressResolver bookieAddressResolver) throws IOException {
                EnsemblePlacementPolicy ensemblePlacementPolicy = null;
                if (ZoneawareEnsemblePlacementPolicy.class == placementPolicyClass) {
                    ensemblePlacementPolicy = TestReplicationWorker.this.buildZoneAwareEnsemblePlacementPolicy(firstThreeBookies);
                } else if (RackawareEnsemblePlacementPolicy.class == placementPolicyClass) {
                    ensemblePlacementPolicy = TestReplicationWorker.this.buildRackAwareEnsemblePlacementPolicy(firstThreeBookies);
                }
                ensemblePlacementPolicy.initialize(conf, Optional.ofNullable(dnsResolver), timer, featureProvider, statsLogger, bookieAddressResolver);
                return ensemblePlacementPolicy;
            }
        };
        LedgerHandle lh = this.bkc.createLedger(3, 3, 3, BookKeeper.DigestType.CRC32, TESTPASSWD);
        int entrySize = 10;
        for (int i = 0; i < entrySize; ++i) {
            lh.addEntry(data);
        }
        lh.close();
        int minNumRacksPerWriteQuorumConfValue = 2;
        ServerConfiguration servConf = new ServerConfiguration((AbstractConfiguration)this.confByIndex(0));
        servConf.setMinNumRacksPerWriteQuorum(minNumRacksPerWriteQuorumConfValue);
        servConf.setProperty("reppDnsResolverClass", (Object)StaticDNSResolver.class.getName());
        servConf.setAuditorPeriodicPlacementPolicyCheckInterval(1000L);
        servConf.setRepairedPlacementPolicyNotAdheringBookieEnable(true);
        MutableObject auditorRef = new MutableObject();
        try {
            TestStatsProvider.TestStatsLogger statsLogger = this.startAuditorAndWaitForPlacementPolicyCheck(servConf, (MutableObject<Auditor>)auditorRef);
            Gauge ledgersNotAdheringToPlacementPolicyGuage = statsLogger.getGauge("NUM_LEDGERS_NOT_ADHERING_TO_PLACEMENT_POLICY");
            Assert.assertEquals((String)"NUM_LEDGERS_NOT_ADHERING_TO_PLACEMENT_POLICY guage value", (Object)1, (Object)ledgersNotAdheringToPlacementPolicyGuage.getSample());
            Gauge ledgersSoftlyAdheringToPlacementPolicyGuage = statsLogger.getGauge("NUM_LEDGERS_SOFTLY_ADHERING_TO_PLACEMENT_POLICY");
            Assert.assertEquals((String)"NUM_LEDGERS_SOFTLY_ADHERING_TO_PLACEMENT_POLICY guage value", (Object)0, (Object)ledgersSoftlyAdheringToPlacementPolicyGuage.getSample());
        }
        finally {
            Auditor auditor = (Auditor)auditorRef.getValue();
            if (auditor != null) {
                auditor.close();
            }
        }
        Stat stat = this.bkc.getZkHandle().exists("/ledgers/underreplication/ledgers/0000/0000/0000/0000/urL0000000000", false);
        Assert.assertNotNull((Object)stat);
        this.baseConf.setRepairedPlacementPolicyNotAdheringBookieEnable(true);
        BookKeeperTestClient bookKeeper = new BookKeeperTestClient(this.baseClientConf){

            protected EnsemblePlacementPolicy initializeEnsemblePlacementPolicy(ClientConfiguration conf, DNSToSwitchMapping dnsResolver, HashedWheelTimer timer, FeatureProvider featureProvider, StatsLogger statsLogger, BookieAddressResolver bookieAddressResolver) throws IOException {
                EnsemblePlacementPolicy ensemblePlacementPolicy = null;
                if (ZoneawareEnsemblePlacementPolicy.class == placementPolicyClass) {
                    ensemblePlacementPolicy = TestReplicationWorker.this.buildZoneAwareEnsemblePlacementPolicy(firstThreeBookies);
                } else if (RackawareEnsemblePlacementPolicy.class == placementPolicyClass) {
                    ensemblePlacementPolicy = TestReplicationWorker.this.buildRackAwareEnsemblePlacementPolicy(firstThreeBookies);
                }
                ensemblePlacementPolicy.initialize(conf, Optional.ofNullable(dnsResolver), timer, featureProvider, statsLogger, bookieAddressResolver);
                return ensemblePlacementPolicy;
            }
        };
        TestStatsProvider statsProvider = new TestStatsProvider();
        TestStatsProvider.TestStatsLogger statsLogger = statsProvider.getStatsLogger("replication");
        ReplicationWorker rw = new ReplicationWorker(this.baseConf, (BookKeeper)bookKeeper, false, (StatsLogger)statsLogger);
        if (checkReplicationStats != null) {
            checkReplicationStats.accept(true, rw);
        } else {
            rw.start();
        }
        BookieId newBookieId = this.startNewBookieAndReturnBookieId();
        if (checkReplicationStats != null) {
            checkReplicationStats.accept(false, rw);
        }
        Awaitility.await().untilAsserted(() -> {
            LedgerMetadata metadata = (LedgerMetadata)((Versioned)this.bkc.getLedgerManager().readLedgerMetadata(lh.getId()).get()).getValue();
            List newBookies = (List)metadata.getAllEnsembles().get(0L);
            Assert.assertTrue((boolean)newBookies.contains(newBookieId));
        });
        Awaitility.await().untilAsserted(() -> {
            Stat stat1 = this.bkc.getZkHandle().exists("/ledgers/underreplication/ledgers/0000/0000/0000/0000/urL0000000000", false);
            Assert.assertNull((Object)stat1);
        });
        for (BookieId rack1Book : firstThreeBookies) {
            this.killBookie(rack1Book);
        }
        this.verifyRecoveredLedgers(lh, 0L, entrySize - 1);
        if (checkReplicationStats == null) {
            rw.shutdown();
        }
        this.baseConf.setRepairedPlacementPolicyNotAdheringBookieEnable(false);
        bookKeeper.close();
    }

    private EnsemblePlacementPolicy buildRackAwareEnsemblePlacementPolicy(final List<BookieId> bookieIds) {
        return new RackawareEnsemblePlacementPolicy(){

            public String resolveNetworkLocation(BookieId addr) {
                if (bookieIds.contains(addr)) {
                    return "/rack1";
                }
                return "/rack2";
            }
        };
    }

    private EnsemblePlacementPolicy buildZoneAwareEnsemblePlacementPolicy(final List<BookieId> firstThreeBookies) {
        return new ZoneawareEnsemblePlacementPolicy(){

            protected String resolveNetworkLocation(BookieId addr) {
                if (((BookieId)firstThreeBookies.get(0)).equals((Object)addr)) {
                    return "/zone1/ud1";
                }
                if (firstThreeBookies.contains(addr)) {
                    return "/zone1/ud2";
                }
                return "/zone2/ud1";
            }
        };
    }

    private TestStatsProvider.TestStatsLogger startAuditorAndWaitForPlacementPolicyCheck(ServerConfiguration servConf, MutableObject<Auditor> auditorRef) throws MetadataException, ReplicationException.CompatibilityException, KeeperException, InterruptedException, ReplicationException.UnavailableException, UnknownHostException {
        LedgerManagerFactory mFactory = this.driver.getLedgerManagerFactory();
        LedgerUnderreplicationManager urm = mFactory.newLedgerUnderreplicationManager();
        TestStatsProvider statsProvider = new TestStatsProvider();
        TestStatsProvider.TestStatsLogger statsLogger = statsProvider.getStatsLogger("auditor");
        TestStatsProvider.TestOpStatsLogger placementPolicyCheckStatsLogger = (TestStatsProvider.TestOpStatsLogger)statsLogger.getOpStatsLogger("PLACEMENT_POLICY_CHECK_TIME");
        AuditorPeriodicCheckTest.TestAuditor auditor = new AuditorPeriodicCheckTest.TestAuditor(BookieImpl.getBookieId((ServerConfiguration)servConf).toString(), servConf, this.bkc, false, (StatsLogger)statsLogger, null);
        auditorRef.setValue((Object)auditor);
        CountDownLatch latch = auditor.getLatch();
        Assert.assertEquals((String)"PLACEMENT_POLICY_CHECK_TIME SuccessCount", (long)0L, (long)placementPolicyCheckStatsLogger.getSuccessCount());
        urm.setPlacementPolicyCheckCTime(-1L);
        auditor.start();
        Assert.assertTrue((String)"placementPolicyCheck should have executed", (boolean)latch.await(20L, TimeUnit.SECONDS));
        for (int i = 0; i < 20; ++i) {
            Thread.sleep(100L);
            if (placementPolicyCheckStatsLogger.getSuccessCount() >= 1L) break;
        }
        Assert.assertEquals((String)"PLACEMENT_POLICY_CHECK_TIME SuccessCount", (long)1L, (long)placementPolicyCheckStatsLogger.getSuccessCount());
        return statsLogger;
    }

    class MockZooKeeperClient
    extends ZooKeeperClient {
        private final String connectString;
        private final int sessionTimeoutMs;
        private final ZooKeeperWatcherBase watcherManager;
        private volatile String pathOfSetDataToFail;
        private volatile String pathOfDeleteToFail;
        private AtomicInteger numOfTimesSetDataFailed;
        private AtomicInteger numOfTimesDeleteFailed;

        MockZooKeeperClient(String connectString, int sessionTimeoutMs, ZooKeeperWatcherBase watcher) throws IOException {
            super(connectString, sessionTimeoutMs, watcher, (RetryPolicy)new BoundExponentialBackoffRetryPolicy((long)sessionTimeoutMs, (long)sessionTimeoutMs, Integer.MAX_VALUE), (RetryPolicy)new BoundExponentialBackoffRetryPolicy((long)sessionTimeoutMs, (long)sessionTimeoutMs, 0), (StatsLogger)NullStatsLogger.INSTANCE, 1, 0.0, false);
            this.numOfTimesSetDataFailed = new AtomicInteger();
            this.numOfTimesDeleteFailed = new AtomicInteger();
            this.connectString = connectString;
            this.sessionTimeoutMs = sessionTimeoutMs;
            this.watcherManager = watcher;
        }

        protected ZooKeeper createZooKeeper() throws IOException {
            return new MockZooKeeper(this.connectString, this.sessionTimeoutMs, (Watcher)this.watcherManager, false);
        }

        private void setPathOfSetDataToFail(String pathOfSetDataToFail) {
            this.pathOfSetDataToFail = pathOfSetDataToFail;
        }

        private void setPathOfDeleteToFail(String pathOfDeleteToFail) {
            this.pathOfDeleteToFail = pathOfDeleteToFail;
        }

        private int getNumOfTimesSetDataFailed() {
            return this.numOfTimesSetDataFailed.get();
        }

        private int getNumOfTimesDeleteFailed() {
            return this.numOfTimesDeleteFailed.get();
        }

        class MockZooKeeper
        extends ZooKeeper {
            public MockZooKeeper(String connectString, int sessionTimeout, Watcher watcher, boolean canBeReadOnly) throws IOException {
                super(connectString, sessionTimeout, watcher, canBeReadOnly);
            }

            public void setData(String path, byte[] data, int version, AsyncCallback.StatCallback cb, Object context) {
                if (MockZooKeeperClient.this.pathOfSetDataToFail != null && MockZooKeeperClient.this.pathOfSetDataToFail.equals(path)) {
                    LOG.error("setData of MockZooKeeper, is failing with CONNECTIONLOSS for path: {}", (Object)path);
                    MockZooKeeperClient.this.numOfTimesSetDataFailed.incrementAndGet();
                    cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, context, null);
                } else {
                    super.setData(path, data, version, cb, context);
                }
            }

            public void delete(String path, int version) throws KeeperException, InterruptedException {
                if (MockZooKeeperClient.this.pathOfDeleteToFail != null && MockZooKeeperClient.this.pathOfDeleteToFail.equals(path)) {
                    LOG.error("delete of MockZooKeeper, is failing with CONNECTIONLOSS for path: {}", (Object)path);
                    MockZooKeeperClient.this.numOfTimesDeleteFailed.incrementAndGet();
                    throw new KeeperException.ConnectionLossException();
                }
                super.delete(path, version);
            }
        }
    }

    class InjectedReplicationWorker
    extends ReplicationWorker {
        CopyOnWriteArrayList<Long> delayReplicationPeriods;

        public InjectedReplicationWorker(ServerConfiguration conf, StatsLogger statsLogger, CopyOnWriteArrayList<Long> delayReplicationPeriods) throws ReplicationException.CompatibilityException, ReplicationException.UnavailableException, InterruptedException, IOException {
            super(conf, statsLogger);
            this.delayReplicationPeriods = delayReplicationPeriods;
        }

        void scheduleTaskWithDelay(TimerTask timerTask, long delayPeriod) {
            this.delayReplicationPeriods.add(delayPeriod);
            super.scheduleTaskWithDelay(timerTask, delayPeriod);
        }
    }
}

