/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tls;

import java.io.IOException;
import org.apache.bookkeeper.auth.BookieAuthProvider;
import org.apache.bookkeeper.common.util.ReflectionUtils;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.tls.BookieAuthZFactory;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBookieAuthZFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TestBookieAuthZFactory.class);

    @Test
    public void testBookieAuthZInitNoRoles() {
        ServerConfiguration conf = new ServerConfiguration();
        String factoryClassName = BookieAuthZFactory.class.getName();
        BookieAuthProvider.Factory factory = (BookieAuthProvider.Factory)ReflectionUtils.newInstance((String)factoryClassName, BookieAuthProvider.Factory.class);
        try {
            factory.init(conf);
            Assert.fail((String)"Not supposed to initialize BookieAuthZFactory without authorized roles set");
        }
        catch (IOException | RuntimeException e) {
            LOG.info("BookieAuthZFactory did not initialize as there are no authorized roles set.");
        }
    }

    @Test
    public void testBookieAuthZInitEmptyRole() {
        ServerConfiguration conf = new ServerConfiguration();
        conf.setAuthorizedRoles("");
        String factoryClassName = BookieAuthZFactory.class.getName();
        BookieAuthProvider.Factory factory = (BookieAuthProvider.Factory)ReflectionUtils.newInstance((String)factoryClassName, BookieAuthProvider.Factory.class);
        try {
            factory.init(conf);
            Assert.fail((String)"Not supposed to initialize BookieAuthZFactory without authorized roles set");
        }
        catch (IOException | RuntimeException e) {
            LOG.info("BookieAuthZFactory did not initialize as there are no authorized roles set.");
        }
    }

    @Test
    public void testBookieAuthZNewProviderNullAddress() {
        ServerConfiguration conf = new ServerConfiguration();
        conf.setAuthorizedRoles("testRole");
        String factoryClassName = BookieAuthZFactory.class.getName();
        BookieAuthProvider.Factory factory = (BookieAuthProvider.Factory)ReflectionUtils.newInstance((String)factoryClassName, BookieAuthProvider.Factory.class);
        try {
            factory.init(conf);
            BookieAuthProvider authProvider = factory.newProvider(null, null);
            authProvider.onProtocolUpgrade();
            Assert.fail((String)"BookieAuthZFactory should fail with a null connection");
        }
        catch (IOException | RuntimeException exception) {
            // empty catch block
        }
    }
}

