/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.zookeeper;

import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.common.testing.executors.MockExecutorController;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public abstract class MockZooKeeperTestCase {
    protected final ConcurrentMap<String, Set<Watcher>> watchers = Maps.newConcurrentMap();
    protected ZooKeeper mockZk;
    protected ScheduledExecutorService zkCallbackExecutor;
    protected MockExecutorController zkCallbackController;
    private MockedStatic<ZkUtils> zkUtilsMockedStatic;

    protected void setup() throws Exception {
        this.mockZk = (ZooKeeper)Mockito.mock(ZooKeeper.class);
        this.zkUtilsMockedStatic = Mockito.mockStatic(ZkUtils.class);
        this.zkCallbackExecutor = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        this.zkCallbackController = new MockExecutorController().controlExecute(this.zkCallbackExecutor).controlSubmit(this.zkCallbackExecutor).controlSchedule(this.zkCallbackExecutor).controlScheduleAtFixedRate(this.zkCallbackExecutor, 10);
    }

    protected void teardown() throws Exception {
        this.zkUtilsMockedStatic.close();
    }

    private void addWatcher(String path, Watcher watcher) {
        if (null == watcher) {
            return;
        }
        HashSet<Watcher> watcherSet = (HashSet<Watcher>)this.watchers.get(path);
        if (null == watcherSet) {
            watcherSet = new HashSet<Watcher>();
            this.watchers.put(path, watcherSet);
        }
        watcherSet.add(watcher);
    }

    private void removeWatcher(String path, Watcher watcher) {
        if (watcher == null) {
            return;
        }
        Set watcherSet = (Set)this.watchers.get(path);
        if (null == watcherSet) {
            return;
        }
        watcherSet.remove(watcher);
        if (watcherSet.isEmpty()) {
            this.watchers.remove(path);
        }
    }

    protected void mockZkUtilsAsyncCreateFullPathOptimistic(String expectedLedgerPath, CreateMode expectedCreateMode, int retCode, String retCreatedZnodeName) throws Exception {
        this.zkUtilsMockedStatic.when(() -> ZkUtils.asyncCreateFullPathOptimistic((ZooKeeper)((ZooKeeper)ArgumentMatchers.eq((Object)this.mockZk)), (String)((String)ArgumentMatchers.eq((Object)expectedLedgerPath)), (byte[])((byte[])ArgumentMatchers.any(byte[].class)), (List)ArgumentMatchers.anyList(), (CreateMode)((CreateMode)ArgumentMatchers.eq((Object)expectedCreateMode)), (AsyncCallback.StringCallback)((AsyncCallback.StringCallback)ArgumentMatchers.any(AsyncCallback.StringCallback.class)), (Object)ArgumentMatchers.any())).thenAnswer(invocationOnMock -> {
            String path = (String)invocationOnMock.getArgument(1);
            AsyncCallback.StringCallback callback = (AsyncCallback.StringCallback)invocationOnMock.getArgument(5);
            Object ctx = invocationOnMock.getArgument(6);
            callback.processResult(retCode, path, ctx, retCreatedZnodeName);
            return null;
        });
    }

    protected void mockZkDelete(String expectedLedgerPath, int expectedVersion, int retCode) throws Exception {
        ((ZooKeeper)Mockito.doAnswer(invocationOnMock -> {
            String path = (String)invocationOnMock.getArgument(0);
            AsyncCallback.VoidCallback callback = (AsyncCallback.VoidCallback)invocationOnMock.getArgument(2);
            Object ctx = invocationOnMock.getArgument(3);
            callback.processResult(retCode, path, ctx);
            return null;
        }).when((Object)this.mockZk)).delete((String)ArgumentMatchers.eq((Object)expectedLedgerPath), ArgumentMatchers.eq((int)expectedVersion), (AsyncCallback.VoidCallback)ArgumentMatchers.any(AsyncCallback.VoidCallback.class), ArgumentMatchers.any());
    }

    protected void mockZkUtilsAsyncDeleteFullPathOptimistic(String expectedLedgerPath, int expectedZnodeVersion, int retCode) throws Exception {
        this.zkUtilsMockedStatic.when(() -> ZkUtils.asyncDeleteFullPathOptimistic((ZooKeeper)((ZooKeeper)ArgumentMatchers.eq((Object)this.mockZk)), (String)((String)ArgumentMatchers.eq((Object)expectedLedgerPath)), (int)ArgumentMatchers.eq((int)expectedZnodeVersion), (AsyncCallback.VoidCallback)((AsyncCallback.VoidCallback)ArgumentMatchers.any(AsyncCallback.VoidCallback.class)), (String)((String)ArgumentMatchers.eq((Object)expectedLedgerPath)))).thenAnswer(invocationOnMock -> {
            String path = (String)invocationOnMock.getArgument(1);
            AsyncCallback.VoidCallback callback = (AsyncCallback.VoidCallback)invocationOnMock.getArgument(3);
            callback.processResult(retCode, path, null);
            return null;
        });
    }

    protected void mockZkGetData(String expectedLedgerPath, boolean expectedWatcher, int retCode, byte[] retData, Stat retStat) throws Exception {
        ((ZooKeeper)Mockito.doAnswer(invocationOnMock -> {
            String path = (String)invocationOnMock.getArgument(0);
            Watcher watcher = (Watcher)invocationOnMock.getArgument(1);
            AsyncCallback.DataCallback callback = (AsyncCallback.DataCallback)invocationOnMock.getArgument(2);
            Object ctx = invocationOnMock.getArgument(3);
            if (0 == retCode) {
                this.addWatcher(path, watcher);
            }
            callback.processResult(retCode, path, ctx, retData, retStat);
            return null;
        }).when((Object)this.mockZk)).getData((String)ArgumentMatchers.eq((Object)expectedLedgerPath), expectedWatcher ? (Watcher)ArgumentMatchers.any(Watcher.class) : (Watcher)ArgumentMatchers.eq(null), (AsyncCallback.DataCallback)ArgumentMatchers.any(AsyncCallback.DataCallback.class), ArgumentMatchers.any());
    }

    protected void mockZkRemoveWatcher() throws Exception {
        ((ZooKeeper)Mockito.doAnswer(invocationOnMock -> {
            String path = (String)invocationOnMock.getArgument(0);
            Watcher watcher = (Watcher)invocationOnMock.getArgument(1);
            AsyncCallback.VoidCallback callback = (AsyncCallback.VoidCallback)invocationOnMock.getArgument(4);
            this.removeWatcher(path, watcher);
            callback.processResult(KeeperException.Code.OK.intValue(), path, null);
            return null;
        }).when((Object)this.mockZk)).removeWatches((String)ArgumentMatchers.any(String.class), (Watcher)ArgumentMatchers.any(Watcher.class), (Watcher.WatcherType)ArgumentMatchers.any(Watcher.WatcherType.class), ((Boolean)ArgumentMatchers.any(Boolean.class)).booleanValue(), (AsyncCallback.VoidCallback)ArgumentMatchers.any(AsyncCallback.VoidCallback.class), ArgumentMatchers.any());
    }

    protected void mockZkSetData(String expectedLedgerPath, byte[] expectedBytes, int expectedVersion, int retCode, Stat retStat) throws Exception {
        ((ZooKeeper)Mockito.doAnswer(invocationOnMock -> {
            String path = (String)invocationOnMock.getArgument(0);
            AsyncCallback.StatCallback callback = (AsyncCallback.StatCallback)invocationOnMock.getArgument(3);
            Object ctx = invocationOnMock.getArgument(4);
            callback.processResult(retCode, path, ctx, retStat);
            return null;
        }).when((Object)this.mockZk)).setData((String)ArgumentMatchers.eq((Object)expectedLedgerPath), (byte[])ArgumentMatchers.eq((Object)expectedBytes), ArgumentMatchers.eq((int)expectedVersion), (AsyncCallback.StatCallback)ArgumentMatchers.any(AsyncCallback.StatCallback.class), ArgumentMatchers.any());
    }

    protected boolean notifyWatchedEvent(Watcher.Event.EventType eventType, Watcher.Event.KeeperState keeperState, String path) {
        Set watcherSet = (Set)this.watchers.remove(path);
        if (null == watcherSet) {
            return false;
        }
        WatchedEvent event = new WatchedEvent(eventType, keeperState, path);
        for (Watcher watcher : watcherSet) {
            watcher.process(event);
        }
        return true;
    }

    protected void mockGetChildren(String expectedPath, boolean expectedWatcher, int retCode, List<String> retChildren, Stat retStat) {
        this.mockGetChildren(expectedPath, expectedWatcher, retCode, retChildren, retStat, 0L);
    }

    protected void mockGetChildren(String expectedPath, boolean expectedWatcher, int retCode, List<String> retChildren, Stat retStat, long delayMs) {
        ((ZooKeeper)Mockito.doAnswer(invocationOnMock -> {
            String p = (String)invocationOnMock.getArgument(0);
            Watcher w = (Watcher)invocationOnMock.getArgument(1);
            AsyncCallback.Children2Callback callback = (AsyncCallback.Children2Callback)invocationOnMock.getArgument(2);
            Object ctx = invocationOnMock.getArgument(3);
            if (0 == retCode) {
                this.addWatcher(p, w);
            }
            this.zkCallbackExecutor.schedule(() -> callback.processResult(retCode, p, ctx, retChildren, retStat), delayMs, TimeUnit.MILLISECONDS);
            return null;
        }).when((Object)this.mockZk)).getChildren((String)ArgumentMatchers.eq((Object)expectedPath), expectedWatcher ? (Watcher)ArgumentMatchers.any(Watcher.class) : (Watcher)ArgumentMatchers.eq(null), (AsyncCallback.Children2Callback)ArgumentMatchers.any(AsyncCallback.Children2Callback.class), ArgumentMatchers.any());
    }
}

