/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.EntryLogger;
import org.apache.bookkeeper.bookie.GarbageCollectorThread;
import org.apache.bookkeeper.bookie.LedgerCache;
import org.apache.bookkeeper.bookie.LedgerCacheImpl;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.jmx.BKMBeanInfo;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.util.SnapshotMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InterleavedLedgerStorage
implements LedgerStorage {
    static final Logger LOG = LoggerFactory.getLogger(InterleavedLedgerStorage.class);
    EntryLogger entryLogger;
    LedgerCache ledgerCache;
    protected final SnapshotMap<Long, Boolean> activeLedgers = new SnapshotMap();
    final GarbageCollectorThread gcThread;

    InterleavedLedgerStorage(ServerConfiguration conf, LedgerManager ledgerManager, LedgerDirsManager ledgerDirsManager) throws IOException {
        this.entryLogger = new EntryLogger(conf, ledgerDirsManager);
        this.ledgerCache = new LedgerCacheImpl(conf, this.activeLedgers, ledgerDirsManager);
        this.gcThread = new GarbageCollectorThread(conf, this.ledgerCache, this.entryLogger, this.activeLedgers, ledgerManager);
    }

    @Override
    public void start() {
        this.gcThread.start();
    }

    @Override
    public void shutdown() throws InterruptedException {
        this.gcThread.shutdown();
        this.entryLogger.shutdown();
        try {
            this.ledgerCache.close();
        }
        catch (IOException e) {
            LOG.error("Error while closing the ledger cache", (Throwable)e);
        }
    }

    @Override
    public boolean setFenced(long ledgerId) throws IOException {
        return this.ledgerCache.setFenced(ledgerId);
    }

    @Override
    public boolean isFenced(long ledgerId) throws IOException {
        return this.ledgerCache.isFenced(ledgerId);
    }

    @Override
    public void setMasterKey(long ledgerId, byte[] masterKey) throws IOException {
        this.ledgerCache.setMasterKey(ledgerId, masterKey);
    }

    @Override
    public byte[] readMasterKey(long ledgerId) throws IOException, BookieException {
        return this.ledgerCache.readMasterKey(ledgerId);
    }

    @Override
    public boolean ledgerExists(long ledgerId) throws IOException {
        return this.ledgerCache.ledgerExists(ledgerId);
    }

    @Override
    public synchronized long addEntry(ByteBuffer entry) throws IOException {
        long ledgerId = entry.getLong();
        long entryId = entry.getLong();
        entry.rewind();
        long pos = this.entryLogger.addEntry(ledgerId, entry);
        this.ledgerCache.putEntryOffset(ledgerId, entryId, pos);
        return entryId;
    }

    @Override
    public ByteBuffer getEntry(long ledgerId, long entryId) throws IOException {
        long offset;
        if (entryId == -1L) {
            entryId = this.ledgerCache.getLastEntry(ledgerId);
        }
        if ((offset = this.ledgerCache.getEntryOffset(ledgerId, entryId)) == 0L) {
            throw new Bookie.NoEntryException(ledgerId, entryId);
        }
        return ByteBuffer.wrap(this.entryLogger.readEntry(ledgerId, entryId, offset));
    }

    @Override
    public boolean isFlushRequired() {
        return this.entryLogger.isFlushRequired();
    }

    @Override
    public void flush() throws IOException {
        if (!this.isFlushRequired()) {
            return;
        }
        boolean flushFailed = false;
        try {
            this.ledgerCache.flushLedger(true);
        }
        catch (IOException ioe) {
            LOG.error("Exception flushing Ledger cache", (Throwable)ioe);
            flushFailed = true;
        }
        try {
            this.entryLogger.flush();
        }
        catch (IOException ioe) {
            LOG.error("Exception flushing Ledger", (Throwable)ioe);
            flushFailed = true;
        }
        if (flushFailed) {
            throw new IOException("Flushing to storage failed, check logs");
        }
    }

    @Override
    public BKMBeanInfo getJMXBean() {
        return this.ledgerCache.getJMXBean();
    }
}

