/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import bk-shade.com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.util.DiskChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerDirsManager {
    private static Logger LOG = LoggerFactory.getLogger(LedgerDirsManager.class);
    private volatile List<File> filledDirs;
    private final List<File> ledgerDirectories;
    private volatile List<File> writableLedgerDirectories;
    private DiskChecker diskChecker;
    private List<LedgerDirsListener> listeners;
    private LedgerDirsMonitor monitor;
    private final Random rand = new Random();

    public LedgerDirsManager(ServerConfiguration conf) {
        this.ledgerDirectories = Arrays.asList(Bookie.getCurrentDirectories(conf.getLedgerDirs()));
        this.writableLedgerDirectories = new ArrayList<File>(this.ledgerDirectories);
        this.filledDirs = new ArrayList<File>();
        this.listeners = new ArrayList<LedgerDirsListener>();
        this.diskChecker = new DiskChecker(conf.getDiskUsageThreshold());
        this.monitor = new LedgerDirsMonitor(conf.getDiskCheckInterval());
    }

    public List<File> getAllLedgerDirs() {
        return this.ledgerDirectories;
    }

    public List<File> getWritableLedgerDirs() throws NoWritableLedgerDirException {
        if (this.writableLedgerDirectories.isEmpty()) {
            String errMsg = "All ledger directories are non writable";
            NoWritableLedgerDirException e = new NoWritableLedgerDirException(errMsg);
            LOG.error(errMsg, (Throwable)e);
            throw e;
        }
        return this.writableLedgerDirectories;
    }

    public boolean isDirFull(File dir) {
        return this.filledDirs.contains(dir);
    }

    @VisibleForTesting
    public void addToFilledDirs(File dir) {
        if (!this.filledDirs.contains(dir)) {
            LOG.warn(dir + " is out of space." + " Adding it to filled dirs list");
            ArrayList<File> updatedFilledDirs = new ArrayList<File>(this.filledDirs);
            updatedFilledDirs.add(dir);
            this.filledDirs = updatedFilledDirs;
            ArrayList<File> newDirs = new ArrayList<File>(this.writableLedgerDirectories);
            newDirs.removeAll(this.filledDirs);
            this.writableLedgerDirectories = newDirs;
            for (LedgerDirsListener listener : this.listeners) {
                listener.diskFull(dir);
            }
        }
    }

    File pickRandomWritableDir() throws NoWritableLedgerDirException {
        return this.pickRandomWritableDir(null);
    }

    File pickRandomWritableDir(File excludedDir) throws NoWritableLedgerDirException {
        int start;
        List<File> writableDirs = this.getWritableLedgerDirs();
        int idx = start = this.rand.nextInt(writableDirs.size());
        File candidate = writableDirs.get(idx);
        while (null != excludedDir && excludedDir.equals(candidate)) {
            if ((idx = (idx + 1) % writableDirs.size()) == start) {
                throw new NoWritableLedgerDirException("No writable directories found from  available writable dirs (" + writableDirs + ") : exclude dir " + excludedDir);
            }
            candidate = writableDirs.get(idx);
        }
        return candidate;
    }

    public void addLedgerDirsListener(LedgerDirsListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void start() {
        this.monitor.setDaemon(true);
        this.monitor.start();
    }

    public void shutdown() {
        this.monitor.interrupt();
        try {
            this.monitor.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static /* synthetic */ List access$000(LedgerDirsManager x0) {
        return x0.listeners;
    }

    static /* synthetic */ DiskChecker access$100(LedgerDirsManager x0) {
        return x0.diskChecker;
    }

    static /* synthetic */ Logger access$200() {
        return LOG;
    }

    public static interface LedgerDirsListener {
        public void diskFailed(File var1);

        public void diskFull(File var1);

        public void allDisksFull();

        public void fatalError();
    }

    public static class NoWritableLedgerDirException
    extends IOException {
        private static final long serialVersionUID = -8696901285061448421L;

        public NoWritableLedgerDirException(String errMsg) {
            super(errMsg);
        }
    }

    private class LedgerDirsMonitor
    extends Thread {
        private final int interval;

        public LedgerDirsMonitor(int interval) {
            super("LedgerDirsMonitorThread");
            this.interval = interval;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

