/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.util.concurrent.RejectedExecutionException;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.util.SafeRunnable;
import org.apache.bookkeeper.versioning.Version;

class ReadOnlyLedgerHandle
extends LedgerHandle
implements BookkeeperInternalCallbacks.LedgerMetadataListener {
    ReadOnlyLedgerHandle(BookKeeper bk, long ledgerId, LedgerMetadata metadata, BookKeeper.DigestType digestType, byte[] password, boolean watch) throws GeneralSecurityException, NumberFormatException {
        super(bk, ledgerId, metadata, digestType, password);
        if (watch) {
            bk.getLedgerManager().registerLedgerMetadataListener(ledgerId, this);
        }
    }

    @Override
    public void close() throws InterruptedException, BKException {
        this.bk.getLedgerManager().unregisterLedgerMetadataListener(this.ledgerId, this);
    }

    @Override
    public void asyncClose(AsyncCallback.CloseCallback cb, Object ctx) {
        this.bk.getLedgerManager().unregisterLedgerMetadataListener(this.ledgerId, this);
        cb.closeComplete(0, this, ctx);
    }

    @Override
    public long addEntry(byte[] data) throws InterruptedException, BKException {
        return this.addEntry(data, 0, data.length);
    }

    @Override
    public long addEntry(byte[] data, int offset, int length) throws InterruptedException, BKException {
        LOG.error("Tried to add entry on a Read-Only ledger handle, ledgerid=" + this.ledgerId);
        throw BKException.create(-100);
    }

    @Override
    public void asyncAddEntry(byte[] data, AsyncCallback.AddCallback cb, Object ctx) {
        this.asyncAddEntry(data, 0, data.length, cb, ctx);
    }

    @Override
    public void asyncAddEntry(byte[] data, int offset, int length, AsyncCallback.AddCallback cb, Object ctx) {
        LOG.error("Tried to add entry on a Read-Only ledger handle, ledgerid=" + this.ledgerId);
        cb.addComplete(-100, this, -1L, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleBookieFailure(InetSocketAddress addr, int bookieIndex) {
        this.blockAddCompletions.incrementAndGet();
        LedgerMetadata ledgerMetadata = this.metadata;
        synchronized (ledgerMetadata) {
            try {
                if (!this.metadata.currentEnsemble.get(bookieIndex).equals(addr)) {
                    LOG.debug("Write did not succeed to {}, bookieIndex {}, but we have already fixed it.", (Object)addr, (Object)bookieIndex);
                    this.blockAddCompletions.decrementAndGet();
                    return;
                }
                this.replaceBookieInMetadata(addr, bookieIndex);
                this.blockAddCompletions.decrementAndGet();
                this.unsetSuccessAndSendWriteRequest(bookieIndex);
            }
            catch (BKException.BKNotEnoughBookiesException e) {
                LOG.error("Could not get additional bookie to remake ensemble, closing ledger: " + this.ledgerId);
                this.handleUnrecoverableErrorDuringAdd(e.getCode());
                return;
            }
        }
    }

    @Override
    public void onChanged(long lid, LedgerMetadata newMetadata) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received ledger metadata update on {} : {}", (Object)lid, (Object)newMetadata);
        }
        if (this.ledgerId != lid) {
            return;
        }
        if (null == newMetadata) {
            return;
        }
        Version.Occurred occurred = this.metadata.getVersion().compare(newMetadata.getVersion());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Try to update metadata from {} to {} : {}", new Object[]{this.metadata, newMetadata, occurred});
        }
        if (Version.Occurred.BEFORE == occurred) {
            try {
                this.bk.mainWorkerPool.submitOrdered(this.ledgerId, new MetadataUpdater(newMetadata));
            }
            catch (RejectedExecutionException ree) {
                LOG.error("Failed on submitting updater to update ledger metadata on ledger {} : {}", (Object)this.ledgerId, (Object)newMetadata);
            }
        }
    }

    public String toString() {
        return String.format("ReadOnlyLedgerHandle(lid = %d, id = %d)", this.ledgerId, super.hashCode());
    }

    class MetadataUpdater
    extends SafeRunnable {
        final LedgerMetadata m;

        MetadataUpdater(LedgerMetadata metadata) {
            this.m = metadata;
        }

        @Override
        public void safeRun() {
            Version.Occurred occurred = ReadOnlyLedgerHandle.this.metadata.getVersion().compare(this.m.getVersion());
            if (Version.Occurred.BEFORE == occurred) {
                LedgerHandle.LOG.info("Updated ledger metadata for ledger {} to {}.", (Object)ReadOnlyLedgerHandle.this.ledgerId, (Object)this.m);
                ReadOnlyLedgerHandle.this.metadata = this.m;
            }
        }
    }
}

