/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.util.MathUtils;

class RoundRobinDistributionSchedule
implements DistributionSchedule {
    private int writeQuorumSize;
    private int ackQuorumSize;
    private int ensembleSize;

    public RoundRobinDistributionSchedule(int writeQuorumSize, int ackQuorumSize, int ensembleSize) {
        this.writeQuorumSize = writeQuorumSize;
        this.ackQuorumSize = ackQuorumSize;
        this.ensembleSize = ensembleSize;
    }

    @Override
    public List<Integer> getWriteSet(long entryId) {
        ArrayList<Integer> set = new ArrayList<Integer>();
        for (int i = 0; i < this.writeQuorumSize; ++i) {
            set.add((int)((entryId + (long)i) % (long)this.ensembleSize));
        }
        return set;
    }

    @Override
    public DistributionSchedule.AckSet getAckSet() {
        final HashSet ackSet = new HashSet();
        return new DistributionSchedule.AckSet(){

            @Override
            public boolean addBookieAndCheck(int bookieIndexHeardFrom) {
                ackSet.add(bookieIndexHeardFrom);
                return ackSet.size() >= RoundRobinDistributionSchedule.this.ackQuorumSize;
            }

            @Override
            public void removeBookie(int bookie) {
                ackSet.remove(bookie);
            }
        };
    }

    @Override
    public DistributionSchedule.QuorumCoverageSet getCoverageSet() {
        return new RRQuorumCoverageSet();
    }

    @Override
    public boolean hasEntry(long entryId, int bookieIndex) {
        return this.getWriteSet(entryId).contains(bookieIndex);
    }

    private class RRQuorumCoverageSet
    implements DistributionSchedule.QuorumCoverageSet {
        private boolean[] covered = null;
        private int numQuorumsUncovered;

        private RRQuorumCoverageSet() {
            this.covered = new boolean[RoundRobinDistributionSchedule.this.ensembleSize];
            this.numQuorumsUncovered = RoundRobinDistributionSchedule.this.ensembleSize;
        }

        @Override
        public synchronized boolean addBookieAndCheckCovered(int bookieIndexHeardFrom) {
            if (this.numQuorumsUncovered == 0) {
                return true;
            }
            for (int i = 0; i < RoundRobinDistributionSchedule.this.ackQuorumSize; ++i) {
                int quorumStartIndex = MathUtils.signSafeMod(bookieIndexHeardFrom - i, RoundRobinDistributionSchedule.this.ensembleSize);
                if (this.covered[quorumStartIndex]) continue;
                this.covered[quorumStartIndex] = true;
                --this.numQuorumsUncovered;
                if (this.numQuorumsUncovered != 0) continue;
                return true;
            }
            return false;
        }
    }
}

