/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.jmx;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.jmx.ZKMBeanInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BKMBeanRegistry
extends MBeanRegistry {
    static final Logger LOG = LoggerFactory.getLogger(BKMBeanRegistry.class);
    static final String DOMAIN = "org.apache.BookKeeperService";
    static BKMBeanRegistry instance = new BKMBeanRegistry();

    public static BKMBeanRegistry getInstance() {
        return instance;
    }

    protected String getDomainName() {
        return DOMAIN;
    }

    protected int tokenize(StringBuilder sb, String path, int index) {
        String[] tokens;
        for (String s : tokens = path.split("/")) {
            if (s.length() == 0) continue;
            sb.append("name").append(index++).append("=").append(s).append(",");
        }
        return index;
    }

    protected ObjectName makeObjectName(String path, ZKMBeanInfo bean) throws MalformedObjectNameException {
        if (path == null) {
            return null;
        }
        StringBuilder beanName = new StringBuilder(this.getDomainName() + ":");
        int counter = 0;
        counter = this.tokenize(beanName, path, counter);
        this.tokenize(beanName, bean.getName(), counter);
        beanName.deleteCharAt(beanName.length() - 1);
        try {
            return new ObjectName(beanName.toString());
        }
        catch (MalformedObjectNameException e) {
            LOG.warn("Invalid name \"" + beanName.toString() + "\" for class " + bean.getClass().toString());
            throw e;
        }
    }
}

