/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

public interface BookieProtocol {
    public static final byte LOWEST_COMPAT_PROTOCOL_VERSION = 0;
    public static final byte CURRENT_PROTOCOL_VERSION = 2;
    public static final long INVALID_ENTRY_ID = -1L;
    public static final long LAST_ADD_CONFIRMED = -1L;
    public static final int MASTER_KEY_LENGTH = 20;
    public static final byte ADDENTRY = 1;
    public static final byte READENTRY = 2;
    public static final int EOK = 0;
    public static final int ENOLEDGER = 1;
    public static final int ENOENTRY = 2;
    public static final int EBADREQ = 100;
    public static final int EIO = 101;
    public static final int EUA = 102;
    public static final int EBADVERSION = 103;
    public static final int EFENCED = 104;
    public static final int EREADONLY = 105;
    public static final short FLAG_NONE = 0;
    public static final short FLAG_DO_FENCING = 1;
    public static final short FLAG_RECOVERY_ADD = 2;

    public static class PacketHeader {
        final byte version;
        final byte opCode;
        final short flags;

        public PacketHeader(byte version, byte opCode, short flags) {
            this.version = version;
            this.opCode = opCode;
            this.flags = flags;
        }

        int toInt() {
            if (this.version == 0) {
                return this.opCode;
            }
            return (this.version & 0xFF) << 24 | (this.opCode & 0xFF) << 16 | this.flags & 0xFFFF;
        }

        static PacketHeader fromInt(int i) {
            byte version = (byte)(i >> 24);
            byte opCode = 0;
            short flags = 0;
            if (version == 0) {
                opCode = (byte)i;
            } else {
                opCode = (byte)(i >> 16 & 0xFF);
                flags = (short)(i & 0xFFFF);
            }
            return new PacketHeader(version, opCode, flags);
        }

        byte getVersion() {
            return this.version;
        }

        byte getOpCode() {
            return this.opCode;
        }

        short getFlags() {
            return this.flags;
        }
    }
}

