/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.bookkeeper.bookie.CheckpointSource;

public class CheckpointSourceList
implements CheckpointSource {
    private final List<? extends CheckpointSource> checkpointSourcesList;

    public CheckpointSourceList(List<? extends CheckpointSource> checkpointSourcesList) {
        this.checkpointSourcesList = checkpointSourcesList;
    }

    @Override
    public CheckpointSource.Checkpoint newCheckpoint() {
        return new CheckpointList(this);
    }

    @Override
    public void checkpointComplete(CheckpointSource.Checkpoint checkpoint, boolean compact) throws IOException {
        if (checkpoint == CheckpointSource.Checkpoint.MAX || checkpoint == CheckpointSource.Checkpoint.MIN) {
            return;
        }
        Preconditions.checkArgument((boolean)(checkpoint instanceof CheckpointList));
        CheckpointList checkpointList = (CheckpointList)checkpoint;
        Preconditions.checkArgument((checkpointList.source == this ? 1 : 0) != 0);
        checkpointList.checkpointComplete(compact);
    }

    private static class CheckpointList
    implements CheckpointSource.Checkpoint {
        private final CheckpointSourceList source;
        private final List<CheckpointSource.Checkpoint> checkpoints;

        public CheckpointList(CheckpointSourceList source) {
            this.source = source;
            this.checkpoints = Lists.newArrayListWithCapacity((int)source.checkpointSourcesList.size());
            for (CheckpointSource checkpointSource : source.checkpointSourcesList) {
                this.checkpoints.add(checkpointSource.newCheckpoint());
            }
        }

        private void checkpointComplete(boolean compact) throws IOException {
            for (int i = 0; i < this.source.checkpointSourcesList.size(); ++i) {
                ((CheckpointSource)this.source.checkpointSourcesList.get(i)).checkpointComplete(this.checkpoints.get(i), compact);
            }
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.source, this.checkpoints});
        }

        public boolean equals(Object o) {
            if (!(o instanceof CheckpointList)) {
                return false;
            }
            CheckpointSource.Checkpoint other = (CheckpointSource.Checkpoint)o;
            return 0 == this.compareTo(other);
        }

        @Override
        public int compareTo(CheckpointSource.Checkpoint o) {
            if (o == CheckpointSource.Checkpoint.MAX) {
                return -1;
            }
            if (o == CheckpointSource.Checkpoint.MIN) {
                return 1;
            }
            Preconditions.checkArgument((boolean)(o instanceof CheckpointList));
            CheckpointList other = (CheckpointList)o;
            if (this.checkpoints.size() != other.checkpoints.size()) {
                return Integer.compare(this.checkpoints.size(), other.checkpoints.size());
            }
            for (int i = 0; i < this.checkpoints.size(); ++i) {
                int res = this.checkpoints.get(i).compareTo(other.checkpoints.get(i));
                if (res == 0) continue;
                return res;
            }
            return 0;
        }
    }
}

