/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.bookkeeper.bookie.FileInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileInfoBackingCache {
    private static final Logger log = LoggerFactory.getLogger(FileInfoBackingCache.class);
    static final int DEAD_REF = -57005;
    final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    final ConcurrentHashMap<Long, CachedFileInfo> fileInfos = new ConcurrentHashMap();
    final FileLoader fileLoader;

    FileInfoBackingCache(FileLoader fileLoader) {
        this.fileLoader = fileLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CachedFileInfo loadFileInfo(long ledgerId, byte[] masterKey) throws IOException {
        this.lock.readLock().lock();
        try {
            CachedFileInfo fi = this.fileInfos.get(ledgerId);
            if (fi != null) {
                boolean retained = fi.tryRetain();
                assert (retained);
                CachedFileInfo cachedFileInfo = fi;
                return cachedFileInfo;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            File backingFile = this.fileLoader.load(ledgerId, masterKey != null);
            CachedFileInfo fi = new CachedFileInfo(ledgerId, backingFile, masterKey);
            this.fileInfos.put(ledgerId, fi);
            boolean retained = fi.tryRetain();
            assert (retained);
            CachedFileInfo cachedFileInfo = fi;
            return cachedFileInfo;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseFileInfo(long ledgerId, CachedFileInfo fileInfo) {
        this.lock.writeLock().lock();
        try {
            if (fileInfo.markDead()) {
                fileInfo.close(true);
                this.fileInfos.remove(ledgerId, (Object)fileInfo);
            }
        }
        catch (IOException ioe) {
            log.error("Error evicting file info({}) for ledger {} from backing cache", new Object[]{fileInfo, ledgerId, ioe});
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void closeAllWithoutFlushing() throws IOException {
        for (Map.Entry<Long, CachedFileInfo> entry : this.fileInfos.entrySet()) {
            entry.getValue().close(false);
        }
    }

    static interface FileLoader {
        public File load(long var1, boolean var3) throws IOException;
    }

    class CachedFileInfo
    extends FileInfo {
        final long ledgerId;
        final AtomicInteger refCount;

        CachedFileInfo(long ledgerId, File lf, byte[] masterKey) throws IOException {
            super(lf, masterKey);
            this.ledgerId = ledgerId;
            this.refCount = new AtomicInteger(0);
        }

        private boolean markDead() {
            return this.refCount.compareAndSet(0, -57005);
        }

        boolean tryRetain() {
            int count;
            do {
                if ((count = this.refCount.get()) >= 0) continue;
                return false;
            } while (!this.refCount.compareAndSet(count, count + 1));
            return true;
        }

        int getRefCount() {
            return this.refCount.get();
        }

        void release() {
            if (this.refCount.decrementAndGet() == 0) {
                FileInfoBackingCache.this.releaseFileInfo(this.ledgerId, this);
            }
        }

        public String toString() {
            return "CachedFileInfo(ledger=" + this.ledgerId + ",refCount=" + this.refCount.get() + ",closed=" + this.isClosed() + ",id=" + System.identityHashCode((Object)this) + ")";
        }
    }
}

