/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.google.common.base.Charsets;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.apache.bookkeeper.bookie.BufferedChannel;
import org.apache.bookkeeper.util.NativeIO;
import org.apache.bookkeeper.util.ZeroBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JournalChannel
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(JournalChannel.class);
    final RandomAccessFile randomAccessFile;
    final int fd;
    final FileChannel fc;
    final BufferedChannel bc;
    final int formatVersion;
    long nextPrealloc = 0L;
    final byte[] magicWord = "BKLG".getBytes(Charsets.UTF_8);
    static final int SECTOR_SIZE = 512;
    private static final int START_OF_FILE = -12345;
    private static long cacheDropLagBytes = 0x800000L;
    static final int V1 = 1;
    static final int V2 = 2;
    static final int V3 = 3;
    static final int V4 = 4;
    static final int V5 = 5;
    static final int HEADER_SIZE = 512;
    static final int VERSION_HEADER_SIZE = 8;
    static final int MIN_COMPAT_JOURNAL_FORMAT_VERSION = 1;
    static final int CURRENT_JOURNAL_FORMAT_VERSION = 5;
    private final long preAllocSize;
    private final int journalAlignSize;
    private final boolean fRemoveFromPageCache;
    public final ByteBuffer zeros;
    private long lastDropPosition = 0L;

    JournalChannel(File journalDirectory, long logId) throws IOException {
        this(journalDirectory, logId, 0x400000L, 65536, -12345L);
    }

    JournalChannel(File journalDirectory, long logId, long preAllocSize, int writeBufferSize) throws IOException {
        this(journalDirectory, logId, preAllocSize, writeBufferSize, -12345L);
    }

    JournalChannel(File journalDirectory, long logId, long preAllocSize, int writeBufferSize, long position) throws IOException {
        this(journalDirectory, logId, preAllocSize, writeBufferSize, 512, position, false, 5);
    }

    JournalChannel(File journalDirectory, long logId, long preAllocSize, int writeBufferSize, int journalAlignSize, boolean fRemoveFromPageCache, int formatVersionToWrite) throws IOException {
        this(journalDirectory, logId, preAllocSize, writeBufferSize, journalAlignSize, -12345L, fRemoveFromPageCache, formatVersionToWrite);
    }

    private JournalChannel(File journalDirectory, long logId, long preAllocSize, int writeBufferSize, int journalAlignSize, long position, boolean fRemoveFromPageCache, int formatVersionToWrite) throws IOException {
        this.journalAlignSize = journalAlignSize;
        this.zeros = ByteBuffer.allocate(journalAlignSize);
        this.preAllocSize = preAllocSize - preAllocSize % (long)journalAlignSize;
        this.fRemoveFromPageCache = fRemoveFromPageCache;
        File fn = new File(journalDirectory, Long.toHexString(logId) + ".txn");
        if (formatVersionToWrite < 4) {
            throw new IOException("Invalid journal format to write : version = " + formatVersionToWrite);
        }
        LOG.info("Opening journal {}", (Object)fn);
        if (!fn.exists()) {
            if (!fn.createNewFile()) {
                LOG.error("Journal file {}, that shouldn't exist, already exists.  is there another bookie process running?", (Object)fn);
                throw new IOException("File " + fn + " suddenly appeared, is another bookie process running?");
            }
            this.randomAccessFile = new RandomAccessFile(fn, "rw");
            this.fc = this.randomAccessFile.getChannel();
            this.formatVersion = formatVersionToWrite;
            int headerSize = 4 == this.formatVersion ? 8 : 512;
            ByteBuffer bb = ByteBuffer.allocate(headerSize);
            ZeroBuffer.put(bb);
            bb.clear();
            bb.put(this.magicWord);
            bb.putInt(this.formatVersion);
            bb.clear();
            this.fc.write(bb);
            this.bc = new BufferedChannel(this.fc, writeBufferSize);
            this.forceWrite(true);
            this.nextPrealloc = this.preAllocSize;
            this.fc.write(this.zeros, this.nextPrealloc - (long)journalAlignSize);
        } else {
            this.randomAccessFile = new RandomAccessFile(fn, "r");
            this.fc = this.randomAccessFile.getChannel();
            this.bc = null;
            ByteBuffer bb = ByteBuffer.allocate(8);
            int c = this.fc.read(bb);
            bb.flip();
            if (c == 8) {
                byte[] first4 = new byte[4];
                bb.get(first4);
                this.formatVersion = Arrays.equals(first4, this.magicWord) ? bb.getInt() : 1;
            } else {
                this.formatVersion = 1;
            }
            if (this.formatVersion < 1 || this.formatVersion > 5) {
                String err = String.format("Invalid journal version, unable to read. Expected between (%d) and (%d), got (%d)", 1, 5, this.formatVersion);
                LOG.error(err);
                throw new IOException(err);
            }
            try {
                if (position == -12345L) {
                    if (this.formatVersion >= 5) {
                        this.fc.position(512L);
                    } else if (this.formatVersion >= 2) {
                        this.fc.position(8L);
                    } else {
                        this.fc.position(0L);
                    }
                } else {
                    this.fc.position(position);
                }
            }
            catch (IOException e) {
                LOG.error("Bookie journal file can seek to position :", (Throwable)e);
            }
        }
        this.fd = fRemoveFromPageCache ? NativeIO.getSysFileDescriptor(this.randomAccessFile.getFD()) : -1;
    }

    int getFormatVersion() {
        return this.formatVersion;
    }

    BufferedChannel getBufferedChannel() throws IOException {
        if (this.bc == null) {
            throw new IOException("Read only journal channel");
        }
        return this.bc;
    }

    void preAllocIfNeeded(long size) throws IOException {
        if (this.bc.position() + size > this.nextPrealloc) {
            this.nextPrealloc += this.preAllocSize;
            this.zeros.clear();
            this.fc.write(this.zeros, this.nextPrealloc - (long)this.journalAlignSize);
        }
    }

    int read(ByteBuffer dst) throws IOException {
        return this.fc.read(dst);
    }

    @Override
    public void close() throws IOException {
        this.fc.close();
    }

    public void forceWrite(boolean forceMetadata) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Journal ForceWrite");
        }
        long newForceWritePosition = this.bc.forceWrite(forceMetadata);
        if (this.fRemoveFromPageCache) {
            long newDropPos = newForceWritePosition - cacheDropLagBytes;
            if (this.lastDropPosition < newDropPos) {
                NativeIO.bestEffortRemoveFromPageCache(this.fd, this.lastDropPosition, newDropPos - this.lastDropPosition);
            }
            this.lastDropPosition = newDropPos;
        }
    }
}

